-- MySQL dump 10.10
--
-- Host: localhost    Database: sys_datos_dfs
-- ------------------------------------------------------
-- Server version	5.0.19-nt

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `dat_articulo`
--

DROP TABLE IF EXISTS `dat_articulo`;
CREATE TABLE `dat_articulo` (
  `IdArticulo` int(11) NOT NULL COMMENT 'Id unico del articulo.\r\nSingle ID of the article.',
  `TeclaDirecta` int(11) default NULL,
  `PrecioConIVA` double(15,6) default '0.000000' COMMENT 'Precio con IVA.\r\nPrice with VAT.',
  `Descripcion` varchar(100) default NULL COMMENT 'Descripcion del articulo.\r\nDescription of the article.',
  `Descripcion1` varchar(100) default NULL COMMENT 'Descripcion adicional del articulo.\r\nAditional description of the article.',
  `Descripcion2` varchar(100) default NULL,
  `IdTipo` int(11) NOT NULL default '1' COMMENT '1=Pesado, 2=Unitario\r\n1=weight, 2=Unit',
  `IdSeccion` int(11) default NULL COMMENT 'Id Seccion del articulo.\r\nSection ID of the article.',
  `FormatoEtiquetaSerieL` varchar(2) default NULL,
  `FormatoEtiquetaSerieL2` varchar(2) default NULL,
  `IdCodBarras` int(11) default '0' COMMENT 'Id codigo de barras del articulo.\r\nBarcode ID of the article.',
  `IdIVA` int(11) default NULL COMMENT 'Id IVA del articulo.\r\nVAT ID of the article.',
  `CodSmiley` int(11) default NULL,
  `LogoPantalla` varchar(1000) default NULL COMMENT 'Ruta del logotipo del articulo.\r\nPath of the logo of the article.',
  `TipoOferta` int(11) default '0' COMMENT '0: No oferta\r\n1: Precio-Peso\r\n2: Cantidad gratis',
  `PrecioOferta` double(15,6) default '0.000000',
  `IdOfertaTemporal` int(11) default NULL,
  `PrecioEstandar` double(15,6) unsigned default '0.000000' COMMENT 'Precio estandar del articulo.\r\nStandard price of the article.',
  `FechaCaducidadActivada` tinyint(1) default '1',
  `FechaCaducidad` datetime default NULL,
  `DiasCaducidad` int(5) default NULL COMMENT 'Dias de caducidad del articulo.\r\nDays of expiration of the article.',
  `HorasCaducidad` int(5) default NULL COMMENT 'Horas de caducidad del articulo.\r\nHours of expiration of the article.',
  `MinutosCaducidad` int(5) default NULL,
  `FechaExtraActivada` tinyint(1) default '1',
  `FechaExtra` datetime default NULL,
  `DiasExtra` int(5) default NULL COMMENT 'Dias extras del articulo.\r\nExtra days of the article.',
  `HorasExtra` int(5) default NULL COMMENT 'Horas extra del articulo.\r\nExtra hours of the article.',
  `MinutosExtra` int(5) default NULL,
  `FechaCongelacionActivada` tinyint(1) default '1',
  `FechaCongelacion` datetime default NULL,
  `DiasCongelacion` int(5) default NULL,
  `HorasCongelacion` int(5) default NULL,
  `MinutosCongelacion` int(5) default NULL,
  `TaraFija` decimal(11,3) default NULL COMMENT 'Tara fija del articulo.\r\nFixed tara of the article.',
  `TaraPorcentual` int(11) default NULL COMMENT 'Tara porcentual de articulo.\r\nPercentaje tara of the article.',
  `EANScanner` varchar(20) default NULL COMMENT 'Codigo EANScanner del articulo.\r\nEANScanner code of the article.',
  `IdClase` int(11) default NULL COMMENT 'Id Clase del articulo.\r\nCass ID of the article.',
  `IdElemAsociado` int(11) default NULL COMMENT 'Id Elemento asociado del articulo.\r\nAssociated element Id of the article.',
  `ModificaPV` tinyint(1) default '0' COMMENT '0= No se puede modificar el precio del articulo en la pantalla de venta, 1= Se puede moficiar el precio del articulo en la pantalla de venta.\r\n0 = You can not change the price of the article on the screen sales, 1 = You can moficiar the price of the artic',
  `Texto1` text COMMENT 'Texto 1 del articulo.\r\nText 1 of the article.',
  `Texto2` text COMMENT 'Texto 2 del articulo.\r\nText 2 of the article.',
  `Texto3` text COMMENT 'Texto 3 del articulo.\r\nText 3 of the article.',
  `Texto4` text COMMENT 'Texto 4 del articulo.\r\nText 4 of the article.',
  `Texto5` text COMMENT 'Texto 5 del articulo.\r\nText 5 of the article.',
  `Texto6` text COMMENT 'Texto 6 del articulo.\r\nText 6 of the article.',
  `Texto7` text COMMENT 'Texto 7 del articulo.\r\nText 7 of the article.',
  `Texto8` text COMMENT 'Texto 8 del articulo.\r\nText 8 of the article.',
  `Texto9` text COMMENT 'Texto 9 del articulo.\r\nText 9 of the article.',
  `Texto10` text COMMENT 'Texto 10 del articulo.\r\nText 10 of the article.',
  `Texto11` text COMMENT 'Texto 11 del articulo.\r\nText 11 of the article.',
  `Texto12` text COMMENT 'Texto 12 del articulo.\r\nText 12 of the article.',
  `Texto13` text COMMENT 'Texto 13 del articulo.\r\nText 13 of the article.',
  `Texto14` text COMMENT 'Texto 14 del articulo.\r\nText 14 of the article.',
  `Texto15` text COMMENT 'Texto 15 del articulo.\r\nText 15 of the article.',
  `Texto16` text COMMENT 'Texto 16 del articulo.\r\nText 16 of the article.',
  `Texto17` text COMMENT 'Texto 17 del articulo.\r\nText 17 of the article.',
  `Texto18` text COMMENT 'Texto 18 del articulo.\r\nText 18 of the article.',
  `Texto19` text COMMENT 'Texto 19 del articulo.\r\nText 19 of the article.',
  `Texto20` text COMMENT 'Texto 20 del articulo.\r\nText 20 of the article.',
  `TextoLibre` text COMMENT 'Texto libre del articulo.\r\nFree text of the article.',
  `TextoNutricional1_1` varchar(100) default NULL,
  `TextoNutricional1_2` varchar(100) default NULL,
  `TextoNutricional2_1` varchar(100) default NULL,
  `TextoNutricional2_2` varchar(100) default NULL,
  `TextoNutricional3_1` varchar(100) default NULL,
  `TextoNutricional3_2` varchar(100) default NULL,
  `TextoNutricional4_1` varchar(100) default NULL,
  `TextoNutricional4_2` varchar(100) default NULL,
  `TextoNutricional5_1` varchar(100) default NULL,
  `TextoNutricional5_2` varchar(100) default NULL,
  `TextoNutricional6_1` varchar(100) default NULL,
  `TextoNutricional6_2` varchar(100) default NULL,
  `TextoNutricional7_1` varchar(100) default NULL,
  `TextoNutricional7_2` varchar(100) default NULL,
  `TextoNutricional8_1` varchar(100) default NULL,
  `TextoNutricional8_2` varchar(100) default NULL,
  `TextoNutricional9_1` varchar(100) default NULL,
  `TextoNutricional9_2` varchar(100) default NULL,
  `TextoNutricional10_1` varchar(100) default NULL,
  `TextoNutricional10_2` varchar(100) default NULL,
  `TextoNutricional11_1` varchar(100) default NULL,
  `TextoNutricional11_2` varchar(100) default NULL,
  `TextoNutricional12_1` varchar(100) default NULL,
  `TextoNutricional12_2` varchar(100) default NULL,
  `TextoNutricional13_1` varchar(100) default NULL,
  `TextoNutricional13_2` varchar(100) default NULL,
  `TextoNutricional14_1` varchar(100) default NULL,
  `TextoNutricional14_2` varchar(100) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1' COMMENT 'Id Empresa del articulo.\r\nCompany ID of the article.',
  `IdSubFamilia` int(11) default NULL COMMENT 'Id Subfamilia del articulo.\r\nSubfamily ID of the article.',
  `IdEtiqueta` int(11) default NULL COMMENT 'Id etiqueta del articulo.\r\nTag Id of the article.',
  `FechaEnvasadoActivada` tinyint(1) default '0',
  `FechaEnvasado` datetime default NULL,
  `DiasEnvasado` int(5) default NULL COMMENT 'Dias envasado del articulo.\r\nPacking days of the article.',
  `HorasEnvasado` int(5) default NULL COMMENT 'Horas envasado del articulo.\r\nPacking hours of the article.',
  `IdLogo` int(11) default NULL,
  `IdLogoColor` int(11) default NULL,
  `BarCode20` int(25) default NULL,
  `IdFamilia` int(11) default NULL COMMENT 'Id Familia del articulo\r\nFamily ID of the article.',
  `PLUNumber` int(11) default NULL,
  `FechaInicioOferta` datetime default NULL,
  `FechaFinOferta` datetime default NULL,
  `HoraInicioOferta` text,
  `HoraFinOferta` text,
  `FactorPrecio` tinyint(1) default NULL,
  `DiaSemanaOferta` tinyint(1) default NULL,
  `IdReceta` int(11) default NULL,
  `TextosEAN128` tinyint(1) NOT NULL default '0' COMMENT '0: 10 textos, 1: 9 textos y EAN 128 24c, 2: 8 textos y EAN 128 48c, 3: 7 textos y EAN 128 72c',
  `IdEAN128` int(11) default '0',
  `CodigoIngrediente1` int(11) default NULL,
  `CodigoIngrediente2` int(11) default NULL,
  `CodigoIngrediente3` int(11) default NULL,
  `CodigoIngrediente4` int(11) default NULL,
  `CodigoIngrediente5` int(11) default NULL,
  `CodigoIngrediente6` int(11) default NULL,
  `CodigoIngrediente7` int(11) default NULL,
  `CodigoIngrediente8` int(11) default NULL,
  `CodigoIngrediente9` int(11) default NULL,
  `CodigoIngrediente10` int(11) default NULL,
  `PesoFijo` decimal(11,3) default NULL,
  `PrecioAnterior` double(15,6) default NULL,
  `FechaModificacionPrecio` datetime default NULL,
  `UsuarioModificacionPrecio` varchar(20) default NULL,
  `CodigoNutricional` int(11) default NULL,
  `Texto1_Texto2` text,
  `Texto3_Texto4` text,
  `Texto5_Texto6` text,
  `Texto7_Texto8` text,
  `Texto9_Texto10` text,
  `IdTaraSeccion` int(11) default NULL,
  `IdIngredienteSeccion` int(11) default NULL,
  `Descripcion_Descripcion1` text,
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `ModificadoEAN` tinyint(1) default NULL,
  `ModificadoTextos` tinyint(1) default NULL,
  `ModificadoTextoG` tinyint(1) default NULL,
  `ModificadoNutricionales` tinyint(1) default '0',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the ticket.',
  `CHKW_MargenInferior` decimal(11,3) default '0.000' COMMENT 'Checkweigher Margen Inferior -> Articulo',
  `CHKW_MargenSuperior` decimal(11,3) default '0.000' COMMENT 'Checkweigher Margen Superior -> Articulo',
  `PesoPieza` int(11) default '0' COMMENT 'Peso de la pieza para el modo cuentapiezas',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  `Color` int(11) NOT NULL default '0',
  PRIMARY KEY  (`IdEmpresa`,`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de los artic';

--
-- Dumping data for table `dat_articulo`
--


/*!40000 ALTER TABLE `dat_articulo` DISABLE KEYS */;
LOCK TABLES `dat_articulo` WRITE;
INSERT INTO `dat_articulo` (`IdArticulo`, `TeclaDirecta`, `PrecioConIVA`, `Descripcion`, `Descripcion1`, `Descripcion2`, `IdTipo`, `IdSeccion`, `FormatoEtiquetaSerieL`, `FormatoEtiquetaSerieL2`, `IdCodBarras`, `IdIVA`, `CodSmiley`, `LogoPantalla`, `TipoOferta`, `PrecioOferta`, `IdOfertaTemporal`, `PrecioEstandar`, `FechaCaducidadActivada`, `FechaCaducidad`, `DiasCaducidad`, `HorasCaducidad`, `MinutosCaducidad`, `FechaExtraActivada`, `FechaExtra`, `DiasExtra`, `HorasExtra`, `MinutosExtra`, `FechaCongelacionActivada`, `FechaCongelacion`, `DiasCongelacion`, `HorasCongelacion`, `MinutosCongelacion`, `TaraFija`, `TaraPorcentual`, `EANScanner`, `IdClase`, `IdElemAsociado`, `ModificaPV`, `Texto1`, `Texto2`, `Texto3`, `Texto4`, `Texto5`, `Texto6`, `Texto7`, `Texto8`, `Texto9`, `Texto10`, `Texto11`, `Texto12`, `Texto13`, `Texto14`, `Texto15`, `Texto16`, `Texto17`, `Texto18`, `Texto19`, `Texto20`, `TextoLibre`, `TextoNutricional1_1`, `TextoNutricional1_2`, `TextoNutricional2_1`, `TextoNutricional2_2`, `TextoNutricional3_1`, `TextoNutricional3_2`, `TextoNutricional4_1`, `TextoNutricional4_2`, `TextoNutricional5_1`, `TextoNutricional5_2`, `TextoNutricional6_1`, `TextoNutricional6_2`, `TextoNutricional7_1`, `TextoNutricional7_2`, `TextoNutricional8_1`, `TextoNutricional8_2`, `TextoNutricional9_1`, `TextoNutricional9_2`, `TextoNutricional10_1`, `TextoNutricional10_2`, `TextoNutricional11_1`, `TextoNutricional11_2`, `TextoNutricional12_1`, `TextoNutricional12_2`, `TextoNutricional13_1`, `TextoNutricional13_2`, `TextoNutricional14_1`, `TextoNutricional14_2`, `IdEmpresa`, `IdSubFamilia`, `IdEtiqueta`, `FechaEnvasadoActivada`, `FechaEnvasado`, `DiasEnvasado`, `HorasEnvasado`, `IdLogo`, `IdLogoColor`, `BarCode20`, `IdFamilia`, `PLUNumber`, `FechaInicioOferta`, `FechaFinOferta`, `HoraInicioOferta`, `HoraFinOferta`, `FactorPrecio`, `DiaSemanaOferta`, `IdReceta`, `TextosEAN128`, `IdEAN128`, `CodigoIngrediente1`, `CodigoIngrediente2`, `CodigoIngrediente3`, `CodigoIngrediente4`, `CodigoIngrediente5`, `CodigoIngrediente6`, `CodigoIngrediente7`, `CodigoIngrediente8`, `CodigoIngrediente9`, `CodigoIngrediente10`, `PesoFijo`, `PrecioAnterior`, `FechaModificacionPrecio`, `UsuarioModificacionPrecio`, `CodigoNutricional`, `Texto1_Texto2`, `Texto3_Texto4`, `Texto5_Texto6`, `Texto7_Texto8`, `Texto9_Texto10`, `IdTaraSeccion`, `IdIngredienteSeccion`, `Descripcion_Descripcion1`, `Modificado`, `ModificadoEAN`, `ModificadoTextos`, `ModificadoTextoG`, `ModificadoNutricionales`, `Operacion`, `Usuario`, `CHKW_MargenInferior`, `CHKW_MargenSuperior`, `PesoPieza`, `TimeStamp`, `Color`) VALUES (1,1,NULL,'RUMSTECK','','',1,1,'21','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-03 15:16:36','2015-10-03 15:16:36','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-10-03 13:17:06',0),(2,NULL,0.000000,'BAVETTE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 20:40:52','2015-09-30 20:40:52','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-09-30 18:40:55',0),(3,NULL,0.000000,'BASSE COTE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:53:46','2015-09-30 19:53:46','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-09-30 17:54:16',0),(4,4,0.000000,'COTE A L\'OS','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:53:46','2015-09-30 19:53:46','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-09-30 17:54:19',0),(5,NULL,0.000000,'PALERON','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:53:46','2015-09-30 19:53:46','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:54:22',0),(6,NULL,0.000000,'FAUX FILET','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:53:46','2015-09-30 19:53:46','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:54:25',0),(7,NULL,0.000000,'STECK EPAULE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:53:46','2015-09-30 19:53:46','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:54:29',0),(8,NULL,0.000000,'ROND DE GITE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-09-30 17:54:55',0),(9,NULL,0.000000,'TENDE DE TRANCHE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:54:59',0),(10,NULL,0.000000,'GITE A LA NOIX','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:55:01',0),(11,NULL,0.000000,'ONGLET','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:55:05',0),(12,NULL,0.000000,'PLAT DE COTE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:55:13',0),(13,NULL,0.000000,'JARRET','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 12:05:47','2015-10-16 12:05:47','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 10:05:52',0),(14,NULL,0.000000,'ROTI FILET','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:55:19',0),(15,NULL,0.000000,'ROTI','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:55:24',0),(16,NULL,0.000000,'ENTRECOTE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:55:28',0),(17,NULL,0.000000,'STEACK','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:54:50','2015-09-30 19:54:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:56:04',0),(18,18,0.000000,'PREPARATION HACHEE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'Viande hachée,',' sel, sucre.','','','','','','','Cuire a cœur','entre 0 et 2 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-14 21:33:37','2015-12-14 21:33:37','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-12-14 20:33:51',0),(19,NULL,0.000000,'BOURGUIGNON','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-09-30 17:56:46',0),(20,NULL,0.000000,'BROCHETTES','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:56:49',0),(21,NULL,0.000000,'VIANDE  POUR FONDU','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:56:53',0),(22,NULL,0.000000,'MERGUEZ','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'Boeuf, Agneau,','sel, épices.','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:56:56',0),(23,NULL,0.000000,'GRILLADES','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:56:59',0),(24,NULL,0.000000,'COLLIER','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:01',0),(25,NULL,0.000000,'FILET','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:04',0),(26,NULL,0.000000,'QUEUE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:08',0),(27,NULL,0.000000,'POIRE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:11',0),(28,NULL,0.000000,'ARAIGNEE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:14',0),(29,NULL,0.000000,'HAMPE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:17',0),(30,NULL,0.000000,'JUMEAU','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:19',0),(31,NULL,0.000000,'MACREUSE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:22',0),(32,NULL,0.000000,'PIECE NOIRE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:26',0),(33,NULL,0.000000,'FOIE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:29',0),(34,NULL,0.000000,'COEUR','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:31',0),(35,NULL,0.000000,'LANGUE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:37',0),(36,NULL,0.000000,'ROGNONS','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:41',0),(37,NULL,0.000000,'JOUE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:44',0),(38,NULL,0.000000,'STEACK LEVURE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-09-30 17:57:47',0),(40,NULL,0.000000,'MERLIN','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:50',0),(42,NULL,0.000000,'TOURNEDOS','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:53',0),(44,NULL,0.000000,'POT AUX FEU','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:57:55',0),(45,NULL,0.000000,'PAVE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:58:00',0),(50,NULL,0.000000,'STEACK 1ere CATAGORIE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:58:03',0),(52,NULL,0.000000,'ROND DE BOEUF SECHE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,90,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:58:06',0),(53,NULL,0.000000,'PAVE RUMSTECK','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:56:41','2015-09-30 19:56:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:58:08',0),(54,NULL,0.000000,'PAVE TENDE DE TRANCHE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:58:42','2015-09-30 19:58:42','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-30 17:58:58',0),(90,NULL,0.000000,'VIANDE POUR ANIMAUX','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-30 19:58:42','2015-09-30 19:58:42','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-09-30 17:58:54',0),(91,NULL,0.000000,'TIBONNE','','',1,1,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:05:56','2015-11-06 10:05:56','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','admin','0.000','0.000',0,'2015-11-06 09:06:27',0),(92,NULL,NULL,'PIECE A GRILLER','façon tournedos','',1,1,'41','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:55:00','2015-12-23 08:55:00','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-12-23 07:55:24',0),(201,NULL,0.000000,'GIGOT D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:25:10','2015-12-23 08:25:10','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-12-23 07:25:27',0),(202,NULL,0.000000,'EPAULE D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-12-23 07:27:33',0),(203,NULL,0.000000,'COLLIER D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-12-23 07:27:35',0),(204,NULL,0.000000,'RAGOUT D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:36',0),(205,NULL,0.000000,'COTELLETTES D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:37',0),(206,NULL,0.000000,'SCELLE D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:38',0),(207,NULL,0.000000,'CARRE DECOUVERT D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:39',0),(208,NULL,0.000000,'FOIE D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:40',0),(209,NULL,0.000000,'COEUR D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:42',0),(210,NULL,0.000000,'ROGNON D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:43',0),(211,NULL,0.000000,'COTELETTE FILET D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:44',0),(220,NULL,0.000000,'GRILLADE AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:45',0),(221,NULL,0.000000,'CARRE AVEC L\'OS D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:46',0),(222,NULL,0.000000,'Cote Bordelaise','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:47',0),(223,NULL,0.000000,'Epaule Facon Gigot','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:48',0),(224,NULL,0.000000,'POITRINE D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-23 08:27:25','2015-12-23 08:27:25','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-12-23 07:27:49',0),(228,NULL,0.000000,'EPAULE D\'AGNEAU ROULEE','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:23',0),(229,NULL,0.000000,'GIGOT D\'AGNEAU TRANCHE','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:29',0),(230,NULL,0.000000,'COTELETTE DECOUVERTE AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:33',0),(231,NULL,0.000000,'COTELETTE 1er AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:37',0),(232,NULL,0.000000,'EPAULE D\'AGNEAU TRANCHEE','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:42',0),(233,NULL,0.000000,'CARRE D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:46',0),(234,NULL,0.000000,'RIS D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:50',0),(236,NULL,0.000000,'SELLE D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:55',0),(237,NULL,0.000000,'SOURIS D\'AGNEAU','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:18:59',0),(239,NULL,0.000000,'POITRINE ROULEE','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:19:04',0),(241,NULL,0.000000,'EPAULE DESOSSEE','','',1,3,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,12,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,19,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:19:30',0),(301,NULL,0.000000,'FILET MIGNON DE PORC','','',1,4,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',NULL,NULL,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:19:23',0),(302,NULL,0.000000,'ROTI FILET DE PORC','','',1,4,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',NULL,NULL,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 10:16:49','2015-11-06 10:16:49','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-11-06 09:19:19',0),(303,NULL,0.000000,'ROTI ECHINE DE PORC',NULL,NULL,1,4,'21',NULL,1,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(304,NULL,0.000000,'COTELLETTE ECHINE PORC',NULL,NULL,1,4,'21',NULL,1,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(305,NULL,0.000000,'COTELETTE FILET DE PORC',NULL,NULL,1,4,'21',NULL,1,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(306,NULL,0.000000,'SAUCISSE DE PORC',NULL,NULL,1,4,'21',NULL,1,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,18,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'Maigre 80 %,','poitrine 20 %,','sel, poivre',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(307,NULL,0.000000,'CHIPOLATAS DE PORC',NULL,NULL,1,4,'21',NULL,1,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,18,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'Maigre 80 %,','poitrine 20 %,','sel, poivre',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(308,NULL,0.000000,'CHAIR A SAUCISSE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,18,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'Maigre 80 %,','poitrine 20 %,','sel, poivre',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(309,NULL,0.000000,'SAUCISSE SECHE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,90,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'Maigre, gras de porc,','vin rouge, sucres, poivr','sel, ail, salpêtre.',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(310,NULL,0.000000,'SAUCISSON SEC','PUR PORC','',1,4,'21','',NULL,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,90,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',NULL,NULL,1,'Maigre, gras de porc,','vin rouge, sucres, poivr','sel, ail, salpêtre.','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-29 19:12:58','2015-10-29 19:12:58','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-29 18:13:17',0),(311,NULL,0.000000,'PORCELET',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(312,NULL,0.000000,'VIANDE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(313,NULL,0.000000,'JAMBON FRAIS','','',1,4,'21','',NULL,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',NULL,NULL,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 09:37:14','2015-11-06 09:37:14','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-11-06 08:37:27',0),(314,NULL,0.000000,'PETIT SALE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(316,NULL,0.000000,'VENTRECHE PORC TRANCHEE',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(317,NULL,0.000000,'POITRINE PORC TRANCHEE',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(321,NULL,0.000000,'PIEDS DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(322,NULL,0.000000,'JARRET DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(323,NULL,0.000000,'FOIE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(324,NULL,0.000000,'COEUR DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(325,NULL,0.000000,'ROGNON DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(326,NULL,0.000000,'LANGUE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(327,NULL,0.000000,'SAUTE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(330,NULL,0.000000,'PLAT DE COTE',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(331,NULL,0.000000,'COUENNE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(332,NULL,0.000000,'EPAULE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(333,NULL,0.000000,'R?TI DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(335,NULL,0.000000,'PAVE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(336,NULL,0.000000,'GRILLADE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(337,NULL,0.000000,'ROUELLE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(338,NULL,0.000000,'GORGE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(339,NULL,0.000000,'TOILE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(340,NULL,0.000000,'TETE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(343,NULL,0.000000,'LONGE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(345,NULL,0.000000,'ROTI FILET A L\'OS DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(346,NULL,0.000000,'ROTI ECHINE A L\'OS DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(347,NULL,0.000000,'POTRINE-VENTRECHE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(348,NULL,0.000000,'COUSTELLOUS DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(349,NULL,0.000000,'CHAIR A PATE DE PORC PUR',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(351,NULL,0.000000,'GRAS DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(352,NULL,0.000000,'CARRE VENTRECHE COUENNE DE POR',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(353,NULL,0.000000,'CARRE VENTRECHE DECOUENNE DE P',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(354,NULL,0.000000,'APERO PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(367,NULL,0.000000,'OREILLES DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(368,NULL,0.000000,'QUEUE DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(369,NULL,0.000000,'LARD DE PORC',NULL,NULL,1,4,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(380,NULL,0.000000,'ESCALOPE DE PORC','','',1,4,'21','',NULL,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',NULL,NULL,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 09:42:06','2015-11-06 09:42:06','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-11-06 08:42:14',0),(381,28,NULL,'JAMBON BLANC','','',1,7,'21','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',NULL,NULL,1,'Jambon de proc,sel nirtr','ite, dextrose, saccharos','e, salpetre, sel, epices','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 09:43:03','2015-11-06 09:43:03','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,'M','admin',NULL,NULL,0,'2015-11-06 08:43:08',0),(500,19,NULL,'SAUCISSON SEC','','',1,7,'','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,90,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,13,1,'Viande bovine, gras de','porc, vin rouge, sel,','episec, ail, poivre','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-28 18:10:19','2015-10-28 18:10:19','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-10-28 17:10:39',0),(601,NULL,0.000000,'COTE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:53:34','2015-10-16 11:53:34','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:53:47',0),(602,NULL,0.000000,'COTE DECOUVERTE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:53:50','2015-10-16 11:53:50','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:53:58',0),(603,NULL,0.000000,'SOUS NOIX','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:54:20','2015-10-16 11:54:20','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:54:26',0),(604,NULL,0.000000,'QUASI','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:54:27','2015-10-16 11:54:27','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:54:31',0),(605,NULL,0.000000,'NOIX','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:54:32','2015-10-16 11:54:32','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:54:37',0),(606,NULL,0.000000,'TENDRON','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:54:41','2015-10-16 11:54:41','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:54:54',0),(607,NULL,0.000000,'CAPELINE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:54:56','2015-10-16 11:54:56','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:00',0),(608,NULL,0.000000,'JARRET','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:02','2015-10-16 11:55:02','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:06',0),(609,NULL,0.000000,'ROTI EPAULE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:07','2015-10-16 11:55:07','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:10',0),(610,NULL,0.000000,'ROTI FILET','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:12','2015-10-16 11:55:12','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:16',0),(611,NULL,0.000000,'NOIX PATISSIERE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:18','2015-10-16 11:55:18','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:21',0),(612,NULL,0.000000,'BLANQUETTE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:22','2015-10-16 11:55:22','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:25',0),(613,29,0.000000,'SAUCISSE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'Maigre et gras de veau','boyaux porc','sel et poivre','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:27','2015-10-16 11:55:27','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:29',0),(614,NULL,0.000000,'ROTI','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:39','2015-10-16 11:55:39','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:44',0),(615,NULL,0.000000,'COTE A L\'OS','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:46','2015-10-16 11:55:46','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:50',0),(616,NULL,0.000000,'COLLIER','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:51','2015-10-16 11:55:51','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:54',0),(617,NULL,0.000000,'COTE FILET','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:55:55','2015-10-16 11:55:55','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:55:58',0),(618,NULL,0.000000,'ONGLET','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:00','2015-10-16 11:56:00','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:03',0),(619,NULL,0.000000,'FOIE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:05','2015-10-16 11:56:05','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:08',0),(620,NULL,0.000000,'COEUR','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:13','2015-10-16 11:56:13','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:16',0),(621,NULL,0.000000,'ESCALOPE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:17','2015-10-16 11:56:17','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:20',0),(622,NULL,0.000000,'ROGNON','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:22','2015-10-16 11:56:22','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:25',0),(623,NULL,0.000000,'CERVELLE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:26','2015-10-16 11:56:26','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:29',0),(624,NULL,0.000000,'RIS','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:31','2015-10-16 11:56:31','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:34',0),(625,NULL,0.000000,'BROCHETTE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:35','2015-10-16 11:56:35','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:38',0),(626,NULL,0.000000,'LANGUE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:40','2015-10-16 11:56:40','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:43',0),(627,NULL,0.000000,'PIED','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:44','2015-10-16 11:56:44','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:47',0),(628,NULL,0.000000,'OSSO BUCCO','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:48','2015-10-16 11:56:48','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:51',0),(629,NULL,0.000000,'PAUPIETTE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:52','2015-10-16 11:56:52','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:56:55',0),(630,NULL,0.000000,'SAUCISSE J.B. SAUGE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,10,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:56:57','2015-10-16 11:56:57','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:57:01',0),(631,NULL,0.000000,'GRENADIN','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:57:03','2015-10-16 11:57:03','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:57:06',0),(632,NULL,0.000000,'QUEUE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:57:32','2015-10-16 11:57:32','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:57:44',0),(633,NULL,0.000000,'TOURNEDOS','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 11:57:32','2015-10-16 11:57:32','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-16 09:57:38',0),(634,NULL,0.000000,'PAVE','','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'','','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-28 18:06:42','2015-10-28 18:06:42','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-28 17:06:51',0),(635,27,0.000000,'SAUCISSE DE  VEAU','Landaise','',1,7,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'Maigre et gras de veau, ','boyaux porc, E120,','moutarde , E315,','dextrose, saccharose,','E262, acetate de sodium,','sel et poivre','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-14 22:22:18','2015-12-14 22:22:18','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-12-14 21:23:01',0),(636,NULL,0.000000,'ROTI DE VEAU','aux pruneaux','',1,7,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'Roti de veau, pruneaux','sel et poivre','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-14 22:40:31','2015-12-14 22:40:31','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-12-14 21:40:36',0),(637,NULL,0.000000,'ROTI DE VEAU','Orloff','',1,7,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'Roti de veau, bacon','fromage, sel et poivre','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-14 22:40:43','2015-12-14 22:40:43','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','admin','0.000','0.000',0,'2015-12-14 21:41:39',0),(700,NULL,0.000000,'CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(701,NULL,0.000000,'STEACK DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(702,NULL,0.000000,'ROTI DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(703,NULL,0.000000,'FILET DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(704,NULL,0.000000,'PREP.HACHE DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'VIANDE DE CHEVAL, SEL','','',NULL,NULL,NULL,NULL,NULL,'Cuire a cœur','entre 0 et 2 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(705,NULL,0.000000,'LANGUE DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(706,NULL,0.000000,'COEUR DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(707,NULL,0.000000,'JOUE DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(708,NULL,0.000000,'FAUX FILET DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(709,NULL,0.000000,'DAUBE DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(710,NULL,0.000000,'ENTRECOTE DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(711,NULL,0.000000,'HAMPE DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(712,NULL,0.000000,'BASSE COTE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(713,NULL,0.000000,'COTE OS CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(714,NULL,0.000000,'RUMSTEACK CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(715,NULL,0.000000,'ONGLET CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(716,NULL,0.000000,'LEVURE DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(717,NULL,0.000000,'BAVETTE DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(718,NULL,0.000000,'TOURNEDOS CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(719,NULL,0.000000,'ROTI FILET CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(720,NULL,0.000000,'SAUCISSE CHEVAL','','',1,6,'21','',NULL,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',NULL,NULL,1,'Viande de cheval,','sel, poivre','','','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-28 18:07:07','2015-10-28 18:07:07','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-10-28 17:07:29',0),(721,NULL,0.000000,'SAUCISSE CHEVAL EPICEE',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'Viande de cheval,','sel, poivre','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(750,NULL,0.000000,'SAUCISSON DE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,90,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'Viande de cheval,','sel, épisec, vin, ail.','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(751,NULL,0.000000,'SAUCISSE SECHE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,90,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'Viande de cheval,','sel, épisec, vin, ail.','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(752,NULL,0.000000,'Rond de cheval seche',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,90,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'','','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(753,NULL,0.000000,'VIANDE SECHEE CHEVAL',NULL,NULL,1,6,'21',NULL,0,NULL,NULL,NULL,0,0.000000,NULL,0.000000,1,NULL,90,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,NULL,NULL,NULL,1,'Viande de cheval,','sel, épisec, vin, ail.','',NULL,NULL,NULL,NULL,NULL,'','entre 2 et 4 degrés',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'A','rgi','0.000','0.000',0,'2015-09-29 19:37:28',0),(901,NULL,NULL,'COLIS VACHE','','',1,1,'11','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.300',NULL,'',1,1,1,'','','','','','','','','','entre 0 et 2 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-16 12:05:23','2015-10-16 12:05:23','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-10-16 10:05:25',0),(903,NULL,NULL,'COLIS JEUNE BOVIN','','',1,0,'11','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.300',NULL,'',1,1,1,'','','','','','','','','','entre 0 et 2 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-12 18:06:28','2015-10-12 18:06:28','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-10-12 16:06:33',0),(904,NULL,NULL,'COLIS VEAU','','',1,0,'11','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.300',NULL,'',1,1,1,'','','','','','','','','','entre 0 et 2 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-12 18:06:35','2015-10-12 18:06:35','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-10-12 16:06:39',0),(907,NULL,NULL,'COLIS AGNEAU','','',1,0,'11','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.300',NULL,'',1,1,1,'','','','','','','','','','entre 0 et 2 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-12 18:06:40','2015-10-12 18:06:40','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-10-12 16:06:45',0),(916,NULL,NULL,'COLIS CHEVAL','','',1,0,'11','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.300',NULL,'',1,1,1,'','','','','','','','','','entre 0 et 2 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-10-12 18:06:47','2015-10-12 18:06:47','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-10-12 16:06:52',0),(917,NULL,NULL,'','','',1,0,'','',NULL,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,1,'','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-11-06 09:37:39','2015-11-06 09:37:39','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,0,0,'A','admin',NULL,NULL,0,'2015-11-06 08:38:02',0),(918,NULL,0.000000,'ROTI','au foie gras','',1,5,'21','',1,NULL,NULL,'',0,0.000000,NULL,0.000000,1,NULL,15,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,'0.010',NULL,'',1,1,1,'Roti de Boeuf, foie gras','sel et poivre','','de Canard','','','','','','entre 2 et 4 degrés','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-12-14 22:46:02','2015-12-14 22:46:02','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin','0.000','0.000',0,'2015-12-14 21:46:10',0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo` ENABLE KEYS */;

/*!50003 SET @OLD_SQL_MODE=@@SQL_MODE*/;
DELIMITER ;;
/*!50003 SET SESSION SQL_MODE="STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION" */;;
/*!50003 CREATE */ /*!50017 DEFINER=`root`@`localhost` */ /*!50003 TRIGGER `ChangePrice` BEFORE UPDATE ON `dat_articulo` FOR EACH ROW BEGIN
  	IF (OLD.PrecioConIVA <> NEW.PrecioConIVA) THEN
  		SET NEW.PrecioAnterior = OLD.PrecioConIVA;  
        SET NEW.FechaModificacionPrecio = CURRENT_TIMESTAMP();
        SET NEW.UsuarioModificacionPrecio = NEW.Usuario;
    END IF;      		    		
  END */;;

DELIMITER ;
/*!50003 SET SESSION SQL_MODE=@OLD_SQL_MODE */;

--
-- Table structure for table `dat_articulo_grupos`
--

DROP TABLE IF EXISTS `dat_articulo_grupos`;
CREATE TABLE `dat_articulo_grupos` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `IdArticulo` int(11) NOT NULL,
  `PrecioConIVA_Marcado` int(11) default '1',
  `PrecioConIVA` double(15,6) default '0.000000',
  `TeclaDirecta_Marcado` int(11) default '1',
  `TeclaDirecta` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`,`IdArticulo`),
  KEY `IdArticulo` (`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_articulo_grupos`
--


/*!40000 ALTER TABLE `dat_articulo_grupos` DISABLE KEYS */;
LOCK TABLES `dat_articulo_grupos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo_grupos` ENABLE KEYS */;

--
-- Table structure for table `dat_articulo_segmentos`
--

DROP TABLE IF EXISTS `dat_articulo_segmentos`;
CREATE TABLE `dat_articulo_segmentos` (
  `IdArticulo` int(11) NOT NULL,
  `IdSegmento` int(11) NOT NULL,
  `IdTipo` int(1) NOT NULL,
  `Cantidad` double(15,3) NOT NULL,
  `Precio` double(15,3) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Operacion` char(1) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdArticulo`,`IdTipo`,`IdSegmento`),
  KEY `Cantidad` (`IdArticulo`,`IdTipo`,`Cantidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_articulo_segmentos`
--


/*!40000 ALTER TABLE `dat_articulo_segmentos` DISABLE KEYS */;
LOCK TABLES `dat_articulo_segmentos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo_segmentos` ENABLE KEYS */;

--
-- Table structure for table `dat_articulo_segmentos_t_b`
--

DROP TABLE IF EXISTS `dat_articulo_segmentos_t_b`;
CREATE TABLE `dat_articulo_segmentos_t_b` (
  `IdArticulo` int(11) NOT NULL,
  `IdTipo` int(11) NOT NULL,
  `IdSegmento` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdArticulo`,`IdTipo`,`IdSegmento`),
  KEY `BusquedaSegmentos` (`IdEmpresa`,`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_articulo_segmentos_t_b`
--


/*!40000 ALTER TABLE `dat_articulo_segmentos_t_b` DISABLE KEYS */;
LOCK TABLES `dat_articulo_segmentos_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo_segmentos_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_articulo_t_b`
--

DROP TABLE IF EXISTS `dat_articulo_t_b`;
CREATE TABLE `dat_articulo_t_b` (
  `IdArticulo` int(11) NOT NULL COMMENT 'Id del articulo asociado a la balanza.\r\nId article associated with the balance.',
  `IdEmpresa` int(11) NOT NULL default '1' COMMENT 'Id Empresa del articulo asociado a la balanza.\r\nCompany ID of the article associated with the balance.',
  `IdTienda` int(11) NOT NULL default '1' COMMENT 'Id Tienda asociada con el articulo.\r\nStore ID associated with the article.',
  `IdBalanza` int(11) NOT NULL default '0' COMMENT 'Id Balanza asociada con el articulo.\r\nBalance ID associated with the article.',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `ModificadoEAN` tinyint(1) default NULL,
  `ModificadoTextos` tinyint(1) default NULL,
  `ModificadoTextoG` tinyint(1) default NULL,
  `ModificadoNutricionales` tinyint(1) default '0',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the ticket.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdArticulo`),
  KEY `BusquedaArticulos` (`IdEmpresa`,`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Tabla donde se guarda la asociacion entre balanzas de una';

--
-- Dumping data for table `dat_articulo_t_b`
--


/*!40000 ALTER TABLE `dat_articulo_t_b` DISABLE KEYS */;
LOCK TABLES `dat_articulo_t_b` WRITE;
INSERT INTO `dat_articulo_t_b` (`IdArticulo`, `IdEmpresa`, `IdTienda`, `IdBalanza`, `Modificado`, `ModificadoEAN`, `ModificadoTextos`, `ModificadoTextoG`, `ModificadoNutricionales`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (381,1,1,10,1,0,0,0,0,'B','admin','2015-11-06 08:43:08'),(917,1,1,10,1,0,0,0,0,'A','admin','2015-11-06 08:38:03');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_avisos_email`
--

DROP TABLE IF EXISTS `dat_avisos_email`;
CREATE TABLE `dat_avisos_email` (
  `IdAviso` int(11) NOT NULL,
  `SMTP` varchar(100) default NULL,
  `PortSMTP` int(6) default NULL,
  `SSL` tinyint(1) default '1',
  `NombreUsuario` varchar(100) default NULL,
  `Contrasenia` varchar(100) default NULL,
  `Asunto` text,
  `Texto` text,
  `IdDestinatarios` int(11) default NULL,
  `EnvioModificaciones` tinyint(1) default '0',
  `RecogidaVentas` tinyint(1) default '0',
  `FinDia` tinyint(1) default '0',
  `Inicializacion` tinyint(1) default '0',
  `EnvioFicheros` tinyint(1) default '0',
  `Importacion` tinyint(1) default '0',
  `Exportacion` tinyint(1) default '0',
  `OpcionesEnvio` int(11) default '1' COMMENT '1=Nunca, 2=Siempre, 3=Solo si error',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdAviso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_avisos_email`
--


/*!40000 ALTER TABLE `dat_avisos_email` DISABLE KEYS */;
LOCK TABLES `dat_avisos_email` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_avisos_email` ENABLE KEYS */;

--
-- Table structure for table `dat_avisos_email_destinatarios`
--

DROP TABLE IF EXISTS `dat_avisos_email_destinatarios`;
CREATE TABLE `dat_avisos_email_destinatarios` (
  `IdDestinatarios` int(11) NOT NULL,
  `Tipo` int(11) NOT NULL COMMENT '1=Para, 2=CC, 3=CCO',
  `Email` varchar(100) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdDestinatarios`,`Tipo`,`Email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_avisos_email_destinatarios`
--


/*!40000 ALTER TABLE `dat_avisos_email_destinatarios` DISABLE KEYS */;
LOCK TABLES `dat_avisos_email_destinatarios` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_avisos_email_destinatarios` ENABLE KEYS */;

--
-- Table structure for table `dat_balanza`
--

DROP TABLE IF EXISTS `dat_balanza`;
CREATE TABLE `dat_balanza` (
  `IdBalanza` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Nombre` varchar(50) default NULL,
  `IdDIBAL` varchar(20) default NULL,
  `EtiquetasGestionStock` tinyint(1) NOT NULL default '0',
  `Dir_IP` varchar(20) default NULL,
  `Dir_IP_Publica` varchar(20) default NULL,
  `Port` int(6) default NULL,
  `TipoBase` varchar(20) default NULL,
  `BaseDatos` varchar(50) default NULL,
  `UserDB` varchar(20) default NULL,
  `PasswDB` varchar(24) default NULL,
  `TimeOutConnection` int(4) default '15',
  `BalanzaTradicional` int(11) default NULL,
  `TipoDisplay` int(11) default NULL COMMENT '1:alfanumerica 2:grafica',
  `DireccionLogica` varchar(2) default NULL,
  `Grupo` varchar(2) default NULL,
  `PuertoEnvio_Tx` int(6) default NULL,
  `PuertoRecepcion_Rx` int(6) default NULL,
  `PathImagen` varchar(1000) default NULL,
  `DisenoImagen` tinyint(1) default '0',
  `ColorFondo` varchar(50) default NULL,
  `XPosition` int(11) default '0',
  `YPosition` int(11) default '0',
  `Ancho` int(11) default '0',
  `Alto` int(11) default '0',
  `IdConfiguracion` int(11) default '0',
  `Z0` varchar(130) default NULL,
  `ZA` varchar(130) default NULL,
  `FicheroTX` text,
  `ListadoFinDeDia` tinyint(1) default '1',
  `CaducidadGlobal` tinyint(1) NOT NULL default '0',
  `FechaActivada` tinyint(1) NOT NULL default '1',
  `FechaCaducidad` datetime default NULL,
  `Dias` int(3) default '0',
  `Horas` int(3) default '0',
  `IdGrupoCabecerasFormato0` int(11) default NULL,
  `IdGrupoCabecerasFormato1` int(11) default NULL,
  `IdGrupoCabecerasFormato2` int(11) default NULL,
  `IdGrupoCabecerasFormato3` int(11) default NULL,
  `IdTablaTeclaVendedor` int(11) default NULL,
  `IdPublicidad` int(11) default '0',
  `IdGrupoMacros` int(11) default NULL,
  `IdGrupoArticulos` int(11) default NULL,
  `ActivedScale` int(11) default '1' COMMENT 'Se utiliza para debuggear Comunicaciones simulando DFS',
  `ImportarClientes` tinyint(1) default '0',
  `Balanza_Seleccionada` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las balanzas';

--
-- Dumping data for table `dat_balanza`
--


/*!40000 ALTER TABLE `dat_balanza` DISABLE KEYS */;
LOCK TABLES `dat_balanza` WRITE;
INSERT INTO `dat_balanza` (`IdBalanza`, `IdTienda`, `IdEmpresa`, `Nombre`, `IdDIBAL`, `EtiquetasGestionStock`, `Dir_IP`, `Dir_IP_Publica`, `Port`, `TipoBase`, `BaseDatos`, `UserDB`, `PasswDB`, `TimeOutConnection`, `BalanzaTradicional`, `TipoDisplay`, `DireccionLogica`, `Grupo`, `PuertoEnvio_Tx`, `PuertoRecepcion_Rx`, `PathImagen`, `DisenoImagen`, `ColorFondo`, `XPosition`, `YPosition`, `Ancho`, `Alto`, `IdConfiguracion`, `Z0`, `ZA`, `FicheroTX`, `ListadoFinDeDia`, `CaducidadGlobal`, `FechaActivada`, `FechaCaducidad`, `Dias`, `Horas`, `IdGrupoCabecerasFormato0`, `IdGrupoCabecerasFormato1`, `IdGrupoCabecerasFormato2`, `IdGrupoCabecerasFormato3`, `IdTablaTeclaVendedor`, `IdPublicidad`, `IdGrupoMacros`, `IdGrupoArticulos`, `ActivedScale`, `ImportarClientes`, `Balanza_Seleccionada`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Scale 1',NULL,0,'192.168.2.1','192.168.2.1',NULL,NULL,NULL,NULL,NULL,15,20,1,'00',NULL,3001,3000,NULL,0,'Turquoise',21,59,250,40,101,NULL,NULL,NULL,1,0,1,NULL,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,1,'B','admin','2015-09-15 20:24:30'),(2,1,1,'Scale 01',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'01',NULL,3002,3000,NULL,0,'SkyBlue',20,110,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-09-15 20:11:34'),(3,1,1,'Scale 00',NULL,0,'192.168.1.240','192.168.1.240',NULL,NULL,NULL,NULL,NULL,15,20,1,'00',NULL,3003,3000,NULL,0,'SkyBlue',25,64,250,40,101,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-09-28 20:54:24'),(4,1,1,'Scale 01',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'01',NULL,3004,3000,NULL,0,'SkyBlue',363,71,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-09-16 23:04:41'),(5,1,1,'Scale 01',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'01',NULL,3005,3000,NULL,0,'SkyBlue',292,64,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-09-28 20:54:24'),(6,1,1,'Scale 01',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'01',NULL,3006,3000,NULL,0,'SkyBlue',20,310,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-09-28 20:26:10'),(7,1,1,'Scale 00',NULL,0,'192.168.1.240','192.168.1.240',NULL,NULL,NULL,NULL,NULL,15,20,1,'00',NULL,3007,3000,NULL,0,'SkyBlue',13,40,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-10-10 14:58:48'),(8,1,1,'Scale 01',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'01',NULL,3008,3000,NULL,0,'SkyBlue',20,410,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-10-10 14:58:48'),(9,1,1,'Scale 02',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'02',NULL,3009,3000,NULL,0,'SkyBlue',170,128,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-10-10 15:28:05'),(10,1,1,'Scale 00',NULL,0,'192.168.1.240','192.168.1.240',NULL,NULL,NULL,NULL,NULL,15,20,1,'00',NULL,3001,3000,NULL,0,'SkyBlue',21,34,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'M','admin','2016-01-06 11:45:57'),(11,1,1,'Scale 01',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'01',NULL,3010,3000,NULL,0,'SkyBlue',20,560,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-11-02 16:52:15'),(1,2,1,'Scale 00',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'00',NULL,3001,3000,NULL,0,'SkyBlue',20,60,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-10-10 15:28:05');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanza` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_clientes`
--

DROP TABLE IF EXISTS `dat_balanzas_clientes`;
CREATE TABLE `dat_balanzas_clientes` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdCliente` int(11) NOT NULL,
  `Nombre` varchar(9) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdCliente`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_balanzas_clientes`
--


/*!40000 ALTER TABLE `dat_balanzas_clientes` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_clientes` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_clientes` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_dld`
--

DROP TABLE IF EXISTS `dat_balanzas_dld`;
CREATE TABLE `dat_balanzas_dld` (
  `IdBalanza` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Nombre` varchar(50) default NULL,
  `Dir_IP_Publica` varchar(20) default NULL,
  `BalanzaTradicional` int(11) default NULL,
  `DireccionLogica` varchar(2) default NULL,
  `Grupo` varchar(2) default NULL,
  `PuertoEnvio_Tx` int(6) default NULL,
  `PuertoRecepcion_Rx` int(6) default NULL,
  `IdConfiguracion` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan las balanzas creadas con el DLD';

--
-- Dumping data for table `dat_balanzas_dld`
--


/*!40000 ALTER TABLE `dat_balanzas_dld` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_dld` WRITE;
INSERT INTO `dat_balanzas_dld` (`IdBalanza`, `IdTienda`, `IdEmpresa`, `Nombre`, `Dir_IP_Publica`, `BalanzaTradicional`, `DireccionLogica`, `Grupo`, `PuertoEnvio_Tx`, `PuertoRecepcion_Rx`, `IdConfiguracion`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Balance 1','192.168.1.240',20,'00','50',3001,3000,1,1,'A','DFD','2015-12-09 19:04:49');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_dld` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_grupos_vendedores`
--

DROP TABLE IF EXISTS `dat_balanzas_grupos_vendedores`;
CREATE TABLE `dat_balanzas_grupos_vendedores` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdGrupo`),
  KEY `IdGrupo` (`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_balanzas_grupos_vendedores`
--


/*!40000 ALTER TABLE `dat_balanzas_grupos_vendedores` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_grupos_vendedores` WRITE;
INSERT INTO `dat_balanzas_grupos_vendedores` (`IdEmpresa`, `IdTienda`, `IdBalanza`, `IdGrupo`) VALUES (1,1,10,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_grupos_vendedores` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_lotes`
--

DROP TABLE IF EXISTS `dat_balanzas_lotes`;
CREATE TABLE `dat_balanzas_lotes` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdLote` int(11) NOT NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdLote`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_balanzas_lotes`
--


/*!40000 ALTER TABLE `dat_balanzas_lotes` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_lotes` WRITE;
INSERT INTO `dat_balanzas_lotes` (`IdEmpresa`, `IdTienda`, `IdBalanza`, `IdLote`) VALUES (1,1,10,1),(1,1,10,2),(1,1,10,3),(1,1,10,4),(1,1,10,5),(1,1,10,6),(1,1,10,7),(1,1,10,8),(1,1,10,9),(1,1,10,10),(1,1,10,11),(1,1,10,12),(1,1,10,13),(1,1,10,14),(1,1,10,15),(1,1,10,16),(1,1,10,17),(1,1,10,18),(1,1,10,19),(1,1,10,20),(1,1,10,21),(1,1,10,22),(1,1,10,23),(1,1,10,24),(1,1,10,25),(1,1,10,26),(1,1,10,27),(1,1,10,28),(1,1,10,29),(1,1,10,30),(1,1,10,31),(1,1,10,32),(1,1,10,33),(1,1,10,34),(1,1,10,35),(1,1,10,36),(1,1,10,37),(1,1,10,38),(1,1,10,39),(1,1,10,40),(1,1,10,41),(1,1,10,42),(1,1,10,43);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_lotes` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_secciones`
--

DROP TABLE IF EXISTS `dat_balanzas_secciones`;
CREATE TABLE `dat_balanzas_secciones` (
  `idEmpresa` int(11) NOT NULL,
  `idTienda` int(11) NOT NULL,
  `idBalanza` int(11) NOT NULL,
  `idSeccion` int(11) NOT NULL,
  PRIMARY KEY  (`idEmpresa`,`idTienda`,`idBalanza`,`idSeccion`),
  KEY `idSeccion` (`idSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_balanzas_secciones`
--


/*!40000 ALTER TABLE `dat_balanzas_secciones` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_secciones` WRITE;
INSERT INTO `dat_balanzas_secciones` (`idEmpresa`, `idTienda`, `idBalanza`, `idSeccion`) VALUES (1,1,10,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_secciones` ENABLE KEYS */;

--
-- Table structure for table `dat_borrado_ventas`
--

DROP TABLE IF EXISTS `dat_borrado_ventas`;
CREATE TABLE `dat_borrado_ventas` (
  `Indice` int(11) NOT NULL,
  `DiasBorradoVentasAuto` int(11) default NULL,
  `FechaUltimoBorradoAuto` datetime default NULL,
  `FechaBorradoInicio` datetime default NULL,
  `FechaBorradoFin` datetime default NULL,
  `DiasBorradoVentasManual` int(11) default NULL,
  `CheckBorradoManual` int(11) default NULL,
  `HoraBorradoAuto` time default NULL,
  `CheckBorradoAuto` tinyint(1) default NULL,
  PRIMARY KEY  (`Indice`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_borrado_ventas`
--


/*!40000 ALTER TABLE `dat_borrado_ventas` DISABLE KEYS */;
LOCK TABLES `dat_borrado_ventas` WRITE;
INSERT INTO `dat_borrado_ventas` (`Indice`, `DiasBorradoVentasAuto`, `FechaUltimoBorradoAuto`, `FechaBorradoInicio`, `FechaBorradoFin`, `DiasBorradoVentasManual`, `CheckBorradoManual`, `HoraBorradoAuto`, `CheckBorradoAuto`) VALUES (1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_borrado_ventas` ENABLE KEYS */;

--
-- Table structure for table `dat_cabecera_etiqueta`
--

DROP TABLE IF EXISTS `dat_cabecera_etiqueta`;
CREATE TABLE `dat_cabecera_etiqueta` (
  `IdEmpresa` int(11) NOT NULL,
  `IdModeloBalanza` int(11) NOT NULL,
  `IdCabecera` int(11) NOT NULL,
  `Descripcion` varchar(52) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdModeloBalanza`,`IdCabecera`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_cabecera_etiqueta`
--


/*!40000 ALTER TABLE `dat_cabecera_etiqueta` DISABLE KEYS */;
LOCK TABLES `dat_cabecera_etiqueta` WRITE;
INSERT INTO `dat_cabecera_etiqueta` (`IdEmpresa`, `IdModeloBalanza`, `IdCabecera`, `Descripcion`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Les Fermes Du Pays Bourian',1,'A','dfd','2015-09-14 17:33:14'),(1,1,2,'La Marzelle',1,'A','dfd','2015-09-14 17:33:52'),(1,1,3,'46310 St Germain du Bel Air',1,'A','dfd','2015-09-14 17:34:09'),(1,1,4,'Num Abattoir :',1,'A','dfd','2015-09-14 19:00:26'),(1,1,5,'Ingredients :',1,'A','dfd','2015-09-15 17:45:23'),(1,1,6,'Eleveur :',1,'A','dfd','2015-09-14 17:40:52'),(1,1,7,'Nunéro de Lot :',1,'A','dfd','2015-09-15 18:03:26'),(1,1,8,'Catégorie :',1,'A','dfd','2015-09-15 20:38:57'),(1,1,9,'Type :',1,'A','dfd','2015-09-15 20:48:43'),(1,20,1,'Les Fermes du Pays Bourian',1,'A','dfd','2015-09-16 19:33:54'),(1,20,2,'La Marzelle',1,'A','dfd','2015-09-16 19:34:05'),(1,20,3,'46310 St Germain du bel Air',1,'A','dfd','2015-09-16 19:34:22'),(1,20,5,'Pays de Naissance :',1,'A','dfd','2015-09-16 19:34:25'),(1,20,6,'Pays d\'élevage :',1,'A','dfd','2015-09-16 19:34:47'),(1,20,7,'Pays d\'abattage :',1,'A','dfd','2015-09-16 19:35:02'),(1,20,8,'Num Abattoir :',1,'A','dfd','2015-09-16 19:35:13'),(1,20,9,'Race :',1,'A','dfd','2015-09-16 19:35:15'),(1,20,10,'Type :',1,'A','dfd','2015-09-16 19:35:32'),(1,20,11,'Catégorie',1,'A','dfd','2015-09-16 19:35:46'),(1,20,12,'Eleveur : ',1,'A','dfd','2015-09-28 17:40:25'),(1,20,13,'D.L.C.',1,'A','dfd','2015-09-28 17:45:14'),(1,20,14,'Emballe le ',1,'A','dfd','2015-09-29 20:21:37'),(1,20,15,'Agrement N° FR 46 443 001 CE',1,'A','dfd','2015-09-30 18:32:07'),(1,20,16,'Ingredients',1,'A','dfd','2015-12-14 21:07:49');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cabecera_etiqueta` ENABLE KEYS */;

--
-- Table structure for table `dat_cabecera_ticket`
--

DROP TABLE IF EXISTS `dat_cabecera_ticket`;
CREATE TABLE `dat_cabecera_ticket` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `IdCabecera` int(11) NOT NULL,
  `Ubicacion` int(11) default NULL,
  `Descripcion` varchar(56) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`,`IdCabecera`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_cabecera_ticket`
--


/*!40000 ALTER TABLE `dat_cabecera_ticket` DISABLE KEYS */;
LOCK TABLES `dat_cabecera_ticket` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cabecera_ticket` ENABLE KEYS */;

--
-- Table structure for table `dat_clase`
--

DROP TABLE IF EXISTS `dat_clase`;
CREATE TABLE `dat_clase` (
  `IdClase` int(11) NOT NULL,
  `NombreClase` varchar(25) default NULL,
  `CodigoIALote` varchar(10) default NULL,
  `CodigoIAPeso` varchar(10) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdClase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan las distintas clases que puede perten';

--
-- Dumping data for table `dat_clase`
--


/*!40000 ALTER TABLE `dat_clase` DISABLE KEYS */;
LOCK TABLES `dat_clase` WRITE;
INSERT INTO `dat_clase` (`IdClase`, `NombreClase`, `CodigoIALote`, `CodigoIAPeso`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'Tracabilitee',NULL,NULL,1,1,'M','admin','2015-12-23 07:27:09');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_clase` ENABLE KEYS */;

--
-- Table structure for table `dat_clase_t_b`
--

DROP TABLE IF EXISTS `dat_clase_t_b`;
CREATE TABLE `dat_clase_t_b` (
  `IdClase` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdClase`),
  KEY `BusquedaClases` (`IdEmpresa`,`IdClase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_clase_t_b`
--


/*!40000 ALTER TABLE `dat_clase_t_b` DISABLE KEYS */;
LOCK TABLES `dat_clase_t_b` WRITE;
INSERT INTO `dat_clase_t_b` (`IdClase`, `IdEmpresa`, `IdTienda`, `IdBalanza`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,10,1,'A','admin','2015-12-23 07:27:09');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_clase_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_cliente`
--

DROP TABLE IF EXISTS `dat_cliente`;
CREATE TABLE `dat_cliente` (
  `IdEmpresa` int(11) NOT NULL,
  `IdCliente` int(11) NOT NULL,
  `Nombre` varchar(9) default NULL,
  `NombreLargo` varchar(30) default NULL,
  `Direccion` varchar(30) default NULL,
  `CodPostal` varchar(10) default NULL,
  `Localidad` varchar(20) default NULL,
  `NIF` varchar(20) default NULL,
  `Activo` tinyint(1) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdCliente`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_cliente`
--


/*!40000 ALTER TABLE `dat_cliente` DISABLE KEYS */;
LOCK TABLES `dat_cliente` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cliente` ENABLE KEYS */;

--
-- Table structure for table `dat_cod_barras`
--

DROP TABLE IF EXISTS `dat_cod_barras`;
CREATE TABLE `dat_cod_barras` (
  `IdCodBarras` int(11) NOT NULL default '0',
  `IdFormatosBarras` int(11) NOT NULL,
  `NombreCodBarras` varchar(20) default NULL,
  `Plantilla` varchar(500) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `TratamientoNegativos` int(11) default '0',
  `UsarEAN` tinyint(1) default '0',
  `AEnviar` int(11) default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdCodBarras`,`IdFormatosBarras`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los distintos codigos de barras. T';

--
-- Dumping data for table `dat_cod_barras`
--


/*!40000 ALTER TABLE `dat_cod_barras` DISABLE KEYS */;
LOCK TABLES `dat_cod_barras` WRITE;
INSERT INTO `dat_cod_barras` (`IdCodBarras`, `IdFormatosBarras`, `NombreCodBarras`, `Plantilla`, `IdEmpresa`, `TratamientoNegativos`, `UsarEAN`, `AEnviar`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,'EAN13 Peulet','29CCCCCHHHHH',1,NULL,0,1,1,'M','admin','2015-10-16 09:54:51'),(2,1,'EAN13 Inter','25CCCCCYYYYY',1,NULL,0,1,0,'A','admin','2015-09-30 15:46:51');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cod_barras` ENABLE KEYS */;

--
-- Table structure for table `dat_cod_barras_t_b`
--

DROP TABLE IF EXISTS `dat_cod_barras_t_b`;
CREATE TABLE `dat_cod_barras_t_b` (
  `IdCodBarras` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `IdFormatosBarras` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdCodBarras`,`IdFormatosBarras`),
  KEY `BusquedaCodBarras` (`IdEmpresa`,`IdCodBarras`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_cod_barras_t_b`
--


/*!40000 ALTER TABLE `dat_cod_barras_t_b` DISABLE KEYS */;
LOCK TABLES `dat_cod_barras_t_b` WRITE;
INSERT INTO `dat_cod_barras_t_b` (`IdCodBarras`, `IdEmpresa`, `IdTienda`, `IdBalanza`, `IdFormatosBarras`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,10,1,1,'A','admin','2015-10-16 09:54:51');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cod_barras_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_configuracion`
--

DROP TABLE IF EXISTS `dat_configuracion`;
CREATE TABLE `dat_configuracion` (
  `IdConfiguracion` int(6) NOT NULL,
  `NombreConfiguracion` varchar(30) default NULL,
  `IdModeloBalanza` int(11) default NULL,
  `Grupo` varchar(2) default '00',
  `LimiteMayoristas` decimal(13,4) default '0.0000',
  `MovimientoDia` int(11) default '0',
  `FinDia` int(11) default '0',
  `MarcarMensajeEtiqueta` int(11) default '0',
  `RegistroCompletoVentas` int(11) default '1',
  `InformeComunicaciones` int(11) default '0',
  `DevolucionPeso` int(11) default '0',
  `FijarPrecio` int(11) default '0',
  `PrecioLibre` int(11) default '0',
  `PrecioDirecto` int(11) default '0',
  `Multiplicacion` int(11) default '0',
  `Resta` int(11) default '0',
  `Suma` int(11) default '0',
  `Subtotal` int(11) default '0',
  `CalculoCambio` int(11) default '0',
  `NumeroCliente` int(11) default '0',
  `CodigoEnTicket` int(11) default '0',
  `TaraEnTicket` int(11) default '0',
  `DescuentoEnTicket` int(11) default '0',
  `DescuentoEnLinea` int(11) default '0',
  `IVAEnTicket` int(11) default '0',
  `ConfiguracionTicket` int(11) default '0',
  `LineasAnuladas` int(11) default '0',
  `RedondeoTicket` int(11) default '0',
  `UnArticulo` int(11) default '0',
  `PapelAdhesivo` int(11) default '0',
  `PesajeAutomatico` int(11) default '0',
  `EtiquetaPorPesada` int(11) default '0',
  `CentradoTextos` int(11) default '0',
  `AcumularEnEtiqueta` int(11) default '0',
  `ImprimirTextoG` int(11) default '0',
  `TalonCaja` int(11) default '0',
  `TalonCaja2` int(11) default '0',
  `CopiaTicket` int(11) default '0',
  `Reapertura` int(11) default '0',
  `DosModosPago` int(11) default '0',
  `CodigoBarrasSeccion` int(11) default '0',
  `CodigoBarrasTicket` int(11) default '0',
  `CodigoBarrasEtiqueta` int(11) default '0',
  `LineaInterpretacionEAN` int(11) default '0',
  `FormatoEAN13Ticket` int(11) default '0',
  `EAN13Ticket` varchar(20) default NULL,
  `FormatoEAN13Etiqueta` int(11) default '0',
  `EAN13Etiqueta` varchar(20) default NULL,
  `FormatoEAN128` int(11) default '0',
  `VentaEscaner` int(11) default '0',
  `LecturaEAN128` int(11) default '0',
  `AnalisisComodines` int(11) default '0',
  `UnidadesX1000` int(11) default '0',
  `CifrasCodigo` int(11) default '0',
  `Caducidad` int(11) default '0',
  `Publicidad` int(11) default '0',
  `ControlCajon` int(11) default '0',
  `PrecioPorcentaje` int(11) default '0',
  `ModoAutomatico` int(11) default '0',
  `TemporizacionCodigo` int(11) default '0',
  `MemorizarImporteCero` int(11) default '0',
  `MemorizarPesoCero` int(11) default '0',
  `CabeceraListados` int(11) default '0',
  `ClaseDefecto` int(11) default '0',
  `ControlPesoLote` int(11) default '0',
  `AperturaCajonCero` int(11) default '0',
  `TrazabilidadGenerica` int(11) default '0',
  `IdPuntosFidelidad` int(11) default NULL,
  `PrecioSello` decimal(13,4) default '0.0000',
  `PrecioReferencia` decimal(13,4) default '0.0000',
  `NombreSello` varchar(20) default NULL,
  `CodigoSello` int(11) default '0',
  `PuntosBonoRegalo` int(11) default '0',
  `DiasSinActividad` int(11) default '0',
  `Code25` varchar(25) default NULL,
  `Code25Checksum` int(11) default NULL,
  `ModoCheckweigher` tinyint(1) default '0' COMMENT 'Modo Checkweigher 0-> No 1-> Articulo 2-> Global',
  `CHKW_MargenInferior` decimal(11,3) default '0.000' COMMENT 'Checkweigher Margen Inferior -> Configuracion',
  `CHKW_MargenSuperior` decimal(11,3) default '0.000' COMMENT 'Checkweigher Margen Superior-> Configuracion',
  `ModoTrabajo` int(11) default '0',
  `SegundaEtiqueta` int(11) default '0',
  `FormatoEtiqueta` int(11) default '0',
  `FormatoEtiqueta2` int(11) default '0',
  `RetardoEtiqueta2` int(11) default '0',
  `FormatoTicket` int(11) default '0',
  `LineasFinTicket` int(11) default '0',
  `TicketPorEtiquetadora` int(11) default '0',
  `DestacarTexto` int(11) default '0',
  `ModoPublicidad` int(11) default '0',
  `DisplayPublicidad` tinyint(1) default '0',
  `ImagenPLU` tinyint(1) default '0',
  `TiempoEntradaPublicidadDD` int(11) default '5',
  `RecibirParametrosImpresion` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdConfiguracion`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_configuracion`
--


/*!40000 ALTER TABLE `dat_configuracion` DISABLE KEYS */;
LOCK TABLES `dat_configuracion` WRITE;
INSERT INTO `dat_configuracion` (`IdConfiguracion`, `NombreConfiguracion`, `IdModeloBalanza`, `Grupo`, `LimiteMayoristas`, `MovimientoDia`, `FinDia`, `MarcarMensajeEtiqueta`, `RegistroCompletoVentas`, `InformeComunicaciones`, `DevolucionPeso`, `FijarPrecio`, `PrecioLibre`, `PrecioDirecto`, `Multiplicacion`, `Resta`, `Suma`, `Subtotal`, `CalculoCambio`, `NumeroCliente`, `CodigoEnTicket`, `TaraEnTicket`, `DescuentoEnTicket`, `DescuentoEnLinea`, `IVAEnTicket`, `ConfiguracionTicket`, `LineasAnuladas`, `RedondeoTicket`, `UnArticulo`, `PapelAdhesivo`, `PesajeAutomatico`, `EtiquetaPorPesada`, `CentradoTextos`, `AcumularEnEtiqueta`, `ImprimirTextoG`, `TalonCaja`, `TalonCaja2`, `CopiaTicket`, `Reapertura`, `DosModosPago`, `CodigoBarrasSeccion`, `CodigoBarrasTicket`, `CodigoBarrasEtiqueta`, `LineaInterpretacionEAN`, `FormatoEAN13Ticket`, `EAN13Ticket`, `FormatoEAN13Etiqueta`, `EAN13Etiqueta`, `FormatoEAN128`, `VentaEscaner`, `LecturaEAN128`, `AnalisisComodines`, `UnidadesX1000`, `CifrasCodigo`, `Caducidad`, `Publicidad`, `ControlCajon`, `PrecioPorcentaje`, `ModoAutomatico`, `TemporizacionCodigo`, `MemorizarImporteCero`, `MemorizarPesoCero`, `CabeceraListados`, `ClaseDefecto`, `ControlPesoLote`, `AperturaCajonCero`, `TrazabilidadGenerica`, `IdPuntosFidelidad`, `PrecioSello`, `PrecioReferencia`, `NombreSello`, `CodigoSello`, `PuntosBonoRegalo`, `DiasSinActividad`, `Code25`, `Code25Checksum`, `ModoCheckweigher`, `CHKW_MargenInferior`, `CHKW_MargenSuperior`, `ModoTrabajo`, `SegundaEtiqueta`, `FormatoEtiqueta`, `FormatoEtiqueta2`, `RetardoEtiqueta2`, `FormatoTicket`, `LineasFinTicket`, `TicketPorEtiquetadora`, `DestacarTexto`, `ModoPublicidad`, `DisplayPublicidad`, `ImagenPLU`, `TiempoEntradaPublicidadDD`, `RecibirParametrosImpresion`, `Modificado`, `IdEmpresa`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'Default 500',20,'50','0.0000',0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,'',0,'',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,NULL,'0.0000','0.0000',NULL,0,0,0,'',NULL,0,'0.000','0.000',0,0,0,0,0,0,4,0,0,0,0,0,5,0,1,1,'M','admindfs','2011-05-25 14:44:54'),(2,'Default L',1,'50','0.0000',0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,'',0,'',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,NULL,'0.0000','0.0000','',0,0,0,'',NULL,0,'0.000','0.000',0,0,0,0,0,0,0,0,0,0,0,0,5,0,1,1,'M','admindfs','2011-06-29 15:02:57'),(3,'Default D900',40,'50','0.0000',0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,'0',0,'0',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,NULL,'0.0000','0.0000',NULL,0,0,0,'',NULL,0,'0.000','0.000',0,0,0,0,0,0,4,0,0,0,0,0,5,0,1,1,'M','admindfs','2013-05-06 08:15:36'),(101,'Boucherie',20,'50','0.0000',1,1,1,2,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,3,0,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,'',2,'',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,NULL,'0.0000','0.0000',NULL,0,0,0,'',NULL,0,'0.000','0.000',0,0,21,0,0,0,4,0,0,0,0,0,5,1,1,1,'M','admin','2015-12-14 20:38:58');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_configuracion` ENABLE KEYS */;

--
-- Table structure for table `dat_configuracion_dfs`
--

DROP TABLE IF EXISTS `dat_configuracion_dfs`;
CREATE TABLE `dat_configuracion_dfs` (
  `SalirCom` int(11) default '0',
  `PermitirEdicionTiendaBalanza` tinyint(1) default '1',
  `NombresArticulo30Caracteres` tinyint(1) default '0',
  `TextosArticulo48Caracteres` tinyint(1) default '0',
  `TextoLibre3000Caracteres` tinyint(1) default '0',
  `ActivarScanner` tinyint(1) default '0',
  `GuardarSeleccionBalanzas` tinyint(1) default '0',
  `GenerarFicheroTxOffline` tinyint(1) default '0',
  `GenerarFicheroInventario` tinyint(1) default '0',
  `PathFicheroInventario` text,
  `GenerarFicheroCambioPrecio` tinyint(1) default '0',
  `PathFicheroCambioPrecio` text,
  `Usuario` varchar(20) default NULL,
  `IdEmpresa` int(11) NOT NULL,
  PRIMARY KEY  (`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_configuracion_dfs`
--


/*!40000 ALTER TABLE `dat_configuracion_dfs` DISABLE KEYS */;
LOCK TABLES `dat_configuracion_dfs` WRITE;
INSERT INTO `dat_configuracion_dfs` (`SalirCom`, `PermitirEdicionTiendaBalanza`, `NombresArticulo30Caracteres`, `TextosArticulo48Caracteres`, `TextoLibre3000Caracteres`, `ActivarScanner`, `GuardarSeleccionBalanzas`, `GenerarFicheroTxOffline`, `GenerarFicheroInventario`, `PathFicheroInventario`, `GenerarFicheroCambioPrecio`, `PathFicheroCambioPrecio`, `Usuario`, `IdEmpresa`) VALUES (0,1,1,0,0,0,0,0,0,'',0,'','admin',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_configuracion_dfs` ENABLE KEYS */;

--
-- Table structure for table `dat_datadicional`
--

DROP TABLE IF EXISTS `dat_datadicional`;
CREATE TABLE `dat_datadicional` (
  `IdIndice` int(11) default NULL,
  `IdDatAdicional` varchar(30) NOT NULL,
  `ClaveDatAdicional` int(11) NOT NULL,
  `ValorDatAdicional` varchar(32) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdDatAdicional`,`ClaveDatAdicional`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los distintos valores de los param';

--
-- Dumping data for table `dat_datadicional`
--


/*!40000 ALTER TABLE `dat_datadicional` DISABLE KEYS */;
LOCK TABLES `dat_datadicional` WRITE;
INSERT INTO `dat_datadicional` (`IdIndice`, `IdDatAdicional`, `ClaveDatAdicional`, `ValorDatAdicional`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (NULL,'Abattoirs',1,'FR46251001CE',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',1,'Vache',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',2,'Jeune Bovin',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',3,'Veau ',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',4,'Agneau',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',5,'Porc',1,0,'M','admin','2015-09-28 20:22:40'),(NULL,'Categorie',6,'Genisse',1,0,'A','admin','2015-09-30 17:11:34'),(NULL,'Eleve en',1,'France, Lot (46)',1,0,'M','admin','2015-09-16 21:31:44'),(NULL,'Pays Abattage',1,'France, Lot (46)',1,0,'M','admin','2015-09-16 21:31:44'),(NULL,'Pays de naissance',1,'France, Lot (46)',1,0,'M','admin','2015-11-17 16:17:03'),(NULL,'Race',1,'Blonde d\'Aquitaine',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Race',2,'Limousine',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Race',3,'Croisée',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Race',4,'F2.46',1,0,'A','admin','2015-11-06 09:16:03'),(NULL,'Race',5,'Aubrac',1,0,'M','admin','2015-11-17 16:17:03'),(NULL,'Type',1,'Viande',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Type',2,'Laitier',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Type',3,'Mixte',1,0,'A','admin','2015-09-16 21:31:44');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_datadicional` ENABLE KEYS */;

--
-- Table structure for table `dat_datadicional_t_b`
--

DROP TABLE IF EXISTS `dat_datadicional_t_b`;
CREATE TABLE `dat_datadicional_t_b` (
  `IdIndice` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdIndice`),
  KEY `BusquedaDatosAdicionales` (`IdEmpresa`,`IdIndice`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_datadicional_t_b`
--


/*!40000 ALTER TABLE `dat_datadicional_t_b` DISABLE KEYS */;
LOCK TABLES `dat_datadicional_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_datadicional_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_departamento`
--

DROP TABLE IF EXISTS `dat_departamento`;
CREATE TABLE `dat_departamento` (
  `IdDepartamento` int(11) NOT NULL,
  `NombreDepartamento` varchar(25) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdDepartamento`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informaci?n de los departamen';

--
-- Dumping data for table `dat_departamento`
--


/*!40000 ALTER TABLE `dat_departamento` DISABLE KEYS */;
LOCK TABLES `dat_departamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_departamento` ENABLE KEYS */;

--
-- Table structure for table `dat_detalle_elem_asociado`
--

DROP TABLE IF EXISTS `dat_detalle_elem_asociado`;
CREATE TABLE `dat_detalle_elem_asociado` (
  `IdElemAsociado` int(11) NOT NULL,
  `IdClase` int(11) NOT NULL,
  `IdParametro` int(11) NOT NULL,
  `Parametro` text,
  `IdDatAdicional` varchar(30) default NULL,
  `Valor` text COMMENT 'Valor introducido por el usuario',
  `Valor1` text COMMENT 'Valor introducido por el usuario de los ofertados en el combo (datos adicionales)',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdElemAsociado`,`IdParametro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de los lotes de anim';

--
-- Dumping data for table `dat_detalle_elem_asociado`
--


/*!40000 ALTER TABLE `dat_detalle_elem_asociado` DISABLE KEYS */;
LOCK TABLES `dat_detalle_elem_asociado` WRITE;
INSERT INTO `dat_detalle_elem_asociado` (`IdElemAsociado`, `IdClase`, `IdParametro`, `Parametro`, `IdDatAdicional`, `Valor`, `Valor1`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-12 16:11:46'),(1,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-12 16:11:46'),(1,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-12 16:11:46'),(1,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-12 16:11:46'),(1,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-10-12 16:11:46'),(1,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-10-12 16:11:46'),(1,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-12 16:11:46'),(2,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-12 15:38:24'),(2,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-12 15:38:24'),(2,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-12 15:38:24'),(2,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-12 15:38:24'),(2,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-10-12 15:38:24'),(2,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'M','admin','2015-10-12 15:38:24'),(2,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-12 15:38:24'),(3,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-12 15:38:44'),(3,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-12 15:38:44'),(3,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-12 15:38:44'),(3,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-12 15:38:44'),(3,1,5,'Race','Race','2','Race-2',1,0,'M','admin','2015-10-12 15:38:44'),(3,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-10-12 15:38:44'),(3,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-12 15:38:44'),(4,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-12 15:38:55'),(4,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-12 15:38:55'),(4,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-12 15:38:55'),(4,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-12 15:38:55'),(4,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-10-12 15:38:55'),(4,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-10-12 15:38:55'),(4,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-12 15:38:55'),(5,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-12 15:40:09'),(5,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-12 15:40:09'),(5,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-12 15:40:09'),(5,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-12 15:40:09'),(5,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-10-12 15:40:09'),(5,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'M','admin','2015-10-12 15:40:09'),(5,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-12 15:40:09'),(6,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-22 16:50:22'),(6,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-22 16:50:22'),(6,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-22 16:50:22'),(6,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-22 16:50:22'),(6,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-10-22 16:50:22'),(6,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-10-22 16:50:22'),(6,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-22 16:50:22'),(7,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-28 16:49:13'),(7,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-28 16:49:13'),(7,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-28 16:49:13'),(7,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-28 16:49:13'),(7,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-10-28 16:49:13'),(7,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'M','admin','2015-10-28 16:49:13'),(7,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-28 16:49:13'),(8,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-22 16:22:37'),(8,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-22 16:22:37'),(8,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-22 16:22:37'),(8,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-22 16:22:37'),(8,1,5,'Race','Race','2','Race-2',1,0,'M','admin','2015-10-22 16:22:37'),(8,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-10-22 16:22:37'),(8,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-22 16:22:37'),(9,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-19 19:42:05'),(9,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-19 19:42:05'),(9,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-19 19:42:05'),(9,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-19 19:42:05'),(9,1,5,'Race','Race','2','Race-2',1,0,'M','admin','2015-10-19 19:42:05'),(9,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-10-19 19:42:05'),(9,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-19 19:42:05'),(10,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-10-27 15:37:35'),(10,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-10-27 15:37:35'),(10,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-10-27 15:37:35'),(10,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-10-27 15:37:35'),(10,1,5,'Race','Race','1','Race-1',1,0,'A','admin','2015-10-27 15:37:35'),(10,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-10-27 15:37:35'),(10,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-10-27 15:37:35'),(11,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-10-28 15:20:56'),(11,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-10-28 15:20:56'),(11,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-10-28 15:20:56'),(11,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-10-28 15:20:56'),(11,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-10-28 15:20:56'),(11,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-10-28 15:20:56'),(11,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-10-28 15:20:56'),(12,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-28 16:52:54'),(12,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-28 16:52:54'),(12,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-28 16:52:54'),(12,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-28 16:52:54'),(12,1,5,'Race','Race','2','Race-2',1,0,'M','admin','2015-10-28 16:52:54'),(12,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-10-28 16:52:54'),(12,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-28 16:52:54'),(13,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-10-28 16:53:12'),(13,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-10-28 16:53:12'),(13,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-10-28 16:53:12'),(13,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-10-28 16:53:12'),(13,1,5,'Race','Race','2','Race-2',1,0,'M','admin','2015-10-28 16:53:12'),(13,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'M','admin','2015-10-28 16:53:12'),(13,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-10-28 16:53:12'),(14,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-11-02 16:21:20'),(14,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-11-02 16:21:20'),(14,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-11-02 16:21:20'),(14,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-11-02 16:21:20'),(14,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-11-02 16:21:20'),(14,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-11-02 16:21:20'),(14,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-11-02 16:21:20'),(15,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-11-02 16:21:38'),(15,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-11-02 16:21:38'),(15,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-11-02 16:21:38'),(15,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-11-02 16:21:38'),(15,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-11-02 16:21:38'),(15,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'M','admin','2015-11-02 16:21:38'),(15,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-11-02 16:21:38'),(16,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-11-02 16:21:45'),(16,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-11-02 16:21:45'),(16,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-11-02 16:21:45'),(16,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-11-02 16:21:45'),(16,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-11-02 16:21:45'),(16,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'M','admin','2015-11-02 16:21:45'),(16,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-11-02 16:21:45'),(17,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-11-02 16:21:54'),(17,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-11-02 16:21:54'),(17,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-11-02 16:21:54'),(17,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-11-02 16:21:54'),(17,1,5,'Race','Race','1','Race-1',1,0,'M','admin','2015-11-02 16:21:54'),(17,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-11-02 16:21:54'),(17,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-11-02 16:21:54'),(18,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-11-02 16:22:07'),(18,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-11-02 16:22:07'),(18,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-11-02 16:22:07'),(18,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-11-02 16:22:07'),(18,1,5,'Race','Race','2','Race-2',1,0,'M','admin','2015-11-02 16:22:07'),(18,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-11-02 16:22:07'),(18,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-11-02 16:22:07'),(19,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-06 09:15:35'),(19,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-06 09:15:35'),(19,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-06 09:15:35'),(19,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-06 09:15:35'),(19,1,5,'Race','Race','4','Race-4',1,0,'A','admin','2015-11-06 09:15:35'),(19,1,6,'Categorie','Categorie','4','Categorie-4',1,0,'A','admin','2015-11-06 09:15:35'),(19,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-06 09:15:35'),(20,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-06 09:15:52'),(20,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-06 09:15:52'),(20,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-06 09:15:52'),(20,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-06 09:15:52'),(20,1,5,'Race','Race','1','Race-1',1,0,'A','admin','2015-11-06 09:15:52'),(20,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-11-06 09:15:52'),(20,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-06 09:15:52'),(21,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-11 15:46:34'),(21,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-11 15:46:34'),(21,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-11 15:46:34'),(21,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-11 15:46:34'),(21,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-11-11 15:46:34'),(21,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-11-11 15:46:34'),(21,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-11 15:46:34'),(22,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-11-17 16:16:58'),(22,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-11-17 16:16:58'),(22,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-11-17 16:16:58'),(22,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-11-17 16:16:58'),(22,1,5,'Race','Race','5','Race-5',1,0,'M','admin','2015-11-17 16:16:58'),(22,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'M','admin','2015-11-17 16:16:58'),(22,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-11-17 16:16:58'),(23,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-11-15 13:45:04'),(23,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-11-15 13:45:04'),(23,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-11-15 13:45:04'),(23,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-11-15 13:45:04'),(23,1,5,'Race','Race','2','Race-2',1,0,'M','admin','2015-11-15 13:45:04'),(23,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-11-15 13:45:04'),(23,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-11-15 13:45:04'),(24,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-24 11:03:28'),(24,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-24 11:03:28'),(24,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-24 11:03:28'),(24,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-24 11:03:28'),(24,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-11-24 11:03:28'),(24,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-11-24 11:03:28'),(24,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-24 11:03:28'),(25,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-15 13:44:08'),(25,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-15 13:44:08'),(25,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-15 13:44:08'),(25,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-15 13:44:08'),(25,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-11-15 13:44:08'),(25,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-11-15 13:44:08'),(25,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-15 13:44:08'),(26,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-11-17 16:18:35'),(26,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-11-17 16:18:35'),(26,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-11-17 16:18:35'),(26,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-11-17 16:18:35'),(26,1,5,'Race','Race','4','Race-4',1,0,'M','admin','2015-11-17 16:18:35'),(26,1,6,'Categorie','Categorie','4','Categorie-4',1,0,'M','admin','2015-11-17 16:18:35'),(26,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-11-17 16:18:35'),(27,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-15 14:18:45'),(27,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-15 14:18:45'),(27,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-15 14:18:45'),(27,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-15 14:18:45'),(27,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-11-15 14:18:45'),(27,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-11-15 14:18:45'),(27,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-15 14:18:45'),(28,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-24 11:06:30'),(28,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-24 11:06:30'),(28,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-24 11:06:30'),(28,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-24 11:06:30'),(28,1,5,'Race','Race','5','Race-5',1,0,'A','admin','2015-11-24 11:06:30'),(28,1,6,'Categorie','Categorie','2','Categorie-2',1,0,'A','admin','2015-11-24 11:06:30'),(28,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-24 11:06:30'),(29,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-12-14 20:43:03'),(29,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-12-14 20:43:03'),(29,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-12-14 20:43:03'),(29,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-12-14 20:43:03'),(29,1,5,'Race','Race','3','Race-3',1,0,'M','admin','2015-12-14 20:43:03'),(29,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'M','admin','2015-12-14 20:43:03'),(29,1,7,'Type','Type','2','Type-2',1,0,'M','admin','2015-12-14 20:43:03'),(30,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-26 15:21:05'),(30,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-26 15:21:05'),(30,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-26 15:21:05'),(30,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-26 15:21:05'),(30,1,5,'Race','Race','3','Race-3',1,0,'A','admin','2015-11-26 15:21:05'),(30,1,6,'Categorie','Categorie','2','Categorie-2',1,0,'A','admin','2015-11-26 15:21:05'),(30,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-26 15:21:05'),(31,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-30 19:37:22'),(31,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-30 19:37:22'),(31,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-30 19:37:22'),(31,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-30 19:37:22'),(31,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-11-30 19:37:22'),(31,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-11-30 19:37:22'),(31,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-11-30 19:37:22'),(32,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-15 14:58:57'),(32,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-15 14:58:57'),(32,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-15 14:58:57'),(32,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-15 14:58:57'),(32,1,5,'Race','Race','1','Race-1',1,0,'A','admin','2015-12-15 14:58:57'),(32,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-12-15 14:58:57'),(32,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-12-15 14:58:57'),(33,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-21 16:04:58'),(33,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-21 16:04:58'),(33,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-21 16:04:58'),(33,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-21 16:04:58'),(33,1,5,'Race','Race','5','Race-5',1,0,'A','admin','2015-12-21 16:04:58'),(33,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'A','admin','2015-12-21 16:04:58'),(33,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-12-21 16:04:58'),(34,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2016-01-04 14:50:51'),(34,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2016-01-04 14:50:51'),(34,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2016-01-04 14:50:51'),(34,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2016-01-04 14:50:51'),(34,1,5,'Race','Race','4','Race-4',1,0,'M','admin','2016-01-04 14:50:51'),(34,1,6,'Categorie','Categorie','4','Categorie-4',1,0,'M','admin','2016-01-04 14:50:51'),(34,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2016-01-04 14:50:51'),(35,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-11-30 19:49:16'),(35,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-11-30 19:49:16'),(35,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-11-30 19:49:16'),(35,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-11-30 19:49:16'),(35,1,5,'Race','Race','3','Race-3',1,0,'A','admin','2015-11-30 19:49:16'),(35,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-11-30 19:49:16'),(35,1,7,'Type','Type','2','Type-2',1,0,'A','admin','2015-11-30 19:49:16'),(36,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'M','admin','2015-12-15 09:32:14'),(36,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'M','admin','2015-12-15 09:32:14'),(36,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'M','admin','2015-12-15 09:32:14'),(36,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'M','admin','2015-12-15 09:32:14'),(36,1,5,'Race','Race','4','Race-4',1,0,'M','admin','2015-12-15 09:32:14'),(36,1,6,'Categorie','Categorie','4','Categorie-4',1,0,'M','admin','2015-12-15 09:32:14'),(36,1,7,'Type','Type','1','Type-1',1,0,'M','admin','2015-12-15 09:32:14'),(37,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-15 09:09:57'),(37,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-15 09:09:57'),(37,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-15 09:09:57'),(37,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-15 09:09:57'),(37,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-12-15 09:09:57'),(37,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'A','admin','2015-12-15 09:09:57'),(37,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-12-15 09:09:57'),(38,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-15 09:23:22'),(38,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-15 09:23:22'),(38,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-15 09:23:22'),(38,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-15 09:23:22'),(38,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-12-15 09:23:22'),(38,1,6,'Categorie','Categorie','2','Categorie-2',1,0,'A','admin','2015-12-15 09:23:22'),(38,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-12-15 09:23:22'),(39,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-16 07:20:30'),(39,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-16 07:20:30'),(39,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-16 07:20:30'),(39,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-16 07:20:30'),(39,1,5,'Race','Race','2','Race-2',1,0,'A','admin','2015-12-16 07:20:30'),(39,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-12-16 07:20:30'),(39,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-12-16 07:20:30'),(40,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-29 14:07:44'),(40,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-29 14:07:44'),(40,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-29 14:07:44'),(40,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-29 14:07:44'),(40,1,5,'Race','Race','4','Race-4',1,0,'A','admin','2015-12-29 14:07:44'),(40,1,6,'Categorie','Categorie','4','Categorie-4',1,0,'A','admin','2015-12-29 14:07:44'),(40,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-12-29 14:07:44'),(41,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-29 14:11:37'),(41,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-29 14:11:37'),(41,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-29 14:11:37'),(41,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-29 14:11:37'),(41,1,5,'Race','Race','1','Race-1',1,0,'A','admin','2015-12-29 14:11:37'),(41,1,6,'Categorie','Categorie','1','Categorie-1',1,0,'A','admin','2015-12-29 14:11:37'),(41,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-12-29 14:11:37'),(42,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-29 16:59:16'),(42,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-29 16:59:16'),(42,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-29 16:59:16'),(42,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-29 16:59:16'),(42,1,5,'Race','Race','1','Race-1',1,0,'A','admin','2015-12-29 16:59:16'),(42,1,6,'Categorie','Categorie','6','Categorie-6',1,0,'A','admin','2015-12-29 16:59:16'),(42,1,7,'Type','Type','1','Type-1',1,0,'A','admin','2015-12-29 16:59:16'),(43,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,0,'A','admin','2015-12-30 12:16:31'),(43,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,0,'A','admin','2015-12-30 12:16:31'),(43,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,0,'A','admin','2015-12-30 12:16:31'),(43,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,0,'A','admin','2015-12-30 12:16:31'),(43,1,5,'Race','Race','3','Race-3',1,0,'A','admin','2015-12-30 12:16:31'),(43,1,6,'Categorie','Categorie','3','Categorie-3',1,0,'A','admin','2015-12-30 12:16:31'),(43,1,7,'Type','Type','3','Type-3',1,0,'A','admin','2015-12-30 12:16:31'),(44,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,1,'M','admin','2016-01-05 14:02:13'),(44,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,1,'M','admin','2016-01-05 14:02:13'),(44,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,1,'M','admin','2016-01-05 14:02:13'),(44,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,1,'M','admin','2016-01-05 14:02:13'),(44,1,5,'Race','Race','4','Race-4',1,1,'M','admin','2016-01-05 14:02:13'),(44,1,6,'Categorie','Categorie','4','Categorie-4',1,1,'M','admin','2016-01-05 14:02:13'),(44,1,7,'Type','Type','1','Type-1',1,1,'M','admin','2016-01-05 14:02:13');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_detalle_elem_asociado` ENABLE KEYS */;

--
-- Table structure for table `dat_divisas`
--

DROP TABLE IF EXISTS `dat_divisas`;
CREATE TABLE `dat_divisas` (
  `IdDivisa` int(11) NOT NULL,
  `Nombre` varchar(20) default NULL,
  `Simbolo` varchar(7) default NULL,
  `Cambio` decimal(6,3) default NULL,
  `DivisaActiva` tinyint(1) default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  UNIQUE KEY `IdEmpresa` (`IdEmpresa`,`IdDivisa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_divisas`
--


/*!40000 ALTER TABLE `dat_divisas` DISABLE KEYS */;
LOCK TABLES `dat_divisas` WRITE;
INSERT INTO `dat_divisas` (`IdDivisa`, `Nombre`, `Simbolo`, `Cambio`, `DivisaActiva`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,'Corona Sueca','Skr','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:25'),(1,'Yen','Y','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:17'),(2,'Corona Noruega','Nkr','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:17'),(3,'Libra','L','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:18'),(4,'Euro','E','0.000',0,1,0,'A','admindfs','2010-11-09 11:43:17'),(5,'Dolar USA','$','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:23'),(6,'Franco Suizo','SwF','0.000',0,1,0,'A','admindfs','2010-11-09 11:48:20'),(7,'Corona Danesa','DKr','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:22');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_divisas` ENABLE KEYS */;

--
-- Table structure for table `dat_divisas_t_b`
--

DROP TABLE IF EXISTS `dat_divisas_t_b`;
CREATE TABLE `dat_divisas_t_b` (
  `IdDivisa` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdDivisa`),
  KEY `BusquedaDivisas` (`IdEmpresa`,`IdDivisa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_divisas_t_b`
--


/*!40000 ALTER TABLE `dat_divisas_t_b` DISABLE KEYS */;
LOCK TABLES `dat_divisas_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_divisas_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_elem_asociado`
--

DROP TABLE IF EXISTS `dat_elem_asociado`;
CREATE TABLE `dat_elem_asociado` (
  `IdElemAsociado` int(11) NOT NULL,
  `NombreElemAsociado` varchar(25) NOT NULL,
  `IdClase` int(11) NOT NULL,
  `Peso` double(15,3) default NULL,
  `FechaCreacion` datetime default NULL,
  `FechaCaducidad` datetime default NULL,
  `FechaMaduracion` datetime default NULL,
  `Texto1` text,
  `Peso1` double(15,3) default NULL,
  `Porcentaje1` double(9,3) default NULL,
  `Texto2` text,
  `Peso2` double(15,3) default NULL,
  `Porcentaje2` double(9,3) default NULL,
  `Texto3` text,
  `Peso3` double(15,3) default NULL,
  `Porcentaje3` double(9,3) default NULL,
  `Texto4` text,
  `Peso4` double(15,3) default NULL,
  `Porcentaje4` double(9,3) default NULL,
  `PesoLote` double(15,3) default NULL,
  `BandejasT` int(11) default '0',
  `BandejasE` int(11) default '0',
  `BandejasTE` int(11) default '0',
  `PesoVendidoT` double(15,3) default '0.000',
  `PesoVendidoE` double(15,3) default '0.000',
  `PesoVendidoTE` double(15,3) default '0.000',
  `ImporteVendidoT` double(15,3) default '0.000',
  `ImporteVendidoE` double(15,3) default '0.000',
  `ImporteVendidoTE` double(15,3) default '0.000',
  `Activo` tinyint(1) NOT NULL default '1',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdElemAsociado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de los parametros';

--
-- Dumping data for table `dat_elem_asociado`
--


/*!40000 ALTER TABLE `dat_elem_asociado` DISABLE KEYS */;
LOCK TABLES `dat_elem_asociado` WRITE;
INSERT INTO `dat_elem_asociado` (`IdElemAsociado`, `NombreElemAsociado`, `IdClase`, `Peso`, `FechaCreacion`, `FechaCaducidad`, `FechaMaduracion`, `Texto1`, `Peso1`, `Porcentaje1`, `Texto2`, `Peso2`, `Porcentaje2`, `Texto3`, `Peso3`, `Porcentaje3`, `Texto4`, `Peso4`, `Porcentaje4`, `PesoLote`, `BandejasT`, `BandejasE`, `BandejasTE`, `PesoVendidoT`, `PesoVendidoE`, `PesoVendidoTE`, `ImporteVendidoT`, `ImporteVendidoE`, `ImporteVendidoTE`, `Activo`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'H08247676',1,1500.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,1500.000,0,2492,2492,0.000,1229.666,1229.666,0.000,14135.370,14135.370,1,1,0,'M','admin','2015-12-23 08:34:14'),(2,'H38262315',1,3000.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,3000.000,0,6360,6360,0.000,2529.074,2529.074,0.000,40650.130,40650.130,1,1,0,'M','admin','2015-11-26 22:32:14'),(3,'CO38866715',1,3000.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,3000.000,0,4043,4043,0.000,1604.538,1604.538,0.000,28696.460,28696.460,1,1,0,'M','admin','2015-11-20 11:30:20'),(4,'H40243815',1,3500.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,3500.000,0,7278,7278,0.000,2548.816,2548.816,0.000,24824.600,24824.600,1,1,0,'M','admin','2015-12-23 08:35:38'),(5,'H40262815',1,4350.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,4350.000,0,2998,2998,0.000,1246.157,1246.157,0.000,12645.100,12645.100,1,1,0,'M','admin','2015-12-23 08:36:54'),(6,'H42254815',1,9000.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,9000.000,0,1122,1122,0.000,504.302,504.302,0.000,7303.960,7303.960,1,1,0,'M','admin','2015-12-23 08:35:15'),(7,'H42263515',1,600.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,600.000,0,215,215,0.000,77.632,77.632,0.000,1240.920,1240.920,1,1,0,'M','admin','2015-11-17 16:17:03'),(8,'Q42558815',1,550.000,NULL,NULL,NULL,'ALOIYAU',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,550.000,0,2952,2952,0.000,1889.122,1889.122,0.000,12679.590,12679.590,1,1,0,'M','admin','2015-11-17 16:17:03'),(9,'AL43TG15',1,202.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,202.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'M','admin','2015-11-17 16:17:03'),(10,'H28227015',1,250.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,250.000,0,91,91,0.000,19.016,19.016,0.000,-372.820,-372.820,1,1,0,'M','admin','2015-11-17 16:17:03'),(11,'AL44TG15',1,250.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,250.000,0,12,12,0.000,8.680,8.680,0.000,82.480,82.480,1,1,0,'M','admin','2015-12-03 12:03:16'),(12,'CO43339815',1,800.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,800.000,0,36,36,0.000,33.870,33.870,0.000,874.930,874.930,1,1,0,'M','admin','2015-11-20 11:35:42'),(13,'CO44914615',1,250.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,250.000,0,964,964,0.000,382.024,382.024,0.000,5481.670,5481.670,1,1,0,'M','admin','2015-12-23 08:36:41'),(14,'H44881015',1,600.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,600.000,0,6684,6684,0.000,2659.390,2659.390,0.000,49579.630,49579.630,1,1,0,'M','admin','2015-12-17 18:09:30'),(15,'H45264115',1,400.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,400.000,0,1209,1209,0.000,839.936,839.936,0.000,10682.680,10682.680,1,1,0,'M','admin','2015-12-17 18:11:05'),(16,'H45265115',1,400.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,400.000,0,2056,2056,0.000,940.126,940.126,0.000,11852.810,11852.810,1,1,0,'M','admin','2015-12-23 08:33:25'),(17,'CO45557315',1,600.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,600.000,0,3701,3701,0.000,1442.030,1442.030,0.000,19548.290,19548.290,1,1,0,'M','admin','2015-11-26 22:32:11'),(18,'AL45TG15',1,250.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,250.000,0,1149,1149,0.000,312.196,312.196,0.000,8253.020,8253.020,1,1,0,'M','admin','2015-11-17 16:17:03'),(19,'CO45AGNX15',1,500.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,500.000,0,3,3,0.000,0.920,0.920,0.000,15.290,15.290,1,1,0,'M','admin','2015-12-23 08:36:55'),(20,'CO46AGNX15',1,500.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,500.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'M','admin','2015-11-17 16:17:03'),(21,'AL46TG15',1,150.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,150.000,0,63,63,0.000,22.770,22.770,0.000,516.630,516.630,1,1,0,'M','admin','2015-11-17 16:17:03'),(22,'CO46800315',1,300.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,300.000,0,529,529,0.000,441.762,441.762,0.000,2827.740,2827.740,1,1,0,'M','admin','2015-12-03 11:57:35'),(23,'AL47TG15',1,200.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,200.000,0,179,179,0.000,61.430,61.430,0.000,1418.290,1418.290,1,1,0,'M','admin','2015-11-20 11:30:21'),(24,'AL48TG15',1,150.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,150.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'A','admin','2015-11-24 11:04:18'),(25,'CO47255715',1,500.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,500.000,0,4194,4194,0.000,1527.744,1527.744,0.000,23642.420,23642.420,1,1,0,'M','admin','2015-12-03 11:57:35'),(26,'CO46AGNX15',1,150.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,150.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'M','admin','2015-11-17 16:18:42'),(27,'N46910915',1,600.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,600.000,0,4431,4431,0.000,2416.498,2416.498,0.000,16245.630,16245.630,1,1,0,'M','admin','2015-12-17 18:11:05'),(28,'CO48800515',1,250.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,250.000,0,977,977,0.000,343.812,343.812,0.000,5539.270,5539.270,1,1,0,'A','admin','2015-12-03 12:03:22'),(29,'CO48366915',1,400.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,400.000,0,7,7,0.000,1.414,1.414,0.000,23.980,23.980,1,1,0,'M','admin','2015-12-23 08:35:17'),(30,'CO47463915',1,500.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,500.000,0,436,436,0.000,141.258,141.258,0.000,2345.560,2345.560,1,1,0,'A','admin','2015-11-26 22:30:02'),(31,'CO49114215',1,600.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,600.000,0,1854,1854,0.000,679.734,679.734,0.000,10262.030,10262.030,1,1,0,'A','admin','2015-12-03 12:03:17'),(32,'H49206315',1,600.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,600.000,0,503,503,0.000,237.994,237.994,0.000,4059.700,4059.700,1,1,0,'A','admin','2015-12-23 08:37:04'),(33,'CO51870015',1,350.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,350.000,0,190,190,0.000,88.530,88.530,0.000,1394.060,1394.060,1,1,0,'A','admin','2015-12-23 08:36:50'),(34,'CO49AGNX15',1,100.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,100.000,0,1,1,0.000,6.730,6.730,0.000,90.860,90.860,1,1,0,'M','admin','2016-01-04 14:51:51'),(35,'M48366915',1,201.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,201.000,0,2,2,0.000,1.512,1.512,0.000,17.840,17.840,1,1,0,'A','admin','2015-12-03 11:57:45'),(36,'TG51AGNX15',1,201.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,201.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'M','admin','2015-12-15 14:59:18'),(37,'N50914715',1,400.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,400.000,0,239,239,0.000,155.727,155.727,0.000,1501.270,1501.270,1,1,0,'A','admin','2015-12-23 08:36:03'),(38,'N51212915',1,400.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,400.000,0,330,330,0.000,123.322,123.322,0.000,2044.070,2044.070,1,1,0,'A','admin','2015-12-23 08:36:50'),(39,'CO49482315',1,500.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,500.000,0,409,409,0.000,173.401,173.401,0.000,2308.910,2308.910,1,1,0,'A','admin','2015-12-23 08:43:13'),(40,'TG53AGNX15',1,60.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,60.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'A','admin','2015-12-29 14:07:52'),(41,'CO53389115',1,600.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,600.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'A','admin','2015-12-29 14:11:42'),(42,'H53265415',1,400.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,400.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'A','admin','2015-12-29 16:59:27'),(43,'AI53713515',1,300.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,300.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,0,'A','admin','2015-12-30 12:16:43'),(44,'CO1AGNX16',1,150.000,NULL,NULL,NULL,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,'',0.000,0.000,150.000,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,1,'M','admin','2016-01-05 14:02:13');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_elem_asociado` ENABLE KEYS */;

--
-- Table structure for table `dat_elem_asociado_t_b`
--

DROP TABLE IF EXISTS `dat_elem_asociado_t_b`;
CREATE TABLE `dat_elem_asociado_t_b` (
  `IdElemAsociado` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdElemAsociado`),
  KEY `BusquedaAnimales` (`IdEmpresa`,`IdElemAsociado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_elem_asociado_t_b`
--


/*!40000 ALTER TABLE `dat_elem_asociado_t_b` DISABLE KEYS */;
LOCK TABLES `dat_elem_asociado_t_b` WRITE;
INSERT INTO `dat_elem_asociado_t_b` (`IdElemAsociado`, `IdEmpresa`, `IdTienda`, `IdBalanza`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (44,1,1,10,1,'A','admin','2016-01-05 14:02:13');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_elem_asociado_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_empresa`
--

DROP TABLE IF EXISTS `dat_empresa`;
CREATE TABLE `dat_empresa` (
  `IdEmpresa` int(11) NOT NULL,
  `NombreEmpresa` varchar(100) NOT NULL,
  `CIF_VAT` varchar(14) default NULL,
  `Direccion` varchar(50) default NULL,
  `CodPostal` varchar(8) default NULL,
  `Poblacion` varchar(25) default NULL,
  `Provincia` varchar(25) default NULL,
  `Dir_IP` varchar(20) default NULL,
  `Dir_IP_Publica` varchar(20) default NULL,
  `Port` int(6) default NULL,
  `TipoBase` varchar(20) default NULL,
  `BaseDatos` varchar(50) default NULL,
  `UserDB` varchar(20) default NULL,
  `PasswDB` varchar(24) default NULL,
  `TimeOutConnection` int(4) default '15',
  `CodBarrasEtiquetas` int(11) default NULL,
  `CodBarrasTickets` int(11) default NULL,
  `CodBarrasPreenvasado` int(11) default NULL,
  `CodBarrasTalonCaja` int(11) default NULL,
  `FormatoEtiquetasUnitarias` int(11) default NULL,
  `FormatoEtiquetasPesadas` int(11) default NULL,
  `FormatoTickets` int(11) default NULL,
  `FormatoTalonCaja` int(11) default NULL,
  `FormatoFactura` int(11) default NULL,
  `FormatoAlbaran` int(11) default NULL,
  `NumReintentosComunicaciones` int(11) default '2',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las empresas';

--
-- Dumping data for table `dat_empresa`
--


/*!40000 ALTER TABLE `dat_empresa` DISABLE KEYS */;
LOCK TABLES `dat_empresa` WRITE;
INSERT INTO `dat_empresa` (`IdEmpresa`, `NombreEmpresa`, `CIF_VAT`, `Direccion`, `CodPostal`, `Poblacion`, `Provincia`, `Dir_IP`, `Dir_IP_Publica`, `Port`, `TipoBase`, `BaseDatos`, `UserDB`, `PasswDB`, `TimeOutConnection`, `CodBarrasEtiquetas`, `CodBarrasTickets`, `CodBarrasPreenvasado`, `CodBarrasTalonCaja`, `FormatoEtiquetasUnitarias`, `FormatoEtiquetasPesadas`, `FormatoTickets`, `FormatoTalonCaja`, `FormatoFactura`, `FormatoAlbaran`, `NumReintentosComunicaciones`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'','','','','','','192.168.1.58','192.168.1.58',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,'M','admin','2015-11-02 16:52:14');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_empresa` ENABLE KEYS */;

--
-- Table structure for table `dat_esclava`
--

DROP TABLE IF EXISTS `dat_esclava`;
CREATE TABLE `dat_esclava` (
  `IdEsclava` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Nombre` varchar(50) default NULL,
  `BalanzaTradicional` tinyint(1) NOT NULL default '0',
  `IdDIBAL` varchar(20) default NULL,
  `EtiquetasGestionStock` tinyint(1) NOT NULL default '0',
  `Dir_IP` varchar(20) default NULL,
  `Port` int(6) default NULL,
  `TipoBase` varchar(20) default NULL,
  `BaseDatos` varchar(50) default NULL,
  `UserDB` varchar(20) default NULL,
  `PasswDB` varchar(24) default NULL,
  `TimeOutConnection` int(4) default '15',
  `CaducidadGlobal` tinyint(1) NOT NULL default '0',
  `FechaActivada` tinyint(1) NOT NULL default '1',
  `FechaCaducidad` datetime default NULL,
  `Dias` int(3) default '0',
  `Horas` int(3) default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Dir_IP_Publica` varchar(20) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdEsclava`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las balanzas';

--
-- Dumping data for table `dat_esclava`
--


/*!40000 ALTER TABLE `dat_esclava` DISABLE KEYS */;
LOCK TABLES `dat_esclava` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_esclava` ENABLE KEYS */;

--
-- Table structure for table `dat_estado`
--

DROP TABLE IF EXISTS `dat_estado`;
CREATE TABLE `dat_estado` (
  `IdEstado` int(11) NOT NULL,
  `NombreEstado` varchar(25) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdEstado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los distintos estados que se pueden t';

--
-- Dumping data for table `dat_estado`
--


/*!40000 ALTER TABLE `dat_estado` DISABLE KEYS */;
LOCK TABLES `dat_estado` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_estado` ENABLE KEYS */;

--
-- Table structure for table `dat_etiqueta`
--

DROP TABLE IF EXISTS `dat_etiqueta`;
CREATE TABLE `dat_etiqueta` (
  `IdEtiqueta` int(11) NOT NULL,
  `NombreEtiqueta` varchar(255) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdEtiqueta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de las etiquetas. Ta';

--
-- Dumping data for table `dat_etiqueta`
--


/*!40000 ALTER TABLE `dat_etiqueta` DISABLE KEYS */;
LOCK TABLES `dat_etiqueta` WRITE;
INSERT INTO `dat_etiqueta` (`IdEtiqueta`, `NombreEtiqueta`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (4,'Ticket',1,0,'M','admin','2009-05-08 09:38:36'),(5,'etiquetaPesado',1,0,'M','admin','2009-05-08 09:38:37'),(6,'etiquetaUnitario',1,0,'A','admin','2009-05-08 09:38:37'),(7,'Ticket_en',1,0,'A','admin','2009-05-08 09:38:37'),(8,'etiquetaPesado_en',1,0,'A','admin','2009-05-08 09:38:37'),(9,'etiquetaUnitario_en',1,0,'A','admin','2009-05-08 09:38:37'),(10,'CounterFoil',1,0,'A','admin','2009-12-11 07:34:00'),(11,'CounterFoil_en',1,0,'A','admin','2010-03-23 07:50:54');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_etiqueta` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion`
--

DROP TABLE IF EXISTS `dat_exportacion`;
CREATE TABLE `dat_exportacion` (
  `IdExportacion` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `NombreExportacion` varchar(50) default NULL,
  `Activo` tinyint(1) NOT NULL default '1',
  `FicheroExportacion` varchar(1000) default NULL,
  `FicheroRx` tinyint(1) default '0' COMMENT '0: Fichero configurable, 1: FicheroRx',
  `FicheroTicket` tinyint(1) default '0' COMMENT '0: Todos los tickets a un fichero, 1: Cada ticket a un fichero.',
  `TipoLineas` tinyint(1) default '0' COMMENT '0:Ambos, 1:Ticket, 2:Etiqueta',
  `ConcaternarLineaATotal` int(11) default '0',
  `IdFtp` int(11) default '0',
  `DirectorioFtp` varchar(300) NOT NULL,
  `NumeroConsecutivo` int(11) NOT NULL default '0',
  `FechaUltimaExportacion` datetime default NULL,
  `FormatoRegistro` varchar(10) default NULL,
  `TipoFicheroExportacion` int(11) NOT NULL default '0',
  PRIMARY KEY  (`IdExportacion`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_exportacion`
--


/*!40000 ALTER TABLE `dat_exportacion` DISABLE KEYS */;
LOCK TABLES `dat_exportacion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion_campos`
--

DROP TABLE IF EXISTS `dat_exportacion_campos`;
CREATE TABLE `dat_exportacion_campos` (
  `IdExportacion` int(11) NOT NULL default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `PosicionInicial` int(11) NOT NULL default '0',
  `Longitud` int(11) default NULL,
  `IdCampo` varchar(50) default NULL,
  `IdTipo` int(11) default NULL,
  `Valor` varchar(50) default NULL COMMENT 'Valor no reemplazable',
  `IdLugar` int(11) NOT NULL default '0' COMMENT '0:Cabecera, 1: L?neas, 2: Nombre fichero, 3: Extensi?n del fichero',
  PRIMARY KEY  (`IdExportacion`,`IdEmpresa`,`PosicionInicial`,`IdLugar`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_exportacion_campos`
--


/*!40000 ALTER TABLE `dat_exportacion_campos` DISABLE KEYS */;
LOCK TABLES `dat_exportacion_campos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion_campos` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion_parametros`
--

DROP TABLE IF EXISTS `dat_exportacion_parametros`;
CREATE TABLE `dat_exportacion_parametros` (
  `IdParametro` int(11) NOT NULL,
  `Hora` datetime default NULL,
  PRIMARY KEY  (`IdParametro`),
  UNIQUE KEY `IdParametro` (`IdParametro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_exportacion_parametros`
--


/*!40000 ALTER TABLE `dat_exportacion_parametros` DISABLE KEYS */;
LOCK TABLES `dat_exportacion_parametros` WRITE;
INSERT INTO `dat_exportacion_parametros` (`IdParametro`, `Hora`) VALUES (1,NULL),(2,NULL),(3,NULL),(4,NULL),(5,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion_parametros` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion_parametros_general`
--

DROP TABLE IF EXISTS `dat_exportacion_parametros_general`;
CREATE TABLE `dat_exportacion_parametros_general` (
  `tipoExportacion` tinyint(1) default '0' COMMENT '0- Continua 1- Por horas',
  `ExportarBalanzasSeleccionadas` tinyint(1) default '0',
  `FinDia` tinyint(1) NOT NULL default '0',
  `HoraFinDia` datetime default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_exportacion_parametros_general`
--


/*!40000 ALTER TABLE `dat_exportacion_parametros_general` DISABLE KEYS */;
LOCK TABLES `dat_exportacion_parametros_general` WRITE;
INSERT INTO `dat_exportacion_parametros_general` (`tipoExportacion`, `ExportarBalanzasSeleccionadas`, `FinDia`, `HoraFinDia`) VALUES (0,1,0,'2015-09-16 23:00:00');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion_parametros_general` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion_tipo_campo`
--

DROP TABLE IF EXISTS `dat_exportacion_tipo_campo`;
CREATE TABLE `dat_exportacion_tipo_campo` (
  `IdTipo` int(11) NOT NULL,
  `GrupoTipo` varchar(50) NOT NULL,
  `GrupoNombre` varchar(50) NOT NULL default 'DATE',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Formato` varchar(20) default '#',
  `Nombre` varchar(50) default NULL,
  `Basico` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`IdTipo`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_exportacion_tipo_campo`
--


/*!40000 ALTER TABLE `dat_exportacion_tipo_campo` DISABLE KEYS */;
LOCK TABLES `dat_exportacion_tipo_campo` WRITE;
INSERT INTO `dat_exportacion_tipo_campo` (`IdTipo`, `GrupoTipo`, `GrupoNombre`, `IdEmpresa`, `Formato`, `Nombre`, `Basico`) VALUES (-7,'ean_format','EAN',1,'#','2CCCCCCEEEEEQ',1),(-6,'decimal_percentage','DECIMAL',1,'2','Default',1),(-5,'no_replace','NOREPLACE',1,'#','Default',1),(-4,'decimal_weight','DECIMAL',1,'3','Default',1),(-3,'decimal_price','DECIMAL',1,'REGIONAL','Default',1),(-2,'numeric_format','INTEGER',1,'#','Default',1),(-1,'text_format','STRING',1,'#','Default',1),(1,'date_format','DATE',1,'DDMMYY','Short date',1),(2,'date_format','DATE',1,'JJJ','Julian date',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion_tipo_campo` ENABLE KEYS */;

--
-- Table structure for table `dat_fin_de_dia`
--

DROP TABLE IF EXISTS `dat_fin_de_dia`;
CREATE TABLE `dat_fin_de_dia` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanzaMaestra` int(11) NOT NULL,
  `IdFinDeDia` bigint(20) NOT NULL,
  `NumFinDeDia` bigint(20) default NULL,
  `Grupo` varchar(2) default NULL,
  `Borrado` varchar(1) default NULL COMMENT 'Indica si se tratade una transmision con o sin puesta a cero de los totalizadores. 0->Sin borrado. 1->Con borrado',
  `Clientes` int(11) default NULL COMMENT 'Numero de tickets de todo tipo. Total number of tickets.',
  `ImporteTotal` double(15,3) default NULL COMMENT 'Suma con signo de totales de tickets de todo tipo.',
  `ClientesMayoristas` int(11) default NULL COMMENT 'Numero de tickets de clientes mayoristas.',
  `ImporteMayoristas` double(15,3) default NULL COMMENT 'Suma de importes de totales de tickets de clientes mayoristas',
  `ClientesNegativos` int(11) default NULL COMMENT 'Numero de tickets negativos.',
  `ImporteNegativos` double(15,3) default NULL COMMENT 'Suma de importes de totales de tickets negativos',
  `ProductosPesados` int(11) default NULL COMMENT 'Numero de operaciones que implican pesaje',
  `ImportePesados` double(15,3) default NULL COMMENT 'Suma de las operaciones que implican pesaje',
  `ProductosNoPesados` int(11) default NULL COMMENT 'Numero de operaciones que no implican pesaje (sumas, restas, multiplicaciones).',
  `ImporteNoPesados` double(15,3) default NULL COMMENT 'Suma de las operaciones que no implican pesaje',
  `ProductosDevueltos` int(11) default NULL COMMENT 'Numero de operaciones que suponen retorno de mercancia (restas para productos no pesados, devoluciones para productos pesados).',
  `ImporteDevueltos` double(15,3) default NULL COMMENT 'Suma de las operaciones que suponen retorno de mercancia.',
  `Libres` varchar(19) default NULL,
  `Fecha` datetime default NULL,
  `Correcto` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `Exportado` tinyint(1) NOT NULL default '0' COMMENT 'Acumulados no exportados. Se pone a 1 al exportarlos el RGI',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdFinDeDia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda los fines de dIa recogidos de las L';

--
-- Dumping data for table `dat_fin_de_dia`
--


/*!40000 ALTER TABLE `dat_fin_de_dia` DISABLE KEYS */;
LOCK TABLES `dat_fin_de_dia` WRITE;
INSERT INTO `dat_fin_de_dia` (`IdEmpresa`, `IdTienda`, `IdBalanzaMaestra`, `IdFinDeDia`, `NumFinDeDia`, `Grupo`, `Borrado`, `Clientes`, `ImporteTotal`, `ClientesMayoristas`, `ImporteMayoristas`, `ClientesNegativos`, `ImporteNegativos`, `ProductosPesados`, `ImportePesados`, `ProductosNoPesados`, `ImporteNoPesados`, `ProductosDevueltos`, `ImporteDevueltos`, `Libres`, `Fecha`, `Correcto`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`, `Exportado`) VALUES (1,1,10,1,1,'50','1',5725,32743.730,4941,32586.500,4,-161.230,5720,32785.230,5,-41.500,5,-161.230,'0000000000000000000','2015-11-02 17:32:00',0,1,'A','Comunicaciones','2015-11-02 16:33:09',0),(1,1,10,2,2,'50','1',3382,21229.910,3058,21625.910,18,-396.000,3364,21625.910,18,-396.000,18,-396.000,'0000000000000000000','2015-11-17 17:20:00',0,1,'A','Comunicaciones','2015-11-17 16:20:31',0),(1,1,10,3,3,'50','1',1937,10698.360,1117,10720.360,1,-22.000,1935,10698.360,2,0.000,1,-22.000,'0000000000000000000','2015-11-20 13:13:00',1,1,'A','Comunicaciones','2015-11-20 12:13:50',0),(1,1,10,4,4,'50','1',679,4200.440,678,4200.440,0,0.000,679,4200.440,0,0.000,0,0.000,'0000000000000000000','2015-11-26 23:35:00',0,1,'A','Comunicaciones','2015-11-26 22:36:11',0),(1,1,10,5,5,'50','1',941,5289.740,925,5289.740,0,0.000,941,5289.740,0,0.000,0,0.000,'0000000000000000000','2015-12-03 13:03:00',0,1,'A','Comunicaciones','2015-12-03 12:04:03',0),(1,1,10,6,6,'50','1',1176,7391.450,1109,7391.450,0,0.000,1176,7391.450,0,0.000,0,0.000,'0000000000000000000','2015-12-14 21:41:00',0,1,'A','Comunicaciones','2015-12-14 20:41:48',0),(1,1,10,7,7,'50','1',1055,7182.860,1011,7182.860,0,0.000,1055,7182.860,0,0.000,0,0.000,'0000000000000000000','2015-12-17 19:12:00',0,1,'A','Comunicaciones','2015-12-17 18:12:48',0),(1,1,10,8,8,'50','1',854,6668.690,824,6668.690,0,0.000,854,6668.690,0,0.000,0,0.000,'0000000000000000000','2015-12-23 09:43:00',0,1,'A','Comunicaciones','2015-12-23 08:43:33',0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_fin_de_dia` ENABLE KEYS */;

--
-- Table structure for table `dat_fin_de_dia_articulo`
--

DROP TABLE IF EXISTS `dat_fin_de_dia_articulo`;
CREATE TABLE `dat_fin_de_dia_articulo` (
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanzaMaestra` int(11) NOT NULL default '0',
  `IdFinDeDia` bigint(20) NOT NULL default '0',
  `NumFinDeDia` bigint(20) default NULL,
  `IdArticulo` int(11) NOT NULL default '0',
  `Peso` double(15,3) default NULL,
  `Precio` double(15,3) default NULL,
  `Importe` double(15,3) default NULL,
  `ImporteSecundario` double(15,3) default NULL,
  `NumeroOperaciones` int(11) default NULL,
  `IdSeccion` int(11) default NULL COMMENT 'Id Seccion del articulo.\\r\\nSection ID of the article.',
  `EANScanner` varchar(20) default NULL COMMENT 'Codigo EANScanner del articulo.\\r\\nEANScanner code of the article.',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdFinDeDia`,`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_fin_de_dia_articulo`
--


/*!40000 ALTER TABLE `dat_fin_de_dia_articulo` DISABLE KEYS */;
LOCK TABLES `dat_fin_de_dia_articulo` WRITE;
INSERT INTO `dat_fin_de_dia_articulo` (`IdEmpresa`, `IdTienda`, `IdBalanzaMaestra`, `IdFinDeDia`, `NumFinDeDia`, `IdArticulo`, `Peso`, `Precio`, `Importe`, `ImporteSecundario`, `NumeroOperaciones`, `IdSeccion`, `EANScanner`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,10,1,1,0,12.270,NULL,170.930,170.930,4,0,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,1,73.490,NULL,1493.970,1493.970,228,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,2,40.230,NULL,760.090,760.090,202,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,3,42.088,NULL,449.390,449.390,94,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,4,6.770,NULL,22.360,22.360,8,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,5,0.530,NULL,5.050,5.050,5,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,6,99.882,NULL,2074.320,2074.320,280,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,8,18.072,NULL,0.000,0.000,79,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,11,4.858,NULL,86.460,86.460,20,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,12,83.686,NULL,460.060,460.060,101,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,13,18.864,NULL,187.870,187.870,22,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,15,75.976,NULL,1005.000,1005.000,101,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,16,95.602,NULL,1999.370,1999.370,192,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,17,34.706,NULL,500.540,500.540,119,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,18,399.659,NULL,3982.310,3982.310,1246,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,19,74.972,NULL,543.650,543.650,81,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,22,11.138,NULL,121.490,121.490,23,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,25,8.346,NULL,82.870,82.870,7,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,26,1.062,NULL,8.500,8.500,1,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,27,5.176,NULL,102.930,102.930,7,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,28,2.686,NULL,53.360,53.360,7,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,29,4.768,NULL,81.520,81.520,27,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,33,4.758,NULL,38.060,38.060,9,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,34,2.236,NULL,0.000,0.000,6,1,'',1,'A','Comunicaciones','2015-11-02 16:33:06'),(1,1,10,1,1,35,5.326,NULL,19.740,19.740,3,1,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,37,12.130,NULL,116.100,116.100,18,1,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,38,153.090,NULL,2589.610,2589.610,647,1,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,42,32.816,NULL,1158.440,1158.440,143,1,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,44,49.600,NULL,0.000,0.000,44,1,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,53,15.814,NULL,380.180,380.180,52,1,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,201,6.888,NULL,281.670,281.670,14,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,203,15.916,NULL,141.540,141.540,38,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,204,7.972,NULL,70.730,70.730,21,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,205,36.108,NULL,663.110,663.110,136,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,206,9.932,NULL,212.650,212.650,15,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,208,1.314,NULL,7.620,7.620,9,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,224,3.202,NULL,28.810,28.810,6,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,228,19.918,NULL,387.070,387.070,17,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,229,32.018,NULL,672.390,672.390,160,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,231,7.802,NULL,142.410,142.410,32,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,232,1.756,NULL,33.020,33.020,7,3,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,310,2.096,NULL,42.550,42.550,11,4,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,500,4.870,NULL,109.670,109.670,23,7,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,601,27.984,NULL,507.250,507.250,63,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,602,5.624,NULL,89.730,89.730,12,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,604,2.918,NULL,56.040,56.040,12,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,606,12.423,NULL,81.870,81.870,19,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,608,5.686,NULL,73.910,73.910,10,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,610,2.790,NULL,63.120,63.120,5,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,612,92.630,NULL,1180.080,1180.080,107,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,613,129.250,NULL,1800.760,1800.760,345,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,614,45.046,NULL,772.840,772.840,62,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,617,45.109,NULL,819.860,819.860,103,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,618,0.566,NULL,8.770,8.770,2,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,619,3.300,NULL,49.500,49.500,13,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,620,0.894,NULL,10.720,10.720,2,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,621,104.894,NULL,1678.280,1678.280,490,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,622,0.270,NULL,3.240,3.240,1,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,624,0.666,NULL,16.650,16.650,2,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,626,1.622,NULL,24.330,24.330,1,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,628,18.542,NULL,247.230,247.230,41,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,631,20.820,NULL,545.580,545.580,91,5,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,701,0.096,NULL,0.090,0.090,1,6,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,717,0.058,NULL,0.220,0.220,1,6,'',1,'A','Comunicaciones','2015-11-02 16:33:07'),(1,1,10,1,1,750,0.804,NULL,32.960,32.960,1,6,'',1,'A','Comunicaciones','2015-11-02 16:33:08'),(1,1,10,1,1,901,224.920,NULL,3074.830,3074.830,46,1,'',1,'A','Comunicaciones','2015-11-02 16:33:08'),(1,1,10,1,1,904,0.926,NULL,0.000,0.000,1,0,'',1,'A','Comunicaciones','2015-11-02 16:33:08'),(1,1,10,2,2,1,51.918,NULL,1237.640,1237.640,168,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,2,22.490,NULL,521.520,521.520,107,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,3,36.184,NULL,635.590,635.590,70,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,4,18.804,NULL,464.580,464.580,12,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,5,16.904,NULL,193.940,193.940,18,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,6,52.168,NULL,1269.130,1269.130,127,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,10,2.874,NULL,35.940,35.940,5,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,11,0.670,NULL,13.330,13.330,4,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,12,99.232,NULL,573.570,573.570,121,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,13,35.498,NULL,294.740,294.740,44,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,15,48.592,NULL,971.570,971.570,52,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,16,44.642,NULL,1026.170,1026.170,84,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,17,59.406,NULL,683.100,683.100,205,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,18,141.694,NULL,1774.730,1774.730,444,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,19,59.534,NULL,501.170,501.170,81,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,23,5.490,NULL,108.710,108.710,17,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,25,2.154,NULL,70.650,70.650,2,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,26,3.512,NULL,30.120,30.120,4,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,27,3.306,NULL,65.760,65.760,8,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,28,1.268,NULL,25.240,25.240,3,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,29,3.424,NULL,68.040,68.040,17,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,34,4.322,NULL,34.570,34.570,5,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,35,7.490,NULL,71.050,71.050,4,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,37,5.250,NULL,55.610,55.610,7,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,38,66.116,NULL,1262.890,1262.890,258,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,42,20.316,NULL,692.870,692.870,81,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,91,0.286,NULL,4.110,4.110,2,1,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,201,57.048,NULL,611.590,611.590,16,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,202,2.364,NULL,0.000,0.000,2,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,203,1.366,NULL,12.300,12.300,4,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,204,15.262,NULL,46.850,46.850,40,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,205,38.732,NULL,321.550,321.550,148,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,206,5.214,NULL,86.270,86.270,8,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,208,4.658,NULL,0.000,0.000,15,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,209,1.218,NULL,0.000,0.000,4,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,210,0.074,NULL,0.000,0.000,1,3,'',1,'A','Comunicaciones','2015-11-17 16:20:29'),(1,1,10,2,2,221,5.074,NULL,95.400,95.400,6,3,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,224,1.602,NULL,14.420,14.420,2,3,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,228,10.788,NULL,142.320,142.320,9,3,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,229,15.344,NULL,266.470,266.470,77,3,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,234,0.134,NULL,0.000,0.000,1,3,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,310,0.314,NULL,6.910,6.910,1,4,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,381,18.837,NULL,298.900,298.900,49,7,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,500,20.186,NULL,48.510,48.510,78,7,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,601,30.746,NULL,501.200,501.200,77,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,602,7.348,NULL,117.560,117.560,17,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,606,1.508,NULL,22.620,22.620,5,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,608,17.212,NULL,222.440,222.440,17,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,612,88.568,NULL,1044.990,1044.990,106,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,613,67.816,NULL,858.660,858.660,162,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,614,76.276,NULL,699.040,699.040,41,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,617,19.902,NULL,364.030,364.030,51,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,619,7.954,NULL,154.710,154.710,29,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,620,2.606,NULL,19.640,19.640,3,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,621,60.520,NULL,987.890,987.890,323,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,622,0.734,NULL,8.810,8.810,3,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,624,1.662,NULL,42.780,42.780,3,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,628,15.984,NULL,164.980,164.980,49,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,631,15.404,NULL,425.990,425.990,68,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,632,3.422,NULL,40.140,40.140,5,5,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,901,5.664,NULL,82.130,82.130,1,1,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,903,53.877,NULL,724.710,724.710,10,0,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,2,2,907,8.130,NULL,109.760,109.760,1,0,'',1,'A','Comunicaciones','2015-11-17 16:20:30'),(1,1,10,3,3,1,27.648,NULL,330.730,330.730,99,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,2,18.476,NULL,233.260,233.260,92,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,3,25.574,NULL,203.480,203.480,71,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,4,20.954,NULL,0.000,0.000,13,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,5,7.178,NULL,82.660,82.660,11,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,6,29.276,NULL,412.500,412.500,82,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,8,0.318,NULL,6.870,6.870,1,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,10,22.574,NULL,0.000,0.000,90,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,11,1.542,NULL,36.300,36.300,6,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,12,54.167,NULL,136.630,136.630,74,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,13,8.134,NULL,78.470,78.470,9,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,14,6.186,NULL,154.650,154.650,3,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,15,32.616,NULL,214.090,214.090,36,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,16,25.530,NULL,481.680,481.680,49,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,17,13.630,NULL,201.690,201.690,50,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,18,136.784,NULL,795.950,795.950,369,1,'',1,'A','Comunicaciones','2015-11-20 12:13:48'),(1,1,10,3,3,19,52.376,NULL,166.040,166.040,91,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,25,0.892,NULL,27.650,27.650,1,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,26,1.206,NULL,11.820,11.820,1,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,27,0.744,NULL,14.810,14.810,1,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,28,0.414,NULL,8.240,8.240,1,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,29,1.688,NULL,35.290,35.290,10,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,33,8.360,NULL,0.000,0.000,34,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,34,1.566,NULL,14.090,14.090,9,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,35,4.012,NULL,38.150,38.150,2,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,36,1.136,NULL,10.220,10.220,2,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,37,4.628,NULL,43.490,43.490,6,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,38,65.474,NULL,622.540,622.540,292,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,42,5.698,NULL,187.130,187.130,27,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,203,4.940,NULL,65.850,65.850,9,3,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,204,1.930,NULL,17.360,17.360,4,3,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,205,10.250,NULL,183.760,183.760,34,3,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,206,2.932,NULL,61.580,61.580,4,3,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,228,5.290,NULL,94.160,94.160,4,3,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,229,7.700,NULL,161.700,161.700,39,3,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,500,0.706,NULL,15.530,15.530,6,7,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,612,67.623,NULL,273.170,273.170,27,5,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,613,21.088,NULL,276.800,276.800,62,5,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,614,6.496,NULL,113.200,113.200,11,5,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,617,14.034,NULL,255.900,255.900,40,5,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,621,21.096,NULL,387.580,387.580,84,5,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,631,8.868,NULL,221.700,221.700,41,5,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,3,3,901,287.316,NULL,4021.640,4021.640,40,1,'',1,'A','Comunicaciones','2015-11-20 12:13:49'),(1,1,10,4,4,1,9.592,NULL,245.460,245.460,33,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,2,2.350,NULL,60.290,60.290,11,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,3,6.608,NULL,142.740,142.740,16,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,5,2.356,NULL,28.270,28.270,4,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,6,19.698,NULL,522.040,522.040,65,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,12,11.888,NULL,77.280,77.280,15,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,13,7.536,NULL,71.600,71.600,13,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,15,6.432,NULL,138.930,138.930,7,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,16,14.192,NULL,376.100,376.100,33,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,17,4.482,NULL,69.470,69.470,19,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,18,54.184,NULL,724.130,724.130,170,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,19,13.742,NULL,164.910,164.910,17,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,38,14.398,NULL,310.970,310.970,60,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,42,3.090,NULL,111.240,111.240,8,1,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,500,0.170,NULL,3.740,3.740,1,7,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,607,2.474,NULL,29.690,29.690,2,5,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,608,2.700,NULL,35.090,35.090,8,5,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,612,6.994,NULL,91.270,91.270,9,5,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,613,24.394,NULL,305.050,305.050,78,5,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,614,9.898,NULL,176.180,176.180,12,5,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,617,11.978,NULL,225.180,225.180,35,5,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,621,9.610,NULL,181.610,181.610,40,5,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,4,4,631,4.368,NULL,109.200,109.200,23,5,'',1,'A','Comunicaciones','2015-11-26 22:36:09'),(1,1,10,5,5,0,0.136,NULL,1.600,1.600,1,0,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,1,13.254,NULL,317.830,317.830,40,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,2,6.980,NULL,161.150,161.150,37,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,3,4.044,NULL,69.330,69.330,7,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,5,2.534,NULL,30.400,30.400,4,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,6,13.878,NULL,335.790,335.790,46,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,11,0.756,NULL,15.050,15.050,4,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,12,14.800,NULL,85.210,85.210,22,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,13,12.412,NULL,120.860,120.860,15,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,15,6.548,NULL,138.960,138.960,8,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,16,11.770,NULL,294.090,294.090,28,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,17,5.748,NULL,74.120,74.120,20,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,18,70.230,NULL,898.430,898.430,226,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,19,10.284,NULL,105.280,105.280,12,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,25,2.094,NULL,64.920,64.920,5,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,26,1.330,NULL,13.030,13.030,1,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,27,0.750,NULL,14.930,14.930,1,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,28,0.640,NULL,12.730,12.730,3,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,29,0.752,NULL,14.960,14.960,4,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,35,1.614,NULL,16.140,16.140,1,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,37,1.618,NULL,15.850,15.850,2,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,38,17.166,NULL,364.280,364.280,80,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,42,4.116,NULL,148.190,148.190,16,1,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,201,2.258,NULL,0.000,0.000,1,3,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,203,1.276,NULL,11.490,11.490,3,3,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,204,3.162,NULL,18.260,18.260,7,3,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,205,11.284,NULL,160.000,160.000,38,3,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,206,2.068,NULL,43.420,43.420,3,3,'',1,'A','Comunicaciones','2015-12-03 12:04:01'),(1,1,10,5,5,228,4.392,NULL,59.380,59.380,4,3,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,229,5.218,NULL,109.560,109.560,30,3,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,601,7.314,NULL,137.520,137.520,17,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,608,6.100,NULL,74.550,74.550,14,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,612,19.106,NULL,248.390,248.390,21,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,613,23.544,NULL,296.060,296.060,67,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,614,4.314,NULL,72.760,72.760,7,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,617,9.562,NULL,173.100,173.100,30,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,619,2.962,NULL,44.430,44.430,12,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,621,19.710,NULL,361.030,361.030,88,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,631,3.032,NULL,75.800,75.800,15,5,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,5,5,907,6.730,NULL,90.860,90.860,1,0,'',1,'A','Comunicaciones','2015-12-03 12:04:02'),(1,1,10,6,6,1,23.280,NULL,565.110,565.110,59,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,2,11.974,NULL,288.030,288.030,51,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,3,5.594,NULL,111.070,111.070,11,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,5,6.914,NULL,72.610,72.610,10,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,6,24.164,NULL,600.130,600.130,71,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,11,1.988,NULL,44.920,44.920,8,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,12,44.676,NULL,265.160,265.160,55,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,13,13.860,NULL,127.620,127.620,19,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,15,15.414,NULL,331.400,331.400,12,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,16,27.168,NULL,644.630,644.630,56,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,17,11.662,NULL,142.340,142.340,52,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,18,76.538,NULL,903.330,903.330,237,1,'',1,'A','Comunicaciones','2015-12-14 20:41:44'),(1,1,10,6,6,19,28.050,NULL,270.740,270.740,32,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,25,2.996,NULL,99.320,99.320,3,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,26,4.992,NULL,41.620,41.620,5,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,27,1.278,NULL,25.440,25.440,2,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,28,0.320,NULL,6.370,6.370,1,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,29,2.234,NULL,47.260,47.260,12,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,35,3.850,NULL,38.500,38.500,2,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,37,7.426,NULL,78.260,78.260,9,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,38,24.794,NULL,320.060,320.060,122,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,42,5.850,NULL,200.350,200.350,29,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,91,1.454,NULL,28.930,28.930,1,1,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,202,1.298,NULL,21.030,21.030,1,3,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,203,2.328,NULL,20.960,20.960,6,3,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,204,3.120,NULL,28.090,28.090,7,3,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,205,9.846,NULL,175.290,175.290,40,3,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,206,2.750,NULL,57.750,57.750,4,3,'',1,'A','Comunicaciones','2015-12-14 20:41:45'),(1,1,10,6,6,208,0.482,NULL,4.820,4.820,3,3,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,228,3.508,NULL,62.440,62.440,3,3,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,229,7.222,NULL,151.690,151.690,41,3,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,500,0.348,NULL,7.660,7.660,1,7,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,601,7.146,NULL,134.340,134.340,20,5,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,608,5.566,NULL,72.060,72.060,15,5,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,612,23.296,NULL,303.850,303.850,28,5,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,614,10.562,NULL,182.450,182.450,13,5,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,617,5.904,NULL,102.970,102.970,17,5,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,621,16.346,NULL,297.230,297.230,74,5,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,631,6.906,NULL,172.650,172.650,37,5,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,6,6,901,33.406,NULL,342.970,342.970,7,1,'',1,'A','Comunicaciones','2015-12-14 20:41:46'),(1,1,10,7,7,1,10.622,NULL,202.090,202.090,33,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,2,7.302,NULL,150.690,150.690,32,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,3,16.542,NULL,312.120,312.120,37,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,5,6.366,NULL,66.840,66.840,3,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,6,16.552,NULL,398.390,398.390,45,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,11,1.456,NULL,26.040,26.040,4,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,12,24.218,NULL,144.090,144.090,29,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,13,9.852,NULL,92.220,92.220,11,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,15,14.964,NULL,255.340,255.340,15,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,16,14.654,NULL,306.200,306.200,30,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,17,6.298,NULL,50.680,50.680,23,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,18,80.886,NULL,1047.090,1047.090,252,1,'',1,'A','Comunicaciones','2015-12-17 18:12:44'),(1,1,10,7,7,19,17.200,NULL,178.880,178.880,17,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,25,1.448,NULL,56.470,56.470,1,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,26,2.882,NULL,23.050,23.050,4,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,27,0.874,NULL,17.390,17.390,1,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,28,0.500,NULL,9.950,9.950,1,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,29,1.054,NULL,20.980,20.980,5,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,34,3.324,NULL,19.940,19.940,2,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,35,3.610,NULL,12.360,12.360,4,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,37,1.480,NULL,14.500,14.500,2,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,38,31.242,NULL,577.000,577.000,105,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,42,5.472,NULL,191.550,191.550,25,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,45,10.684,NULL,165.640,165.640,38,1,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,201,31.852,NULL,620.710,620.710,11,3,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,202,0.918,NULL,15.150,15.150,1,3,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,203,2.078,NULL,19.260,19.260,7,3,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,204,2.392,NULL,21.530,21.530,6,3,'',1,'A','Comunicaciones','2015-12-17 18:12:45'),(1,1,10,7,7,205,6.550,NULL,120.830,120.830,25,3,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,206,2.618,NULL,54.980,54.980,4,3,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,208,0.368,NULL,0.000,0.000,1,3,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,228,4.162,NULL,74.090,74.090,4,3,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,229,4.862,NULL,102.120,102.120,26,3,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,233,1.362,NULL,24.240,24.240,2,3,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,601,22.444,NULL,411.420,411.420,59,5,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,608,10.396,NULL,106.530,106.530,12,5,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,612,58.193,NULL,54.160,54.160,10,5,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,614,14.074,NULL,79.360,79.360,8,5,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,620,1.074,NULL,10.740,10.740,1,5,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,621,10.326,NULL,176.840,176.840,47,5,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,624,0.548,NULL,15.340,15.340,1,5,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,631,6.088,NULL,152.200,152.200,30,5,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,635,22.868,NULL,290.570,290.570,59,7,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,636,5.624,NULL,117.660,117.660,7,7,'',1,'A','Comunicaciones','2015-12-17 18:12:46'),(1,1,10,7,7,637,4.566,NULL,94.860,94.860,6,7,'',1,'A','Comunicaciones','2015-12-17 18:12:47'),(1,1,10,7,7,907,0.078,NULL,1.170,1.170,1,0,'',1,'A','Comunicaciones','2015-12-17 18:12:47'),(1,1,10,7,7,918,7.134,NULL,279.600,279.600,8,5,'',1,'A','Comunicaciones','2015-12-17 18:12:47'),(1,1,10,8,8,1,18.990,NULL,441.550,441.550,54,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,2,6.142,NULL,133.040,133.040,30,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,3,3.112,NULL,48.240,48.240,5,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,4,4.384,NULL,87.240,87.240,3,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,5,2.408,NULL,20.880,20.880,3,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,6,13.528,NULL,282.070,282.070,23,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,11,0.314,NULL,6.250,6.250,1,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,12,14.508,NULL,80.200,80.200,21,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,13,6.976,NULL,65.160,65.160,10,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,15,13.574,NULL,214.300,214.300,12,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,16,9.852,NULL,219.760,219.760,22,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,17,28.245,NULL,57.530,57.530,22,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,18,45.154,NULL,631.340,631.340,141,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,19,14.822,NULL,133.640,133.640,17,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,21,3.788,NULL,80.730,80.730,5,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,25,17.940,NULL,569.530,569.530,31,1,'',1,'A','Comunicaciones','2015-12-23 08:43:29'),(1,1,10,8,8,26,1.040,NULL,4.900,4.900,2,1,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,27,1.248,NULL,24.840,24.840,2,1,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,28,1.178,NULL,23.450,23.450,3,1,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,29,1.044,NULL,23.120,23.120,5,1,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,38,9.560,NULL,176.060,176.060,42,1,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,42,13.932,NULL,421.760,421.760,54,1,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,45,16.662,NULL,251.980,251.980,56,1,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,92,9.214,NULL,199.020,199.020,11,1,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,201,4.006,NULL,78.420,78.420,2,3,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,202,1.660,NULL,26.490,26.490,2,3,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,203,2.688,NULL,39.620,39.620,7,3,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,204,2.632,NULL,23.680,23.680,6,3,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,205,9.442,NULL,166.800,166.800,34,3,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,206,2.188,NULL,45.950,45.950,3,3,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,228,4.142,NULL,72.510,72.510,4,3,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,229,3.838,NULL,80.600,80.600,12,3,'',1,'A','Comunicaciones','2015-12-23 08:43:30'),(1,1,10,8,8,233,1.234,NULL,21.970,21.970,2,3,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,310,0.372,NULL,5.770,5.770,1,4,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,601,7.388,NULL,129.830,129.830,18,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,608,5.494,NULL,61.820,61.820,14,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,612,12.816,NULL,167.620,167.620,13,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,613,2.348,NULL,29.360,29.360,4,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,614,9.450,NULL,149.080,149.080,6,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,621,9.828,NULL,172.400,172.400,44,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,624,6.768,NULL,186.150,186.150,12,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,631,5.428,NULL,135.700,135.700,24,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,635,23.478,NULL,294.790,294.790,57,7,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,637,13.132,NULL,269.220,269.220,9,7,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,901,13.430,NULL,194.740,194.740,2,1,'',1,'A','Comunicaciones','2015-12-23 08:43:31'),(1,1,10,8,8,918,3.082,NULL,119.580,119.580,3,5,'',1,'A','Comunicaciones','2015-12-23 08:43:31');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_fin_de_dia_articulo` ENABLE KEYS */;

--
-- Table structure for table `dat_forma_pago`
--

DROP TABLE IF EXISTS `dat_forma_pago`;
CREATE TABLE `dat_forma_pago` (
  `IdFormaPago` int(11) NOT NULL,
  `Descripcion` varchar(50) default NULL,
  `Contado` tinyint(1) default '0',
  `AperturaCajon` tinyint(1) default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdFormaPago`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las posibles';

--
-- Dumping data for table `dat_forma_pago`
--


/*!40000 ALTER TABLE `dat_forma_pago` DISABLE KEYS */;
LOCK TABLES `dat_forma_pago` WRITE;
INSERT INTO `dat_forma_pago` (`IdFormaPago`, `Descripcion`, `Contado`, `AperturaCajon`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'Contado',1,1,1,0,'M','Admin','2008-03-05 08:14:45'),(2,'Tarjeta/Cheque',2,0,1,0,'M','admin','2008-10-09 13:59:44'),(3,'Credito',2,0,1,0,'M','Admin','2008-10-09 13:59:52'),(4,'A cuenta',3,0,1,0,'M','Admin','2008-10-09 13:59:59'),(5,'Otros',1,1,1,0,'M','Admin','2007-05-15 09:57:21');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_forma_pago` ENABLE KEYS */;

--
-- Table structure for table `dat_ftp`
--

DROP TABLE IF EXISTS `dat_ftp`;
CREATE TABLE `dat_ftp` (
  `IdFtp` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `NombreFtp` varchar(100) NOT NULL,
  `ServidorFtp` varchar(100) NOT NULL,
  `PuertoFtp` int(11) default '21',
  `UsuarioFtp` varchar(100) NOT NULL,
  `Password` varchar(100) NOT NULL,
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the receipt.',
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdFtp`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ftp`
--


/*!40000 ALTER TABLE `dat_ftp` DISABLE KEYS */;
LOCK TABLES `dat_ftp` WRITE;
INSERT INTO `dat_ftp` (`IdFtp`, `IdEmpresa`, `NombreFtp`, `ServidorFtp`, `PuertoFtp`, `UsuarioFtp`, `Password`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,1,'','',21,'','',0,'A','dgi','2012-10-18 07:46:43');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ftp` ENABLE KEYS */;

--
-- Table structure for table `dat_ftp_carpeta`
--

DROP TABLE IF EXISTS `dat_ftp_carpeta`;
CREATE TABLE `dat_ftp_carpeta` (
  `IdCarpetaLocal` int(11) NOT NULL,
  `IdFtp` int(11) default '0',
  `DirectorioFtp` varchar(300) NOT NULL,
  PRIMARY KEY  (`IdCarpetaLocal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ftp_carpeta`
--


/*!40000 ALTER TABLE `dat_ftp_carpeta` DISABLE KEYS */;
LOCK TABLES `dat_ftp_carpeta` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ftp_carpeta` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_articulos`
--

DROP TABLE IF EXISTS `dat_grupo_articulos`;
CREATE TABLE `dat_grupo_articulos` (
  `IdGrupo` int(11) NOT NULL,
  `NombreGrupo` varchar(50) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_articulos`
--


/*!40000 ALTER TABLE `dat_grupo_articulos` DISABLE KEYS */;
LOCK TABLES `dat_grupo_articulos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_articulos` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_cabeceras`
--

DROP TABLE IF EXISTS `dat_grupo_cabeceras`;
CREATE TABLE `dat_grupo_cabeceras` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `Descripcion` varchar(50) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_cabeceras`
--


/*!40000 ALTER TABLE `dat_grupo_cabeceras` DISABLE KEYS */;
LOCK TABLES `dat_grupo_cabeceras` WRITE;
INSERT INTO `dat_grupo_cabeceras` (`IdEmpresa`, `IdGrupo`, `Descripcion`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,0,'Default',0,'A','admindfs','2015-09-16 21:31:44');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_cabeceras` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_cabeceras_t_b`
--

DROP TABLE IF EXISTS `dat_grupo_cabeceras_t_b`;
CREATE TABLE `dat_grupo_cabeceras_t_b` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdFormato` int(11) NOT NULL,
  `IdGrupo` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdFormato`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_cabeceras_t_b`
--


/*!40000 ALTER TABLE `dat_grupo_cabeceras_t_b` DISABLE KEYS */;
LOCK TABLES `dat_grupo_cabeceras_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_cabeceras_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_macros`
--

DROP TABLE IF EXISTS `dat_grupo_macros`;
CREATE TABLE `dat_grupo_macros` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `NombreGrupo` varchar(50) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_macros`
--


/*!40000 ALTER TABLE `dat_grupo_macros` DISABLE KEYS */;
LOCK TABLES `dat_grupo_macros` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_macros` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_pantallas`
--

DROP TABLE IF EXISTS `dat_grupo_pantallas`;
CREATE TABLE `dat_grupo_pantallas` (
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdGrupo` int(11) NOT NULL,
  `IdPantalla` int(11) NOT NULL,
  `IdPublicidad` int(11) NOT NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`,`IdPantalla`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_pantallas`
--


/*!40000 ALTER TABLE `dat_grupo_pantallas` DISABLE KEYS */;
LOCK TABLES `dat_grupo_pantallas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_pantallas` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_publicidad_grafica`
--

DROP TABLE IF EXISTS `dat_grupo_publicidad_grafica`;
CREATE TABLE `dat_grupo_publicidad_grafica` (
  `IdGrupo` int(11) NOT NULL,
  `NombreGrupo` varchar(50) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_publicidad_grafica`
--


/*!40000 ALTER TABLE `dat_grupo_publicidad_grafica` DISABLE KEYS */;
LOCK TABLES `dat_grupo_publicidad_grafica` WRITE;
INSERT INTO `dat_grupo_publicidad_grafica` (`IdGrupo`, `NombreGrupo`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,'Default g.',1,0,'A','admindfs','2011-12-22 09:42:59');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_publicidad_grafica` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_vendedores`
--

DROP TABLE IF EXISTS `dat_grupo_vendedores`;
CREATE TABLE `dat_grupo_vendedores` (
  `IdGrupo` int(11) NOT NULL,
  `NombreGrupo` varchar(50) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_vendedores`
--


/*!40000 ALTER TABLE `dat_grupo_vendedores` DISABLE KEYS */;
LOCK TABLES `dat_grupo_vendedores` WRITE;
INSERT INTO `dat_grupo_vendedores` (`IdGrupo`, `NombreGrupo`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,'Default group',1,0,'A','admindfs','2011-06-10 10:43:41');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_vendedores` ENABLE KEYS */;

--
-- Table structure for table `dat_importacion`
--

DROP TABLE IF EXISTS `dat_importacion`;
CREATE TABLE `dat_importacion` (
  `IdImportacion` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `NombreImportacion` varchar(50) default NULL,
  `Activo` tinyint(1) NOT NULL default '1',
  `LineaInicio` int(11) default '0',
  `FicheroImportacion` varchar(1000) default NULL,
  `TextoImportacion` varchar(20000) default NULL,
  `TipoFichero` varchar(20) default 'ARTICLES',
  `TipoOperacion` varchar(20) default 'COMBINE',
  `SeparadorCampos` varchar(1) default NULL,
  `IdFtp` int(11) default '0',
  `DirectorioFtp` varchar(300) NOT NULL,
  `FicheroFtp` varchar(100) default NULL,
  `FicheroRegular` text,
  `DirectorioProcesado` text,
  `FicheroProcesado` varchar(100) default NULL,
  `DefectoProcesado` int(11) default '1',
  `SeccionMasCodigo` int(11) default '0',
  `NivelXml` int(11) default '2',
  `TipoImagen` varchar(20) default 'ARTICLE',
  PRIMARY KEY  (`IdImportacion`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_importacion`
--


/*!40000 ALTER TABLE `dat_importacion` DISABLE KEYS */;
LOCK TABLES `dat_importacion` WRITE;
INSERT INTO `dat_importacion` (`IdImportacion`, `IdEmpresa`, `NombreImportacion`, `Activo`, `LineaInicio`, `FicheroImportacion`, `TextoImportacion`, `TipoFichero`, `TipoOperacion`, `SeparadorCampos`, `IdFtp`, `DirectorioFtp`, `FicheroFtp`, `FicheroRegular`, `DirectorioProcesado`, `FicheroProcesado`, `DefectoProcesado`, `SeccionMasCodigo`, `NivelXml`, `TipoImagen`) VALUES (1,1,'import articles',1,1,'C:\\Users\\T500\\Documents\\Fiche articles PLU.csv','Code;Nom1;Type;Famille;Format Etiquette;Jour Péremption;Tare Fixe;Text 1;Text 2;Text 3;Text 9;Text 10\n1;RUMSTECK;1;1;21;15;0,01;;;;;entre 2 et 4 degrés\n2;BAVETTE;1;1;21;15;0,01;;;;;entre 2 et 4 degrés\n3;BASSE COTE;1;1;21;15;0,01;;;;;entre 2 et 4 degrés','ARTICLES','COMBINE',';',0,'','','Fiche articles PLU.csv','C:\\Program Files (x86)\\DFS\\RGI\\Processed files','yyyyMMddHHmmss_*.*',1,0,2,'ARTICLE');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_importacion` ENABLE KEYS */;

--
-- Table structure for table `dat_importacion_campos`
--

DROP TABLE IF EXISTS `dat_importacion_campos`;
CREATE TABLE `dat_importacion_campos` (
  `IdImportacion` int(11) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `PosicionInicial` int(11) default NULL,
  `CampoInicial` varchar(50) default NULL,
  `Longitud` int(11) default NULL,
  `IdCampo` varchar(50) default NULL,
  `IdTipo` varchar(50) default NULL,
  `IdCodigoTipoCampo` int(11) default NULL,
  `IdGrupoArticulo` varchar(1000) default NULL,
  `PosicionInicialPadre` int(11) default NULL,
  `CampoInicialPadre` varchar(50) default NULL,
  `Orden` int(11) default '0',
  `LongitudCodigo` varchar(1) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_importacion_campos`
--


/*!40000 ALTER TABLE `dat_importacion_campos` DISABLE KEYS */;
LOCK TABLES `dat_importacion_campos` WRITE;
INSERT INTO `dat_importacion_campos` (`IdImportacion`, `IdEmpresa`, `PosicionInicial`, `CampoInicial`, `Longitud`, `IdCampo`, `IdTipo`, `IdCodigoTipoCampo`, `IdGrupoArticulo`, `PosicionInicialPadre`, `CampoInicialPadre`, `Orden`, `LongitudCodigo`) VALUES (1,1,0,'',1,'IdArticulo','INTEGER',-2,'',NULL,'',0,''),(1,1,1,'',8,'Descripcion','STRING',-1,'',NULL,'',0,''),(1,1,2,'',1,'IdTipo','INTEGER',-2,'',NULL,'',0,''),(1,1,3,'',1,'IdSeccion','INTEGER',-2,'',NULL,'',0,''),(1,1,4,'',2,'FormatoEtiquetaSerieL','STRING',-1,'',NULL,'',0,''),(1,1,5,'',2,'DiasCaducidad','INTEGER',-2,'',NULL,'',0,''),(1,1,6,'',4,'TaraFija','DECIMAL_3',-6,'',NULL,'',0,''),(1,1,7,'',0,'Texto1','STRING',-1,'',NULL,'',0,''),(1,1,8,'',0,'Texto2','STRING',-1,'',NULL,'',0,''),(1,1,9,'',0,'Texto3','STRING',-1,'',NULL,'',0,''),(1,1,10,'',0,'Texto9','STRING',-1,'',NULL,'',0,''),(1,1,11,'',19,'Texto10','STRING',-1,'',NULL,'',0,'');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_importacion_campos` ENABLE KEYS */;

--
-- Table structure for table `dat_importacion_parametros`
--

DROP TABLE IF EXISTS `dat_importacion_parametros`;
CREATE TABLE `dat_importacion_parametros` (
  `HoraInicio` datetime default NULL,
  `HoraFin` datetime default NULL,
  `CicloCompletoFichero` int(11) NOT NULL default '0',
  `ImportarBalanzasSeleccionadas` tinyint(1) default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_importacion_parametros`
--


/*!40000 ALTER TABLE `dat_importacion_parametros` DISABLE KEYS */;
LOCK TABLES `dat_importacion_parametros` WRITE;
INSERT INTO `dat_importacion_parametros` (`HoraInicio`, `HoraFin`, `CicloCompletoFichero`, `ImportarBalanzasSeleccionadas`) VALUES (NULL,NULL,1,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_importacion_parametros` ENABLE KEYS */;

--
-- Table structure for table `dat_importacion_tipo_campo`
--

DROP TABLE IF EXISTS `dat_importacion_tipo_campo`;
CREATE TABLE `dat_importacion_tipo_campo` (
  `IdCodigo` int(11) NOT NULL,
  `GrupoTipo` varchar(50) NOT NULL,
  `IdTipo` varchar(50) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Basico` tinyint(1) NOT NULL default '0',
  `Nombre` varchar(20) default NULL,
  PRIMARY KEY  (`IdCodigo`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_importacion_tipo_campo`
--


/*!40000 ALTER TABLE `dat_importacion_tipo_campo` DISABLE KEYS */;
LOCK TABLES `dat_importacion_tipo_campo` WRITE;
INSERT INTO `dat_importacion_tipo_campo` (`IdCodigo`, `GrupoTipo`, `IdTipo`, `IdEmpresa`, `Basico`, `Nombre`) VALUES (-16,'decimal_price','DECIMAL_0',1,1,NULL),(-15,'decimal_price','DECIMAL_3',1,1,NULL),(-14,'decimal_price','DECIMAL_1',1,1,NULL),(-13,'ean_format','STRING',1,1,NULL),(-12,'time_format','TIME',1,1,NULL),(-11,'date_format','DATE_DDMMYY',1,1,NULL),(-10,'date_format','DATE_YYYYMMDD',1,1,NULL),(-9,'upload_flag','FLAG_UPLOAD',1,1,NULL),(-8,'delete_flag','FLAG_DELETE',1,1,NULL),(-7,'decimal_price','DECIMAL_REGIONAL',1,1,NULL),(-6,'decimal_weight','DECIMAL_3',1,1,NULL),(-5,'decimal_price','DECIMAL_2',1,1,NULL),(-4,'decimal_price','DECIMAL_.',1,1,NULL),(-3,'decimal_price','DECIMAL_,',1,1,NULL),(-2,'numeric_format','INTEGER',1,1,NULL),(-1,'text_format','STRING',1,1,NULL),(1,'ean_format','EAN_nCCCCCEEEEEE',1,0,'nCCCCCEEEEEE'),(2,'ean_format','EAN_nnCCCCEEEEEE',1,0,'nnCCCCEEEEEE'),(3,'ean_format','EAN_nnKKCCCEEEEE',1,0,'nnKKCCCEEEEE');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_importacion_tipo_campo` ENABLE KEYS */;

--
-- Table structure for table `dat_ingrediente`
--

DROP TABLE IF EXISTS `dat_ingrediente`;
CREATE TABLE `dat_ingrediente` (
  `CodigoIngrediente` int(11) NOT NULL,
  `NumeroLineaIngrediente` int(11) NOT NULL,
  `TextoIngrediente` text,
  PRIMARY KEY  (`CodigoIngrediente`,`NumeroLineaIngrediente`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ingrediente`
--


/*!40000 ALTER TABLE `dat_ingrediente` DISABLE KEYS */;
LOCK TABLES `dat_ingrediente` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ingrediente` ENABLE KEYS */;

--
-- Table structure for table `dat_ingredientes_seccion`
--

DROP TABLE IF EXISTS `dat_ingredientes_seccion`;
CREATE TABLE `dat_ingredientes_seccion` (
  `IdSeccion` int(11) NOT NULL,
  `IdIngredienteSeccion` int(11) NOT NULL,
  `Descripcion` text,
  `TextoIngrediente` text,
  PRIMARY KEY  (`IdSeccion`,`IdIngredienteSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_ingredientes_seccion`
--


/*!40000 ALTER TABLE `dat_ingredientes_seccion` DISABLE KEYS */;
LOCK TABLES `dat_ingredientes_seccion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ingredientes_seccion` ENABLE KEYS */;

--
-- Table structure for table `dat_iva`
--

DROP TABLE IF EXISTS `dat_iva`;
CREATE TABLE `dat_iva` (
  `IdIVA` int(11) NOT NULL,
  `PorcentajeIVA` decimal(9,2) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdIVA`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de los distinto';

--
-- Dumping data for table `dat_iva`
--


/*!40000 ALTER TABLE `dat_iva` DISABLE KEYS */;
LOCK TABLES `dat_iva` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_iva` ENABLE KEYS */;

--
-- Table structure for table `dat_iva_t_b`
--

DROP TABLE IF EXISTS `dat_iva_t_b`;
CREATE TABLE `dat_iva_t_b` (
  `IdIVA` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdIVA`),
  KEY `BusquedaIVAs` (`IdEmpresa`,`IdIVA`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_iva_t_b`
--


/*!40000 ALTER TABLE `dat_iva_t_b` DISABLE KEYS */;
LOCK TABLES `dat_iva_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_iva_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_articulo`
--

DROP TABLE IF EXISTS `dat_logos_articulo`;
CREATE TABLE `dat_logos_articulo` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(100) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_logos_articulo`
--


/*!40000 ALTER TABLE `dat_logos_articulo` DISABLE KEYS */;
LOCK TABLES `dat_logos_articulo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_articulo` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_articulo_t_b`
--

DROP TABLE IF EXISTS `dat_logos_articulo_t_b`;
CREATE TABLE `dat_logos_articulo_t_b` (
  `IdLogo` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del logo.\r\nUser creation of the logo.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdLogo`),
  KEY `BusquedaLogos` (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Tabla donde se guarda la asociacion entre balanzas de una';

--
-- Dumping data for table `dat_logos_articulo_t_b`
--


/*!40000 ALTER TABLE `dat_logos_articulo_t_b` DISABLE KEYS */;
LOCK TABLES `dat_logos_articulo_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_articulo_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_impresion`
--

DROP TABLE IF EXISTS `dat_logos_impresion`;
CREATE TABLE `dat_logos_impresion` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(100) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_logos_impresion`
--


/*!40000 ALTER TABLE `dat_logos_impresion` DISABLE KEYS */;
LOCK TABLES `dat_logos_impresion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_impresion` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_inicio`
--

DROP TABLE IF EXISTS `dat_logos_inicio`;
CREATE TABLE `dat_logos_inicio` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(100) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_logos_inicio`
--


/*!40000 ALTER TABLE `dat_logos_inicio` DISABLE KEYS */;
LOCK TABLES `dat_logos_inicio` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_inicio` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_publicidad`
--

DROP TABLE IF EXISTS `dat_logos_publicidad`;
CREATE TABLE `dat_logos_publicidad` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(100) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_logos_publicidad`
--


/*!40000 ALTER TABLE `dat_logos_publicidad` DISABLE KEYS */;
LOCK TABLES `dat_logos_publicidad` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_publicidad` ENABLE KEYS */;

--
-- Table structure for table `dat_macro`
--

DROP TABLE IF EXISTS `dat_macro`;
CREATE TABLE `dat_macro` (
  `IdEmpresa` int(11) NOT NULL,
  `IdMacro` int(11) NOT NULL,
  `NombreMacro` varchar(50) default NULL,
  `Tecla` varchar(20) default NULL,
  `Password` varchar(20) default NULL,
  `Combinacion` varchar(500) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdMacro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_macro`
--


/*!40000 ALTER TABLE `dat_macro` DISABLE KEYS */;
LOCK TABLES `dat_macro` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_macro` ENABLE KEYS */;

--
-- Table structure for table `dat_macro_inter`
--

DROP TABLE IF EXISTS `dat_macro_inter`;
CREATE TABLE `dat_macro_inter` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `IdMacro` int(11) NOT NULL,
  `NumeroMacro` int(11) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`,`IdMacro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_macro_inter`
--


/*!40000 ALTER TABLE `dat_macro_inter` DISABLE KEYS */;
LOCK TABLES `dat_macro_inter` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_macro_inter` ENABLE KEYS */;

--
-- Table structure for table `dat_macro_t_b`
--

DROP TABLE IF EXISTS `dat_macro_t_b`;
CREATE TABLE `dat_macro_t_b` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdMacro` int(11) NOT NULL,
  `NumeroMacro` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdMacro`,`NumeroMacro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_macro_t_b`
--


/*!40000 ALTER TABLE `dat_macro_t_b` DISABLE KEYS */;
LOCK TABLES `dat_macro_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_macro_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_mensajes`
--

DROP TABLE IF EXISTS `dat_mensajes`;
CREATE TABLE `dat_mensajes` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdMensaje` int(11) NOT NULL,
  `Texto` varchar(200) default NULL,
  `Enviado` tinyint(1) default NULL,
  `Recibido` tinyint(1) default NULL,
  `Fecha` datetime default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdMensaje`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_mensajes`
--


/*!40000 ALTER TABLE `dat_mensajes` DISABLE KEYS */;
LOCK TABLES `dat_mensajes` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_mensajes` ENABLE KEYS */;

--
-- Table structure for table `dat_numero_ticket`
--

DROP TABLE IF EXISTS `dat_numero_ticket`;
CREATE TABLE `dat_numero_ticket` (
  `IdEmpresa` int(11) NOT NULL,
  `IdNumTicket` int(11) NOT NULL,
  `NombreNumTicket` varchar(50) default NULL,
  `NumeroFinDia` int(11) default NULL,
  `NumeroTicket` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdNumTicket`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_numero_ticket`
--


/*!40000 ALTER TABLE `dat_numero_ticket` DISABLE KEYS */;
LOCK TABLES `dat_numero_ticket` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_numero_ticket` ENABLE KEYS */;

--
-- Table structure for table `dat_nutricional_inter`
--

DROP TABLE IF EXISTS `dat_nutricional_inter`;
CREATE TABLE `dat_nutricional_inter` (
  `CodigoNutricional` int(11) NOT NULL,
  `Cantidad` double(15,3) default '0.000',
  `Unidad` varchar(20) default '',
  `ParteEnteraMedida` int(11) default '0',
  `ParteDecimalMedida` varchar(20) default '',
  `Medida` varchar(50) default '',
  `ValorEnergetico` double(15,3) default '0.000',
  `ValorEnergeticoPorcentual` double(15,3) default '0.000',
  `Carbohidratos` double(15,3) default '0.000',
  `CarbohidratosPorcentual` double(15,3) default '0.000',
  `Proteinas` double(15,3) default '0.000',
  `ProteinasPorcentual` double(15,3) default '0.000',
  `GrasasTotales` double(15,3) default '0.000',
  `GrasasTotalesPorcentual` double(15,3) default '0.000',
  `GrasasSaturadas` double(15,3) default '0.000',
  `GrasasSaturadasPorcentual` double(15,3) default '0.000',
  `GrasasTrans` double(15,3) default '0.000',
  `GrasasTransPorcentual` double(15,3) default '0.000',
  `FibraAlimentar` double(15,3) default '0.000',
  `FibraAlimentarPorcentual` double(15,3) default '0.000',
  `Sodio` double(15,3) default '0.000',
  `SodioPorcentual` double(15,3) default '0.000',
  `Modificado` int(11) default '0',
  `TextoNutricional1_1` varchar(100) default NULL,
  `TextoNutricional1_2` varchar(100) default NULL,
  `TextoNutricional2_1` varchar(100) default NULL,
  `TextoNutricional2_2` varchar(100) default NULL,
  `TextoNutricional3_1` varchar(100) default NULL,
  `TextoNutricional3_2` varchar(100) default NULL,
  `TextoNutricional4_1` varchar(100) default NULL,
  `TextoNutricional4_2` varchar(100) default NULL,
  `TextoNutricional5_1` varchar(100) default NULL,
  `TextoNutricional5_2` varchar(100) default NULL,
  `TextoNutricional6_1` varchar(100) default NULL,
  `TextoNutricional6_2` varchar(100) default NULL,
  `TextoNutricional7_1` varchar(100) default NULL,
  `TextoNutricional7_2` varchar(100) default NULL,
  `TextoNutricional8_1` varchar(100) default NULL,
  `TextoNutricional8_2` varchar(100) default NULL,
  `TextoNutricional9_1` varchar(100) default NULL,
  `TextoNutricional9_2` varchar(100) default NULL,
  `TextoNutricional10_1` varchar(100) default NULL,
  `TextoNutricional10_2` varchar(100) default NULL,
  `TextoNutricional11_1` varchar(100) default NULL,
  `TextoNutricional11_2` varchar(100) default NULL,
  `TextoNutricional12_1` varchar(100) default NULL,
  `TextoNutricional12_2` varchar(100) default NULL,
  `TextoNutricional13_1` varchar(100) default NULL,
  `TextoNutricional13_2` varchar(100) default NULL,
  `TextoNutricional14_1` varchar(100) default NULL,
  `TextoNutricional14_2` varchar(100) default NULL,
  PRIMARY KEY  (`CodigoNutricional`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_nutricional_inter`
--


/*!40000 ALTER TABLE `dat_nutricional_inter` DISABLE KEYS */;
LOCK TABLES `dat_nutricional_inter` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_nutricional_inter` ENABLE KEYS */;

--
-- Table structure for table `dat_nutricionales_preguntas`
--

DROP TABLE IF EXISTS `dat_nutricionales_preguntas`;
CREATE TABLE `dat_nutricionales_preguntas` (
  `IdEmpresa` int(11) NOT NULL,
  `IdPregunta` int(11) NOT NULL,
  `Pregunta` varchar(100) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPregunta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_nutricionales_preguntas`
--


/*!40000 ALTER TABLE `dat_nutricionales_preguntas` DISABLE KEYS */;
LOCK TABLES `dat_nutricionales_preguntas` WRITE;
INSERT INTO `dat_nutricionales_preguntas` (`IdEmpresa`, `IdPregunta`, `Pregunta`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,'Informacion Nutricional',0,'A','admindfs','2012-11-27 11:05:56'),(1,2,'Valor Energetico',0,'A','admindfs','2012-11-27 11:06:10'),(1,3,'Grasas',0,'A','admindfs','2012-11-27 11:06:31'),(1,4,'Acidos Grasos Saturados',0,'A','admindfs','2012-11-27 11:06:44'),(1,5,'Hidratos de carbono',0,'A','admindfs','2012-11-27 11:07:07'),(1,6,'Azucares',0,'A','admindfs','2012-11-27 11:07:27'),(1,7,'Proteinas',0,'A','admindfs','2012-11-27 11:07:39'),(1,8,'Sal',0,'A','admindfs','2012-11-27 11:07:46'),(1,9,'Fibra alimentaria',0,'A','admindfs','2012-11-27 11:07:55'),(1,10,'Vitamina A',0,'A','admindfs','2012-11-27 11:08:04'),(1,11,'Vitamina C',0,'A','admindfs','2012-11-27 11:08:19'),(1,12,'Calcio',0,'A','admindfs','2012-11-27 11:08:31'),(1,13,'Hierro',0,'A','admindfs','2012-11-27 11:08:39'),(1,14,'Vitamina',0,'A','admindfs','2012-11-27 11:08:48');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_nutricionales_preguntas` ENABLE KEYS */;

--
-- Table structure for table `dat_nutricionales_preguntas_t_b`
--

DROP TABLE IF EXISTS `dat_nutricionales_preguntas_t_b`;
CREATE TABLE `dat_nutricionales_preguntas_t_b` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdPregunta` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPregunta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_nutricionales_preguntas_t_b`
--


/*!40000 ALTER TABLE `dat_nutricionales_preguntas_t_b` DISABLE KEYS */;
LOCK TABLES `dat_nutricionales_preguntas_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_nutricionales_preguntas_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_ofertas_temporales`
--

DROP TABLE IF EXISTS `dat_ofertas_temporales`;
CREATE TABLE `dat_ofertas_temporales` (
  `IdOfertaTemporal` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `NombreOfertaTemporal` varchar(50) NOT NULL default '',
  `FechaInicio` datetime default NULL,
  `FechaFin` datetime default NULL,
  `Dias` varchar(20) default '1, 2, 3, 4, 5, 6, 7',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdOfertaTemporal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ofertas_temporales`
--


/*!40000 ALTER TABLE `dat_ofertas_temporales` DISABLE KEYS */;
LOCK TABLES `dat_ofertas_temporales` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ofertas_temporales` ENABLE KEYS */;

--
-- Table structure for table `dat_ofertas_temporales_t_b`
--

DROP TABLE IF EXISTS `dat_ofertas_temporales_t_b`;
CREATE TABLE `dat_ofertas_temporales_t_b` (
  `IdOfertaTemporal` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdOfertaTemporal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ofertas_temporales_t_b`
--


/*!40000 ALTER TABLE `dat_ofertas_temporales_t_b` DISABLE KEYS */;
LOCK TABLES `dat_ofertas_temporales_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ofertas_temporales_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_param_clase`
--

DROP TABLE IF EXISTS `dat_param_clase`;
CREATE TABLE `dat_param_clase` (
  `IdClase` int(11) NOT NULL,
  `IdParametro` int(11) NOT NULL,
  `Parametro` text,
  `IdDatAdicional` varchar(30) default NULL,
  `Orden` int(11) default NULL,
  `CodigoIA` varchar(10) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdClase`,`IdParametro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los parametros que puede tomar una cl';

--
-- Dumping data for table `dat_param_clase`
--


/*!40000 ALTER TABLE `dat_param_clase` DISABLE KEYS */;
LOCK TABLES `dat_param_clase` WRITE;
INSERT INTO `dat_param_clase` (`IdClase`, `IdParametro`, `Parametro`, `IdDatAdicional`, `Orden`, `CodigoIA`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,'Pays de Naissance','Pays de naissance',1,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,2,'Pays d\'elevage','Eleve en',2,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,3,'Pays d\'abattage','Pays Abattage',3,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,4,'N° Abattoir','Abattoirs',4,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,5,'Race','Race',5,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,6,'Categorie','Categorie',6,'',1,0,'A','admin','2015-09-15 20:34:07'),(1,7,'Type','Type',7,'',1,0,'A','admin','2015-09-15 20:34:07');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_param_clase` ENABLE KEYS */;

--
-- Table structure for table `dat_param_clase_t_b`
--

DROP TABLE IF EXISTS `dat_param_clase_t_b`;
CREATE TABLE `dat_param_clase_t_b` (
  `IdClase` int(11) NOT NULL,
  `IdParametro` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdClase`,`IdParametro`),
  KEY `BusquedaClases` (`IdEmpresa`,`IdClase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_param_clase_t_b`
--


/*!40000 ALTER TABLE `dat_param_clase_t_b` DISABLE KEYS */;
LOCK TABLES `dat_param_clase_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_param_clase_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_programacion`
--

DROP TABLE IF EXISTS `dat_programacion`;
CREATE TABLE `dat_programacion` (
  `IdEmpresa` int(11) NOT NULL,
  `IdProgramacion` int(11) NOT NULL,
  `NombreProgramacion` varchar(50) default NULL,
  `Fecha` datetime default NULL,
  `Repeticion` int(11) default NULL,
  `TiempoRepeticion` time default NULL,
  `Activa` tinyint(1) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdProgramacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_programacion`
--


/*!40000 ALTER TABLE `dat_programacion` DISABLE KEYS */;
LOCK TABLES `dat_programacion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_programacion` ENABLE KEYS */;

--
-- Table structure for table `dat_programacion_balanzas`
--

DROP TABLE IF EXISTS `dat_programacion_balanzas`;
CREATE TABLE `dat_programacion_balanzas` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdProgramacion` int(11) NOT NULL,
  `IdAccion` int(11) NOT NULL default '0',
  `Orden` int(11) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdProgramacion`,`IdAccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_programacion_balanzas`
--


/*!40000 ALTER TABLE `dat_programacion_balanzas` DISABLE KEYS */;
LOCK TABLES `dat_programacion_balanzas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_programacion_balanzas` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_alfanumerica`
--

DROP TABLE IF EXISTS `dat_publicidad_alfanumerica`;
CREATE TABLE `dat_publicidad_alfanumerica` (
  `IdPublicidad` int(11) NOT NULL,
  `NombrePublicidad` varchar(20) default NULL,
  `Texto1` varchar(119) default NULL,
  `Ritmo1` int(11) default NULL,
  `Texto2` varchar(119) default NULL,
  `Ritmo2` int(11) default NULL,
  `Texto3` varchar(119) default NULL,
  `Ritmo3` int(11) default NULL,
  `Texto4` varchar(119) default NULL,
  `Ritmo4` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Usuario` varchar(50) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_publicidad_alfanumerica`
--


/*!40000 ALTER TABLE `dat_publicidad_alfanumerica` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_alfanumerica` WRITE;
INSERT INTO `dat_publicidad_alfanumerica` (`IdPublicidad`, `NombrePublicidad`, `Texto1`, `Ritmo1`, `Texto2`, `Ritmo2`, `Texto3`, `Ritmo3`, `Texto4`, `Ritmo4`, `Modificado`, `Operacion`, `IdEmpresa`, `Usuario`, `TimeStamp`) VALUES (0,'Default a.',NULL,1,NULL,1,NULL,1,NULL,1,0,'A',1,'admindfs','2011-06-22 09:02:03');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_alfanumerica` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_alfanumerica_t_b`
--

DROP TABLE IF EXISTS `dat_publicidad_alfanumerica_t_b`;
CREATE TABLE `dat_publicidad_alfanumerica_t_b` (
  `IdPublicidad` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPublicidad`),
  KEY `BusquedaPublicidad` (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_publicidad_alfanumerica_t_b`
--


/*!40000 ALTER TABLE `dat_publicidad_alfanumerica_t_b` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_alfanumerica_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_alfanumerica_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_grafica`
--

DROP TABLE IF EXISTS `dat_publicidad_grafica`;
CREATE TABLE `dat_publicidad_grafica` (
  `IdNumeroPantalla` int(11) NOT NULL,
  `NombrePublicidad` varchar(20) default NULL,
  `IdFont` int(11) default NULL,
  `IdLogo` int(11) default NULL,
  `Temporizacion` int(11) default NULL,
  `Texto1` varchar(50) default NULL,
  `Efecto1` int(11) default NULL,
  `Texto2` varchar(50) default NULL,
  `Efecto2` int(11) default NULL,
  `Texto3` varchar(50) default NULL,
  `Efecto3` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Usuario` varchar(50) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdNumeroPantalla`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_publicidad_grafica`
--


/*!40000 ALTER TABLE `dat_publicidad_grafica` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_grafica` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_grafica` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_grafica_simple`
--

DROP TABLE IF EXISTS `dat_publicidad_grafica_simple`;
CREATE TABLE `dat_publicidad_grafica_simple` (
  `IdEmpresa` int(11) NOT NULL,
  `IdPublicidad` int(11) NOT NULL,
  `NombrePublicidad` varchar(50) default NULL,
  `IdTipo` int(11) default NULL,
  `Escena1Texto1` varchar(50) default NULL,
  `Escena1Texto2` varchar(50) default NULL,
  `Escena1Texto3` varchar(50) default NULL,
  `Escena2Texto1` varchar(50) default NULL,
  `Escena2Texto2` varchar(50) default NULL,
  `Escena2Texto3` varchar(50) default NULL,
  `Escena3Texto1` varchar(50) default NULL,
  `Escena3Texto2` varchar(50) default NULL,
  `Escena3Texto3` varchar(50) default NULL,
  `Escena4Texto1` varchar(50) default NULL,
  `Escena4Texto2` varchar(50) default NULL,
  `Escena4Texto3` varchar(50) default NULL,
  `Escena5Texto1` varchar(50) default NULL,
  `Escena5Texto2` varchar(50) default NULL,
  `Escena5Texto3` varchar(50) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_publicidad_grafica_simple`
--


/*!40000 ALTER TABLE `dat_publicidad_grafica_simple` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_grafica_simple` WRITE;
INSERT INTO `dat_publicidad_grafica_simple` (`IdEmpresa`, `IdPublicidad`, `NombrePublicidad`, `IdTipo`, `Escena1Texto1`, `Escena1Texto2`, `Escena1Texto3`, `Escena2Texto1`, `Escena2Texto2`, `Escena2Texto3`, `Escena3Texto1`, `Escena3Texto2`, `Escena3Texto3`, `Escena4Texto1`, `Escena4Texto2`, `Escena4Texto3`, `Escena5Texto1`, `Escena5Texto2`, `Escena5Texto3`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,0,'Default g.',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-10-02 14:26:06');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_grafica_simple` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_grafica_simple_t_b`
--

DROP TABLE IF EXISTS `dat_publicidad_grafica_simple_t_b`;
CREATE TABLE `dat_publicidad_grafica_simple_t_b` (
  `IdPublicidad` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPublicidad`),
  KEY `BusquedaPublicidad` (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_publicidad_grafica_simple_t_b`
--


/*!40000 ALTER TABLE `dat_publicidad_grafica_simple_t_b` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_grafica_simple_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_grafica_simple_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_grafica_t_b`
--

DROP TABLE IF EXISTS `dat_publicidad_grafica_t_b`;
CREATE TABLE `dat_publicidad_grafica_t_b` (
  `IdPublicidad` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPublicidad`),
  KEY `BusquedaPublicidad` (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_publicidad_grafica_t_b`
--


/*!40000 ALTER TABLE `dat_publicidad_grafica_t_b` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_grafica_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_grafica_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_puntos_fidelidad`
--

DROP TABLE IF EXISTS `dat_puntos_fidelidad`;
CREATE TABLE `dat_puntos_fidelidad` (
  `IdPuntosFidelidad` int(11) NOT NULL,
  `PuntosFidelidad` int(11) default NULL,
  `TextoPuntosFidelidad` varchar(50) default NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(50) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPuntosFidelidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_puntos_fidelidad`
--


/*!40000 ALTER TABLE `dat_puntos_fidelidad` DISABLE KEYS */;
LOCK TABLES `dat_puntos_fidelidad` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_puntos_fidelidad` ENABLE KEYS */;

--
-- Table structure for table `dat_puntos_fidelidad_t_b`
--

DROP TABLE IF EXISTS `dat_puntos_fidelidad_t_b`;
CREATE TABLE `dat_puntos_fidelidad_t_b` (
  `IdPuntosFidelidad` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPuntosFidelidad`),
  KEY `BusquedaPuntosFidelidad` (`IdEmpresa`,`IdPuntosFidelidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_puntos_fidelidad_t_b`
--


/*!40000 ALTER TABLE `dat_puntos_fidelidad_t_b` DISABLE KEYS */;
LOCK TABLES `dat_puntos_fidelidad_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_puntos_fidelidad_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_pwd_balanza`
--

DROP TABLE IF EXISTS `dat_pwd_balanza`;
CREATE TABLE `dat_pwd_balanza` (
  `IdPwd` int(11) NOT NULL,
  `Tipo` int(11) NOT NULL default '1',
  `PwdActual` varchar(10) default NULL,
  `PwdNuevo` varchar(10) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPwd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_pwd_balanza`
--


/*!40000 ALTER TABLE `dat_pwd_balanza` DISABLE KEYS */;
LOCK TABLES `dat_pwd_balanza` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_pwd_balanza` ENABLE KEYS */;

--
-- Table structure for table `dat_receta`
--

DROP TABLE IF EXISTS `dat_receta`;
CREATE TABLE `dat_receta` (
  `IdReceta` int(11) NOT NULL,
  `ModoTitulo` tinyint(1) NOT NULL default '0',
  `FuenteTitulo` tinyint(1) NOT NULL default '0',
  `MagnificacionTitulo` tinyint(2) NOT NULL default '0',
  `TextoTitulo` varchar(50) default NULL,
  `ModoLineas` tinyint(1) NOT NULL default '0',
  `FuenteLineas` tinyint(1) NOT NULL default '0',
  `MagnificacionLineas` tinyint(2) NOT NULL default '0',
  `ModoLogo` tinyint(4) NOT NULL default '0',
  `IdLogo` int(11) default NULL,
  `RotacionLogo` tinyint(1) NOT NULL default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdReceta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_receta`
--


/*!40000 ALTER TABLE `dat_receta` DISABLE KEYS */;
LOCK TABLES `dat_receta` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_receta` ENABLE KEYS */;

--
-- Table structure for table `dat_receta_lineas`
--

DROP TABLE IF EXISTS `dat_receta_lineas`;
CREATE TABLE `dat_receta_lineas` (
  `IdReceta` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `NumeroLinea` int(11) NOT NULL,
  `TextoLinea` varchar(100) default NULL,
  PRIMARY KEY  (`IdReceta`,`IdEmpresa`,`NumeroLinea`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_receta_lineas`
--


/*!40000 ALTER TABLE `dat_receta_lineas` DISABLE KEYS */;
LOCK TABLES `dat_receta_lineas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_receta_lineas` ENABLE KEYS */;

--
-- Table structure for table `dat_receta_t_b`
--

DROP TABLE IF EXISTS `dat_receta_t_b`;
CREATE TABLE `dat_receta_t_b` (
  `IdReceta` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdReceta`),
  KEY `BusquedaRecetas` (`IdEmpresa`,`IdReceta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_receta_t_b`
--


/*!40000 ALTER TABLE `dat_receta_t_b` DISABLE KEYS */;
LOCK TABLES `dat_receta_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_receta_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_seccion`
--

DROP TABLE IF EXISTS `dat_seccion`;
CREATE TABLE `dat_seccion` (
  `IdSeccion` int(11) NOT NULL,
  `NombreSeccion` varchar(50) NOT NULL default '',
  `TeclaDirecta` int(11) default NULL,
  `Prefijo` int(11) default NULL,
  `IdLogo` int(11) default NULL,
  `IdCodBarras` int(11) default NULL,
  `IdEAN128` int(11) default NULL,
  `PermitirVenta` int(11) NOT NULL default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `ModificadoCodBarras` tinyint(1) default NULL,
  `ModificadoEAN128` tinyint(1) default NULL,
  `ModificadoPermitirVenta` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de las secciones. Ta';

--
-- Dumping data for table `dat_seccion`
--


/*!40000 ALTER TABLE `dat_seccion` DISABLE KEYS */;
LOCK TABLES `dat_seccion` WRITE;
INSERT INTO `dat_seccion` (`IdSeccion`, `NombreSeccion`, `TeclaDirecta`, `Prefijo`, `IdLogo`, `IdCodBarras`, `IdEAN128`, `PermitirVenta`, `IdEmpresa`, `Modificado`, `ModificadoCodBarras`, `ModificadoEAN128`, `ModificadoPermitirVenta`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,'Default section',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,NULL,'M','admin','2015-09-28 20:22:39'),(1,'Boeuf',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'A','admin','2015-09-28 20:22:39'),(2,'Veau',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'A','admin','2015-09-28 20:22:39'),(3,'Agneaux',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'A','admin','2015-09-28 20:22:39'),(4,'Porc',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'A','admin','2015-09-28 20:22:39'),(5,'Jeune Bovin',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'M','admin','2015-09-28 20:22:39'),(6,'Cheval',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'A','admin','2015-09-28 20:22:39'),(7,'Transformations',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'A','admin','2015-09-28 20:22:39'),(8,'Plats Cuisines',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'A','admin','2015-09-28 20:22:39');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_seccion` ENABLE KEYS */;

--
-- Table structure for table `dat_seccion_t_b`
--

DROP TABLE IF EXISTS `dat_seccion_t_b`;
CREATE TABLE `dat_seccion_t_b` (
  `IdSeccion` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `ModificadoCodBarras` tinyint(1) default NULL,
  `ModificadoEAN128` tinyint(1) default NULL,
  `ModificadoPermitirVenta` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdSeccion`),
  KEY `BusquedaSecciones` (`IdEmpresa`,`IdSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_seccion_t_b`
--


/*!40000 ALTER TABLE `dat_seccion_t_b` DISABLE KEYS */;
LOCK TABLES `dat_seccion_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_seccion_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_seriel_registros_tmp`
--

DROP TABLE IF EXISTS `dat_seriel_registros_tmp`;
CREATE TABLE `dat_seriel_registros_tmp` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanzaMaestra` int(11) NOT NULL,
  `NumTicket` int(11) NOT NULL,
  `TipoRegistro` varchar(2) NOT NULL,
  `NumTramo` int(11) NOT NULL,
  `NumMensajeTramo` int(11) NOT NULL,
  `Registro` varchar(130) default NULL,
  `TicketCompleto` tinyint(1) default '0',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`NumTicket`,`TipoRegistro`,`NumTramo`,`NumMensajeTramo`),
  KEY `TipoRegistro` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`NumTicket`,`TipoRegistro`),
  KEY `Balanza` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`),
  KEY `NumTicket` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`NumTicket`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda los registros de la L que todavia no s';

--
-- Dumping data for table `dat_seriel_registros_tmp`
--


/*!40000 ALTER TABLE `dat_seriel_registros_tmp` DISABLE KEYS */;
LOCK TABLES `dat_seriel_registros_tmp` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_seriel_registros_tmp` ENABLE KEYS */;

--
-- Table structure for table `dat_tabla_teclas_vendedor`
--

DROP TABLE IF EXISTS `dat_tabla_teclas_vendedor`;
CREATE TABLE `dat_tabla_teclas_vendedor` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTabla` int(11) NOT NULL,
  `NombreTabla` varchar(100) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTabla`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_tabla_teclas_vendedor`
--


/*!40000 ALTER TABLE `dat_tabla_teclas_vendedor` DISABLE KEYS */;
LOCK TABLES `dat_tabla_teclas_vendedor` WRITE;
INSERT INTO `dat_tabla_teclas_vendedor` (`IdEmpresa`, `IdTabla`, `NombreTabla`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,'Ferme des Pays Bourian',1,'A','admin','2015-09-15 17:36:12'),(1,2,'Bruno Belivent',1,'A','admin','2015-09-15 17:36:23');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_tabla_teclas_vendedor` ENABLE KEYS */;

--
-- Table structure for table `dat_taras`
--

DROP TABLE IF EXISTS `dat_taras`;
CREATE TABLE `dat_taras` (
  `IdTara` int(11) NOT NULL,
  `Tara` decimal(5,3) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTara`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_taras`
--


/*!40000 ALTER TABLE `dat_taras` DISABLE KEYS */;
LOCK TABLES `dat_taras` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_taras` ENABLE KEYS */;

--
-- Table structure for table `dat_taras_seccion`
--

DROP TABLE IF EXISTS `dat_taras_seccion`;
CREATE TABLE `dat_taras_seccion` (
  `IdSeccion` int(11) NOT NULL,
  `IdTaraSeccion` int(11) NOT NULL,
  `TaraFija` decimal(11,3) default NULL,
  PRIMARY KEY  (`IdSeccion`,`IdTaraSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_taras_seccion`
--


/*!40000 ALTER TABLE `dat_taras_seccion` DISABLE KEYS */;
LOCK TABLES `dat_taras_seccion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_taras_seccion` ENABLE KEYS */;

--
-- Table structure for table `dat_taras_t_b`
--

DROP TABLE IF EXISTS `dat_taras_t_b`;
CREATE TABLE `dat_taras_t_b` (
  `IdTara` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdTara`),
  KEY `BusquedaTaras` (`IdEmpresa`,`IdTara`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_taras_t_b`
--


/*!40000 ALTER TABLE `dat_taras_t_b` DISABLE KEYS */;
LOCK TABLES `dat_taras_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_taras_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_teclado_tradicional`
--

DROP TABLE IF EXISTS `dat_teclado_tradicional`;
CREATE TABLE `dat_teclado_tradicional` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTeclado` int(11) NOT NULL,
  `NombreTeclado` varchar(100) default NULL,
  `TipoTeclado` int(11) NOT NULL,
  `MargenSuperior` decimal(11,3) default NULL,
  `MargenInferior` decimal(11,3) default NULL,
  `MargenIzquierdo` decimal(11,3) default NULL,
  `MargenDerecho` decimal(11,3) default NULL,
  `FuenteTecla` varchar(100) default NULL,
  `ColorFuente` varchar(100) default NULL,
  `ImagenTeclado` varchar(250) default NULL,
  `TextoPLU` int(11) default '1',
  `PintarVendedores` tinyint(1) default '1',
  `IdTablaTeclas` int(11) default NULL,
  `IdTablaTeclasVendedor` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTeclado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_teclado_tradicional`
--


/*!40000 ALTER TABLE `dat_teclado_tradicional` DISABLE KEYS */;
LOCK TABLES `dat_teclado_tradicional` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_teclado_tradicional` ENABLE KEYS */;

--
-- Table structure for table `dat_ticket_cabecera`
--

DROP TABLE IF EXISTS `dat_ticket_cabecera`;
CREATE TABLE `dat_ticket_cabecera` (
  `IdTicket` bigint(20) NOT NULL default '1' COMMENT 'Identificador unico por cada ticket generado.\r\nUnique Identifier generated by each receipt.',
  `NumTicket` bigint(20) default NULL COMMENT 'Numero unico por cada Empresa, Tienda, Balanza Maestra, Balanza Esclava y Tipo de Venta.\r\nUnique number for each Enterprise, Shop, Master Scale, Slave Scale and Type of Sale.',
  `IdEmpresa` int(11) NOT NULL default '1' COMMENT 'Identificador de la Empresa desde la que se ha generado el ticket.\r\nEnterprise identifier that has generated the receipt.',
  `NombreEmpresa` varchar(100) default NULL COMMENT 'Nombre de la Empresa desde la que se ha generado el ticket.\r\nEnterprise name that has generated the receipt.',
  `IdTienda` int(11) NOT NULL default '1' COMMENT 'Identificador de la Tienda desde la que se ha generado el ticket.\r\nShop identifier that has generated the receipt.',
  `NombreTienda` varchar(50) default NULL COMMENT 'Nombre de la Tienda desde la que se ha generado el ticket.\r\nShop name that has generated the receipt.',
  `IdBalanzaMaestra` int(11) NOT NULL default '0' COMMENT 'Identificador de la Balanza Maestra en la que se ha generado el ticket.\r\nMaster Scale identifier that has generated the receipt.',
  `NombreBalanzaMaestra` varchar(50) default NULL COMMENT 'Nombre de la Balanza Maestra en la que se ha generado el ticket.\r\nMaster Scale Name that has generated the receipt.',
  `IdBalanzaEsclava` int(11) NOT NULL default '0' COMMENT 'Identificador de la Balanza Esclava desde la que se ha generado el ticket.\r\nSlave Scale identifier that has generated the receipt.',
  `NombreBalanzaEsclava` varchar(50) default NULL COMMENT 'Nombre Balanza Esclava desde la que se ha generado el ticket.\r\nSlave Scale name that has generated the receipt.',
  `Tipo` varchar(2) NOT NULL default 'T' COMMENT 'Tipo de documento: T = Ticket, E = Etiqueta.\r\nDocument type: T = Receipt, E = Label.',
  `IdVendedor` int(11) default NULL COMMENT 'Identificador del vendedor que ha generado el ticket.\r\nSeller identifier that has generated the receipt.',
  `NombreVendedor` varchar(50) default NULL COMMENT 'Nombre del vendedor que ha generado el ticket.\r\nSeller name that has generated the receipt.',
  `IdCliente` int(11) default NULL COMMENT 'Identificador del cliente al que se le ha hecho el ticket.\r\nClient Identifier for whom has made the receipt.',
  `NombreCliente` varchar(9) default NULL COMMENT 'Nombre del cliente al que se le ha hecho el ticket.\r\nClient name for whom has made the receipt.',
  `NombreLargoCliente` varchar(30) default NULL,
  `DireccionCliente` varchar(30) default NULL COMMENT 'Direccion del cliente al que se le ha hecho el ticket. Client address for whom has made the receipt.',
  `CodPostalCliente` varchar(10) default NULL COMMENT 'Codigo postal del cliente al que se le ha hecho el ticket. Client postal code for whom has made the receipt.',
  `LocalidadCliente` varchar(20) default NULL COMMENT 'Poblacion del cliente al que se le ha hecho el ticket. Client town for whom has made the receipt.',
  `NIFCliente` varchar(20) default NULL COMMENT 'DNI del cliente al que se le ha hecho el ticket. Client identication number for whom has made the receipt.',
  `TipoVenta` tinyint(1) NOT NULL default '2' COMMENT 'Tipo de venta: 2 (impreso) o 3 (no impreso)\r\nSale type: 2 (printed) or 3 (not printed)',
  `ImporteLineas` double(15,3) default NULL COMMENT 'Importe total de todas las lineas del ticket. Importe total antes del descuento en total.\r\nTotal amount of all lines of receipt. Total amount before the total discount.',
  `PorcDescuento` double(9,3) default NULL COMMENT 'Porcentaje del descuento en el total del ticket.\r\nPercentage of total discount receipt.',
  `ImporteDescuento` double(15,3) default NULL COMMENT 'Importe del descuento en el total del ticket.\r\nAmount of total discount receipt.',
  `ImporteTotal` double(15,3) default NULL COMMENT 'Importe total del ticket (despues del descuento).\r\nTotal amount of receipt (after the discount)',
  `ImporteLineas2` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `PorcDescuento2` double(9,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteDescuento2` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteTotal2` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteLineas3` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `PorcDescuento3` double(9,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteDescuento3` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteTotal3` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteTotalSinIVAConDtoL` double(15,3) default NULL COMMENT 'Importe de todas las lineas sin IVA y con descuento de linea. Amount of all the lines without VAR and with line discount.',
  `ImporteTotalSinIVAConDtoLConDtoTotal` double(15,3) default NULL COMMENT 'Importe de todas las lineas sin IVA y con descuento de linea y con descuento en total. Amount of all the lines without VAR and with line discount and with total discount.',
  `ImporteDtoTotalSinIVA` double(15,3) default NULL COMMENT 'Importe del descuento total sin IVA. Amount of  total discount without VAR.',
  `ImporteTotalDelIVAConDtoLConDtoTotal` double(15,3) default NULL COMMENT 'Importe del IVA con descuento en linea y descuento en total. Amount of VAR with line discount and with total discount.',
  `ImporteSinRedondeo` double(15,3) default NULL COMMENT 'Importe del ticket sin redondeo. Amount of the receipt without rounding.',
  `ImporteDelRedondeo` double(15,3) default NULL COMMENT 'Importe del redondeo. Amount of rounding.',
  `IdSeccion` int(11) default NULL,
  `SignoTotal` int(11) default '0',
  `ImporteTotalAbsoluto` double(15,3) default NULL,
  `PreseleccionCliente` tinyint(1) default '0' COMMENT 'Campo de uso interno.\r\nInternal use field.',
  `Fecha` datetime default NULL COMMENT 'Fecha de creacion del ticket.\r\nDate creation of the ticket.',
  `Enviado` tinyint(1) NOT NULL default '0' COMMENT 'Reservado.\r\nReserved.',
  `NumLineas` smallint(6) default NULL COMMENT 'Numero de lineas del ticket.\r\nNumber of lines of receipt.',
  `CodigoBarras` varchar(20) default NULL COMMENT 'Codigo de Barras del ticket.\r\nBarCode receipt.',
  `CodBarrasTalonCaja` varchar(20) default NULL COMMENT 'Codigo de barras del talon de caja. Bar code of counterfoil.',
  `SerieLIdFinDeDia` bigint(20) default NULL COMMENT 'Identificador del fin de dia donde se ha tenido en cuenta el ticket. End of day Identificator where the receipt has been added.',
  `SerieLTicketErroneo` tinyint(1) NOT NULL default '0' COMMENT 'Ticket erroneo de la serie L. Wrong receipt from L series.',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the receipt.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  `EstadoTicket` char(1) default NULL COMMENT 'Estado del ticket: C=Copia, P=Reabierto, R= Copia reabierta.\r\nReceipt state: C=Copy, P=Reopened, R= Copy reopened.',
  `ImporteEntregado` double(15,3) default NULL COMMENT 'Importe entregado por el cliente.\r\nAmount given by the customer.',
  `ImporteDevuelto` double(15,3) default NULL COMMENT 'Importe devuelto al cliente.\r\nAmount returned to the customer.',
  `PuntosFidelidad` double(15,3) default NULL COMMENT 'Puntos de fidelidad conseguidos en este ticket.\r\nFidelity points get in this receipt.',
  `Exportado` tinyint(1) NOT NULL default '0' COMMENT 'Ventas no exportadas. Se pone a 1 al exportarlas el RGI',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdBalanzaEsclava`,`TipoVenta`,`IdTicket`),
  KEY `Fecha` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdVendedor`,`Tipo`,`Fecha`),
  KEY `IdTicket` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdTicket`),
  KEY `Modificados` (`Modificado`,`Operacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de un ticket ya';

--
-- Dumping data for table `dat_ticket_cabecera`
--


/*!40000 ALTER TABLE `dat_ticket_cabecera` DISABLE KEYS */;
LOCK TABLES `dat_ticket_cabecera` WRITE;
INSERT INTO `dat_ticket_cabecera` (`IdTicket`, `NumTicket`, `IdEmpresa`, `NombreEmpresa`, `IdTienda`, `NombreTienda`, `IdBalanzaMaestra`, `NombreBalanzaMaestra`, `IdBalanzaEsclava`, `NombreBalanzaEsclava`, `Tipo`, `IdVendedor`, `NombreVendedor`, `IdCliente`, `NombreCliente`, `NombreLargoCliente`, `DireccionCliente`, `CodPostalCliente`, `LocalidadCliente`, `NIFCliente`, `TipoVenta`, `ImporteLineas`, `PorcDescuento`, `ImporteDescuento`, `ImporteTotal`, `ImporteLineas2`, `PorcDescuento2`, `ImporteDescuento2`, `ImporteTotal2`, `ImporteLineas3`, `PorcDescuento3`, `ImporteDescuento3`, `ImporteTotal3`, `ImporteTotalSinIVAConDtoL`, `ImporteTotalSinIVAConDtoLConDtoTotal`, `ImporteDtoTotalSinIVA`, `ImporteTotalDelIVAConDtoLConDtoTotal`, `ImporteSinRedondeo`, `ImporteDelRedondeo`, `IdSeccion`, `SignoTotal`, `ImporteTotalAbsoluto`, `PreseleccionCliente`, `Fecha`, `Enviado`, `NumLineas`, `CodigoBarras`, `CodBarrasTalonCaja`, `SerieLIdFinDeDia`, `SerieLTicketErroneo`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`, `EstadoTicket`, `ImporteEntregado`, `ImporteDevuelto`, `PuntosFidelidad`, `Exportado`) VALUES (1,25,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-09-16 23:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:23','C',0.000,0.000,0.000,0),(2,26,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-09-16 23:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:23','C',0.000,0.000,0.000,0),(3,27,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-09-17 01:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:24','C',0.000,0.000,0.000,0),(4,28,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-09-28 19:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:24','C',0.000,0.000,0.000,0),(5,29,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-09-28 19:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:24','C',0.000,0.000,0.000,0),(6,30,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,1,0,3.020,0,'2015-09-29 21:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:25','C',3.020,0.000,0.000,0),(7,31,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,1,0,3.020,0,'2015-09-29 21:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:25','C',3.020,0.000,0.000,0),(8,32,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.220,NULL,NULL,NULL,15.220,NULL,NULL,NULL,NULL,15.220,15.220,0.000,0.000,NULL,NULL,1,0,15.220,0,'2015-09-29 22:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:25','C',15.220,0.000,0.000,0),(9,33,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,1,0,3.020,0,'2015-09-29 22:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:26','C',3.020,0.000,0.000,0),(10,34,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,1,0,3.020,0,'2015-09-29 22:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:26','C',3.020,0.000,0.000,0),(11,35,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,1,0,3.020,0,'2015-09-29 22:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:26','C',3.020,0.000,0.000,0),(12,36,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,1,0,3.020,0,'2015-09-29 22:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:26','C',3.020,0.000,0.000,0),(13,37,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,1,0,3.020,0,'2015-09-29 22:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:27','C',3.020,0.000,0.000,0),(14,38,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.810,NULL,NULL,NULL,2.810,NULL,NULL,NULL,NULL,2.810,2.810,0.000,0.000,NULL,NULL,1,0,2.810,0,'2015-09-29 22:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:27','C',2.810,0.000,0.000,0),(15,39,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.810,NULL,NULL,NULL,2.810,NULL,NULL,NULL,NULL,2.810,2.810,0.000,0.000,NULL,NULL,1,0,2.810,0,'2015-09-29 22:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:27','C',2.810,0.000,0.000,0),(16,40,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-09-29 22:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:27','C',0.000,0.000,0.000,0),(17,41,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,53.590,NULL,NULL,NULL,53.590,NULL,NULL,NULL,NULL,53.590,53.590,0.000,0.000,NULL,NULL,1,0,53.590,0,'2015-09-29 22:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:28','C',53.590,0.000,0.000,0),(18,42,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,53.590,NULL,NULL,NULL,53.590,NULL,NULL,NULL,NULL,53.590,53.590,0.000,0.000,NULL,NULL,1,0,53.590,0,'2015-09-29 22:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:28','C',53.590,0.000,0.000,0),(19,43,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,53.590,NULL,NULL,NULL,53.590,NULL,NULL,NULL,NULL,53.590,53.590,0.000,0.000,NULL,NULL,1,0,53.590,0,'2015-09-29 22:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:29','C',53.590,0.000,0.000,0),(20,44,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.300,NULL,NULL,NULL,2.300,NULL,NULL,NULL,NULL,2.300,2.300,0.000,0.000,NULL,NULL,1,0,2.300,0,'2015-09-29 22:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:29','C',2.300,0.000,0.000,0),(21,45,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.300,NULL,NULL,NULL,2.300,NULL,NULL,NULL,NULL,2.300,2.300,0.000,0.000,NULL,NULL,1,0,2.300,0,'2015-09-29 22:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:29','C',2.300,0.000,0.000,0),(22,46,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.780,NULL,NULL,NULL,0.780,NULL,NULL,NULL,NULL,0.780,0.780,0.000,0.000,NULL,NULL,1,0,0.780,0,'2015-09-29 22:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:30','C',0.780,0.000,0.000,0),(23,47,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.780,NULL,NULL,NULL,0.780,NULL,NULL,NULL,NULL,0.780,0.780,0.000,0.000,NULL,NULL,1,0,0.780,0,'2015-09-29 22:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:30','C',0.780,0.000,0.000,0),(24,48,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.780,NULL,NULL,NULL,0.780,NULL,NULL,NULL,NULL,0.780,0.780,0.000,0.000,NULL,NULL,1,0,0.780,0,'2015-09-29 22:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:30','C',0.780,0.000,0.000,0),(25,49,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.780,NULL,NULL,NULL,0.780,NULL,NULL,NULL,NULL,0.780,0.780,0.000,0.000,NULL,NULL,1,0,0.780,0,'2015-09-29 22:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:30','C',0.780,0.000,0.000,0),(26,50,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.780,NULL,NULL,NULL,0.780,NULL,NULL,NULL,NULL,0.780,0.780,0.000,0.000,NULL,NULL,1,0,0.780,0,'2015-09-29 22:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:31','C',0.780,0.000,0.000,0),(27,51,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.780,NULL,NULL,NULL,0.780,NULL,NULL,NULL,NULL,0.780,0.780,0.000,0.000,NULL,NULL,1,0,0.780,0,'2015-09-29 22:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:31','C',0.780,0.000,0.000,0),(28,52,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.780,NULL,NULL,NULL,0.780,NULL,NULL,NULL,NULL,0.780,0.780,0.000,0.000,NULL,NULL,1,0,0.780,0,'2015-09-29 23:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:31','C',0.780,0.000,0.000,0),(29,53,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.780,NULL,NULL,NULL,0.780,NULL,NULL,NULL,NULL,0.780,0.780,0.000,0.000,NULL,NULL,1,0,0.780,0,'2015-09-29 23:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:32','C',0.780,0.000,0.000,0),(30,55,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.000,NULL,NULL,NULL,2.000,NULL,NULL,NULL,NULL,2.000,2.000,0.000,0.000,NULL,NULL,1,0,2.000,0,'2015-09-30 17:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:32','C',2.000,0.000,0.000,0),(31,56,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.000,NULL,NULL,NULL,2.000,NULL,NULL,NULL,NULL,2.000,2.000,0.000,0.000,NULL,NULL,1,0,2.000,0,'2015-09-30 17:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:32','C',2.000,0.000,0.000,0),(32,57,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.430,NULL,NULL,NULL,2.430,NULL,NULL,NULL,NULL,2.430,2.430,0.000,0.000,NULL,NULL,1,0,2.430,0,'2015-09-30 17:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:32','C',2.430,0.000,0.000,0),(33,58,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.430,NULL,NULL,NULL,2.430,NULL,NULL,NULL,NULL,2.430,2.430,0.000,0.000,NULL,NULL,1,0,2.430,0,'2015-09-30 17:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:33','C',2.430,0.000,0.000,0),(34,59,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.430,NULL,NULL,NULL,2.430,NULL,NULL,NULL,NULL,2.430,2.430,0.000,0.000,NULL,NULL,1,0,2.430,0,'2015-09-30 17:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:33','C',2.430,0.000,0.000,0),(35,60,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.430,NULL,NULL,NULL,2.430,NULL,NULL,NULL,NULL,2.430,2.430,0.000,0.000,NULL,NULL,1,0,2.430,0,'2015-09-30 17:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:33','C',2.430,0.000,0.000,0),(36,61,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.430,NULL,NULL,NULL,2.430,NULL,NULL,NULL,NULL,2.430,2.430,0.000,0.000,NULL,NULL,1,0,2.430,0,'2015-09-30 17:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:33','C',2.430,0.000,0.000,0),(37,62,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.430,NULL,NULL,NULL,2.430,NULL,NULL,NULL,NULL,2.430,2.430,0.000,0.000,NULL,NULL,1,0,2.430,0,'2015-09-30 17:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:34','C',2.430,0.000,0.000,0),(38,63,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 17:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:34','C',2.340,0.000,0.000,0),(39,64,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 17:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:34','C',2.340,0.000,0.000,0),(40,65,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 17:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:35','C',2.340,0.000,0.000,0),(41,66,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 17:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:35','C',2.340,0.000,0.000,0),(42,67,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 17:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:35','C',2.340,0.000,0.000,0),(43,68,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 17:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:36','C',2.340,0.000,0.000,0),(44,69,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.230,NULL,NULL,NULL,0.230,NULL,NULL,NULL,NULL,0.230,0.230,0.000,0.000,NULL,NULL,1,0,0.230,0,'2015-09-30 17:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:36','C',0.230,0.000,0.000,0),(45,70,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 17:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:36','C',2.340,0.000,0.000,0),(46,71,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 18:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:36','C',2.340,0.000,0.000,0),(47,72,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 18:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:37','C',2.340,0.000,0.000,0),(48,73,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.340,NULL,NULL,NULL,2.340,NULL,NULL,NULL,NULL,2.340,2.340,0.000,0.000,NULL,NULL,1,0,2.340,0,'2015-09-30 18:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:37','C',2.340,0.000,0.000,0),(49,74,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 18:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:37','C',0.910,0.000,0.000,0),(50,75,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 18:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:38','C',0.910,0.000,0.000,0),(51,76,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 18:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:38','C',0.910,0.000,0.000,0),(52,77,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 18:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:38','C',0.910,0.000,0.000,0),(53,78,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',3,'Artus-Garric',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 18:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:38','C',0.910,0.000,0.000,0),(54,79,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',3,'Artus-Garric',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.010,NULL,NULL,NULL,1.010,NULL,NULL,NULL,NULL,1.010,1.010,0.000,0.000,NULL,NULL,1,0,1.010,0,'2015-09-30 18:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:39','C',1.010,0.000,0.000,0),(55,80,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',3,'Artus-Garric',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.010,NULL,NULL,NULL,1.010,NULL,NULL,NULL,NULL,1.010,1.010,0.000,0.000,NULL,NULL,1,0,1.010,0,'2015-09-30 18:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:40','C',1.010,0.000,0.000,0),(56,81,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',3,'Artus-Garric',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.010,NULL,NULL,NULL,1.010,NULL,NULL,NULL,NULL,1.010,1.010,0.000,0.000,NULL,NULL,1,0,1.010,0,'2015-09-30 18:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:40','C',1.010,0.000,0.000,0),(57,82,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',3,'Artus-Garric',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.010,NULL,NULL,NULL,1.010,NULL,NULL,NULL,NULL,1.010,1.010,0.000,0.000,NULL,NULL,1,0,1.010,0,'2015-09-30 18:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:40','C',1.010,0.000,0.000,0),(58,83,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',3,'Artus-Garric',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.010,NULL,NULL,NULL,1.010,NULL,NULL,NULL,NULL,1.010,1.010,0.000,0.000,NULL,NULL,1,0,1.010,0,'2015-09-30 18:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:40','C',1.010,0.000,0.000,0),(59,84,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,1,0,4.770,0,'2015-09-30 18:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:41','C',4.770,0.000,0.000,0),(60,85,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,1,0,1.670,0,'2015-09-30 19:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:41','C',1.670,0.000,0.000,0),(61,86,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,1,0,1.670,0,'2015-09-30 19:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:41','C',1.670,0.000,0.000,0),(62,87,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-09-30 19:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:42','C',0.000,0.000,0.000,0),(63,88,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,1,0,1.670,0,'2015-09-30 19:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:42','C',1.670,0.000,0.000,0),(64,89,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,1,0,4.750,0,'2015-09-30 19:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:42','C',4.750,0.000,0.000,0),(65,90,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.680,NULL,NULL,NULL,2.680,NULL,NULL,NULL,NULL,2.680,2.680,0.000,0.000,NULL,NULL,3,0,2.680,0,'2015-09-30 19:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:42','C',2.680,0.000,0.000,0),(66,91,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.680,NULL,NULL,NULL,2.680,NULL,NULL,NULL,NULL,2.680,2.680,0.000,0.000,NULL,NULL,3,0,2.680,0,'2015-09-30 19:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:43','C',2.680,0.000,0.000,0),(67,100,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.180,NULL,NULL,NULL,17.180,NULL,NULL,NULL,NULL,17.180,17.180,0.000,0.000,NULL,NULL,1,0,17.180,0,'2015-09-30 20:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:43','C',17.180,0.000,0.000,0),(68,101,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.440,NULL,NULL,NULL,1.440,NULL,NULL,NULL,NULL,1.440,1.440,0.000,0.000,NULL,NULL,1,0,1.440,0,'2015-09-30 20:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:43','C',1.440,0.000,0.000,0),(69,102,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 20:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:44','C',0.910,0.000,0.000,0),(70,92,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.590,NULL,NULL,NULL,1.590,NULL,NULL,NULL,NULL,1.590,1.590,0.000,0.000,NULL,NULL,3,0,1.590,0,'2015-09-30 19:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:44','C',1.590,0.000,0.000,0),(71,93,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.950,NULL,NULL,NULL,0.950,NULL,NULL,NULL,NULL,0.950,0.950,0.000,0.000,NULL,NULL,1,0,0.950,0,'2015-09-30 19:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:45','C',0.950,0.000,0.000,0),(72,94,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 20:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:45','C',0.910,0.000,0.000,0),(73,95,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.020,NULL,NULL,NULL,5.020,NULL,NULL,NULL,NULL,5.020,5.020,0.000,0.000,NULL,NULL,1,0,5.020,0,'2015-09-30 20:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:45','C',5.020,0.000,0.000,0),(74,96,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 20:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:45','C',0.910,0.000,0.000,0),(75,97,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.110,NULL,NULL,NULL,2.110,NULL,NULL,NULL,NULL,2.110,2.110,0.000,0.000,NULL,NULL,3,0,2.110,0,'2015-09-30 20:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:46','C',2.110,0.000,0.000,0),(76,98,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.090,NULL,NULL,NULL,0.090,NULL,NULL,NULL,NULL,0.090,0.090,0.000,0.000,NULL,NULL,6,0,0.090,0,'2015-09-30 20:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:46','C',0.090,0.000,0.000,0),(77,99,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 20:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:46','C',0.910,0.000,0.000,0),(78,103,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-09-30 20:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:47','C',0.910,0.000,0.000,0),(79,104,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.010,NULL,NULL,NULL,1.010,NULL,NULL,NULL,NULL,1.010,1.010,0.000,0.000,NULL,NULL,1,0,1.010,0,'2015-09-30 20:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:47','C',1.010,0.000,0.000,0),(80,105,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.010,NULL,NULL,NULL,1.010,NULL,NULL,NULL,NULL,1.010,1.010,0.000,0.000,NULL,NULL,1,0,1.010,0,'2015-09-30 20:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:47','C',1.010,0.000,0.000,0),(81,106,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.220,NULL,NULL,NULL,0.220,NULL,NULL,NULL,NULL,0.220,0.220,0.000,0.000,NULL,NULL,6,0,0.220,0,'2015-09-30 20:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:47','C',0.220,0.000,0.000,0),(82,107,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-09-30 20:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:48','C',0.000,0.000,0.000,0),(83,108,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,1,0,3.750,0,'2015-10-01 07:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:48','C',3.750,0.000,0.000,0),(84,109,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,1,0,3.750,0,'2015-10-01 07:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:48','C',3.750,0.000,0.000,0),(85,110,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-01 07:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:49','C',3.560,0.000,0.000,0),(86,111,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,1,0,3.450,0,'2015-10-01 07:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:49','C',3.450,0.000,0.000,0),(87,112,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-01 07:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:49','C',3.630,0.000,0.000,0),(88,113,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.520,NULL,NULL,NULL,3.520,NULL,NULL,NULL,NULL,3.520,3.520,0.000,0.000,NULL,NULL,1,0,3.520,0,'2015-10-01 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:50','C',3.520,0.000,0.000,0),(89,114,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.710,NULL,NULL,NULL,3.710,NULL,NULL,NULL,NULL,3.710,3.710,0.000,0.000,NULL,NULL,1,0,3.710,0,'2015-10-01 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:50','C',3.710,0.000,0.000,0),(90,115,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-01 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:50','C',3.470,0.000,0.000,0),(91,116,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-01 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:51','C',3.560,0.000,0.000,0),(92,117,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,1,0,3.450,0,'2015-10-01 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:51','C',3.450,0.000,0.000,0),(93,118,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-01 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:51','C',3.610,0.000,0.000,0),(94,119,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.540,NULL,NULL,NULL,3.540,NULL,NULL,NULL,NULL,3.540,3.540,0.000,0.000,NULL,NULL,1,0,3.540,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:52','C',3.540,0.000,0.000,0),(95,120,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:52','C',3.610,0.000,0.000,0),(96,121,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:52','C',3.610,0.000,0.000,0),(97,122,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.520,NULL,NULL,NULL,3.520,NULL,NULL,NULL,NULL,3.520,3.520,0.000,0.000,NULL,NULL,1,0,3.520,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:53','C',3.520,0.000,0.000,0),(98,123,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:53','C',3.610,0.000,0.000,0),(99,124,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:53','C',3.470,0.000,0.000,0),(100,125,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.370,NULL,NULL,NULL,3.370,NULL,NULL,NULL,NULL,3.370,3.370,0.000,0.000,NULL,NULL,1,0,3.370,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:54','C',3.370,0.000,0.000,0),(101,126,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,1,0,3.820,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:54','C',3.820,0.000,0.000,0),(102,127,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.230,NULL,NULL,NULL,3.230,NULL,NULL,NULL,NULL,3.230,3.230,0.000,0.000,NULL,NULL,1,0,3.230,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:54','C',3.230,0.000,0.000,0),(103,128,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.190,NULL,NULL,NULL,3.190,NULL,NULL,NULL,NULL,3.190,3.190,0.000,0.000,NULL,NULL,1,0,3.190,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:54','C',3.190,0.000,0.000,0),(104,129,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-01 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:55','C',3.630,0.000,0.000,0),(105,130,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.950,NULL,NULL,NULL,2.950,NULL,NULL,NULL,NULL,2.950,2.950,0.000,0.000,NULL,NULL,1,0,2.950,0,'2015-10-01 07:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:55','C',2.950,0.000,0.000,0),(106,131,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-01 07:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:56','C',3.630,0.000,0.000,0),(107,132,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,1,0,3.820,0,'2015-10-01 07:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:56','C',3.820,0.000,0.000,0),(108,133,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-01 07:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:56','C',3.660,0.000,0.000,0),(109,134,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,1,0,3.330,0,'2015-10-01 07:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:56','C',3.330,0.000,0.000,0),(110,135,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.490,NULL,NULL,NULL,3.490,NULL,NULL,NULL,NULL,3.490,3.490,0.000,0.000,NULL,NULL,1,0,3.490,0,'2015-10-01 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:57','C',3.490,0.000,0.000,0),(111,136,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-01 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:58','C',3.610,0.000,0.000,0),(112,137,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-01 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:58','C',3.590,0.000,0.000,0),(113,138,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-01 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:59','C',3.470,0.000,0.000,0),(114,139,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-01 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:59','C',3.610,0.000,0.000,0),(115,140,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-01 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:59','C',3.630,0.000,0.000,0),(116,141,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,1,0,3.280,0,'2015-10-01 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:00:59','C',3.280,0.000,0.000,0),(117,142,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.000,NULL,NULL,NULL,3.000,NULL,NULL,NULL,NULL,3.000,3.000,0.000,0.000,NULL,NULL,1,0,3.000,0,'2015-10-01 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:00','C',3.000,0.000,0.000,0),(118,143,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-01 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:00','C',3.780,0.000,0.000,0),(119,144,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.490,NULL,NULL,NULL,3.490,NULL,NULL,NULL,NULL,3.490,3.490,0.000,0.000,NULL,NULL,1,0,3.490,0,'2015-10-01 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:00','C',3.490,0.000,0.000,0),(120,145,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-01 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:01','C',3.560,0.000,0.000,0),(121,146,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-01 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:01','C',3.780,0.000,0.000,0),(122,147,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.520,NULL,NULL,NULL,3.520,NULL,NULL,NULL,NULL,3.520,3.520,0.000,0.000,NULL,NULL,1,0,3.520,0,'2015-10-01 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:01','C',3.520,0.000,0.000,0),(123,148,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-01 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:01','C',3.610,0.000,0.000,0),(124,149,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.680,NULL,NULL,NULL,3.680,NULL,NULL,NULL,NULL,3.680,3.680,0.000,0.000,NULL,NULL,1,0,3.680,0,'2015-10-01 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:02','C',3.680,0.000,0.000,0),(125,150,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-01 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:02','C',3.630,0.000,0.000,0),(126,151,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-01 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:02','C',3.470,0.000,0.000,0),(127,152,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.540,NULL,NULL,NULL,3.540,NULL,NULL,NULL,NULL,3.540,3.540,0.000,0.000,NULL,NULL,1,0,3.540,0,'2015-10-01 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:03','C',3.540,0.000,0.000,0),(128,153,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.710,NULL,NULL,NULL,3.710,NULL,NULL,NULL,NULL,3.710,3.710,0.000,0.000,NULL,NULL,1,0,3.710,0,'2015-10-01 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:03','C',3.710,0.000,0.000,0),(129,154,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.680,NULL,NULL,NULL,3.680,NULL,NULL,NULL,NULL,3.680,3.680,0.000,0.000,NULL,NULL,1,0,3.680,0,'2015-10-01 07:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:03','C',3.680,0.000,0.000,0),(130,155,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-01 07:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:04','C',3.660,0.000,0.000,0),(131,156,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-01 07:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:04','C',3.610,0.000,0.000,0),(132,157,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.680,NULL,NULL,NULL,3.680,NULL,NULL,NULL,NULL,3.680,3.680,0.000,0.000,NULL,NULL,1,0,3.680,0,'2015-10-01 07:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:04','C',3.680,0.000,0.000,0),(133,158,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-01 07:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:04','C',3.630,0.000,0.000,0),(134,159,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-01 07:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:05','C',3.470,0.000,0.000,0),(135,160,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-01 07:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:05','C',3.590,0.000,0.000,0),(136,161,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-01 07:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:05','C',3.470,0.000,0.000,0),(137,162,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-01 07:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:06','C',3.660,0.000,0.000,0),(138,163,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.730,NULL,NULL,NULL,3.730,NULL,NULL,NULL,NULL,3.730,3.730,0.000,0.000,NULL,NULL,1,0,3.730,0,'2015-10-01 07:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:06','C',3.730,0.000,0.000,0),(139,164,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.230,NULL,NULL,NULL,3.230,NULL,NULL,NULL,NULL,3.230,3.230,0.000,0.000,NULL,NULL,1,0,3.230,0,'2015-10-01 07:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:07','C',3.230,0.000,0.000,0),(140,165,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.420,NULL,NULL,NULL,3.420,NULL,NULL,NULL,NULL,3.420,3.420,0.000,0.000,NULL,NULL,1,0,3.420,0,'2015-10-01 07:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:07','C',3.420,0.000,0.000,0),(141,166,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.350,NULL,NULL,NULL,3.350,NULL,NULL,NULL,NULL,3.350,3.350,0.000,0.000,NULL,NULL,1,0,3.350,0,'2015-10-01 07:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:07','C',3.350,0.000,0.000,0),(142,167,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-01 07:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:08','C',3.470,0.000,0.000,0),(143,168,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.540,NULL,NULL,NULL,3.540,NULL,NULL,NULL,NULL,3.540,3.540,0.000,0.000,NULL,NULL,1,0,3.540,0,'2015-10-01 07:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:08','C',3.540,0.000,0.000,0),(144,169,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.190,NULL,NULL,NULL,3.190,NULL,NULL,NULL,NULL,3.190,3.190,0.000,0.000,NULL,NULL,1,0,3.190,0,'2015-10-01 07:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:08','C',3.190,0.000,0.000,0),(145,170,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.540,NULL,NULL,NULL,3.540,NULL,NULL,NULL,NULL,3.540,3.540,0.000,0.000,NULL,NULL,1,0,3.540,0,'2015-10-01 07:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:09','C',3.540,0.000,0.000,0),(146,171,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,1,0,3.400,0,'2015-10-01 07:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:09','C',3.400,0.000,0.000,0),(147,172,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-01 07:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:09','C',3.560,0.000,0.000,0),(148,173,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,1,0,3.450,0,'2015-10-01 07:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:10','C',3.450,0.000,0.000,0),(149,174,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,1,0,3.750,0,'2015-10-01 07:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:10','C',3.750,0.000,0.000,0),(150,175,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,1,0,3.750,0,'2015-10-01 07:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:10','C',3.750,0.000,0.000,0),(151,176,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-01 07:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:11','C',3.560,0.000,0.000,0),(152,177,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-01 08:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:11','C',4.020,0.000,0.000,0),(153,178,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.380,NULL,NULL,NULL,3.380,NULL,NULL,NULL,NULL,3.380,3.380,0.000,0.000,NULL,NULL,1,0,3.380,0,'2015-10-01 08:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:11','C',3.380,0.000,0.000,0),(154,179,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:13','C',4.000,0.000,0.000,0),(155,180,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-01 08:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:13','C',4.240,0.000,0.000,0),(156,181,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-01 08:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:14','C',4.190,0.000,0.000,0),(157,182,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.050,NULL,NULL,NULL,4.050,NULL,NULL,NULL,NULL,4.050,4.050,0.000,0.000,NULL,NULL,1,0,4.050,0,'2015-10-01 08:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:14','C',4.050,0.000,0.000,0),(158,183,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-01 08:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:14','C',4.130,0.000,0.000,0),(159,184,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,21.330,NULL,NULL,NULL,21.330,NULL,NULL,NULL,NULL,21.330,21.330,0.000,0.000,NULL,NULL,1,0,21.330,0,'2015-10-01 08:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:15','C',21.330,0.000,0.000,0),(160,185,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.050,NULL,NULL,NULL,4.050,NULL,NULL,NULL,NULL,4.050,4.050,0.000,0.000,NULL,NULL,1,0,4.050,0,'2015-10-01 08:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:15','C',4.050,0.000,0.000,0),(161,186,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-01 08:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:15','C',4.160,0.000,0.000,0),(162,187,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-01 08:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:16','C',4.270,0.000,0.000,0),(163,188,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-01 08:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:16','C',4.190,0.000,0.000,0),(164,189,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-01 08:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:16','C',4.020,0.000,0.000,0),(165,190,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-01 08:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:17','C',4.160,0.000,0.000,0),(166,191,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.860,NULL,NULL,NULL,3.860,NULL,NULL,NULL,NULL,3.860,3.860,0.000,0.000,NULL,NULL,1,0,3.860,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:17','C',3.860,0.000,0.000,0),(167,192,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:18','C',4.100,0.000,0.000,0),(168,193,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:18','C',4.100,0.000,0.000,0),(169,194,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:18','C',4.210,0.000,0.000,0),(170,195,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:19','C',4.240,0.000,0.000,0),(171,196,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:19','C',4.020,0.000,0.000,0),(172,197,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:22','C',4.130,0.000,0.000,0),(173,198,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:23','C',4.130,0.000,0.000,0),(174,199,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:23','C',4.080,0.000,0.000,0),(175,200,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 08:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:23','C',4.100,0.000,0.000,0),(176,201,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:23','C',4.130,0.000,0.000,0),(177,202,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.860,NULL,NULL,NULL,3.860,NULL,NULL,NULL,NULL,3.860,3.860,0.000,0.000,NULL,NULL,1,0,3.860,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:24','C',3.860,0.000,0.000,0),(178,203,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:24','C',4.080,0.000,0.000,0),(179,204,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.830,NULL,NULL,NULL,3.830,NULL,NULL,NULL,NULL,3.830,3.830,0.000,0.000,NULL,NULL,1,0,3.830,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:24','C',3.830,0.000,0.000,0),(180,205,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,1,0,3.670,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:25','C',3.670,0.000,0.000,0),(181,206,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,1,0,3.890,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:25','C',3.890,0.000,0.000,0),(182,207,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:25','C',4.000,0.000,0.000,0),(183,208,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:26','C',4.290,0.000,0.000,0),(184,209,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:26','C',4.100,0.000,0.000,0),(185,210,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:26','C',4.000,0.000,0.000,0),(186,211,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.270,NULL,NULL,NULL,3.270,NULL,NULL,NULL,NULL,3.270,3.270,0.000,0.000,NULL,NULL,1,0,3.270,0,'2015-10-01 08:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:27','C',3.270,0.000,0.000,0),(187,212,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.050,NULL,NULL,NULL,4.050,NULL,NULL,NULL,NULL,4.050,4.050,0.000,0.000,NULL,NULL,1,0,4.050,0,'2015-10-01 08:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:27','C',4.050,0.000,0.000,0),(188,213,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-01 08:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:27','C',4.020,0.000,0.000,0),(189,214,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.940,NULL,NULL,NULL,3.940,NULL,NULL,NULL,NULL,3.940,3.940,0.000,0.000,NULL,NULL,1,0,3.940,0,'2015-10-01 08:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:28','C',3.940,0.000,0.000,0),(190,215,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-01 08:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:28','C',3.970,0.000,0.000,0),(191,216,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-01 08:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:28','C',4.210,0.000,0.000,0),(192,217,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-01 08:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:29','C',3.780,0.000,0.000,0),(193,218,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:29','C',4.000,0.000,0.000,0),(194,219,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:29','C',4.270,0.000,0.000,0),(195,220,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:30','C',4.130,0.000,0.000,0),(196,221,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:30','C',4.270,0.000,0.000,0),(197,222,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:30','C',3.780,0.000,0.000,0),(198,223,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:31','C',4.130,0.000,0.000,0),(199,224,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.540,NULL,NULL,NULL,3.540,NULL,NULL,NULL,NULL,3.540,3.540,0.000,0.000,NULL,NULL,1,0,3.540,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:31','C',3.540,0.000,0.000,0),(200,225,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.830,NULL,NULL,NULL,3.830,NULL,NULL,NULL,NULL,3.830,3.830,0.000,0.000,NULL,NULL,1,0,3.830,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:31','C',3.830,0.000,0.000,0),(201,226,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:32','C',4.020,0.000,0.000,0),(202,227,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-01 08:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:32','C',4.080,0.000,0.000,0),(203,228,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.940,NULL,NULL,NULL,3.940,NULL,NULL,NULL,NULL,3.940,3.940,0.000,0.000,NULL,NULL,1,0,3.940,0,'2015-10-01 08:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:32','C',3.940,0.000,0.000,0),(204,229,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.400,NULL,NULL,NULL,4.400,NULL,NULL,NULL,NULL,4.400,4.400,0.000,0.000,NULL,NULL,1,0,4.400,0,'2015-10-01 08:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:33','C',4.400,0.000,0.000,0),(205,230,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-01 08:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:33','C',4.080,0.000,0.000,0),(206,231,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 08:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:33','C',4.100,0.000,0.000,0),(207,232,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,1,0,3.890,0,'2015-10-01 08:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:34','C',3.890,0.000,0.000,0),(208,233,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-01 08:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:34','C',4.290,0.000,0.000,0),(209,234,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:34','C',4.210,0.000,0.000,0),(210,235,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:35','C',4.290,0.000,0.000,0),(211,236,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:35','C',4.240,0.000,0.000,0),(212,237,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:35','C',4.290,0.000,0.000,0),(213,238,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:36','C',4.270,0.000,0.000,0),(214,239,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:36','C',4.270,0.000,0.000,0),(215,240,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:36','C',4.240,0.000,0.000,0),(216,241,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:37','C',4.130,0.000,0.000,0),(217,242,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-01 08:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:37','C',4.190,0.000,0.000,0),(218,243,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:37','C',4.240,0.000,0.000,0),(219,244,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:38','C',4.240,0.000,0.000,0),(220,245,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:39','C',4.000,0.000,0.000,0),(221,246,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.920,NULL,NULL,NULL,3.920,NULL,NULL,NULL,NULL,3.920,3.920,0.000,0.000,NULL,NULL,1,0,3.920,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:39','C',3.920,0.000,0.000,0),(222,247,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.400,NULL,NULL,NULL,4.400,NULL,NULL,NULL,NULL,4.400,4.400,0.000,0.000,NULL,NULL,1,0,4.400,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:39','C',4.400,0.000,0.000,0),(223,248,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.400,NULL,NULL,NULL,4.400,NULL,NULL,NULL,NULL,4.400,4.400,0.000,0.000,NULL,NULL,1,0,4.400,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:40','C',4.400,0.000,0.000,0),(224,249,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:40','C',4.100,0.000,0.000,0),(225,250,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.810,NULL,NULL,NULL,3.810,NULL,NULL,NULL,NULL,3.810,3.810,0.000,0.000,NULL,NULL,1,0,3.810,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:40','C',3.810,0.000,0.000,0),(226,251,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.830,NULL,NULL,NULL,3.830,NULL,NULL,NULL,NULL,3.830,3.830,0.000,0.000,NULL,NULL,1,0,3.830,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:41','C',3.830,0.000,0.000,0),(227,252,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 08:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:41','C',4.100,0.000,0.000,0),(228,253,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:41','C',4.000,0.000,0.000,0),(229,254,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:42','C',4.000,0.000,0.000,0),(230,255,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 08:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:42','C',4.100,0.000,0.000,0),(231,256,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:42','C',4.000,0.000,0.000,0),(232,257,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-01 08:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:43','C',4.190,0.000,0.000,0),(233,258,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-01 08:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:43','C',4.160,0.000,0.000,0),(234,259,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-01 08:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:43','C',4.020,0.000,0.000,0),(235,260,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-01 08:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:43','C',4.270,0.000,0.000,0),(236,261,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,1,0,3.670,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:44','C',3.670,0.000,0.000,0),(237,262,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:44','C',4.290,0.000,0.000,0),(238,263,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:44','C',4.190,0.000,0.000,0),(239,264,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:45','C',4.000,0.000,0.000,0),(240,265,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:45','C',4.270,0.000,0.000,0),(241,266,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:46','C',4.160,0.000,0.000,0),(242,267,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:46','C',3.780,0.000,0.000,0),(243,268,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,1,0,3.670,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:46','C',3.670,0.000,0.000,0),(244,269,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:47','C',3.560,0.000,0.000,0),(245,270,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:47','C',4.080,0.000,0.000,0),(246,271,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:47','C',4.160,0.000,0.000,0),(247,272,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.830,NULL,NULL,NULL,3.830,NULL,NULL,NULL,NULL,3.830,3.830,0.000,0.000,NULL,NULL,1,0,3.830,0,'2015-10-01 08:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:48','C',3.830,0.000,0.000,0),(248,273,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:48','C',4.210,0.000,0.000,0),(249,274,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.650,NULL,NULL,NULL,3.650,NULL,NULL,NULL,NULL,3.650,3.650,0.000,0.000,NULL,NULL,1,0,3.650,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:48','C',3.650,0.000,0.000,0),(250,275,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:49','C',4.290,0.000,0.000,0),(251,276,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.350,NULL,NULL,NULL,4.350,NULL,NULL,NULL,NULL,4.350,4.350,0.000,0.000,NULL,NULL,1,0,4.350,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:49','C',4.350,0.000,0.000,0),(252,277,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.810,NULL,NULL,NULL,3.810,NULL,NULL,NULL,NULL,3.810,3.810,0.000,0.000,NULL,NULL,1,0,3.810,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:49','C',3.810,0.000,0.000,0),(253,278,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:50','C',4.080,0.000,0.000,0),(254,279,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.190,NULL,NULL,NULL,3.190,NULL,NULL,NULL,NULL,3.190,3.190,0.000,0.000,NULL,NULL,1,0,3.190,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:50','C',3.190,0.000,0.000,0),(255,280,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:50','C',3.780,0.000,0.000,0),(256,281,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.320,NULL,NULL,NULL,3.320,NULL,NULL,NULL,NULL,3.320,3.320,0.000,0.000,NULL,NULL,1,0,3.320,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:51','C',3.320,0.000,0.000,0),(257,282,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.050,NULL,NULL,NULL,4.050,NULL,NULL,NULL,NULL,4.050,4.050,0.000,0.000,NULL,NULL,1,0,4.050,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:51','C',4.050,0.000,0.000,0),(258,283,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:51','C',3.780,0.000,0.000,0),(259,284,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.590,NULL,NULL,NULL,4.590,NULL,NULL,NULL,NULL,4.590,4.590,0.000,0.000,NULL,NULL,1,0,4.590,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:52','C',4.590,0.000,0.000,0),(260,285,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:52','C',4.160,0.000,0.000,0),(261,286,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.400,NULL,NULL,NULL,4.400,NULL,NULL,NULL,NULL,4.400,4.400,0.000,0.000,NULL,NULL,1,0,4.400,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:52','C',4.400,0.000,0.000,0),(262,287,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:53','C',4.000,0.000,0.000,0),(263,288,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-01 08:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:53','C',4.290,0.000,0.000,0),(264,289,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.980,NULL,NULL,NULL,4.980,NULL,NULL,NULL,NULL,4.980,4.980,0.000,0.000,NULL,NULL,1,0,4.980,0,'2015-10-01 08:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:53','C',4.980,0.000,0.000,0),(265,290,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.280,NULL,NULL,NULL,4.280,NULL,NULL,NULL,NULL,4.280,4.280,0.000,0.000,NULL,NULL,1,0,4.280,0,'2015-10-01 08:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:54','C',4.280,0.000,0.000,0),(266,291,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.010,NULL,NULL,NULL,4.010,NULL,NULL,NULL,NULL,4.010,4.010,0.000,0.000,NULL,NULL,1,0,4.010,0,'2015-10-01 08:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:54','C',4.010,0.000,0.000,0),(267,292,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.010,NULL,NULL,NULL,3.010,NULL,NULL,NULL,NULL,3.010,3.010,0.000,0.000,NULL,NULL,1,0,3.010,0,'2015-10-01 08:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:54','C',3.010,0.000,0.000,0),(268,293,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.040,NULL,NULL,NULL,4.040,NULL,NULL,NULL,NULL,4.040,4.040,0.000,0.000,NULL,NULL,1,0,4.040,0,'2015-10-01 08:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:55','C',4.040,0.000,0.000,0),(269,294,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.810,NULL,NULL,NULL,3.810,NULL,NULL,NULL,NULL,3.810,3.810,0.000,0.000,NULL,NULL,1,0,3.810,0,'2015-10-01 08:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:55','C',3.810,0.000,0.000,0),(270,295,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.270,NULL,NULL,NULL,3.270,NULL,NULL,NULL,NULL,3.270,3.270,0.000,0.000,NULL,NULL,1,0,3.270,0,'2015-10-01 08:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:55','C',3.270,0.000,0.000,0),(271,296,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.610,NULL,NULL,NULL,5.610,NULL,NULL,NULL,NULL,5.610,5.610,0.000,0.000,NULL,NULL,1,0,5.610,0,'2015-10-01 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:56','C',5.610,0.000,0.000,0),(272,297,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.970,NULL,NULL,NULL,2.970,NULL,NULL,NULL,NULL,2.970,2.970,0.000,0.000,NULL,NULL,1,0,2.970,0,'2015-10-01 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:01:59','C',2.970,0.000,0.000,0),(273,298,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.180,NULL,NULL,NULL,4.180,NULL,NULL,NULL,NULL,4.180,4.180,0.000,0.000,NULL,NULL,1,0,4.180,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:00','C',4.180,0.000,0.000,0),(274,299,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.140,NULL,NULL,NULL,3.140,NULL,NULL,NULL,NULL,3.140,3.140,0.000,0.000,NULL,NULL,1,0,3.140,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:00','C',3.140,0.000,0.000,0),(275,300,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.910,NULL,NULL,NULL,2.910,NULL,NULL,NULL,NULL,2.910,2.910,0.000,0.000,NULL,NULL,1,0,2.910,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:00','C',2.910,0.000,0.000,0),(276,301,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.070,NULL,NULL,NULL,3.070,NULL,NULL,NULL,NULL,3.070,3.070,0.000,0.000,NULL,NULL,1,0,3.070,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:01','C',3.070,0.000,0.000,0),(277,302,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.610,NULL,NULL,NULL,2.610,NULL,NULL,NULL,NULL,2.610,2.610,0.000,0.000,NULL,NULL,1,0,2.610,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:01','C',2.610,0.000,0.000,0),(278,303,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,1,0,3.670,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:01','C',3.670,0.000,0.000,0),(279,304,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.940,NULL,NULL,NULL,3.940,NULL,NULL,NULL,NULL,3.940,3.940,0.000,0.000,NULL,NULL,1,0,3.940,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:02','C',3.940,0.000,0.000,0),(280,305,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.510,NULL,NULL,NULL,4.510,NULL,NULL,NULL,NULL,4.510,4.510,0.000,0.000,NULL,NULL,1,0,4.510,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:02','C',4.510,0.000,0.000,0),(281,306,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.540,NULL,NULL,NULL,3.540,NULL,NULL,NULL,NULL,3.540,3.540,0.000,0.000,NULL,NULL,1,0,3.540,0,'2015-10-01 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:03','C',3.540,0.000,0.000,0),(282,307,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.900,NULL,NULL,NULL,9.900,NULL,NULL,NULL,NULL,9.900,9.900,0.000,0.000,NULL,NULL,1,0,9.900,0,'2015-10-01 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:03','C',9.900,0.000,0.000,0),(283,308,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.900,NULL,NULL,NULL,11.900,NULL,NULL,NULL,NULL,11.900,11.900,0.000,0.000,NULL,NULL,1,0,11.900,0,'2015-10-01 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:03','C',11.900,0.000,0.000,0),(284,309,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.800,NULL,NULL,NULL,11.800,NULL,NULL,NULL,NULL,11.800,11.800,0.000,0.000,NULL,NULL,1,0,11.800,0,'2015-10-01 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:04','C',11.800,0.000,0.000,0),(285,310,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.260,NULL,NULL,NULL,10.260,NULL,NULL,NULL,NULL,10.260,10.260,0.000,0.000,NULL,NULL,1,0,10.260,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:04','C',10.260,0.000,0.000,0),(286,311,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.230,NULL,NULL,NULL,11.230,NULL,NULL,NULL,NULL,11.230,11.230,0.000,0.000,NULL,NULL,1,0,11.230,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:04','C',11.230,0.000,0.000,0),(287,312,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.440,NULL,NULL,NULL,13.440,NULL,NULL,NULL,NULL,13.440,13.440,0.000,0.000,NULL,NULL,1,0,13.440,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:05','C',13.440,0.000,0.000,0),(288,313,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.800,NULL,NULL,NULL,11.800,NULL,NULL,NULL,NULL,11.800,11.800,0.000,0.000,NULL,NULL,1,0,11.800,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:05','C',11.800,0.000,0.000,0),(289,314,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.620,NULL,NULL,NULL,10.620,NULL,NULL,NULL,NULL,10.620,10.620,0.000,0.000,NULL,NULL,1,0,10.620,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:05','C',10.620,0.000,0.000,0),(290,315,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.670,NULL,NULL,NULL,12.670,NULL,NULL,NULL,NULL,12.670,12.670,0.000,0.000,NULL,NULL,1,0,12.670,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:06','C',12.670,0.000,0.000,0),(291,316,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.570,NULL,NULL,NULL,12.570,NULL,NULL,NULL,NULL,12.570,12.570,0.000,0.000,NULL,NULL,1,0,12.570,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:06','C',12.570,0.000,0.000,0),(292,317,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.770,NULL,NULL,NULL,10.770,NULL,NULL,NULL,NULL,10.770,10.770,0.000,0.000,NULL,NULL,1,0,10.770,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:06','C',10.770,0.000,0.000,0),(293,318,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.720,NULL,NULL,NULL,10.720,NULL,NULL,NULL,NULL,10.720,10.720,0.000,0.000,NULL,NULL,1,0,10.720,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:07','C',10.720,0.000,0.000,0),(294,319,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.950,NULL,NULL,NULL,11.950,NULL,NULL,NULL,NULL,11.950,11.950,0.000,0.000,NULL,NULL,1,0,11.950,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:07','C',11.950,0.000,0.000,0),(295,320,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.980,NULL,NULL,NULL,10.980,NULL,NULL,NULL,NULL,10.980,10.980,0.000,0.000,NULL,NULL,1,0,10.980,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:07','C',10.980,0.000,0.000,0),(296,321,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.570,NULL,NULL,NULL,12.570,NULL,NULL,NULL,NULL,12.570,12.570,0.000,0.000,NULL,NULL,1,0,12.570,0,'2015-10-01 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:08','C',12.570,0.000,0.000,0),(297,322,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.160,NULL,NULL,NULL,12.160,NULL,NULL,NULL,NULL,12.160,12.160,0.000,0.000,NULL,NULL,1,0,12.160,0,'2015-10-01 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:08','C',12.160,0.000,0.000,0),(298,323,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.360,NULL,NULL,NULL,10.360,NULL,NULL,NULL,NULL,10.360,10.360,0.000,0.000,NULL,NULL,1,0,10.360,0,'2015-10-01 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:08','C',10.360,0.000,0.000,0),(299,324,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.850,NULL,NULL,NULL,9.850,NULL,NULL,NULL,NULL,9.850,9.850,0.000,0.000,NULL,NULL,1,0,9.850,0,'2015-10-01 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:09','C',9.850,0.000,0.000,0),(300,325,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.230,NULL,NULL,NULL,11.230,NULL,NULL,NULL,NULL,11.230,11.230,0.000,0.000,NULL,NULL,1,0,11.230,0,'2015-10-01 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:09','C',11.230,0.000,0.000,0),(301,326,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.030,NULL,NULL,NULL,11.030,NULL,NULL,NULL,NULL,11.030,11.030,0.000,0.000,NULL,NULL,1,0,11.030,0,'2015-10-01 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:09','C',11.030,0.000,0.000,0),(302,327,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.620,NULL,NULL,NULL,10.620,NULL,NULL,NULL,NULL,10.620,10.620,0.000,0.000,NULL,NULL,1,0,10.620,0,'2015-10-01 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:10','C',10.620,0.000,0.000,0),(303,328,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.030,NULL,NULL,NULL,11.030,NULL,NULL,NULL,NULL,11.030,11.030,0.000,0.000,NULL,NULL,1,0,11.030,0,'2015-10-01 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:10','C',11.030,0.000,0.000,0),(304,329,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.440,NULL,NULL,NULL,5.440,NULL,NULL,NULL,NULL,5.440,5.440,0.000,0.000,NULL,NULL,1,0,5.440,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:10','C',5.440,0.000,0.000,0),(305,330,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.360,NULL,NULL,NULL,6.360,NULL,NULL,NULL,NULL,6.360,6.360,0.000,0.000,NULL,NULL,1,0,6.360,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:12','C',6.360,0.000,0.000,0),(306,331,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.640,NULL,NULL,NULL,5.640,NULL,NULL,NULL,NULL,5.640,5.640,0.000,0.000,NULL,NULL,1,0,5.640,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:12','C',5.640,0.000,0.000,0),(307,332,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.820,NULL,NULL,NULL,4.820,NULL,NULL,NULL,NULL,4.820,4.820,0.000,0.000,NULL,NULL,1,0,4.820,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:12','C',4.820,0.000,0.000,0),(308,333,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.720,NULL,NULL,NULL,4.720,NULL,NULL,NULL,NULL,4.720,4.720,0.000,0.000,NULL,NULL,1,0,4.720,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:13','C',4.720,0.000,0.000,0),(309,334,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.720,NULL,NULL,NULL,4.720,NULL,NULL,NULL,NULL,4.720,4.720,0.000,0.000,NULL,NULL,1,0,4.720,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:13','C',4.720,0.000,0.000,0),(310,335,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.310,NULL,NULL,NULL,6.310,NULL,NULL,NULL,NULL,6.310,6.310,0.000,0.000,NULL,NULL,1,0,6.310,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:13','C',6.310,0.000,0.000,0),(311,336,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.750,NULL,NULL,NULL,5.750,NULL,NULL,NULL,NULL,5.750,5.750,0.000,0.000,NULL,NULL,1,0,5.750,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:14','C',5.750,0.000,0.000,0),(312,337,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.510,NULL,NULL,NULL,4.510,NULL,NULL,NULL,NULL,4.510,4.510,0.000,0.000,NULL,NULL,1,0,4.510,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:14','C',4.510,0.000,0.000,0),(313,338,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.310,NULL,NULL,NULL,6.310,NULL,NULL,NULL,NULL,6.310,6.310,0.000,0.000,NULL,NULL,1,0,6.310,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:14','C',6.310,0.000,0.000,0),(314,339,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.640,NULL,NULL,NULL,5.640,NULL,NULL,NULL,NULL,5.640,5.640,0.000,0.000,NULL,NULL,1,0,5.640,0,'2015-10-01 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:15','C',5.640,0.000,0.000,0),(315,340,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.460,NULL,NULL,NULL,4.460,NULL,NULL,NULL,NULL,4.460,4.460,0.000,0.000,NULL,NULL,1,0,4.460,0,'2015-10-01 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:15','C',4.460,0.000,0.000,0),(316,341,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.360,NULL,NULL,NULL,5.360,NULL,NULL,NULL,NULL,5.360,5.360,0.000,0.000,NULL,NULL,1,0,5.360,0,'2015-10-01 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:15','C',5.360,0.000,0.000,0),(317,342,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.080,NULL,NULL,NULL,6.080,NULL,NULL,NULL,NULL,6.080,6.080,0.000,0.000,NULL,NULL,1,0,6.080,0,'2015-10-01 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:16','C',6.080,0.000,0.000,0),(318,343,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.430,NULL,NULL,NULL,5.430,NULL,NULL,NULL,NULL,5.430,5.430,0.000,0.000,NULL,NULL,1,0,5.430,0,'2015-10-01 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:16','C',5.430,0.000,0.000,0),(319,344,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.460,NULL,NULL,NULL,5.460,NULL,NULL,NULL,NULL,5.460,5.460,0.000,0.000,NULL,NULL,1,0,5.460,0,'2015-10-01 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:17','C',5.460,0.000,0.000,0),(320,345,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-01 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:17','C',4.000,0.000,0.000,0),(321,346,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.840,NULL,NULL,NULL,3.840,NULL,NULL,NULL,NULL,3.840,3.840,0.000,0.000,NULL,NULL,1,0,3.840,0,'2015-10-01 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:17','C',3.840,0.000,0.000,0),(322,347,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.160,NULL,NULL,NULL,7.160,NULL,NULL,NULL,NULL,7.160,7.160,0.000,0.000,NULL,NULL,1,0,7.160,0,'2015-10-01 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:18','C',7.160,0.000,0.000,0),(323,348,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.590,NULL,NULL,NULL,4.590,NULL,NULL,NULL,NULL,4.590,4.590,0.000,0.000,NULL,NULL,1,0,4.590,0,'2015-10-01 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:18','C',4.590,0.000,0.000,0),(324,349,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.210,NULL,NULL,NULL,5.210,NULL,NULL,NULL,NULL,5.210,5.210,0.000,0.000,NULL,NULL,1,0,5.210,0,'2015-10-01 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:18','C',5.210,0.000,0.000,0),(325,350,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-01 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:19','C',3.560,0.000,0.000,0),(326,351,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.410,NULL,NULL,NULL,3.410,NULL,NULL,NULL,NULL,3.410,3.410,0.000,0.000,NULL,NULL,1,0,3.410,0,'2015-10-01 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:19','C',3.410,0.000,0.000,0),(327,352,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.720,NULL,NULL,NULL,4.720,NULL,NULL,NULL,NULL,4.720,4.720,0.000,0.000,NULL,NULL,1,0,4.720,0,'2015-10-01 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:19','C',4.720,0.000,0.000,0),(328,353,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.580,NULL,NULL,NULL,4.580,NULL,NULL,NULL,NULL,4.580,4.580,0.000,0.000,NULL,NULL,1,0,4.580,0,'2015-10-01 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:20','C',4.580,0.000,0.000,0),(329,354,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.880,NULL,NULL,NULL,5.880,NULL,NULL,NULL,NULL,5.880,5.880,0.000,0.000,NULL,NULL,1,0,5.880,0,'2015-10-01 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:20','C',5.880,0.000,0.000,0),(330,355,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.150,NULL,NULL,NULL,4.150,NULL,NULL,NULL,NULL,4.150,4.150,0.000,0.000,NULL,NULL,1,0,4.150,0,'2015-10-01 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:21','C',4.150,0.000,0.000,0),(331,356,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.860,NULL,NULL,NULL,4.860,NULL,NULL,NULL,NULL,4.860,4.860,0.000,0.000,NULL,NULL,1,0,4.860,0,'2015-10-01 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:21','C',4.860,0.000,0.000,0),(332,357,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.610,NULL,NULL,NULL,5.610,NULL,NULL,NULL,NULL,5.610,5.610,0.000,0.000,NULL,NULL,1,0,5.610,0,'2015-10-01 08:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:22','C',5.610,0.000,0.000,0),(333,358,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.610,NULL,NULL,NULL,5.610,NULL,NULL,NULL,NULL,5.610,5.610,0.000,0.000,NULL,NULL,1,0,5.610,0,'2015-10-01 08:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:22','C',5.610,0.000,0.000,0),(334,359,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.790,NULL,NULL,NULL,8.790,NULL,NULL,NULL,NULL,8.790,8.790,0.000,0.000,NULL,NULL,1,0,8.790,0,'2015-10-01 08:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:23','C',8.790,0.000,0.000,0),(335,360,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.830,NULL,NULL,NULL,8.830,NULL,NULL,NULL,NULL,8.830,8.830,0.000,0.000,NULL,NULL,1,0,8.830,0,'2015-10-01 08:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:23','C',8.830,0.000,0.000,0),(336,361,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.420,NULL,NULL,NULL,9.420,NULL,NULL,NULL,NULL,9.420,9.420,0.000,0.000,NULL,NULL,1,0,9.420,0,'2015-10-01 08:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:23','C',9.420,0.000,0.000,0),(337,362,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.160,NULL,NULL,NULL,8.160,NULL,NULL,NULL,NULL,8.160,8.160,0.000,0.000,NULL,NULL,1,0,8.160,0,'2015-10-01 08:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:24','C',8.160,0.000,0.000,0),(338,363,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.630,NULL,NULL,NULL,8.630,NULL,NULL,NULL,NULL,8.630,8.630,0.000,0.000,NULL,NULL,1,0,8.630,0,'2015-10-01 08:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:24','C',8.630,0.000,0.000,0),(339,364,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.500,NULL,NULL,NULL,8.500,NULL,NULL,NULL,NULL,8.500,8.500,0.000,0.000,NULL,NULL,1,0,8.500,0,'2015-10-01 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:25','C',8.500,0.000,0.000,0),(340,365,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.330,NULL,NULL,NULL,5.330,NULL,NULL,NULL,NULL,5.330,5.330,0.000,0.000,NULL,NULL,1,0,5.330,0,'2015-10-01 08:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:25','C',5.330,0.000,0.000,0),(341,366,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-01 08:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:25','C',4.130,0.000,0.000,0),(342,367,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,1,0,4.800,0,'2015-10-01 08:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:26','C',4.800,0.000,0.000,0),(343,368,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.410,NULL,NULL,NULL,3.410,NULL,NULL,NULL,NULL,3.410,3.410,0.000,0.000,NULL,NULL,1,0,3.410,0,'2015-10-01 08:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:26','C',3.410,0.000,0.000,0),(344,369,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.220,NULL,NULL,NULL,4.220,NULL,NULL,NULL,NULL,4.220,4.220,0.000,0.000,NULL,NULL,1,0,4.220,0,'2015-10-01 08:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:27','C',4.220,0.000,0.000,0),(345,370,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,1,0,3.740,0,'2015-10-01 08:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:27','C',3.740,0.000,0.000,0),(346,371,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.460,NULL,NULL,NULL,4.460,NULL,NULL,NULL,NULL,4.460,4.460,0.000,0.000,NULL,NULL,1,0,4.460,0,'2015-10-01 08:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:27','C',4.460,0.000,0.000,0),(347,372,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.070,NULL,NULL,NULL,5.070,NULL,NULL,NULL,NULL,5.070,5.070,0.000,0.000,NULL,NULL,1,0,5.070,0,'2015-10-01 08:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:28','C',5.070,0.000,0.000,0),(348,373,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.480,NULL,NULL,NULL,5.480,NULL,NULL,NULL,NULL,5.480,5.480,0.000,0.000,NULL,NULL,1,0,5.480,0,'2015-10-01 08:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:28','C',5.480,0.000,0.000,0),(349,374,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-01 08:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:28','C',4.290,0.000,0.000,0),(350,375,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.230,NULL,NULL,NULL,4.230,NULL,NULL,NULL,NULL,4.230,4.230,0.000,0.000,NULL,NULL,1,0,4.230,0,'2015-10-01 08:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:29','C',4.230,0.000,0.000,0),(351,376,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.790,NULL,NULL,NULL,5.790,NULL,NULL,NULL,NULL,5.790,5.790,0.000,0.000,NULL,NULL,1,0,5.790,0,'2015-10-01 08:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:29','C',5.790,0.000,0.000,0),(352,377,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.180,NULL,NULL,NULL,5.180,NULL,NULL,NULL,NULL,5.180,5.180,0.000,0.000,NULL,NULL,1,0,5.180,0,'2015-10-01 08:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:29','C',5.180,0.000,0.000,0),(353,378,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.820,NULL,NULL,NULL,5.820,NULL,NULL,NULL,NULL,5.820,5.820,0.000,0.000,NULL,NULL,1,0,5.820,0,'2015-10-01 08:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:30','C',5.820,0.000,0.000,0),(354,379,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.910,NULL,NULL,NULL,6.910,NULL,NULL,NULL,NULL,6.910,6.910,0.000,0.000,NULL,NULL,1,0,6.910,0,'2015-10-01 08:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:30','C',6.910,0.000,0.000,0),(355,380,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.470,NULL,NULL,NULL,7.470,NULL,NULL,NULL,NULL,7.470,7.470,0.000,0.000,NULL,NULL,1,0,7.470,0,'2015-10-01 08:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:30','C',7.470,0.000,0.000,0),(356,381,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.950,NULL,NULL,NULL,6.950,NULL,NULL,NULL,NULL,6.950,6.950,0.000,0.000,NULL,NULL,1,0,6.950,0,'2015-10-01 08:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:31','C',6.950,0.000,0.000,0),(357,382,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.190,NULL,NULL,NULL,7.190,NULL,NULL,NULL,NULL,7.190,7.190,0.000,0.000,NULL,NULL,1,0,7.190,0,'2015-10-01 08:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:31','C',7.190,0.000,0.000,0),(358,383,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.070,NULL,NULL,NULL,7.070,NULL,NULL,NULL,NULL,7.070,7.070,0.000,0.000,NULL,NULL,1,0,7.070,0,'2015-10-01 08:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:31','C',7.070,0.000,0.000,0),(359,384,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.540,NULL,NULL,NULL,6.540,NULL,NULL,NULL,NULL,6.540,6.540,0.000,0.000,NULL,NULL,1,0,6.540,0,'2015-10-01 08:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:32','C',6.540,0.000,0.000,0),(360,385,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.720,NULL,NULL,NULL,7.720,NULL,NULL,NULL,NULL,7.720,7.720,0.000,0.000,NULL,NULL,1,0,7.720,0,'2015-10-01 08:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:32','C',7.720,0.000,0.000,0),(361,386,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.910,NULL,NULL,NULL,6.910,NULL,NULL,NULL,NULL,6.910,6.910,0.000,0.000,NULL,NULL,1,0,6.910,0,'2015-10-01 08:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:32','C',6.910,0.000,0.000,0),(362,387,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.260,NULL,NULL,NULL,6.260,NULL,NULL,NULL,NULL,6.260,6.260,0.000,0.000,NULL,NULL,1,0,6.260,0,'2015-10-01 08:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:33','C',6.260,0.000,0.000,0),(363,388,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.280,NULL,NULL,NULL,8.280,NULL,NULL,NULL,NULL,8.280,8.280,0.000,0.000,NULL,NULL,1,0,8.280,0,'2015-10-01 08:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:33','C',8.280,0.000,0.000,0),(364,389,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.400,NULL,NULL,NULL,8.400,NULL,NULL,NULL,NULL,8.400,8.400,0.000,0.000,NULL,NULL,1,0,8.400,0,'2015-10-01 08:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:34','C',8.400,0.000,0.000,0),(365,390,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.280,NULL,NULL,NULL,8.280,NULL,NULL,NULL,NULL,8.280,8.280,0.000,0.000,NULL,NULL,1,0,8.280,0,'2015-10-01 08:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:34','C',8.280,0.000,0.000,0),(366,391,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.760,NULL,NULL,NULL,7.760,NULL,NULL,NULL,NULL,7.760,7.760,0.000,0.000,NULL,NULL,1,0,7.760,0,'2015-10-01 08:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:34','C',7.760,0.000,0.000,0),(367,392,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.900,NULL,NULL,NULL,5.900,NULL,NULL,NULL,NULL,5.900,5.900,0.000,0.000,NULL,NULL,1,0,5.900,0,'2015-10-01 08:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:35','C',5.900,0.000,0.000,0),(368,393,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.790,NULL,NULL,NULL,10.790,NULL,NULL,NULL,NULL,10.790,10.790,0.000,0.000,NULL,NULL,1,0,10.790,0,'2015-10-01 08:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:35','C',10.790,0.000,0.000,0),(369,394,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.620,NULL,NULL,NULL,11.620,NULL,NULL,NULL,NULL,11.620,11.620,0.000,0.000,NULL,NULL,1,0,11.620,0,'2015-10-01 08:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:36','C',11.620,0.000,0.000,0),(370,395,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.980,NULL,NULL,NULL,4.980,NULL,NULL,NULL,NULL,4.980,4.980,0.000,0.000,NULL,NULL,1,0,4.980,0,'2015-10-01 08:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:36','C',4.980,0.000,0.000,0),(371,396,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.070,NULL,NULL,NULL,10.070,NULL,NULL,NULL,NULL,10.070,10.070,0.000,0.000,NULL,NULL,1,0,10.070,0,'2015-10-01 08:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:36','C',10.070,0.000,0.000,0),(372,397,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.130,NULL,NULL,NULL,11.130,NULL,NULL,NULL,NULL,11.130,11.130,0.000,0.000,NULL,NULL,1,0,11.130,0,'2015-10-01 08:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:43','C',11.130,0.000,0.000,0),(373,398,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.000,NULL,NULL,NULL,8.000,NULL,NULL,NULL,NULL,8.000,8.000,0.000,0.000,NULL,NULL,1,0,8.000,0,'2015-10-01 08:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:43','C',8.000,0.000,0.000,0),(374,399,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.960,NULL,NULL,NULL,8.960,NULL,NULL,NULL,NULL,8.960,8.960,0.000,0.000,NULL,NULL,1,0,8.960,0,'2015-10-01 08:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:43','C',8.960,0.000,0.000,0),(375,400,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.770,NULL,NULL,NULL,11.770,NULL,NULL,NULL,NULL,11.770,11.770,0.000,0.000,NULL,NULL,1,0,11.770,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:44','C',11.770,0.000,0.000,0),(376,401,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.340,NULL,NULL,NULL,10.340,NULL,NULL,NULL,NULL,10.340,10.340,0.000,0.000,NULL,NULL,1,0,10.340,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:44','C',10.340,0.000,0.000,0),(377,402,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.070,NULL,NULL,NULL,10.070,NULL,NULL,NULL,NULL,10.070,10.070,0.000,0.000,NULL,NULL,1,0,10.070,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:44','C',10.070,0.000,0.000,0),(378,403,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.180,NULL,NULL,NULL,11.180,NULL,NULL,NULL,NULL,11.180,11.180,0.000,0.000,NULL,NULL,1,0,11.180,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:45','C',11.180,0.000,0.000,0),(379,404,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.430,NULL,NULL,NULL,9.430,NULL,NULL,NULL,NULL,9.430,9.430,0.000,0.000,NULL,NULL,1,0,9.430,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:45','C',9.430,0.000,0.000,0),(380,405,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.840,NULL,NULL,NULL,7.840,NULL,NULL,NULL,NULL,7.840,7.840,0.000,0.000,NULL,NULL,1,0,7.840,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:46','C',7.840,0.000,0.000,0),(381,406,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.590,NULL,NULL,NULL,8.590,NULL,NULL,NULL,NULL,8.590,8.590,0.000,0.000,NULL,NULL,1,0,8.590,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:46','C',8.590,0.000,0.000,0),(382,407,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.320,NULL,NULL,NULL,8.320,NULL,NULL,NULL,NULL,8.320,8.320,0.000,0.000,NULL,NULL,1,0,8.320,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:46','C',8.320,0.000,0.000,0),(383,408,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.430,NULL,NULL,NULL,8.430,NULL,NULL,NULL,NULL,8.430,8.430,0.000,0.000,NULL,NULL,1,0,8.430,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:47','C',8.430,0.000,0.000,0),(384,409,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.900,NULL,NULL,NULL,8.900,NULL,NULL,NULL,NULL,8.900,8.900,0.000,0.000,NULL,NULL,1,0,8.900,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:47','C',8.900,0.000,0.000,0),(385,410,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.530,NULL,NULL,NULL,8.530,NULL,NULL,NULL,NULL,8.530,8.530,0.000,0.000,NULL,NULL,1,0,8.530,0,'2015-10-01 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:47','C',8.530,0.000,0.000,0),(386,411,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.650,NULL,NULL,NULL,9.650,NULL,NULL,NULL,NULL,9.650,9.650,0.000,0.000,NULL,NULL,1,0,9.650,0,'2015-10-01 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:48','C',9.650,0.000,0.000,0),(387,412,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.590,NULL,NULL,NULL,8.590,NULL,NULL,NULL,NULL,8.590,8.590,0.000,0.000,NULL,NULL,1,0,8.590,0,'2015-10-01 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:48','C',8.590,0.000,0.000,0),(388,413,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.690,NULL,NULL,NULL,8.690,NULL,NULL,NULL,NULL,8.690,8.690,0.000,0.000,NULL,NULL,1,0,8.690,0,'2015-10-01 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:49','C',8.690,0.000,0.000,0),(389,414,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.120,NULL,NULL,NULL,9.120,NULL,NULL,NULL,NULL,9.120,9.120,0.000,0.000,NULL,NULL,1,0,9.120,0,'2015-10-01 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:49','C',9.120,0.000,0.000,0),(390,415,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.370,NULL,NULL,NULL,8.370,NULL,NULL,NULL,NULL,8.370,8.370,0.000,0.000,NULL,NULL,1,0,8.370,0,'2015-10-01 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:49','C',8.370,0.000,0.000,0),(391,416,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.370,NULL,NULL,NULL,7.370,NULL,NULL,NULL,NULL,7.370,7.370,0.000,0.000,NULL,NULL,1,0,7.370,0,'2015-10-01 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:50','C',7.370,0.000,0.000,0),(392,417,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.320,NULL,NULL,NULL,8.320,NULL,NULL,NULL,NULL,8.320,8.320,0.000,0.000,NULL,NULL,1,0,8.320,0,'2015-10-01 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:50','C',8.320,0.000,0.000,0),(393,418,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.180,NULL,NULL,NULL,10.180,NULL,NULL,NULL,NULL,10.180,10.180,0.000,0.000,NULL,NULL,1,0,10.180,0,'2015-10-01 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:50','C',10.180,0.000,0.000,0),(394,419,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.710,NULL,NULL,NULL,10.710,NULL,NULL,NULL,NULL,10.710,10.710,0.000,0.000,NULL,NULL,1,0,10.710,0,'2015-10-01 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:51','C',10.710,0.000,0.000,0),(395,420,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.170,NULL,NULL,NULL,9.170,NULL,NULL,NULL,NULL,9.170,9.170,0.000,0.000,NULL,NULL,1,0,9.170,0,'2015-10-01 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:51','C',9.170,0.000,0.000,0),(396,421,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.690,NULL,NULL,NULL,8.690,NULL,NULL,NULL,NULL,8.690,8.690,0.000,0.000,NULL,NULL,1,0,8.690,0,'2015-10-01 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:51','C',8.690,0.000,0.000,0),(397,422,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.320,NULL,NULL,NULL,8.320,NULL,NULL,NULL,NULL,8.320,8.320,0.000,0.000,NULL,NULL,1,0,8.320,0,'2015-10-01 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:52','C',8.320,0.000,0.000,0),(398,423,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.900,NULL,NULL,NULL,7.900,NULL,NULL,NULL,NULL,7.900,7.900,0.000,0.000,NULL,NULL,1,0,7.900,0,'2015-10-01 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:52','C',7.900,0.000,0.000,0),(399,424,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.920,NULL,NULL,NULL,7.920,NULL,NULL,NULL,NULL,7.920,7.920,0.000,0.000,NULL,NULL,1,0,7.920,0,'2015-10-01 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:53','C',7.920,0.000,0.000,0),(400,425,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.350,NULL,NULL,NULL,8.350,NULL,NULL,NULL,NULL,8.350,8.350,0.000,0.000,NULL,NULL,1,0,8.350,0,'2015-10-01 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:53','C',8.350,0.000,0.000,0),(401,426,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.350,NULL,NULL,NULL,8.350,NULL,NULL,NULL,NULL,8.350,8.350,0.000,0.000,NULL,NULL,1,0,8.350,0,'2015-10-01 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:53','C',8.350,0.000,0.000,0),(402,427,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.700,NULL,NULL,NULL,7.700,NULL,NULL,NULL,NULL,7.700,7.700,0.000,0.000,NULL,NULL,1,0,7.700,0,'2015-10-01 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:54','C',7.700,0.000,0.000,0),(403,428,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.450,NULL,NULL,NULL,8.450,NULL,NULL,NULL,NULL,8.450,8.450,0.000,0.000,NULL,NULL,1,0,8.450,0,'2015-10-01 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:54','C',8.450,0.000,0.000,0),(404,429,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,24.240,NULL,NULL,NULL,24.240,NULL,NULL,NULL,NULL,24.240,24.240,0.000,0.000,NULL,NULL,1,0,24.240,0,'2015-10-01 09:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:54','C',24.240,0.000,0.000,0),(405,430,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.960,NULL,NULL,NULL,15.960,NULL,NULL,NULL,NULL,15.960,15.960,0.000,0.000,NULL,NULL,1,0,15.960,0,'2015-10-01 09:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:55','C',15.960,0.000,0.000,0),(406,431,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.140,NULL,NULL,NULL,5.140,NULL,NULL,NULL,NULL,5.140,5.140,0.000,0.000,NULL,NULL,1,0,5.140,0,'2015-10-01 09:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:55','C',5.140,0.000,0.000,0),(407,432,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.580,NULL,NULL,NULL,6.580,NULL,NULL,NULL,NULL,6.580,6.580,0.000,0.000,NULL,NULL,1,0,6.580,0,'2015-10-01 09:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:55','C',6.580,0.000,0.000,0),(408,433,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.730,NULL,NULL,NULL,7.730,NULL,NULL,NULL,NULL,7.730,7.730,0.000,0.000,NULL,NULL,1,0,7.730,0,'2015-10-01 09:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:56','C',7.730,0.000,0.000,0),(409,434,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,1,0,4.750,0,'2015-10-01 09:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:56','C',4.750,0.000,0.000,0),(410,435,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.390,NULL,NULL,NULL,7.390,NULL,NULL,NULL,NULL,7.390,7.390,0.000,0.000,NULL,NULL,1,0,7.390,0,'2015-10-01 09:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:56','C',7.390,0.000,0.000,0),(411,436,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.060,NULL,NULL,NULL,8.060,NULL,NULL,NULL,NULL,8.060,8.060,0.000,0.000,NULL,NULL,1,0,8.060,0,'2015-10-01 09:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:57','C',8.060,0.000,0.000,0),(412,437,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.790,NULL,NULL,NULL,3.790,NULL,NULL,NULL,NULL,3.790,3.790,0.000,0.000,NULL,NULL,1,0,3.790,0,'2015-10-01 09:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:57','C',3.790,0.000,0.000,0),(413,438,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.330,NULL,NULL,NULL,5.330,NULL,NULL,NULL,NULL,5.330,5.330,0.000,0.000,NULL,NULL,1,0,5.330,0,'2015-10-01 09:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:57','C',5.330,0.000,0.000,0),(414,439,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.820,NULL,NULL,NULL,7.820,NULL,NULL,NULL,NULL,7.820,7.820,0.000,0.000,NULL,NULL,1,0,7.820,0,'2015-10-01 09:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:58','C',7.820,0.000,0.000,0),(415,440,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.530,NULL,NULL,NULL,6.530,NULL,NULL,NULL,NULL,6.530,6.530,0.000,0.000,NULL,NULL,1,0,6.530,0,'2015-10-01 09:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:58','C',6.530,0.000,0.000,0),(416,441,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.530,NULL,NULL,NULL,6.530,NULL,NULL,NULL,NULL,6.530,6.530,0.000,0.000,NULL,NULL,1,0,6.530,0,'2015-10-01 09:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:59','C',6.530,0.000,0.000,0),(417,442,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.370,NULL,NULL,NULL,3.370,NULL,NULL,NULL,NULL,3.370,3.370,0.000,0.000,NULL,NULL,1,0,3.370,0,'2015-10-01 09:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:02:59','C',3.370,0.000,0.000,0),(418,443,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.960,NULL,NULL,NULL,3.960,NULL,NULL,NULL,NULL,3.960,3.960,0.000,0.000,NULL,NULL,1,0,3.960,0,'2015-10-01 09:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:00','C',3.960,0.000,0.000,0),(419,444,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.450,NULL,NULL,NULL,17.450,NULL,NULL,NULL,NULL,17.450,17.450,0.000,0.000,NULL,NULL,1,0,17.450,0,'2015-10-01 09:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:00','C',17.450,0.000,0.000,0),(420,445,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.270,NULL,NULL,NULL,18.270,NULL,NULL,NULL,NULL,18.270,18.270,0.000,0.000,NULL,NULL,1,0,18.270,0,'2015-10-01 09:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:00','C',18.270,0.000,0.000,0),(421,446,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,19.570,NULL,NULL,NULL,19.570,NULL,NULL,NULL,NULL,19.570,19.570,0.000,0.000,NULL,NULL,1,0,19.570,0,'2015-10-01 09:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:01','C',19.570,0.000,0.000,0),(422,447,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,16.630,NULL,NULL,NULL,16.630,NULL,NULL,NULL,NULL,16.630,16.630,0.000,0.000,NULL,NULL,1,0,16.630,0,'2015-10-01 09:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:01','C',16.630,0.000,0.000,0),(423,448,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.420,NULL,NULL,NULL,15.420,NULL,NULL,NULL,NULL,15.420,15.420,0.000,0.000,NULL,NULL,1,0,15.420,0,'2015-10-01 09:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:01','C',15.420,0.000,0.000,0),(424,449,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,16.070,NULL,NULL,NULL,16.070,NULL,NULL,NULL,NULL,16.070,16.070,0.000,0.000,NULL,NULL,1,0,16.070,0,'2015-10-01 09:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:02','C',16.070,0.000,0.000,0),(425,450,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.060,NULL,NULL,NULL,4.060,NULL,NULL,NULL,NULL,4.060,4.060,0.000,0.000,NULL,NULL,1,0,4.060,0,'2015-10-01 09:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:02','C',4.060,0.000,0.000,0),(426,451,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,1,0,3.890,0,'2015-10-01 09:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:02','C',3.890,0.000,0.000,0),(427,452,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.490,NULL,NULL,NULL,4.490,NULL,NULL,NULL,NULL,4.490,4.490,0.000,0.000,NULL,NULL,1,0,4.490,0,'2015-10-01 09:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:03','C',4.490,0.000,0.000,0),(428,453,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.530,NULL,NULL,NULL,5.530,NULL,NULL,NULL,NULL,5.530,5.530,0.000,0.000,NULL,NULL,1,0,5.530,0,'2015-10-01 09:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:03','C',5.530,0.000,0.000,0),(429,454,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 09:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:04','C',4.100,0.000,0.000,0),(430,455,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,1,0,4.750,0,'2015-10-01 09:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:04','C',4.750,0.000,0.000,0),(431,456,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.460,NULL,NULL,NULL,3.460,NULL,NULL,NULL,NULL,3.460,3.460,0.000,0.000,NULL,NULL,1,0,3.460,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:04','C',3.460,0.000,0.000,0),(432,457,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.410,NULL,NULL,NULL,4.410,NULL,NULL,NULL,NULL,4.410,4.410,0.000,0.000,NULL,NULL,1,0,4.410,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:05','C',4.410,0.000,0.000,0),(433,458,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.610,NULL,NULL,NULL,6.610,NULL,NULL,NULL,NULL,6.610,6.610,0.000,0.000,NULL,NULL,1,0,6.610,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:05','C',6.610,0.000,0.000,0),(434,459,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.050,NULL,NULL,NULL,5.050,NULL,NULL,NULL,NULL,5.050,5.050,0.000,0.000,NULL,NULL,1,0,5.050,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:05','C',5.050,0.000,0.000,0),(435,460,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.050,NULL,NULL,NULL,6.050,NULL,NULL,NULL,NULL,6.050,6.050,0.000,0.000,NULL,NULL,1,0,6.050,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:06','C',6.050,0.000,0.000,0),(436,461,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.960,NULL,NULL,NULL,5.960,NULL,NULL,NULL,NULL,5.960,5.960,0.000,0.000,NULL,NULL,1,0,5.960,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:06','C',5.960,0.000,0.000,0),(437,462,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.490,NULL,NULL,NULL,4.490,NULL,NULL,NULL,NULL,4.490,4.490,0.000,0.000,NULL,NULL,1,0,4.490,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:06','C',4.490,0.000,0.000,0),(438,463,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:07','C',3.970,0.000,0.000,0),(439,464,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.450,NULL,NULL,NULL,4.450,NULL,NULL,NULL,NULL,4.450,4.450,0.000,0.000,NULL,NULL,1,0,4.450,0,'2015-10-01 09:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:08','C',4.450,0.000,0.000,0),(440,465,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.450,NULL,NULL,NULL,4.450,NULL,NULL,NULL,NULL,4.450,4.450,0.000,0.000,NULL,NULL,1,0,4.450,0,'2015-10-01 09:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:08','C',4.450,0.000,0.000,0),(441,466,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-01 09:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:08','C',3.970,0.000,0.000,0),(442,467,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.790,NULL,NULL,NULL,5.790,NULL,NULL,NULL,NULL,5.790,5.790,0.000,0.000,NULL,NULL,1,0,5.790,0,'2015-10-01 09:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:09','C',5.790,0.000,0.000,0),(443,468,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-01 09:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:09','C',3.970,0.000,0.000,0),(444,469,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.450,NULL,NULL,NULL,4.450,NULL,NULL,NULL,NULL,4.450,4.450,0.000,0.000,NULL,NULL,1,0,4.450,0,'2015-10-01 09:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:09','C',4.450,0.000,0.000,0),(445,470,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-01 09:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:10','C',3.970,0.000,0.000,0),(446,471,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.610,NULL,NULL,NULL,6.610,NULL,NULL,NULL,NULL,6.610,6.610,0.000,0.000,NULL,NULL,1,0,6.610,0,'2015-10-01 09:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:10','C',6.610,0.000,0.000,0),(447,472,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.670,NULL,NULL,NULL,4.670,NULL,NULL,NULL,NULL,4.670,4.670,0.000,0.000,NULL,NULL,1,0,4.670,0,'2015-10-01 09:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:10','C',4.670,0.000,0.000,0),(448,473,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.790,NULL,NULL,NULL,5.790,NULL,NULL,NULL,NULL,5.790,5.790,0.000,0.000,NULL,NULL,1,0,5.790,0,'2015-10-01 09:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:10','C',5.790,0.000,0.000,0),(449,474,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.920,NULL,NULL,NULL,4.920,NULL,NULL,NULL,NULL,4.920,4.920,0.000,0.000,NULL,NULL,1,0,4.920,0,'2015-10-01 09:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:11','C',4.920,0.000,0.000,0),(450,475,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 09:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:11','C',4.100,0.000,0.000,0),(451,476,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.010,NULL,NULL,NULL,5.010,NULL,NULL,NULL,NULL,5.010,5.010,0.000,0.000,NULL,NULL,1,0,5.010,0,'2015-10-01 09:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:11','C',5.010,0.000,0.000,0),(452,477,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.760,NULL,NULL,NULL,3.760,NULL,NULL,NULL,NULL,3.760,3.760,0.000,0.000,NULL,NULL,1,0,3.760,0,'2015-10-01 09:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:12','C',3.760,0.000,0.000,0),(453,478,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.310,NULL,NULL,NULL,6.310,NULL,NULL,NULL,NULL,6.310,6.310,0.000,0.000,NULL,NULL,1,0,6.310,0,'2015-10-01 09:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:12','C',6.310,0.000,0.000,0),(454,479,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.440,NULL,NULL,NULL,6.440,NULL,NULL,NULL,NULL,6.440,6.440,0.000,0.000,NULL,NULL,1,0,6.440,0,'2015-10-01 09:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:12','C',6.440,0.000,0.000,0),(455,480,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.520,NULL,NULL,NULL,6.520,NULL,NULL,NULL,NULL,6.520,6.520,0.000,0.000,NULL,NULL,1,0,6.520,0,'2015-10-01 09:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:13','C',6.520,0.000,0.000,0),(456,481,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.840,NULL,NULL,NULL,4.840,NULL,NULL,NULL,NULL,4.840,4.840,0.000,0.000,NULL,NULL,1,0,4.840,0,'2015-10-01 09:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:13','C',4.840,0.000,0.000,0),(457,482,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-01 09:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:13','C',3.970,0.000,0.000,0),(458,483,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.670,NULL,NULL,NULL,4.670,NULL,NULL,NULL,NULL,4.670,4.670,0.000,0.000,NULL,NULL,1,0,4.670,0,'2015-10-01 09:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:14','C',4.670,0.000,0.000,0),(459,484,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,1,0,4.800,0,'2015-10-01 09:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:14','C',4.800,0.000,0.000,0),(460,485,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.240,NULL,NULL,NULL,3.240,NULL,NULL,NULL,NULL,3.240,3.240,0.000,0.000,NULL,NULL,1,0,3.240,0,'2015-10-01 09:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:14','C',3.240,0.000,0.000,0),(461,486,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.150,NULL,NULL,NULL,4.150,NULL,NULL,NULL,NULL,4.150,4.150,0.000,0.000,NULL,NULL,1,0,4.150,0,'2015-10-01 09:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:14','C',4.150,0.000,0.000,0),(462,487,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.880,NULL,NULL,NULL,4.880,NULL,NULL,NULL,NULL,4.880,4.880,0.000,0.000,NULL,NULL,1,0,4.880,0,'2015-10-01 09:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:15','C',4.880,0.000,0.000,0),(463,488,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.640,NULL,NULL,NULL,2.640,NULL,NULL,NULL,NULL,2.640,2.640,0.000,0.000,NULL,NULL,1,0,2.640,0,'2015-10-01 09:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:15','C',2.640,0.000,0.000,0),(464,489,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.440,NULL,NULL,NULL,6.440,NULL,NULL,NULL,NULL,6.440,6.440,0.000,0.000,NULL,NULL,1,0,6.440,0,'2015-10-01 09:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:15','C',6.440,0.000,0.000,0),(465,490,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.050,NULL,NULL,NULL,6.050,NULL,NULL,NULL,NULL,6.050,6.050,0.000,0.000,NULL,NULL,1,0,6.050,0,'2015-10-01 09:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:16','C',6.050,0.000,0.000,0),(466,491,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.920,NULL,NULL,NULL,5.920,NULL,NULL,NULL,NULL,5.920,5.920,0.000,0.000,NULL,NULL,1,0,5.920,0,'2015-10-01 09:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:16','C',5.920,0.000,0.000,0),(467,492,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,1,0,3.330,0,'2015-10-01 09:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:16','C',3.330,0.000,0.000,0),(468,493,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.800,NULL,NULL,NULL,3.800,NULL,NULL,NULL,NULL,3.800,3.800,0.000,0.000,NULL,NULL,1,0,3.800,0,'2015-10-01 09:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:17','C',3.800,0.000,0.000,0),(469,494,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.930,NULL,NULL,NULL,3.930,NULL,NULL,NULL,NULL,3.930,3.930,0.000,0.000,NULL,NULL,1,0,3.930,0,'2015-10-01 09:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:17','C',3.930,0.000,0.000,0),(470,495,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.410,NULL,NULL,NULL,3.410,NULL,NULL,NULL,NULL,3.410,3.410,0.000,0.000,NULL,NULL,1,0,3.410,0,'2015-10-01 09:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:17','C',3.410,0.000,0.000,0),(471,496,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.150,NULL,NULL,NULL,4.150,NULL,NULL,NULL,NULL,4.150,4.150,0.000,0.000,NULL,NULL,1,0,4.150,0,'2015-10-01 09:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:18','C',4.150,0.000,0.000,0),(472,497,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.540,NULL,NULL,NULL,4.540,NULL,NULL,NULL,NULL,4.540,4.540,0.000,0.000,NULL,NULL,1,0,4.540,0,'2015-10-01 09:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:27','C',4.540,0.000,0.000,0),(473,498,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.920,NULL,NULL,NULL,4.920,NULL,NULL,NULL,NULL,4.920,4.920,0.000,0.000,NULL,NULL,1,0,4.920,0,'2015-10-01 09:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:27','C',4.920,0.000,0.000,0),(474,499,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.090,NULL,NULL,NULL,6.090,NULL,NULL,NULL,NULL,6.090,6.090,0.000,0.000,NULL,NULL,1,0,6.090,0,'2015-10-01 09:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:27','C',6.090,0.000,0.000,0),(475,500,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.280,NULL,NULL,NULL,4.280,NULL,NULL,NULL,NULL,4.280,4.280,0.000,0.000,NULL,NULL,1,0,4.280,0,'2015-10-01 09:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:27','C',4.280,0.000,0.000,0),(476,501,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.360,NULL,NULL,NULL,4.360,NULL,NULL,NULL,NULL,4.360,4.360,0.000,0.000,NULL,NULL,1,0,4.360,0,'2015-10-01 09:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:28','C',4.360,0.000,0.000,0),(477,502,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.480,NULL,NULL,NULL,6.480,NULL,NULL,NULL,NULL,6.480,6.480,0.000,0.000,NULL,NULL,1,0,6.480,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:28','C',6.480,0.000,0.000,0),(478,503,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.780,NULL,NULL,NULL,6.780,NULL,NULL,NULL,NULL,6.780,6.780,0.000,0.000,NULL,NULL,1,0,6.780,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:28','C',6.780,0.000,0.000,0),(479,504,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.830,NULL,NULL,NULL,5.830,NULL,NULL,NULL,NULL,5.830,5.830,0.000,0.000,NULL,NULL,1,0,5.830,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:29','C',5.830,0.000,0.000,0),(480,505,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.180,NULL,NULL,NULL,5.180,NULL,NULL,NULL,NULL,5.180,5.180,0.000,0.000,NULL,NULL,1,0,5.180,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:29','C',5.180,0.000,0.000,0),(481,506,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.880,NULL,NULL,NULL,4.880,NULL,NULL,NULL,NULL,4.880,4.880,0.000,0.000,NULL,NULL,1,0,4.880,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:29','C',4.880,0.000,0.000,0),(482,507,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.440,NULL,NULL,NULL,5.440,NULL,NULL,NULL,NULL,5.440,5.440,0.000,0.000,NULL,NULL,1,0,5.440,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:30','C',5.440,0.000,0.000,0),(483,508,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.400,NULL,NULL,NULL,5.400,NULL,NULL,NULL,NULL,5.400,5.400,0.000,0.000,NULL,NULL,1,0,5.400,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:30','C',5.400,0.000,0.000,0),(484,509,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.720,NULL,NULL,NULL,2.720,NULL,NULL,NULL,NULL,2.720,2.720,0.000,0.000,NULL,NULL,1,0,2.720,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:30','C',2.720,0.000,0.000,0),(485,510,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-01 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:31','C',3.970,0.000,0.000,0),(486,511,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.590,NULL,NULL,NULL,9.590,NULL,NULL,NULL,NULL,9.590,9.590,0.000,0.000,NULL,NULL,1,0,9.590,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:31','C',9.590,0.000,0.000,0),(487,512,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.200,NULL,NULL,NULL,3.200,NULL,NULL,NULL,NULL,3.200,3.200,0.000,0.000,NULL,NULL,1,0,3.200,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:31','C',3.200,0.000,0.000,0),(488,513,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.140,NULL,NULL,NULL,5.140,NULL,NULL,NULL,NULL,5.140,5.140,0.000,0.000,NULL,NULL,1,0,5.140,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:32','C',5.140,0.000,0.000,0),(489,514,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.370,NULL,NULL,NULL,3.370,NULL,NULL,NULL,NULL,3.370,3.370,0.000,0.000,NULL,NULL,1,0,3.370,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:32','C',3.370,0.000,0.000,0),(490,515,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:32','C',4.190,0.000,0.000,0),(491,516,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.150,NULL,NULL,NULL,4.150,NULL,NULL,NULL,NULL,4.150,4.150,0.000,0.000,NULL,NULL,1,0,4.150,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:33','C',4.150,0.000,0.000,0),(492,517,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,1,0,4.800,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:33','C',4.800,0.000,0.000,0),(493,518,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.140,NULL,NULL,NULL,5.140,NULL,NULL,NULL,NULL,5.140,5.140,0.000,0.000,NULL,NULL,1,0,5.140,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:33','C',5.140,0.000,0.000,0),(494,519,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.920,NULL,NULL,NULL,4.920,NULL,NULL,NULL,NULL,4.920,4.920,0.000,0.000,NULL,NULL,1,0,4.920,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:34','C',4.920,0.000,0.000,0),(495,520,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.930,NULL,NULL,NULL,3.930,NULL,NULL,NULL,NULL,3.930,3.930,0.000,0.000,NULL,NULL,1,0,3.930,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:34','C',3.930,0.000,0.000,0),(496,521,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.040,NULL,NULL,NULL,8.040,NULL,NULL,NULL,NULL,8.040,8.040,0.000,0.000,NULL,NULL,1,0,8.040,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:34','C',8.040,0.000,0.000,0),(497,522,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.680,NULL,NULL,NULL,2.680,NULL,NULL,NULL,NULL,2.680,2.680,0.000,0.000,NULL,NULL,1,0,2.680,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:35','C',2.680,0.000,0.000,0),(498,523,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:35','C',4.100,0.000,0.000,0),(499,524,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.660,NULL,NULL,NULL,5.660,NULL,NULL,NULL,NULL,5.660,5.660,0.000,0.000,NULL,NULL,1,0,5.660,0,'2015-10-01 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:35','C',5.660,0.000,0.000,0),(500,525,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.860,NULL,NULL,NULL,7.860,NULL,NULL,NULL,NULL,7.860,7.860,0.000,0.000,NULL,NULL,1,0,7.860,0,'2015-10-01 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:36','C',7.860,0.000,0.000,0),(501,526,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.660,NULL,NULL,NULL,5.660,NULL,NULL,NULL,NULL,5.660,5.660,0.000,0.000,NULL,NULL,1,0,5.660,0,'2015-10-01 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:36','C',5.660,0.000,0.000,0),(502,527,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.960,NULL,NULL,NULL,5.960,NULL,NULL,NULL,NULL,5.960,5.960,0.000,0.000,NULL,NULL,1,0,5.960,0,'2015-10-01 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:36','C',5.960,0.000,0.000,0),(503,528,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.230,NULL,NULL,NULL,5.230,NULL,NULL,NULL,NULL,5.230,5.230,0.000,0.000,NULL,NULL,1,0,5.230,0,'2015-10-01 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:37','C',5.230,0.000,0.000,0),(504,529,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.480,NULL,NULL,NULL,6.480,NULL,NULL,NULL,NULL,6.480,6.480,0.000,0.000,NULL,NULL,1,0,6.480,0,'2015-10-01 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:37','C',6.480,0.000,0.000,0),(505,530,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.580,NULL,NULL,NULL,4.580,NULL,NULL,NULL,NULL,4.580,4.580,0.000,0.000,NULL,NULL,1,0,4.580,0,'2015-10-01 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:37','C',4.580,0.000,0.000,0),(506,531,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.520,NULL,NULL,NULL,6.520,NULL,NULL,NULL,NULL,6.520,6.520,0.000,0.000,NULL,NULL,1,0,6.520,0,'2015-10-01 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:38','C',6.520,0.000,0.000,0),(507,532,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.960,NULL,NULL,NULL,5.960,NULL,NULL,NULL,NULL,5.960,5.960,0.000,0.000,NULL,NULL,1,0,5.960,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:38','C',5.960,0.000,0.000,0),(508,533,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.530,NULL,NULL,NULL,5.530,NULL,NULL,NULL,NULL,5.530,5.530,0.000,0.000,NULL,NULL,1,0,5.530,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:38','C',5.530,0.000,0.000,0),(509,534,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.710,NULL,NULL,NULL,4.710,NULL,NULL,NULL,NULL,4.710,4.710,0.000,0.000,NULL,NULL,1,0,4.710,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:39','C',4.710,0.000,0.000,0),(510,535,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.520,NULL,NULL,NULL,6.520,NULL,NULL,NULL,NULL,6.520,6.520,0.000,0.000,NULL,NULL,1,0,6.520,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:39','C',6.520,0.000,0.000,0),(511,536,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.440,NULL,NULL,NULL,6.440,NULL,NULL,NULL,NULL,6.440,6.440,0.000,0.000,NULL,NULL,1,0,6.440,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:39','C',6.440,0.000,0.000,0),(512,537,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.650,NULL,NULL,NULL,6.650,NULL,NULL,NULL,NULL,6.650,6.650,0.000,0.000,NULL,NULL,1,0,6.650,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:40','C',6.650,0.000,0.000,0),(513,538,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,1,0,3.330,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:40','C',3.330,0.000,0.000,0),(514,539,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.430,NULL,NULL,NULL,7.430,NULL,NULL,NULL,NULL,7.430,7.430,0.000,0.000,NULL,NULL,1,0,7.430,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:40','C',7.430,0.000,0.000,0),(515,540,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.500,NULL,NULL,NULL,3.500,NULL,NULL,NULL,NULL,3.500,3.500,0.000,0.000,NULL,NULL,1,0,3.500,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:41','C',3.500,0.000,0.000,0),(516,541,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,1,0,3.330,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:41','C',3.330,0.000,0.000,0),(517,542,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.060,NULL,NULL,NULL,4.060,NULL,NULL,NULL,NULL,4.060,4.060,0.000,0.000,NULL,NULL,1,0,4.060,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:41','C',4.060,0.000,0.000,0),(518,543,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.710,NULL,NULL,NULL,4.710,NULL,NULL,NULL,NULL,4.710,4.710,0.000,0.000,NULL,NULL,1,0,4.710,0,'2015-10-01 09:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:41','C',4.710,0.000,0.000,0),(519,544,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.410,NULL,NULL,NULL,3.410,NULL,NULL,NULL,NULL,3.410,3.410,0.000,0.000,NULL,NULL,1,0,3.410,0,'2015-10-01 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:42','C',3.410,0.000,0.000,0),(520,545,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.930,NULL,NULL,NULL,3.930,NULL,NULL,NULL,NULL,3.930,3.930,0.000,0.000,NULL,NULL,1,0,3.930,0,'2015-10-01 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:42','C',3.930,0.000,0.000,0),(521,546,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.150,NULL,NULL,NULL,4.150,NULL,NULL,NULL,NULL,4.150,4.150,0.000,0.000,NULL,NULL,1,0,4.150,0,'2015-10-01 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:42','C',4.150,0.000,0.000,0),(522,547,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.000,NULL,NULL,NULL,6.000,NULL,NULL,NULL,NULL,6.000,6.000,0.000,0.000,NULL,NULL,1,0,6.000,0,'2015-10-01 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:43','C',6.000,0.000,0.000,0),(523,548,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.230,NULL,NULL,NULL,4.230,NULL,NULL,NULL,NULL,4.230,4.230,0.000,0.000,NULL,NULL,1,0,4.230,0,'2015-10-01 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:43','C',4.230,0.000,0.000,0),(524,549,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.560,NULL,NULL,NULL,4.560,NULL,NULL,NULL,NULL,4.560,4.560,0.000,0.000,NULL,NULL,1,0,4.560,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:44','C',4.560,0.000,0.000,0),(525,550,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,1,0,4.800,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:44','C',4.800,0.000,0.000,0),(526,551,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.220,NULL,NULL,NULL,4.220,NULL,NULL,NULL,NULL,4.220,4.220,0.000,0.000,NULL,NULL,1,0,4.220,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:45','C',4.220,0.000,0.000,0),(527,552,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.610,NULL,NULL,NULL,4.610,NULL,NULL,NULL,NULL,4.610,4.610,0.000,0.000,NULL,NULL,1,0,4.610,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:45','C',4.610,0.000,0.000,0),(528,553,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.850,NULL,NULL,NULL,4.850,NULL,NULL,NULL,NULL,4.850,4.850,0.000,0.000,NULL,NULL,1,0,4.850,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:45','C',4.850,0.000,0.000,0),(529,554,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.380,NULL,NULL,NULL,5.380,NULL,NULL,NULL,NULL,5.380,5.380,0.000,0.000,NULL,NULL,1,0,5.380,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:46','C',5.380,0.000,0.000,0),(530,555,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.040,NULL,NULL,NULL,5.040,NULL,NULL,NULL,NULL,5.040,5.040,0.000,0.000,NULL,NULL,1,0,5.040,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:46','C',5.040,0.000,0.000,0),(531,556,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.900,NULL,NULL,NULL,5.900,NULL,NULL,NULL,NULL,5.900,5.900,0.000,0.000,NULL,NULL,1,0,5.900,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:46','C',5.900,0.000,0.000,0),(532,557,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.180,NULL,NULL,NULL,4.180,NULL,NULL,NULL,NULL,4.180,4.180,0.000,0.000,NULL,NULL,1,0,4.180,0,'2015-10-01 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:46','C',4.180,0.000,0.000,0),(533,558,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.780,NULL,NULL,NULL,2.780,NULL,NULL,NULL,NULL,2.780,2.780,0.000,0.000,NULL,NULL,1,0,2.780,0,'2015-10-01 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:47','C',2.780,0.000,0.000,0),(534,559,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',4,'VERGNES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.430,NULL,NULL,NULL,6.430,NULL,NULL,NULL,NULL,6.430,6.430,0.000,0.000,NULL,NULL,1,0,6.430,0,'2015-10-01 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:47','C',6.430,0.000,0.000,0),(535,560,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.610,NULL,NULL,NULL,4.610,NULL,NULL,NULL,NULL,4.610,4.610,0.000,0.000,NULL,NULL,1,0,4.610,0,'2015-10-01 10:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:47','C',4.610,0.000,0.000,0),(536,561,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.220,NULL,NULL,NULL,4.220,NULL,NULL,NULL,NULL,4.220,4.220,0.000,0.000,NULL,NULL,1,0,4.220,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:48','C',4.220,0.000,0.000,0),(537,562,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.840,NULL,NULL,NULL,3.840,NULL,NULL,NULL,NULL,3.840,3.840,0.000,0.000,NULL,NULL,1,0,3.840,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:48','C',3.840,0.000,0.000,0),(538,563,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.420,NULL,NULL,NULL,4.420,NULL,NULL,NULL,NULL,4.420,4.420,0.000,0.000,NULL,NULL,1,0,4.420,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:48','C',4.420,0.000,0.000,0),(539,564,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.650,NULL,NULL,NULL,3.650,NULL,NULL,NULL,NULL,3.650,3.650,0.000,0.000,NULL,NULL,1,0,3.650,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:49','C',3.650,0.000,0.000,0),(540,565,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.220,NULL,NULL,NULL,3.220,NULL,NULL,NULL,NULL,3.220,3.220,0.000,0.000,NULL,NULL,1,0,3.220,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:49','C',3.220,0.000,0.000,0),(541,566,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.700,NULL,NULL,NULL,3.700,NULL,NULL,NULL,NULL,3.700,3.700,0.000,0.000,NULL,NULL,1,0,3.700,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:49','C',3.700,0.000,0.000,0),(542,567,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.610,NULL,NULL,NULL,4.610,NULL,NULL,NULL,NULL,4.610,4.610,0.000,0.000,NULL,NULL,1,0,4.610,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:50','C',4.610,0.000,0.000,0),(543,568,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.860,NULL,NULL,NULL,5.860,NULL,NULL,NULL,NULL,5.860,5.860,0.000,0.000,NULL,NULL,1,0,5.860,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:50','C',5.860,0.000,0.000,0),(544,569,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,1,0,4.800,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:50','C',4.800,0.000,0.000,0),(545,570,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.380,NULL,NULL,NULL,5.380,NULL,NULL,NULL,NULL,5.380,5.380,0.000,0.000,NULL,NULL,1,0,5.380,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:51','C',5.380,0.000,0.000,0),(546,571,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.090,NULL,NULL,NULL,5.090,NULL,NULL,NULL,NULL,5.090,5.090,0.000,0.000,NULL,NULL,1,0,5.090,0,'2015-10-01 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:51','C',5.090,0.000,0.000,0),(547,572,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.180,NULL,NULL,NULL,4.180,NULL,NULL,NULL,NULL,4.180,4.180,0.000,0.000,NULL,NULL,1,0,4.180,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:52','C',4.180,0.000,0.000,0),(548,573,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.830,NULL,NULL,NULL,2.830,NULL,NULL,NULL,NULL,2.830,2.830,0.000,0.000,NULL,NULL,1,0,2.830,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:52','C',2.830,0.000,0.000,0),(549,574,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.430,NULL,NULL,NULL,6.430,NULL,NULL,NULL,NULL,6.430,6.430,0.000,0.000,NULL,NULL,1,0,6.430,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:52','C',6.430,0.000,0.000,0),(550,575,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.850,NULL,NULL,NULL,4.850,NULL,NULL,NULL,NULL,4.850,4.850,0.000,0.000,NULL,NULL,1,0,4.850,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:53','C',4.850,0.000,0.000,0),(551,576,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.610,NULL,NULL,NULL,4.610,NULL,NULL,NULL,NULL,4.610,4.610,0.000,0.000,NULL,NULL,1,0,4.610,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:53','C',4.610,0.000,0.000,0),(552,577,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.560,NULL,NULL,NULL,4.560,NULL,NULL,NULL,NULL,4.560,4.560,0.000,0.000,NULL,NULL,1,0,4.560,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:54','C',4.560,0.000,0.000,0),(553,578,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.660,NULL,NULL,NULL,4.660,NULL,NULL,NULL,NULL,4.660,4.660,0.000,0.000,NULL,NULL,1,0,4.660,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:54','C',4.660,0.000,0.000,0),(554,579,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.280,NULL,NULL,NULL,5.280,NULL,NULL,NULL,NULL,5.280,5.280,0.000,0.000,NULL,NULL,1,0,5.280,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:54','C',5.280,0.000,0.000,0),(555,580,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.560,NULL,NULL,NULL,4.560,NULL,NULL,NULL,NULL,4.560,4.560,0.000,0.000,NULL,NULL,1,0,4.560,0,'2015-10-01 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:55','C',4.560,0.000,0.000,0),(556,581,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.020,NULL,NULL,NULL,11.020,NULL,NULL,NULL,NULL,11.020,11.020,0.000,0.000,NULL,NULL,1,0,11.020,0,'2015-10-01 10:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:55','C',11.020,0.000,0.000,0),(557,582,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.460,NULL,NULL,NULL,11.460,NULL,NULL,NULL,NULL,11.460,11.460,0.000,0.000,NULL,NULL,1,0,11.460,0,'2015-10-01 10:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:55','C',11.460,0.000,0.000,0),(558,583,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.560,NULL,NULL,NULL,11.560,NULL,NULL,NULL,NULL,11.560,11.560,0.000,0.000,NULL,NULL,1,0,11.560,0,'2015-10-01 10:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:55','C',11.560,0.000,0.000,0),(559,584,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.250,NULL,NULL,NULL,9.250,NULL,NULL,NULL,NULL,9.250,9.250,0.000,0.000,NULL,NULL,1,0,9.250,0,'2015-10-01 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:56','C',9.250,0.000,0.000,0),(560,585,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.690,NULL,NULL,NULL,9.690,NULL,NULL,NULL,NULL,9.690,9.690,0.000,0.000,NULL,NULL,1,0,9.690,0,'2015-10-01 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:56','C',9.690,0.000,0.000,0),(561,586,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.410,NULL,NULL,NULL,8.410,NULL,NULL,NULL,NULL,8.410,8.410,0.000,0.000,NULL,NULL,1,0,8.410,0,'2015-10-01 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:56','C',8.410,0.000,0.000,0),(562,587,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.480,NULL,NULL,NULL,13.480,NULL,NULL,NULL,NULL,13.480,13.480,0.000,0.000,NULL,NULL,1,0,13.480,0,'2015-10-01 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:57','C',13.480,0.000,0.000,0),(563,588,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.090,NULL,NULL,NULL,13.090,NULL,NULL,NULL,NULL,13.090,13.090,0.000,0.000,NULL,NULL,1,0,13.090,0,'2015-10-01 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:57','C',13.090,0.000,0.000,0),(564,589,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.890,NULL,NULL,NULL,12.890,NULL,NULL,NULL,NULL,12.890,12.890,0.000,0.000,NULL,NULL,1,0,12.890,0,'2015-10-01 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:57','C',12.890,0.000,0.000,0),(565,590,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.330,NULL,NULL,NULL,10.330,NULL,NULL,NULL,NULL,10.330,10.330,0.000,0.000,NULL,NULL,1,0,10.330,0,'2015-10-01 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:58','C',10.330,0.000,0.000,0),(566,591,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.410,NULL,NULL,NULL,5.410,NULL,NULL,NULL,NULL,5.410,5.410,0.000,0.000,NULL,NULL,1,0,5.410,0,'2015-10-01 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:58','C',5.410,0.000,0.000,0),(567,592,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.800,NULL,NULL,NULL,2.800,NULL,NULL,NULL,NULL,2.800,2.800,0.000,0.000,NULL,NULL,1,0,2.800,0,'2015-10-01 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:58','C',2.800,0.000,0.000,0),(568,593,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.590,NULL,NULL,NULL,6.590,NULL,NULL,NULL,NULL,6.590,6.590,0.000,0.000,NULL,NULL,1,0,6.590,0,'2015-10-01 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:59','C',6.590,0.000,0.000,0),(569,594,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.300,NULL,NULL,NULL,6.300,NULL,NULL,NULL,NULL,6.300,6.300,0.000,0.000,NULL,NULL,1,0,6.300,0,'2015-10-01 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:59','C',6.300,0.000,0.000,0),(570,595,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.170,NULL,NULL,NULL,8.170,NULL,NULL,NULL,NULL,8.170,8.170,0.000,0.000,NULL,NULL,1,0,8.170,0,'2015-10-01 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:03:59','C',8.170,0.000,0.000,0),(571,596,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.950,NULL,NULL,NULL,8.950,NULL,NULL,NULL,NULL,8.950,8.950,0.000,0.000,NULL,NULL,1,0,8.950,0,'2015-10-01 10:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:00','C',8.950,0.000,0.000,0),(572,597,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.410,NULL,NULL,NULL,5.410,NULL,NULL,NULL,NULL,5.410,5.410,0.000,0.000,NULL,NULL,1,0,5.410,0,'2015-10-01 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:08','C',5.410,0.000,0.000,0),(573,598,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.300,NULL,NULL,NULL,6.300,NULL,NULL,NULL,NULL,6.300,6.300,0.000,0.000,NULL,NULL,1,0,6.300,0,'2015-10-01 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:09','C',6.300,0.000,0.000,0),(574,599,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.120,NULL,NULL,NULL,8.120,NULL,NULL,NULL,NULL,8.120,8.120,0.000,0.000,NULL,NULL,1,0,8.120,0,'2015-10-01 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:09','C',8.120,0.000,0.000,0),(575,600,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.590,NULL,NULL,NULL,6.590,NULL,NULL,NULL,NULL,6.590,6.590,0.000,0.000,NULL,NULL,1,0,6.590,0,'2015-10-01 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:09','C',6.590,0.000,0.000,0),(576,601,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.000,NULL,NULL,NULL,9.000,NULL,NULL,NULL,NULL,9.000,9.000,0.000,0.000,NULL,NULL,1,0,9.000,0,'2015-10-01 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:09','C',9.000,0.000,0.000,0),(577,602,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-01 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:10','C',4.080,0.000,0.000,0),(578,603,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.970,NULL,NULL,NULL,4.970,NULL,NULL,NULL,NULL,4.970,4.970,0.000,0.000,NULL,NULL,1,0,4.970,0,'2015-10-01 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:10','C',4.970,0.000,0.000,0),(579,604,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.920,NULL,NULL,NULL,4.920,NULL,NULL,NULL,NULL,4.920,4.920,0.000,0.000,NULL,NULL,1,0,4.920,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:10','C',4.920,0.000,0.000,0),(580,605,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.640,NULL,NULL,NULL,3.640,NULL,NULL,NULL,NULL,3.640,3.640,0.000,0.000,NULL,NULL,1,0,3.640,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:11','C',3.640,0.000,0.000,0),(581,606,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.640,NULL,NULL,NULL,3.640,NULL,NULL,NULL,NULL,3.640,3.640,0.000,0.000,NULL,NULL,1,0,3.640,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:11','C',3.640,0.000,0.000,0),(582,607,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.510,NULL,NULL,NULL,8.510,NULL,NULL,NULL,NULL,8.510,8.510,0.000,0.000,NULL,NULL,1,0,8.510,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:11','C',8.510,0.000,0.000,0),(583,608,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.510,NULL,NULL,NULL,8.510,NULL,NULL,NULL,NULL,8.510,8.510,0.000,0.000,NULL,NULL,1,0,8.510,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:11','C',8.510,0.000,0.000,0),(584,609,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.020,NULL,NULL,NULL,5.020,NULL,NULL,NULL,NULL,5.020,5.020,0.000,0.000,NULL,NULL,1,0,5.020,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:12','C',5.020,0.000,0.000,0),(585,610,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.480,NULL,NULL,NULL,4.480,NULL,NULL,NULL,NULL,4.480,4.480,0.000,0.000,NULL,NULL,1,0,4.480,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:12','C',4.480,0.000,0.000,0),(586,611,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.720,NULL,NULL,NULL,4.720,NULL,NULL,NULL,NULL,4.720,4.720,0.000,0.000,NULL,NULL,1,0,4.720,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:12','C',4.720,0.000,0.000,0),(587,612,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,1,0,4.770,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:12','C',4.770,0.000,0.000,0),(588,613,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.350,NULL,NULL,NULL,6.350,NULL,NULL,NULL,NULL,6.350,6.350,0.000,0.000,NULL,NULL,1,0,6.350,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:13','C',6.350,0.000,0.000,0),(589,614,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.790,NULL,NULL,NULL,6.790,NULL,NULL,NULL,NULL,6.790,6.790,0.000,0.000,NULL,NULL,1,0,6.790,0,'2015-10-01 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:13','C',6.790,0.000,0.000,0),(590,615,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.330,NULL,NULL,NULL,17.330,NULL,NULL,NULL,NULL,17.330,17.330,0.000,0.000,NULL,NULL,1,0,17.330,0,'2015-10-01 10:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:13','C',17.330,0.000,0.000,0),(591,616,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.330,NULL,NULL,NULL,17.330,NULL,NULL,NULL,NULL,17.330,17.330,0.000,0.000,NULL,NULL,1,0,17.330,0,'2015-10-01 10:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:14','C',17.330,0.000,0.000,0),(592,617,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.330,NULL,NULL,NULL,17.330,NULL,NULL,NULL,NULL,17.330,17.330,0.000,0.000,NULL,NULL,1,0,17.330,0,'2015-10-01 10:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:14','C',17.330,0.000,0.000,0),(593,618,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.610,NULL,NULL,NULL,8.610,NULL,NULL,NULL,NULL,8.610,8.610,0.000,0.000,NULL,NULL,1,0,8.610,0,'2015-10-01 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:14','C',8.610,0.000,0.000,0),(594,619,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.460,NULL,NULL,NULL,8.460,NULL,NULL,NULL,NULL,8.460,8.460,0.000,0.000,NULL,NULL,1,0,8.460,0,'2015-10-01 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:14','C',8.460,0.000,0.000,0),(595,620,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.610,NULL,NULL,NULL,8.610,NULL,NULL,NULL,NULL,8.610,8.610,0.000,0.000,NULL,NULL,1,0,8.610,0,'2015-10-01 10:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:15','C',8.610,0.000,0.000,0),(596,621,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.610,NULL,NULL,NULL,8.610,NULL,NULL,NULL,NULL,8.610,8.610,0.000,0.000,NULL,NULL,1,0,8.610,0,'2015-10-01 10:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:15','C',8.610,0.000,0.000,0),(597,622,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.610,NULL,NULL,NULL,8.610,NULL,NULL,NULL,NULL,8.610,8.610,0.000,0.000,NULL,NULL,1,0,8.610,0,'2015-10-01 10:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:15','C',8.610,0.000,0.000,0),(598,623,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.500,NULL,NULL,NULL,9.500,NULL,NULL,NULL,NULL,9.500,9.500,0.000,0.000,NULL,NULL,1,0,9.500,0,'2015-10-01 10:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:15','C',9.500,0.000,0.000,0),(599,624,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.500,NULL,NULL,NULL,9.500,NULL,NULL,NULL,NULL,9.500,9.500,0.000,0.000,NULL,NULL,1,0,9.500,0,'2015-10-01 10:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:16','C',9.500,0.000,0.000,0),(600,625,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.590,NULL,NULL,NULL,6.590,NULL,NULL,NULL,NULL,6.590,6.590,0.000,0.000,NULL,NULL,1,0,6.590,0,'2015-10-01 10:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:16','C',6.590,0.000,0.000,0),(601,626,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.590,NULL,NULL,NULL,6.590,NULL,NULL,NULL,NULL,6.590,6.590,0.000,0.000,NULL,NULL,1,0,6.590,0,'2015-10-01 10:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:16','C',6.590,0.000,0.000,0),(602,627,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.590,NULL,NULL,NULL,6.590,NULL,NULL,NULL,NULL,6.590,6.590,0.000,0.000,NULL,NULL,1,0,6.590,0,'2015-10-01 10:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:17','C',6.590,0.000,0.000,0),(603,628,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.560,NULL,NULL,NULL,13.560,NULL,NULL,NULL,NULL,13.560,13.560,0.000,0.000,NULL,NULL,1,0,13.560,0,'2015-10-01 10:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:17','C',13.560,0.000,0.000,0),(604,629,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.420,NULL,NULL,NULL,3.420,NULL,NULL,NULL,NULL,3.420,3.420,0.000,0.000,NULL,NULL,1,0,3.420,0,'2015-10-01 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:17','C',3.420,0.000,0.000,0),(605,630,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.000,NULL,NULL,NULL,12.000,NULL,NULL,NULL,NULL,12.000,12.000,0.000,0.000,NULL,NULL,1,0,12.000,0,'2015-10-01 11:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:17','C',12.000,0.000,0.000,0),(606,631,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.030,NULL,NULL,NULL,0.030,NULL,NULL,NULL,NULL,0.030,0.030,0.000,0.000,NULL,NULL,1,0,0.030,0,'2015-10-01 11:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:18','C',0.030,0.000,0.000,0),(607,632,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.380,NULL,NULL,NULL,0.380,NULL,NULL,NULL,NULL,0.380,0.380,0.000,0.000,NULL,NULL,1,0,0.380,0,'2015-10-01 11:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:18','C',0.380,0.000,0.000,0),(608,633,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.750,NULL,NULL,NULL,7.750,NULL,NULL,NULL,NULL,7.750,7.750,0.000,0.000,NULL,NULL,1,0,7.750,0,'2015-10-01 11:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:18','C',7.750,0.000,0.000,0),(609,634,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.180,NULL,NULL,NULL,5.180,NULL,NULL,NULL,NULL,5.180,5.180,0.000,0.000,NULL,NULL,1,0,5.180,0,'2015-10-01 11:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:18','C',5.180,0.000,0.000,0),(610,635,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.520,NULL,NULL,NULL,8.520,NULL,NULL,NULL,NULL,8.520,8.520,0.000,0.000,NULL,NULL,1,0,8.520,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:19','C',8.520,0.000,0.000,0),(611,636,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.310,NULL,NULL,NULL,6.310,NULL,NULL,NULL,NULL,6.310,6.310,0.000,0.000,NULL,NULL,1,0,6.310,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:19','C',6.310,0.000,0.000,0),(612,637,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.820,NULL,NULL,NULL,6.820,NULL,NULL,NULL,NULL,6.820,6.820,0.000,0.000,NULL,NULL,1,0,6.820,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:19','C',6.820,0.000,0.000,0),(613,638,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.570,NULL,NULL,NULL,8.570,NULL,NULL,NULL,NULL,8.570,8.570,0.000,0.000,NULL,NULL,1,0,8.570,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:19','C',8.570,0.000,0.000,0),(614,639,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.130,NULL,NULL,NULL,5.130,NULL,NULL,NULL,NULL,5.130,5.130,0.000,0.000,NULL,NULL,1,0,5.130,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:20','C',5.130,0.000,0.000,0),(615,640,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.670,NULL,NULL,NULL,6.670,NULL,NULL,NULL,NULL,6.670,6.670,0.000,0.000,NULL,NULL,1,0,6.670,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:20','C',6.670,0.000,0.000,0),(616,641,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.820,NULL,NULL,NULL,6.820,NULL,NULL,NULL,NULL,6.820,6.820,0.000,0.000,NULL,NULL,1,0,6.820,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:20','C',6.820,0.000,0.000,0),(617,642,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.520,NULL,NULL,NULL,6.520,NULL,NULL,NULL,NULL,6.520,6.520,0.000,0.000,NULL,NULL,1,0,6.520,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:20','C',6.520,0.000,0.000,0),(618,643,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.080,NULL,NULL,NULL,7.080,NULL,NULL,NULL,NULL,7.080,7.080,0.000,0.000,NULL,NULL,1,0,7.080,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:21','C',7.080,0.000,0.000,0),(619,644,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.820,NULL,NULL,NULL,4.820,NULL,NULL,NULL,NULL,4.820,4.820,0.000,0.000,NULL,NULL,1,0,4.820,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:21','C',4.820,0.000,0.000,0),(620,645,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.000,NULL,NULL,NULL,6.000,NULL,NULL,NULL,NULL,6.000,6.000,0.000,0.000,NULL,NULL,1,0,6.000,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:21','C',6.000,0.000,0.000,0),(621,646,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.640,NULL,NULL,NULL,7.640,NULL,NULL,NULL,NULL,7.640,7.640,0.000,0.000,NULL,NULL,1,0,7.640,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:22','C',7.640,0.000,0.000,0),(622,647,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.160,NULL,NULL,NULL,6.160,NULL,NULL,NULL,NULL,6.160,6.160,0.000,0.000,NULL,NULL,1,0,6.160,0,'2015-10-01 11:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:22','C',6.160,0.000,0.000,0),(623,648,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.280,NULL,NULL,NULL,5.280,NULL,NULL,NULL,NULL,5.280,5.280,0.000,0.000,NULL,NULL,1,0,5.280,0,'2015-10-01 11:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:22','C',5.280,0.000,0.000,0),(624,649,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,1,0,4.800,0,'2015-10-01 11:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:23','C',4.800,0.000,0.000,0),(625,650,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.280,NULL,NULL,NULL,4.280,NULL,NULL,NULL,NULL,4.280,4.280,0.000,0.000,NULL,NULL,1,0,4.280,0,'2015-10-01 11:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:23','C',4.280,0.000,0.000,0),(626,651,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.310,NULL,NULL,NULL,6.310,NULL,NULL,NULL,NULL,6.310,6.310,0.000,0.000,NULL,NULL,1,0,6.310,0,'2015-10-01 11:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:23','C',6.310,0.000,0.000,0),(627,652,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.960,NULL,NULL,NULL,6.960,NULL,NULL,NULL,NULL,6.960,6.960,0.000,0.000,NULL,NULL,1,0,6.960,0,'2015-10-01 11:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:23','C',6.960,0.000,0.000,0),(628,653,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.930,NULL,NULL,NULL,3.930,NULL,NULL,NULL,NULL,3.930,3.930,0.000,0.000,NULL,NULL,1,0,3.930,0,'2015-10-01 11:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:24','C',3.930,0.000,0.000,0),(629,654,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.000,NULL,NULL,NULL,6.000,NULL,NULL,NULL,NULL,6.000,6.000,0.000,0.000,NULL,NULL,1,0,6.000,0,'2015-10-01 11:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:24','C',6.000,0.000,0.000,0),(630,655,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,1,0,4.750,0,'2015-10-01 11:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:24','C',4.750,0.000,0.000,0),(631,656,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.710,NULL,NULL,NULL,4.710,NULL,NULL,NULL,NULL,4.710,4.710,0.000,0.000,NULL,NULL,1,0,4.710,0,'2015-10-01 11:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:24','C',4.710,0.000,0.000,0),(632,657,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.150,NULL,NULL,NULL,4.150,NULL,NULL,NULL,NULL,4.150,4.150,0.000,0.000,NULL,NULL,1,0,4.150,0,'2015-10-01 11:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:25','C',4.150,0.000,0.000,0),(633,658,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-01 11:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:25','C',4.100,0.000,0.000,0),(634,659,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.500,NULL,NULL,NULL,9.500,NULL,NULL,NULL,NULL,9.500,9.500,0.000,0.000,NULL,NULL,1,0,9.500,0,'2015-10-01 11:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:25','C',9.500,0.000,0.000,0),(635,660,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.550,NULL,NULL,NULL,6.550,NULL,NULL,NULL,NULL,6.550,6.550,0.000,0.000,NULL,NULL,1,0,6.550,0,'2015-10-01 11:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:25','C',6.550,0.000,0.000,0),(636,661,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.490,NULL,NULL,NULL,7.490,NULL,NULL,NULL,NULL,7.490,7.490,0.000,0.000,NULL,NULL,1,0,7.490,0,'2015-10-01 11:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:26','C',7.490,0.000,0.000,0),(637,662,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.960,NULL,NULL,NULL,3.960,NULL,NULL,NULL,NULL,3.960,3.960,0.000,0.000,NULL,NULL,1,0,3.960,0,'2015-10-01 11:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:26','C',3.960,0.000,0.000,0),(638,663,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.630,NULL,NULL,NULL,7.630,NULL,NULL,NULL,NULL,7.630,7.630,0.000,0.000,NULL,NULL,1,0,7.630,0,'2015-10-01 11:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:26','C',7.630,0.000,0.000,0),(639,664,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.540,NULL,NULL,NULL,5.540,NULL,NULL,NULL,NULL,5.540,5.540,0.000,0.000,NULL,NULL,1,0,5.540,0,'2015-10-01 11:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:27','C',5.540,0.000,0.000,0),(640,665,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.550,NULL,NULL,NULL,6.550,NULL,NULL,NULL,NULL,6.550,6.550,0.000,0.000,NULL,NULL,1,0,6.550,0,'2015-10-01 11:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:27','C',6.550,0.000,0.000,0),(641,666,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.780,NULL,NULL,NULL,7.780,NULL,NULL,NULL,NULL,7.780,7.780,0.000,0.000,NULL,NULL,1,0,7.780,0,'2015-10-01 11:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:27','C',7.780,0.000,0.000,0),(642,667,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.470,NULL,NULL,NULL,5.470,NULL,NULL,NULL,NULL,5.470,5.470,0.000,0.000,NULL,NULL,1,0,5.470,0,'2015-10-01 11:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:28','C',5.470,0.000,0.000,0),(643,668,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.060,NULL,NULL,NULL,7.060,NULL,NULL,NULL,NULL,7.060,7.060,0.000,0.000,NULL,NULL,1,0,7.060,0,'2015-10-01 11:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:28','C',7.060,0.000,0.000,0),(644,669,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.420,NULL,NULL,NULL,8.420,NULL,NULL,NULL,NULL,8.420,8.420,0.000,0.000,NULL,NULL,1,0,8.420,0,'2015-10-01 11:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:28','C',8.420,0.000,0.000,0),(645,670,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.620,NULL,NULL,NULL,6.620,NULL,NULL,NULL,NULL,6.620,6.620,0.000,0.000,NULL,NULL,1,0,6.620,0,'2015-10-01 11:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:28','C',6.620,0.000,0.000,0),(646,671,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.680,NULL,NULL,NULL,4.680,NULL,NULL,NULL,NULL,4.680,4.680,0.000,0.000,NULL,NULL,1,0,4.680,0,'2015-10-01 11:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:42','C',4.680,0.000,0.000,0),(647,672,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,5,0,3.400,0,'2015-10-01 11:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:42','C',3.400,0.000,0.000,0),(648,673,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,5,0,3.300,0,'2015-10-01 11:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:43','C',3.300,0.000,0.000,0),(649,674,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.980,NULL,NULL,NULL,2.980,NULL,NULL,NULL,NULL,2.980,2.980,0.000,0.000,NULL,NULL,5,0,2.980,0,'2015-10-01 11:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:43','C',2.980,0.000,0.000,0),(650,675,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.030,NULL,NULL,NULL,3.030,NULL,NULL,NULL,NULL,3.030,3.030,0.000,0.000,NULL,NULL,5,0,3.030,0,'2015-10-01 11:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:43','C',3.030,0.000,0.000,0),(651,676,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-01 11:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:44','C',3.480,0.000,0.000,0),(652,677,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.350,NULL,NULL,NULL,3.350,NULL,NULL,NULL,NULL,3.350,3.350,0.000,0.000,NULL,NULL,5,0,3.350,0,'2015-10-01 11:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:44','C',3.350,0.000,0.000,0),(653,678,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.700,NULL,NULL,NULL,2.700,NULL,NULL,NULL,NULL,2.700,2.700,0.000,0.000,NULL,NULL,5,0,2.700,0,'2015-10-01 11:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:44','C',2.700,0.000,0.000,0),(654,679,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.280,NULL,NULL,NULL,6.280,NULL,NULL,NULL,NULL,6.280,6.280,0.000,0.000,NULL,NULL,5,0,6.280,0,'2015-10-01 11:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:44','C',6.280,0.000,0.000,0),(655,680,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.180,NULL,NULL,NULL,6.180,NULL,NULL,NULL,NULL,6.180,6.180,0.000,0.000,NULL,NULL,5,0,6.180,0,'2015-10-01 11:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:45','C',6.180,0.000,0.000,0),(656,681,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.780,NULL,NULL,NULL,5.780,NULL,NULL,NULL,NULL,5.780,5.780,0.000,0.000,NULL,NULL,5,0,5.780,0,'2015-10-01 11:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:45','C',5.780,0.000,0.000,0),(657,682,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.350,NULL,NULL,NULL,6.350,NULL,NULL,NULL,NULL,6.350,6.350,0.000,0.000,NULL,NULL,5,0,6.350,0,'2015-10-01 11:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:45','C',6.350,0.000,0.000,0),(658,683,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.000,NULL,NULL,NULL,6.000,NULL,NULL,NULL,NULL,6.000,6.000,0.000,0.000,NULL,NULL,5,0,6.000,0,'2015-10-01 11:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:45','C',6.000,0.000,0.000,0),(659,684,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.480,NULL,NULL,NULL,6.480,NULL,NULL,NULL,NULL,6.480,6.480,0.000,0.000,NULL,NULL,5,0,6.480,0,'2015-10-01 11:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:46','C',6.480,0.000,0.000,0),(660,685,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.480,NULL,NULL,NULL,5.480,NULL,NULL,NULL,NULL,5.480,5.480,0.000,0.000,NULL,NULL,5,0,5.480,0,'2015-10-01 11:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:46','C',5.480,0.000,0.000,0),(661,686,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.280,NULL,NULL,NULL,7.280,NULL,NULL,NULL,NULL,7.280,7.280,0.000,0.000,NULL,NULL,5,0,7.280,0,'2015-10-01 11:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:46','C',7.280,0.000,0.000,0),(662,687,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.030,NULL,NULL,NULL,9.030,NULL,NULL,NULL,NULL,9.030,9.030,0.000,0.000,NULL,NULL,5,0,9.030,0,'2015-10-01 11:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:46','C',9.030,0.000,0.000,0),(663,688,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.300,NULL,NULL,NULL,5.300,NULL,NULL,NULL,NULL,5.300,5.300,0.000,0.000,NULL,NULL,5,0,5.300,0,'2015-10-01 11:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:47','C',5.300,0.000,0.000,0),(664,689,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.630,NULL,NULL,NULL,5.630,NULL,NULL,NULL,NULL,5.630,5.630,0.000,0.000,NULL,NULL,5,0,5.630,0,'2015-10-01 11:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:47','C',5.630,0.000,0.000,0),(665,690,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.100,NULL,NULL,NULL,3.100,NULL,NULL,NULL,NULL,3.100,3.100,0.000,0.000,NULL,NULL,5,0,3.100,0,'2015-10-01 11:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:47','C',3.100,0.000,0.000,0),(666,691,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,5,0,4.130,0,'2015-10-01 11:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:47','C',4.130,0.000,0.000,0),(667,692,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,5,0,4.750,0,'2015-10-01 11:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:48','C',4.750,0.000,0.000,0),(668,693,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.100,NULL,NULL,NULL,3.100,NULL,NULL,NULL,NULL,3.100,3.100,0.000,0.000,NULL,NULL,5,0,3.100,0,'2015-10-01 11:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:48','C',3.100,0.000,0.000,0),(669,694,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.000,NULL,NULL,NULL,3.000,NULL,NULL,NULL,NULL,3.000,3.000,0.000,0.000,NULL,NULL,5,0,3.000,0,'2015-10-01 11:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:48','C',3.000,0.000,0.000,0),(670,695,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.180,NULL,NULL,NULL,3.180,NULL,NULL,NULL,NULL,3.180,3.180,0.000,0.000,NULL,NULL,5,0,3.180,0,'2015-10-01 11:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:49','C',3.180,0.000,0.000,0),(671,696,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.930,NULL,NULL,NULL,2.930,NULL,NULL,NULL,NULL,2.930,2.930,0.000,0.000,NULL,NULL,5,0,2.930,0,'2015-10-01 11:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:49','C',2.930,0.000,0.000,0),(672,697,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.850,NULL,NULL,NULL,6.850,NULL,NULL,NULL,NULL,6.850,6.850,0.000,0.000,NULL,NULL,5,0,6.850,0,'2015-10-01 11:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:49','C',6.850,0.000,0.000,0),(673,698,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.500,NULL,NULL,NULL,5.500,NULL,NULL,NULL,NULL,5.500,5.500,0.000,0.000,NULL,NULL,5,0,5.500,0,'2015-10-01 11:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:49','C',5.500,0.000,0.000,0),(674,699,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.000,NULL,NULL,NULL,5.000,NULL,NULL,NULL,NULL,5.000,5.000,0.000,0.000,NULL,NULL,5,0,5.000,0,'2015-10-01 11:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:50','C',5.000,0.000,0.000,0),(675,700,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,5,0,3.280,0,'2015-10-01 11:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:50','C',3.280,0.000,0.000,0),(676,701,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.180,NULL,NULL,NULL,2.180,NULL,NULL,NULL,NULL,2.180,2.180,0.000,0.000,NULL,NULL,5,0,2.180,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:50','C',2.180,0.000,0.000,0),(677,702,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.300,NULL,NULL,NULL,4.300,NULL,NULL,NULL,NULL,4.300,4.300,0.000,0.000,NULL,NULL,5,0,4.300,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:50','C',4.300,0.000,0.000,0),(678,703,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.980,NULL,NULL,NULL,4.980,NULL,NULL,NULL,NULL,4.980,4.980,0.000,0.000,NULL,NULL,5,0,4.980,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:51','C',4.980,0.000,0.000,0),(679,704,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.180,NULL,NULL,NULL,3.180,NULL,NULL,NULL,NULL,3.180,3.180,0.000,0.000,NULL,NULL,5,0,3.180,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:51','C',3.180,0.000,0.000,0),(680,705,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.950,NULL,NULL,NULL,2.950,NULL,NULL,NULL,NULL,2.950,2.950,0.000,0.000,NULL,NULL,5,0,2.950,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:51','C',2.950,0.000,0.000,0),(681,706,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.050,NULL,NULL,NULL,5.050,NULL,NULL,NULL,NULL,5.050,5.050,0.000,0.000,NULL,NULL,5,0,5.050,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:51','C',5.050,0.000,0.000,0),(682,707,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,5,0,3.400,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:52','C',3.400,0.000,0.000,0),(683,708,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.100,NULL,NULL,NULL,3.100,NULL,NULL,NULL,NULL,3.100,3.100,0.000,0.000,NULL,NULL,5,0,3.100,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:52','C',3.100,0.000,0.000,0),(684,709,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.150,NULL,NULL,NULL,3.150,NULL,NULL,NULL,NULL,3.150,3.150,0.000,0.000,NULL,NULL,5,0,3.150,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:52','C',3.150,0.000,0.000,0),(685,710,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.850,NULL,NULL,NULL,4.850,NULL,NULL,NULL,NULL,4.850,4.850,0.000,0.000,NULL,NULL,5,0,4.850,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:53','C',4.850,0.000,0.000,0),(686,711,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.950,NULL,NULL,NULL,3.950,NULL,NULL,NULL,NULL,3.950,3.950,0.000,0.000,NULL,NULL,5,0,3.950,0,'2015-10-01 11:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:53','C',3.950,0.000,0.000,0),(687,712,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.580,NULL,NULL,NULL,5.580,NULL,NULL,NULL,NULL,5.580,5.580,0.000,0.000,NULL,NULL,5,0,5.580,0,'2015-10-01 11:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:53','C',5.580,0.000,0.000,0),(688,713,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.000,NULL,NULL,NULL,5.000,NULL,NULL,NULL,NULL,5.000,5.000,0.000,0.000,NULL,NULL,5,0,5.000,0,'2015-10-01 11:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:53','C',5.000,0.000,0.000,0),(689,714,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.450,NULL,NULL,NULL,4.450,NULL,NULL,NULL,NULL,4.450,4.450,0.000,0.000,NULL,NULL,5,0,4.450,0,'2015-10-01 11:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:54','C',4.450,0.000,0.000,0),(690,715,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.730,NULL,NULL,NULL,2.730,NULL,NULL,NULL,NULL,2.730,2.730,0.000,0.000,NULL,NULL,5,0,2.730,0,'2015-10-01 11:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:54','C',2.730,0.000,0.000,0),(691,716,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.850,NULL,NULL,NULL,2.850,NULL,NULL,NULL,NULL,2.850,2.850,0.000,0.000,NULL,NULL,5,0,2.850,0,'2015-10-01 11:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:54','C',2.850,0.000,0.000,0),(692,717,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.830,NULL,NULL,NULL,2.830,NULL,NULL,NULL,NULL,2.830,2.830,0.000,0.000,NULL,NULL,5,0,2.830,0,'2015-10-01 11:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:54','C',2.830,0.000,0.000,0),(693,718,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.180,NULL,NULL,NULL,4.180,NULL,NULL,NULL,NULL,4.180,4.180,0.000,0.000,NULL,NULL,5,0,4.180,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:55','C',4.180,0.000,0.000,0),(694,719,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,5,0,3.450,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:55','C',3.450,0.000,0.000,0),(695,720,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.980,NULL,NULL,NULL,2.980,NULL,NULL,NULL,NULL,2.980,2.980,0.000,0.000,NULL,NULL,5,0,2.980,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:55','C',2.980,0.000,0.000,0),(696,721,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.000,NULL,NULL,NULL,3.000,NULL,NULL,NULL,NULL,3.000,3.000,0.000,0.000,NULL,NULL,5,0,3.000,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:56','C',3.000,0.000,0.000,0),(697,722,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.280,NULL,NULL,NULL,4.280,NULL,NULL,NULL,NULL,4.280,4.280,0.000,0.000,NULL,NULL,5,0,4.280,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:56','C',4.280,0.000,0.000,0),(698,723,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.350,NULL,NULL,NULL,4.350,NULL,NULL,NULL,NULL,4.350,4.350,0.000,0.000,NULL,NULL,5,0,4.350,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:56','C',4.350,0.000,0.000,0),(699,724,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.630,NULL,NULL,NULL,4.630,NULL,NULL,NULL,NULL,4.630,4.630,0.000,0.000,NULL,NULL,5,0,4.630,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:56','C',4.630,0.000,0.000,0),(700,725,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.730,NULL,NULL,NULL,4.730,NULL,NULL,NULL,NULL,4.730,4.730,0.000,0.000,NULL,NULL,5,0,4.730,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:57','C',4.730,0.000,0.000,0),(701,726,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,5,0,3.450,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:57','C',3.450,0.000,0.000,0),(702,727,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.030,NULL,NULL,NULL,3.030,NULL,NULL,NULL,NULL,3.030,3.030,0.000,0.000,NULL,NULL,5,0,3.030,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:57','C',3.030,0.000,0.000,0),(703,728,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,5,0,4.100,0,'2015-10-01 11:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:57','C',4.100,0.000,0.000,0),(704,729,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.830,NULL,NULL,NULL,5.830,NULL,NULL,NULL,NULL,5.830,5.830,0.000,0.000,NULL,NULL,5,0,5.830,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:58','C',5.830,0.000,0.000,0),(705,730,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.880,NULL,NULL,NULL,4.880,NULL,NULL,NULL,NULL,4.880,4.880,0.000,0.000,NULL,NULL,5,0,4.880,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:58','C',4.880,0.000,0.000,0),(706,731,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.730,NULL,NULL,NULL,5.730,NULL,NULL,NULL,NULL,5.730,5.730,0.000,0.000,NULL,NULL,5,0,5.730,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:58','C',5.730,0.000,0.000,0),(707,732,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,5,0,4.750,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:58','C',4.750,0.000,0.000,0),(708,733,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.900,NULL,NULL,NULL,4.900,NULL,NULL,NULL,NULL,4.900,4.900,0.000,0.000,NULL,NULL,5,0,4.900,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:59','C',4.900,0.000,0.000,0),(709,734,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.480,NULL,NULL,NULL,4.480,NULL,NULL,NULL,NULL,4.480,4.480,0.000,0.000,NULL,NULL,5,0,4.480,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:59','C',4.480,0.000,0.000,0),(710,735,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.050,NULL,NULL,NULL,3.050,NULL,NULL,NULL,NULL,3.050,3.050,0.000,0.000,NULL,NULL,5,0,3.050,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:04:59','C',3.050,0.000,0.000,0),(711,736,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.230,NULL,NULL,NULL,3.230,NULL,NULL,NULL,NULL,3.230,3.230,0.000,0.000,NULL,NULL,5,0,3.230,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:00','C',3.230,0.000,0.000,0),(712,737,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.000,NULL,NULL,NULL,3.000,NULL,NULL,NULL,NULL,3.000,3.000,0.000,0.000,NULL,NULL,5,0,3.000,0,'2015-10-01 11:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:00','C',3.000,0.000,0.000,0),(713,738,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.050,NULL,NULL,NULL,3.050,NULL,NULL,NULL,NULL,3.050,3.050,0.000,0.000,NULL,NULL,5,0,3.050,0,'2015-10-01 11:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:00','C',3.050,0.000,0.000,0),(714,739,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.720,NULL,NULL,NULL,4.720,NULL,NULL,NULL,NULL,4.720,4.720,0.000,0.000,NULL,NULL,5,0,4.720,0,'2015-10-01 11:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:00','C',4.720,0.000,0.000,0),(715,740,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.520,NULL,NULL,NULL,5.520,NULL,NULL,NULL,NULL,5.520,5.520,0.000,0.000,NULL,NULL,5,0,5.520,0,'2015-10-01 11:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:01','C',5.520,0.000,0.000,0),(716,741,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.790,NULL,NULL,NULL,6.790,NULL,NULL,NULL,NULL,6.790,6.790,0.000,0.000,NULL,NULL,5,0,6.790,0,'2015-10-01 11:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:01','C',6.790,0.000,0.000,0),(717,742,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.310,NULL,NULL,NULL,4.310,NULL,NULL,NULL,NULL,4.310,4.310,0.000,0.000,NULL,NULL,5,0,4.310,0,'2015-10-01 11:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:01','C',4.310,0.000,0.000,0),(718,743,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.730,NULL,NULL,NULL,4.730,NULL,NULL,NULL,NULL,4.730,4.730,0.000,0.000,NULL,NULL,5,0,4.730,0,'2015-10-01 11:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:01','C',4.730,0.000,0.000,0),(719,744,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.530,NULL,NULL,NULL,3.530,NULL,NULL,NULL,NULL,3.530,3.530,0.000,0.000,NULL,NULL,5,0,3.530,0,'2015-10-01 11:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:02','C',3.530,0.000,0.000,0),(720,745,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.410,NULL,NULL,NULL,3.410,NULL,NULL,NULL,NULL,3.410,3.410,0.000,0.000,NULL,NULL,5,0,3.410,0,'2015-10-01 11:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:02','C',3.410,0.000,0.000,0),(721,746,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.030,NULL,NULL,NULL,3.030,NULL,NULL,NULL,NULL,3.030,3.030,0.000,0.000,NULL,NULL,5,0,3.030,0,'2015-10-01 11:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:02','C',3.030,0.000,0.000,0),(722,747,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.910,NULL,NULL,NULL,2.910,NULL,NULL,NULL,NULL,2.910,2.910,0.000,0.000,NULL,NULL,5,0,2.910,0,'2015-10-01 11:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:02','C',2.910,0.000,0.000,0),(723,748,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.880,NULL,NULL,NULL,3.880,NULL,NULL,NULL,NULL,3.880,3.880,0.000,0.000,NULL,NULL,5,0,3.880,0,'2015-10-01 11:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:03','C',3.880,0.000,0.000,0),(724,749,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.070,NULL,NULL,NULL,4.070,NULL,NULL,NULL,NULL,4.070,4.070,0.000,0.000,NULL,NULL,5,0,4.070,0,'2015-10-01 11:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:03','C',4.070,0.000,0.000,0),(725,750,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,5,0,3.300,0,'2015-10-01 11:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:03','C',3.300,0.000,0.000,0),(726,751,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,5,0,4.190,0,'2015-10-01 11:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:03','C',4.190,0.000,0.000,0),(727,752,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.350,NULL,NULL,NULL,13.350,NULL,NULL,NULL,NULL,13.350,13.350,0.000,0.000,NULL,NULL,5,0,13.350,0,'2015-10-01 11:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:04','C',13.350,0.000,0.000,0),(728,753,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.820,NULL,NULL,NULL,10.820,NULL,NULL,NULL,NULL,10.820,10.820,0.000,0.000,NULL,NULL,5,0,10.820,0,'2015-10-01 11:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:04','C',10.820,0.000,0.000,0),(729,754,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.600,NULL,NULL,NULL,5.600,NULL,NULL,NULL,NULL,5.600,5.600,0.000,0.000,NULL,NULL,5,0,5.600,0,'2015-10-01 11:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:04','C',5.600,0.000,0.000,0),(730,755,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.900,NULL,NULL,NULL,3.900,NULL,NULL,NULL,NULL,3.900,3.900,0.000,0.000,NULL,NULL,5,0,3.900,0,'2015-10-01 11:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:05','C',3.900,0.000,0.000,0),(731,756,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.100,NULL,NULL,NULL,6.100,NULL,NULL,NULL,NULL,6.100,6.100,0.000,0.000,NULL,NULL,5,0,6.100,0,'2015-10-01 11:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:05','C',6.100,0.000,0.000,0),(732,757,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.550,NULL,NULL,NULL,7.550,NULL,NULL,NULL,NULL,7.550,7.550,0.000,0.000,NULL,NULL,5,0,7.550,0,'2015-10-01 11:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:05','C',7.550,0.000,0.000,0),(733,758,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.650,NULL,NULL,NULL,6.650,NULL,NULL,NULL,NULL,6.650,6.650,0.000,0.000,NULL,NULL,5,0,6.650,0,'2015-10-01 11:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:06','C',6.650,0.000,0.000,0),(734,759,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.550,NULL,NULL,NULL,8.550,NULL,NULL,NULL,NULL,8.550,8.550,0.000,0.000,NULL,NULL,5,0,8.550,0,'2015-10-01 11:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:06','C',8.550,0.000,0.000,0),(735,760,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.050,NULL,NULL,NULL,7.050,NULL,NULL,NULL,NULL,7.050,7.050,0.000,0.000,NULL,NULL,5,0,7.050,0,'2015-10-01 11:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:06','C',7.050,0.000,0.000,0),(736,761,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.700,NULL,NULL,NULL,6.700,NULL,NULL,NULL,NULL,6.700,6.700,0.000,0.000,NULL,NULL,5,0,6.700,0,'2015-10-01 11:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:06','C',6.700,0.000,0.000,0),(737,762,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.750,NULL,NULL,NULL,10.750,NULL,NULL,NULL,NULL,10.750,10.750,0.000,0.000,NULL,NULL,5,0,10.750,0,'2015-10-01 11:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:07','C',10.750,0.000,0.000,0),(738,763,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.780,NULL,NULL,NULL,12.780,NULL,NULL,NULL,NULL,12.780,12.780,0.000,0.000,NULL,NULL,5,0,12.780,0,'2015-10-01 11:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:07','C',12.780,0.000,0.000,0),(739,764,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.530,NULL,NULL,NULL,10.530,NULL,NULL,NULL,NULL,10.530,10.530,0.000,0.000,NULL,NULL,5,0,10.530,0,'2015-10-01 11:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:07','C',10.530,0.000,0.000,0),(740,765,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.620,NULL,NULL,NULL,11.620,NULL,NULL,NULL,NULL,11.620,11.620,0.000,0.000,NULL,NULL,5,0,11.620,0,'2015-10-01 11:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:07','C',11.620,0.000,0.000,0),(741,766,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.620,NULL,NULL,NULL,6.620,NULL,NULL,NULL,NULL,6.620,6.620,0.000,0.000,NULL,NULL,5,0,6.620,0,'2015-10-01 11:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:08','C',6.620,0.000,0.000,0),(742,767,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.270,NULL,NULL,NULL,13.270,NULL,NULL,NULL,NULL,13.270,13.270,0.000,0.000,NULL,NULL,5,0,13.270,0,'2015-10-01 11:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:08','C',13.270,0.000,0.000,0),(743,768,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.020,NULL,NULL,NULL,6.020,NULL,NULL,NULL,NULL,6.020,6.020,0.000,0.000,NULL,NULL,5,0,6.020,0,'2015-10-01 11:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:08','C',6.020,0.000,0.000,0),(744,769,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.990,NULL,NULL,NULL,8.990,NULL,NULL,NULL,NULL,8.990,8.990,0.000,0.000,NULL,NULL,5,0,8.990,0,'2015-10-01 11:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:09','C',8.990,0.000,0.000,0),(745,770,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.620,NULL,NULL,NULL,11.620,NULL,NULL,NULL,NULL,11.620,11.620,0.000,0.000,NULL,NULL,5,0,11.620,0,'2015-10-01 11:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:09','C',11.620,0.000,0.000,0),(746,771,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.080,NULL,NULL,NULL,8.080,NULL,NULL,NULL,NULL,8.080,8.080,0.000,0.000,NULL,NULL,5,0,8.080,0,'2015-10-01 11:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:12','C',8.080,0.000,0.000,0),(747,772,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.470,NULL,NULL,NULL,5.470,NULL,NULL,NULL,NULL,5.470,5.470,0.000,0.000,NULL,NULL,5,0,5.470,0,'2015-10-01 11:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:12','C',5.470,0.000,0.000,0),(748,773,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.630,NULL,NULL,NULL,5.630,NULL,NULL,NULL,NULL,5.630,5.630,0.000,0.000,NULL,NULL,5,0,5.630,0,'2015-10-01 11:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:12','C',5.630,0.000,0.000,0),(749,774,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.530,NULL,NULL,NULL,5.530,NULL,NULL,NULL,NULL,5.530,5.530,0.000,0.000,NULL,NULL,5,0,5.530,0,'2015-10-01 11:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:13','C',5.530,0.000,0.000,0),(750,775,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.410,NULL,NULL,NULL,5.410,NULL,NULL,NULL,NULL,5.410,5.410,0.000,0.000,NULL,NULL,5,0,5.410,0,'2015-10-01 11:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:13','C',5.410,0.000,0.000,0),(751,776,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.320,NULL,NULL,NULL,9.320,NULL,NULL,NULL,NULL,9.320,9.320,0.000,0.000,NULL,NULL,5,0,9.320,0,'2015-10-01 11:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:13','C',9.320,0.000,0.000,0),(752,777,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.180,NULL,NULL,NULL,10.180,NULL,NULL,NULL,NULL,10.180,10.180,0.000,0.000,NULL,NULL,5,0,10.180,0,'2015-10-01 11:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:14','C',10.180,0.000,0.000,0),(753,778,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.110,NULL,NULL,NULL,6.110,NULL,NULL,NULL,NULL,6.110,6.110,0.000,0.000,NULL,NULL,5,0,6.110,0,'2015-10-01 11:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:14','C',6.110,0.000,0.000,0),(754,779,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.840,NULL,NULL,NULL,12.840,NULL,NULL,NULL,NULL,12.840,12.840,0.000,0.000,NULL,NULL,5,0,12.840,0,'2015-10-01 11:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:14','C',12.840,0.000,0.000,0),(755,780,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,20.170,NULL,NULL,NULL,20.170,NULL,NULL,NULL,NULL,20.170,20.170,0.000,0.000,NULL,NULL,5,0,20.170,0,'2015-10-01 11:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:15','C',20.170,0.000,0.000,0),(756,781,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.490,NULL,NULL,NULL,3.490,NULL,NULL,NULL,NULL,3.490,3.490,0.000,0.000,NULL,NULL,5,0,3.490,0,'2015-10-01 11:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:15','C',3.490,0.000,0.000,0),(757,782,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.140,NULL,NULL,NULL,5.140,NULL,NULL,NULL,NULL,5.140,5.140,0.000,0.000,NULL,NULL,5,0,5.140,0,'2015-10-01 11:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:15','C',5.140,0.000,0.000,0),(758,783,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,5,0,4.190,0,'2015-10-01 11:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:15','C',4.190,0.000,0.000,0),(759,784,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.250,NULL,NULL,NULL,4.250,NULL,NULL,NULL,NULL,4.250,4.250,0.000,0.000,NULL,NULL,5,0,4.250,0,'2015-10-01 11:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:16','C',4.250,0.000,0.000,0),(760,785,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.390,NULL,NULL,NULL,5.390,NULL,NULL,NULL,NULL,5.390,5.390,0.000,0.000,NULL,NULL,5,0,5.390,0,'2015-10-01 11:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:16','C',5.390,0.000,0.000,0),(761,786,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.080,NULL,NULL,NULL,5.080,NULL,NULL,NULL,NULL,5.080,5.080,0.000,0.000,NULL,NULL,5,0,5.080,0,'2015-10-01 11:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:16','C',5.080,0.000,0.000,0),(762,787,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.740,NULL,NULL,NULL,4.740,NULL,NULL,NULL,NULL,4.740,4.740,0.000,0.000,NULL,NULL,5,0,4.740,0,'2015-10-01 11:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:16','C',4.740,0.000,0.000,0),(763,788,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,5,0,4.190,0,'2015-10-01 11:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:17','C',4.190,0.000,0.000,0),(764,789,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.740,NULL,NULL,NULL,4.740,NULL,NULL,NULL,NULL,4.740,4.740,0.000,0.000,NULL,NULL,5,0,4.740,0,'2015-10-01 11:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:18','C',4.740,0.000,0.000,0),(765,790,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.770,NULL,NULL,NULL,2.770,NULL,NULL,NULL,NULL,2.770,2.770,0.000,0.000,NULL,NULL,5,0,2.770,0,'2015-10-01 11:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:18','C',2.770,0.000,0.000,0),(766,791,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.200,NULL,NULL,NULL,3.200,NULL,NULL,NULL,NULL,3.200,3.200,0.000,0.000,NULL,NULL,5,0,3.200,0,'2015-10-01 11:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:18','C',3.200,0.000,0.000,0),(767,792,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.340,NULL,NULL,NULL,4.340,NULL,NULL,NULL,NULL,4.340,4.340,0.000,0.000,NULL,NULL,5,0,4.340,0,'2015-10-01 11:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:19','C',4.340,0.000,0.000,0),(768,793,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.840,NULL,NULL,NULL,4.840,NULL,NULL,NULL,NULL,4.840,4.840,0.000,0.000,NULL,NULL,5,0,4.840,0,'2015-10-01 11:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:19','C',4.840,0.000,0.000,0),(769,794,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.230,NULL,NULL,NULL,3.230,NULL,NULL,NULL,NULL,3.230,3.230,0.000,0.000,NULL,NULL,5,0,3.230,0,'2015-10-01 11:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:19','C',3.230,0.000,0.000,0),(770,795,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.800,NULL,NULL,NULL,2.800,NULL,NULL,NULL,NULL,2.800,2.800,0.000,0.000,NULL,NULL,5,0,2.800,0,'2015-10-01 11:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:19','C',2.800,0.000,0.000,0),(771,796,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.710,NULL,NULL,NULL,2.710,NULL,NULL,NULL,NULL,2.710,2.710,0.000,0.000,NULL,NULL,5,0,2.710,0,'2015-10-01 11:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:20','C',2.710,0.000,0.000,0),(772,797,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,5,0,3.330,0,'2015-10-01 11:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:20','C',3.330,0.000,0.000,0),(773,798,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,5,0,4.770,0,'2015-10-01 11:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:20','C',4.770,0.000,0.000,0),(774,799,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,5,0,4.000,0,'2015-10-01 11:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:20','C',4.000,0.000,0.000,0),(775,800,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.820,NULL,NULL,NULL,11.820,NULL,NULL,NULL,NULL,11.820,11.820,0.000,0.000,NULL,NULL,1,0,11.820,0,'2015-10-01 11:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:21','C',11.820,0.000,0.000,0),(776,801,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.050,NULL,NULL,NULL,5.050,NULL,NULL,NULL,NULL,5.050,5.050,0.000,0.000,NULL,NULL,5,0,5.050,0,'2015-10-01 11:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:21','C',5.050,0.000,0.000,0),(777,802,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.650,NULL,NULL,NULL,4.650,NULL,NULL,NULL,NULL,4.650,4.650,0.000,0.000,NULL,NULL,5,0,4.650,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:21','C',4.650,0.000,0.000,0),(778,803,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.950,NULL,NULL,NULL,5.950,NULL,NULL,NULL,NULL,5.950,5.950,0.000,0.000,NULL,NULL,5,0,5.950,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:22','C',5.950,0.000,0.000,0),(779,804,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.750,NULL,NULL,NULL,8.750,NULL,NULL,NULL,NULL,8.750,8.750,0.000,0.000,NULL,NULL,5,0,8.750,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:22','C',8.750,0.000,0.000,0),(780,805,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.650,NULL,NULL,NULL,6.650,NULL,NULL,NULL,NULL,6.650,6.650,0.000,0.000,NULL,NULL,5,0,6.650,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:22','C',6.650,0.000,0.000,0),(781,806,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.950,NULL,NULL,NULL,6.950,NULL,NULL,NULL,NULL,6.950,6.950,0.000,0.000,NULL,NULL,5,0,6.950,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:22','C',6.950,0.000,0.000,0),(782,807,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,5,0,4.750,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:23','C',4.750,0.000,0.000,0),(783,808,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.050,NULL,NULL,NULL,4.050,NULL,NULL,NULL,NULL,4.050,4.050,0.000,0.000,NULL,NULL,5,0,4.050,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:23','C',4.050,0.000,0.000,0),(784,809,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.900,NULL,NULL,NULL,5.900,NULL,NULL,NULL,NULL,5.900,5.900,0.000,0.000,NULL,NULL,5,0,5.900,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:23','C',5.900,0.000,0.000,0),(785,810,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.300,NULL,NULL,NULL,6.300,NULL,NULL,NULL,NULL,6.300,6.300,0.000,0.000,NULL,NULL,5,0,6.300,0,'2015-10-01 11:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:23','C',6.300,0.000,0.000,0),(786,811,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,41.610,NULL,NULL,NULL,41.610,NULL,NULL,NULL,NULL,41.610,41.610,0.000,0.000,NULL,NULL,1,0,41.610,0,'2015-10-01 12:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:24','C',41.610,0.000,0.000,0),(787,812,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.200,NULL,NULL,NULL,4.200,NULL,NULL,NULL,NULL,4.200,4.200,0.000,0.000,NULL,NULL,5,0,4.200,0,'2015-10-01 12:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:24','C',4.200,0.000,0.000,0),(788,813,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.570,NULL,NULL,NULL,4.570,NULL,NULL,NULL,NULL,4.570,4.570,0.000,0.000,NULL,NULL,5,0,4.570,0,'2015-10-01 12:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:24','C',4.570,0.000,0.000,0),(789,814,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.230,NULL,NULL,NULL,4.230,NULL,NULL,NULL,NULL,4.230,4.230,0.000,0.000,NULL,NULL,5,0,4.230,0,'2015-10-01 12:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:24','C',4.230,0.000,0.000,0),(790,815,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.860,NULL,NULL,NULL,3.860,NULL,NULL,NULL,NULL,3.860,3.860,0.000,0.000,NULL,NULL,5,0,3.860,0,'2015-10-01 12:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:25','C',3.860,0.000,0.000,0),(791,816,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,5,0,3.670,0,'2015-10-01 12:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:25','C',3.670,0.000,0.000,0),(792,817,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,5,0,3.590,0,'2015-10-01 12:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:25','C',3.590,0.000,0.000,0),(793,818,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.100,NULL,NULL,NULL,3.100,NULL,NULL,NULL,NULL,3.100,3.100,0.000,0.000,NULL,NULL,5,0,3.100,0,'2015-10-01 12:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:26','C',3.100,0.000,0.000,0),(794,819,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,5,0,3.780,0,'2015-10-01 12:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:26','C',3.780,0.000,0.000,0),(795,820,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,5,0,3.780,0,'2015-10-01 12:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:26','C',3.780,0.000,0.000,0),(796,821,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.090,NULL,NULL,NULL,6.090,NULL,NULL,NULL,NULL,6.090,6.090,0.000,0.000,NULL,NULL,5,0,6.090,0,'2015-10-01 12:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:26','C',6.090,0.000,0.000,0),(797,822,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.520,NULL,NULL,NULL,5.520,NULL,NULL,NULL,NULL,5.520,5.520,0.000,0.000,NULL,NULL,5,0,5.520,0,'2015-10-01 12:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:27','C',5.520,0.000,0.000,0),(798,823,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.900,NULL,NULL,NULL,7.900,NULL,NULL,NULL,NULL,7.900,7.900,0.000,0.000,NULL,NULL,5,0,7.900,0,'2015-10-01 12:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:27','C',7.900,0.000,0.000,0),(799,824,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.990,NULL,NULL,NULL,4.990,NULL,NULL,NULL,NULL,4.990,4.990,0.000,0.000,NULL,NULL,5,0,4.990,0,'2015-10-01 12:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:27','C',4.990,0.000,0.000,0),(800,825,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.380,NULL,NULL,NULL,4.380,NULL,NULL,NULL,NULL,4.380,4.380,0.000,0.000,NULL,NULL,5,0,4.380,0,'2015-10-01 12:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:27','C',4.380,0.000,0.000,0),(801,826,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.120,NULL,NULL,NULL,6.120,NULL,NULL,NULL,NULL,6.120,6.120,0.000,0.000,NULL,NULL,5,0,6.120,0,'2015-10-01 12:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:28','C',6.120,0.000,0.000,0),(802,827,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,5,0,4.080,0,'2015-10-01 12:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:28','C',4.080,0.000,0.000,0),(803,828,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.590,NULL,NULL,NULL,5.590,NULL,NULL,NULL,NULL,5.590,5.590,0.000,0.000,NULL,NULL,5,0,5.590,0,'2015-10-01 12:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:28','C',5.590,0.000,0.000,0),(804,829,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.930,NULL,NULL,NULL,3.930,NULL,NULL,NULL,NULL,3.930,3.930,0.000,0.000,NULL,NULL,5,0,3.930,0,'2015-10-01 12:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:28','C',3.930,0.000,0.000,0),(805,830,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,5,0,3.970,0,'2015-10-01 12:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:29','C',3.970,0.000,0.000,0),(806,831,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.770,NULL,NULL,NULL,6.770,NULL,NULL,NULL,NULL,6.770,6.770,0.000,0.000,NULL,NULL,5,0,6.770,0,'2015-10-01 12:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:29','C',6.770,0.000,0.000,0),(807,832,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.100,NULL,NULL,NULL,3.100,NULL,NULL,NULL,NULL,3.100,3.100,0.000,0.000,NULL,NULL,5,0,3.100,0,'2015-10-01 12:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:29','C',3.100,0.000,0.000,0),(808,833,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.140,NULL,NULL,NULL,5.140,NULL,NULL,NULL,NULL,5.140,5.140,0.000,0.000,NULL,NULL,5,0,5.140,0,'2015-10-01 12:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:30','C',5.140,0.000,0.000,0),(809,834,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.100,NULL,NULL,NULL,3.100,NULL,NULL,NULL,NULL,3.100,3.100,0.000,0.000,NULL,NULL,5,0,3.100,0,'2015-10-01 12:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:30','C',3.100,0.000,0.000,0),(810,835,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.250,NULL,NULL,NULL,5.250,NULL,NULL,NULL,NULL,5.250,5.250,0.000,0.000,NULL,NULL,5,0,5.250,0,'2015-10-01 12:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:30','C',5.250,0.000,0.000,0),(811,836,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.100,NULL,NULL,NULL,5.100,NULL,NULL,NULL,NULL,5.100,5.100,0.000,0.000,NULL,NULL,5,0,5.100,0,'2015-10-01 12:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:30','C',5.100,0.000,0.000,0),(812,837,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.420,NULL,NULL,NULL,4.420,NULL,NULL,NULL,NULL,4.420,4.420,0.000,0.000,NULL,NULL,5,0,4.420,0,'2015-10-01 12:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:31','C',4.420,0.000,0.000,0),(813,838,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.290,NULL,NULL,NULL,3.290,NULL,NULL,NULL,NULL,3.290,3.290,0.000,0.000,NULL,NULL,5,0,3.290,0,'2015-10-01 12:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:31','C',3.290,0.000,0.000,0),(814,839,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.860,NULL,NULL,NULL,3.860,NULL,NULL,NULL,NULL,3.860,3.860,0.000,0.000,NULL,NULL,5,0,3.860,0,'2015-10-01 12:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:31','C',3.860,0.000,0.000,0),(815,840,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-01 12:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:31','C',3.480,0.000,0.000,0),(816,841,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.650,NULL,NULL,NULL,4.650,NULL,NULL,NULL,NULL,4.650,4.650,0.000,0.000,NULL,NULL,5,0,4.650,0,'2015-10-01 12:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:32','C',4.650,0.000,0.000,0),(817,842,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.950,NULL,NULL,NULL,4.950,NULL,NULL,NULL,NULL,4.950,4.950,0.000,0.000,NULL,NULL,5,0,4.950,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:32','C',4.950,0.000,0.000,0),(818,843,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.180,NULL,NULL,NULL,3.180,NULL,NULL,NULL,NULL,3.180,3.180,0.000,0.000,NULL,NULL,5,0,3.180,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:32','C',3.180,0.000,0.000,0),(819,844,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,5,0,3.820,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:33','C',3.820,0.000,0.000,0),(820,845,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.140,NULL,NULL,NULL,5.140,NULL,NULL,NULL,NULL,5.140,5.140,0.000,0.000,NULL,NULL,5,0,5.140,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:33','C',5.140,0.000,0.000,0),(821,846,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,5,0,3.820,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:33','C',3.820,0.000,0.000,0),(822,847,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,5,0,4.800,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:33','C',4.800,0.000,0.000,0),(823,848,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,5,0,4.270,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:34','C',4.270,0.000,0.000,0),(824,849,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.200,NULL,NULL,NULL,4.200,NULL,NULL,NULL,NULL,4.200,4.200,0.000,0.000,NULL,NULL,5,0,4.200,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:34','C',4.200,0.000,0.000,0),(825,850,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.420,NULL,NULL,NULL,4.420,NULL,NULL,NULL,NULL,4.420,4.420,0.000,0.000,NULL,NULL,5,0,4.420,0,'2015-10-01 12:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:34','C',4.420,0.000,0.000,0),(826,851,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.500,NULL,NULL,NULL,4.500,NULL,NULL,NULL,NULL,4.500,4.500,0.000,0.000,NULL,NULL,5,0,4.500,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:34','C',4.500,0.000,0.000,0),(827,852,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,5,0,4.270,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:35','C',4.270,0.000,0.000,0),(828,853,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,5,0,4.270,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:35','C',4.270,0.000,0.000,0),(829,854,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.630,NULL,NULL,NULL,5.630,NULL,NULL,NULL,NULL,5.630,5.630,0.000,0.000,NULL,NULL,5,0,5.630,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:35','C',5.630,0.000,0.000,0),(830,855,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,5,0,4.270,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:35','C',4.270,0.000,0.000,0),(831,856,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.590,NULL,NULL,NULL,5.590,NULL,NULL,NULL,NULL,5.590,5.590,0.000,0.000,NULL,NULL,5,0,5.590,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:36','C',5.590,0.000,0.000,0),(832,857,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.540,NULL,NULL,NULL,4.540,NULL,NULL,NULL,NULL,4.540,4.540,0.000,0.000,NULL,NULL,5,0,4.540,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:36','C',4.540,0.000,0.000,0),(833,858,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.290,NULL,NULL,NULL,3.290,NULL,NULL,NULL,NULL,3.290,3.290,0.000,0.000,NULL,NULL,5,0,3.290,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:36','C',3.290,0.000,0.000,0),(834,859,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.690,NULL,NULL,NULL,4.690,NULL,NULL,NULL,NULL,4.690,4.690,0.000,0.000,NULL,NULL,5,0,4.690,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:37','C',4.690,0.000,0.000,0),(835,860,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.150,NULL,NULL,NULL,2.150,NULL,NULL,NULL,NULL,2.150,2.150,0.000,0.000,NULL,NULL,5,0,2.150,0,'2015-10-01 12:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:37','C',2.150,0.000,0.000,0),(836,861,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,5,0,3.970,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:37','C',3.970,0.000,0.000,0),(837,862,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.380,NULL,NULL,NULL,2.380,NULL,NULL,NULL,NULL,2.380,2.380,0.000,0.000,NULL,NULL,5,0,2.380,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:37','C',2.380,0.000,0.000,0),(838,863,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.570,NULL,NULL,NULL,4.570,NULL,NULL,NULL,NULL,4.570,4.570,0.000,0.000,NULL,NULL,5,0,4.570,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:38','C',4.570,0.000,0.000,0),(839,864,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.760,NULL,NULL,NULL,2.760,NULL,NULL,NULL,NULL,2.760,2.760,0.000,0.000,NULL,NULL,5,0,2.760,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:38','C',2.760,0.000,0.000,0),(840,865,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,5,0,3.670,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:38','C',3.670,0.000,0.000,0),(841,866,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.230,NULL,NULL,NULL,4.230,NULL,NULL,NULL,NULL,4.230,4.230,0.000,0.000,NULL,NULL,5,0,4.230,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:38','C',4.230,0.000,0.000,0),(842,867,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.300,NULL,NULL,NULL,7.300,NULL,NULL,NULL,NULL,7.300,7.300,0.000,0.000,NULL,NULL,5,0,7.300,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:39','C',7.300,0.000,0.000,0),(843,868,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.700,NULL,NULL,NULL,3.700,NULL,NULL,NULL,NULL,3.700,3.700,0.000,0.000,NULL,NULL,5,0,3.700,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:39','C',3.700,0.000,0.000,0),(844,869,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.350,NULL,NULL,NULL,4.350,NULL,NULL,NULL,NULL,4.350,4.350,0.000,0.000,NULL,NULL,5,0,4.350,0,'2015-10-01 12:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:39','C',4.350,0.000,0.000,0),(845,870,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.350,NULL,NULL,NULL,4.350,NULL,NULL,NULL,NULL,4.350,4.350,0.000,0.000,NULL,NULL,5,0,4.350,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:40','C',4.350,0.000,0.000,0),(846,871,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,5,0,3.890,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:45','C',3.890,0.000,0.000,0),(847,872,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.500,NULL,NULL,NULL,4.500,NULL,NULL,NULL,NULL,4.500,4.500,0.000,0.000,NULL,NULL,5,0,4.500,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:46','C',4.500,0.000,0.000,0),(848,873,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.950,NULL,NULL,NULL,2.950,NULL,NULL,NULL,NULL,2.950,2.950,0.000,0.000,NULL,NULL,5,0,2.950,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:46','C',2.950,0.000,0.000,0),(849,874,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.840,NULL,NULL,NULL,4.840,NULL,NULL,NULL,NULL,4.840,4.840,0.000,0.000,NULL,NULL,5,0,4.840,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:46','C',4.840,0.000,0.000,0),(850,875,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.030,NULL,NULL,NULL,5.030,NULL,NULL,NULL,NULL,5.030,5.030,0.000,0.000,NULL,NULL,5,0,5.030,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:46','C',5.030,0.000,0.000,0),(851,876,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:47','C',3.480,0.000,0.000,0),(852,877,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.070,NULL,NULL,NULL,5.070,NULL,NULL,NULL,NULL,5.070,5.070,0.000,0.000,NULL,NULL,5,0,5.070,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:47','C',5.070,0.000,0.000,0),(853,878,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.870,NULL,NULL,NULL,2.870,NULL,NULL,NULL,NULL,2.870,2.870,0.000,0.000,NULL,NULL,5,0,2.870,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:47','C',2.870,0.000,0.000,0),(854,879,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,5,0,3.330,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:48','C',3.330,0.000,0.000,0),(855,880,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.180,NULL,NULL,NULL,3.180,NULL,NULL,NULL,NULL,3.180,3.180,0.000,0.000,NULL,NULL,5,0,3.180,0,'2015-10-01 12:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:48','C',3.180,0.000,0.000,0),(856,881,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.840,NULL,NULL,NULL,2.840,NULL,NULL,NULL,NULL,2.840,2.840,0.000,0.000,NULL,NULL,5,0,2.840,0,'2015-10-01 12:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:48','C',2.840,0.000,0.000,0),(857,882,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.230,NULL,NULL,NULL,4.230,NULL,NULL,NULL,NULL,4.230,4.230,0.000,0.000,NULL,NULL,5,0,4.230,0,'2015-10-01 12:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:48','C',4.230,0.000,0.000,0),(858,883,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.990,NULL,NULL,NULL,2.990,NULL,NULL,NULL,NULL,2.990,2.990,0.000,0.000,NULL,NULL,5,0,2.990,0,'2015-10-01 12:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:49','C',2.990,0.000,0.000,0),(859,884,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.930,NULL,NULL,NULL,3.930,NULL,NULL,NULL,NULL,3.930,3.930,0.000,0.000,NULL,NULL,5,0,3.930,0,'2015-10-01 12:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:49','C',3.930,0.000,0.000,0),(860,885,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,5,0,3.020,0,'2015-10-01 12:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:49','C',3.020,0.000,0.000,0),(861,886,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.230,NULL,NULL,NULL,4.230,NULL,NULL,NULL,NULL,4.230,4.230,0.000,0.000,NULL,NULL,5,0,4.230,0,'2015-10-01 12:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:49','C',4.230,0.000,0.000,0),(862,887,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,5,0,4.800,0,'2015-10-01 12:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:50','C',4.800,0.000,0.000,0),(863,888,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.310,NULL,NULL,NULL,4.310,NULL,NULL,NULL,NULL,4.310,4.310,0.000,0.000,NULL,NULL,5,0,4.310,0,'2015-10-01 12:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:50','C',4.310,0.000,0.000,0),(864,889,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.350,NULL,NULL,NULL,14.350,NULL,NULL,NULL,NULL,14.350,14.350,0.000,0.000,NULL,NULL,5,0,14.350,0,'2015-10-01 12:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:50','C',14.350,0.000,0.000,0),(865,890,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.710,NULL,NULL,NULL,11.710,NULL,NULL,NULL,NULL,11.710,11.710,0.000,0.000,NULL,NULL,5,0,11.710,0,'2015-10-01 12:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:51','C',11.710,0.000,0.000,0),(866,891,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.890,NULL,NULL,NULL,11.890,NULL,NULL,NULL,NULL,11.890,11.890,0.000,0.000,NULL,NULL,5,0,11.890,0,'2015-10-01 12:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:51','C',11.890,0.000,0.000,0),(867,892,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.890,NULL,NULL,NULL,10.890,NULL,NULL,NULL,NULL,10.890,10.890,0.000,0.000,NULL,NULL,5,0,10.890,0,'2015-10-01 12:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:51','C',10.890,0.000,0.000,0),(868,893,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.300,NULL,NULL,NULL,17.300,NULL,NULL,NULL,NULL,17.300,17.300,0.000,0.000,NULL,NULL,5,0,17.300,0,'2015-10-01 12:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:51','C',17.300,0.000,0.000,0),(869,894,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.320,NULL,NULL,NULL,9.320,NULL,NULL,NULL,NULL,9.320,9.320,0.000,0.000,NULL,NULL,5,0,9.320,0,'2015-10-01 12:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:52','C',9.320,0.000,0.000,0),(870,895,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.030,NULL,NULL,NULL,8.030,NULL,NULL,NULL,NULL,8.030,8.030,0.000,0.000,NULL,NULL,5,0,8.030,0,'2015-10-01 12:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:52','C',8.030,0.000,0.000,0),(871,896,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.240,NULL,NULL,NULL,8.240,NULL,NULL,NULL,NULL,8.240,8.240,0.000,0.000,NULL,NULL,5,0,8.240,0,'2015-10-01 12:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:52','C',8.240,0.000,0.000,0),(872,897,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.240,NULL,NULL,NULL,8.240,NULL,NULL,NULL,NULL,8.240,8.240,0.000,0.000,NULL,NULL,5,0,8.240,0,'2015-10-01 12:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:52','C',8.240,0.000,0.000,0),(873,898,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.490,NULL,NULL,NULL,7.490,NULL,NULL,NULL,NULL,7.490,7.490,0.000,0.000,NULL,NULL,5,0,7.490,0,'2015-10-01 12:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:53','C',7.490,0.000,0.000,0),(874,899,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.390,NULL,NULL,NULL,6.390,NULL,NULL,NULL,NULL,6.390,6.390,0.000,0.000,NULL,NULL,5,0,6.390,0,'2015-10-01 12:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:53','C',6.390,0.000,0.000,0),(875,900,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.360,NULL,NULL,NULL,9.360,NULL,NULL,NULL,NULL,9.360,9.360,0.000,0.000,NULL,NULL,5,0,9.360,0,'2015-10-01 12:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:54','C',9.360,0.000,0.000,0),(876,901,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.100,NULL,NULL,NULL,9.100,NULL,NULL,NULL,NULL,9.100,9.100,0.000,0.000,NULL,NULL,5,0,9.100,0,'2015-10-01 12:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:54','C',9.100,0.000,0.000,0),(877,902,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.540,NULL,NULL,NULL,8.540,NULL,NULL,NULL,NULL,8.540,8.540,0.000,0.000,NULL,NULL,5,0,8.540,0,'2015-10-01 12:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:54','C',8.540,0.000,0.000,0),(878,903,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.500,NULL,NULL,NULL,6.500,NULL,NULL,NULL,NULL,6.500,6.500,0.000,0.000,NULL,NULL,5,0,6.500,0,'2015-10-01 12:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:54','C',6.500,0.000,0.000,0),(879,904,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.530,NULL,NULL,NULL,10.530,NULL,NULL,NULL,NULL,10.530,10.530,0.000,0.000,NULL,NULL,5,0,10.530,0,'2015-10-01 12:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:55','C',10.530,0.000,0.000,0),(880,905,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.470,NULL,NULL,NULL,6.470,NULL,NULL,NULL,NULL,6.470,6.470,0.000,0.000,NULL,NULL,5,0,6.470,0,'2015-10-01 12:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:55','C',6.470,0.000,0.000,0),(881,906,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.490,NULL,NULL,NULL,10.490,NULL,NULL,NULL,NULL,10.490,10.490,0.000,0.000,NULL,NULL,5,0,10.490,0,'2015-10-01 12:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:55','C',10.490,0.000,0.000,0),(882,907,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.850,NULL,NULL,NULL,9.850,NULL,NULL,NULL,NULL,9.850,9.850,0.000,0.000,NULL,NULL,5,0,9.850,0,'2015-10-01 12:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:55','C',9.850,0.000,0.000,0),(883,908,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.510,NULL,NULL,NULL,11.510,NULL,NULL,NULL,NULL,11.510,11.510,0.000,0.000,NULL,NULL,5,0,11.510,0,'2015-10-01 12:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:56','C',11.510,0.000,0.000,0),(884,909,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.390,NULL,NULL,NULL,13.390,NULL,NULL,NULL,NULL,13.390,13.390,0.000,0.000,NULL,NULL,5,0,13.390,0,'2015-10-01 12:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:56','C',13.390,0.000,0.000,0),(885,910,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.710,NULL,NULL,NULL,7.710,NULL,NULL,NULL,NULL,7.710,7.710,0.000,0.000,NULL,NULL,5,0,7.710,0,'2015-10-01 12:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:56','C',7.710,0.000,0.000,0),(886,911,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.420,NULL,NULL,NULL,8.420,NULL,NULL,NULL,NULL,8.420,8.420,0.000,0.000,NULL,NULL,5,0,8.420,0,'2015-10-01 12:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:56','C',8.420,0.000,0.000,0),(887,912,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.880,NULL,NULL,NULL,6.880,NULL,NULL,NULL,NULL,6.880,6.880,0.000,0.000,NULL,NULL,5,0,6.880,0,'2015-10-01 12:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:57','C',6.880,0.000,0.000,0),(888,913,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.670,NULL,NULL,NULL,12.670,NULL,NULL,NULL,NULL,12.670,12.670,0.000,0.000,NULL,NULL,5,0,12.670,0,'2015-10-01 12:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:57','C',12.670,0.000,0.000,0),(889,914,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.460,NULL,NULL,NULL,3.460,NULL,NULL,NULL,NULL,3.460,3.460,0.000,0.000,NULL,NULL,5,0,3.460,0,'2015-10-01 12:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:57','C',3.460,0.000,0.000,0),(890,915,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.730,NULL,NULL,NULL,4.730,NULL,NULL,NULL,NULL,4.730,4.730,0.000,0.000,NULL,NULL,5,0,4.730,0,'2015-10-01 12:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:58','C',4.730,0.000,0.000,0),(891,916,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.770,NULL,NULL,NULL,3.770,NULL,NULL,NULL,NULL,3.770,3.770,0.000,0.000,NULL,NULL,5,0,3.770,0,'2015-10-01 12:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:58','C',3.770,0.000,0.000,0),(892,917,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.700,NULL,NULL,NULL,14.700,NULL,NULL,NULL,NULL,14.700,14.700,0.000,0.000,NULL,NULL,5,0,14.700,0,'2015-10-01 12:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:58','C',14.700,0.000,0.000,0),(893,918,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.230,NULL,NULL,NULL,15.230,NULL,NULL,NULL,NULL,15.230,15.230,0.000,0.000,NULL,NULL,5,0,15.230,0,'2015-10-01 12:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:58','C',15.230,0.000,0.000,0),(894,919,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.550,NULL,NULL,NULL,15.550,NULL,NULL,NULL,NULL,15.550,15.550,0.000,0.000,NULL,NULL,5,0,15.550,0,'2015-10-01 12:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:59','C',15.550,0.000,0.000,0),(895,920,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.390,NULL,NULL,NULL,15.390,NULL,NULL,NULL,NULL,15.390,15.390,0.000,0.000,NULL,NULL,5,0,15.390,0,'2015-10-01 12:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:59','C',15.390,0.000,0.000,0),(896,921,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.760,NULL,NULL,NULL,10.760,NULL,NULL,NULL,NULL,10.760,10.760,0.000,0.000,NULL,NULL,5,0,10.760,0,'2015-10-01 12:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:59','C',10.760,0.000,0.000,0),(897,922,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.270,NULL,NULL,NULL,10.270,NULL,NULL,NULL,NULL,10.270,10.270,0.000,0.000,NULL,NULL,5,0,10.270,0,'2015-10-01 12:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:05:59','C',10.270,0.000,0.000,0),(898,923,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.770,NULL,NULL,NULL,12.770,NULL,NULL,NULL,NULL,12.770,12.770,0.000,0.000,NULL,NULL,5,0,12.770,0,'2015-10-01 12:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:00','C',12.770,0.000,0.000,0),(899,924,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.100,NULL,NULL,NULL,13.100,NULL,NULL,NULL,NULL,13.100,13.100,0.000,0.000,NULL,NULL,5,0,13.100,0,'2015-10-01 12:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:00','C',13.100,0.000,0.000,0),(900,925,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.330,NULL,NULL,NULL,18.330,NULL,NULL,NULL,NULL,18.330,18.330,0.000,0.000,NULL,NULL,5,0,18.330,0,'2015-10-01 12:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:00','C',18.330,0.000,0.000,0),(901,926,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.950,NULL,NULL,NULL,14.950,NULL,NULL,NULL,NULL,14.950,14.950,0.000,0.000,NULL,NULL,5,0,14.950,0,'2015-10-01 12:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:00','C',14.950,0.000,0.000,0),(902,927,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.900,NULL,NULL,NULL,12.900,NULL,NULL,NULL,NULL,12.900,12.900,0.000,0.000,NULL,NULL,5,0,12.900,0,'2015-10-01 12:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:01','C',12.900,0.000,0.000,0),(903,928,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,16.430,NULL,NULL,NULL,16.430,NULL,NULL,NULL,NULL,16.430,16.430,0.000,0.000,NULL,NULL,5,0,16.430,0,'2015-10-01 12:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:01','C',16.430,0.000,0.000,0),(904,929,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.060,NULL,NULL,NULL,12.060,NULL,NULL,NULL,NULL,12.060,12.060,0.000,0.000,NULL,NULL,5,0,12.060,0,'2015-10-01 12:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:01','C',12.060,0.000,0.000,0),(905,930,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.900,NULL,NULL,NULL,12.900,NULL,NULL,NULL,NULL,12.900,12.900,0.000,0.000,NULL,NULL,5,0,12.900,0,'2015-10-01 12:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:02','C',12.900,0.000,0.000,0),(906,931,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.430,NULL,NULL,NULL,14.430,NULL,NULL,NULL,NULL,14.430,14.430,0.000,0.000,NULL,NULL,5,0,14.430,0,'2015-10-01 12:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:02','C',14.430,0.000,0.000,0),(907,932,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.700,NULL,NULL,NULL,9.700,NULL,NULL,NULL,NULL,9.700,9.700,0.000,0.000,NULL,NULL,5,0,9.700,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:02','C',9.700,0.000,0.000,0),(908,933,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.160,NULL,NULL,NULL,13.160,NULL,NULL,NULL,NULL,13.160,13.160,0.000,0.000,NULL,NULL,5,0,13.160,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:02','C',13.160,0.000,0.000,0),(909,934,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.120,NULL,NULL,NULL,12.120,NULL,NULL,NULL,NULL,12.120,12.120,0.000,0.000,NULL,NULL,5,0,12.120,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:03','C',12.120,0.000,0.000,0),(910,935,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.880,NULL,NULL,NULL,13.880,NULL,NULL,NULL,NULL,13.880,13.880,0.000,0.000,NULL,NULL,5,0,13.880,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:03','C',13.880,0.000,0.000,0),(911,936,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.220,NULL,NULL,NULL,14.220,NULL,NULL,NULL,NULL,14.220,14.220,0.000,0.000,NULL,NULL,5,0,14.220,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:03','C',14.220,0.000,0.000,0),(912,937,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.960,NULL,NULL,NULL,13.960,NULL,NULL,NULL,NULL,13.960,13.960,0.000,0.000,NULL,NULL,5,0,13.960,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:03','C',13.960,0.000,0.000,0),(913,938,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.940,NULL,NULL,NULL,13.940,NULL,NULL,NULL,NULL,13.940,13.940,0.000,0.000,NULL,NULL,5,0,13.940,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:04','C',13.940,0.000,0.000,0),(914,939,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.990,NULL,NULL,NULL,13.990,NULL,NULL,NULL,NULL,13.990,13.990,0.000,0.000,NULL,NULL,5,0,13.990,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:04','C',13.990,0.000,0.000,0),(915,940,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.980,NULL,NULL,NULL,14.980,NULL,NULL,NULL,NULL,14.980,14.980,0.000,0.000,NULL,NULL,5,0,14.980,0,'2015-10-01 12:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:04','C',14.980,0.000,0.000,0),(916,941,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.720,NULL,NULL,NULL,2.720,NULL,NULL,NULL,NULL,2.720,2.720,0.000,0.000,NULL,NULL,3,0,2.720,0,'2015-10-01 12:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:05','C',2.720,0.000,0.000,0),(917,942,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.790,NULL,NULL,NULL,2.790,NULL,NULL,NULL,NULL,2.790,2.790,0.000,0.000,NULL,NULL,3,0,2.790,0,'2015-10-01 12:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:05','C',2.790,0.000,0.000,0),(918,943,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.300,NULL,NULL,NULL,2.300,NULL,NULL,NULL,NULL,2.300,2.300,0.000,0.000,NULL,NULL,3,0,2.300,0,'2015-10-01 12:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:05','C',2.300,0.000,0.000,0),(919,944,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.240,NULL,NULL,NULL,3.240,NULL,NULL,NULL,NULL,3.240,3.240,0.000,0.000,NULL,NULL,3,0,3.240,0,'2015-10-01 12:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:05','C',3.240,0.000,0.000,0),(920,945,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,42.970,NULL,NULL,NULL,42.970,NULL,NULL,NULL,NULL,42.970,42.970,0.000,0.000,NULL,NULL,3,0,42.970,0,'2015-10-01 12:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:06','C',42.970,0.000,0.000,0),(921,946,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,43.400,NULL,NULL,NULL,43.400,NULL,NULL,NULL,NULL,43.400,43.400,0.000,0.000,NULL,NULL,3,0,43.400,0,'2015-10-01 12:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:06','C',43.400,0.000,0.000,0),(922,947,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.920,NULL,NULL,NULL,3.920,NULL,NULL,NULL,NULL,3.920,3.920,0.000,0.000,NULL,NULL,3,0,3.920,0,'2015-10-01 12:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:06','C',3.920,0.000,0.000,0),(923,948,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,3,0,4.100,0,'2015-10-01 12:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:07','C',4.100,0.000,0.000,0),(924,949,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.670,NULL,NULL,NULL,15.670,NULL,NULL,NULL,NULL,15.670,15.670,0.000,0.000,NULL,NULL,3,0,15.670,0,'2015-10-01 12:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:07','C',15.670,0.000,0.000,0),(925,950,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.030,NULL,NULL,NULL,4.030,NULL,NULL,NULL,NULL,4.030,4.030,0.000,0.000,NULL,NULL,3,0,4.030,0,'2015-10-01 12:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:07','C',4.030,0.000,0.000,0),(926,951,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.070,NULL,NULL,NULL,3.070,NULL,NULL,NULL,NULL,3.070,3.070,0.000,0.000,NULL,NULL,3,0,3.070,0,'2015-10-01 12:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:07','C',3.070,0.000,0.000,0),(927,952,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,3,0,3.780,0,'2015-10-01 12:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:08','C',3.780,0.000,0.000,0),(928,953,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.190,NULL,NULL,NULL,3.190,NULL,NULL,NULL,NULL,3.190,3.190,0.000,0.000,NULL,NULL,3,0,3.190,0,'2015-10-01 12:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:08','C',3.190,0.000,0.000,0),(929,954,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,3,0,3.280,0,'2015-10-01 12:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:08','C',3.280,0.000,0.000,0),(930,955,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.190,NULL,NULL,NULL,3.190,NULL,NULL,NULL,NULL,3.190,3.190,0.000,0.000,NULL,NULL,3,0,3.190,0,'2015-10-01 12:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:08','C',3.190,0.000,0.000,0),(931,956,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.650,NULL,NULL,NULL,3.650,NULL,NULL,NULL,NULL,3.650,3.650,0.000,0.000,NULL,NULL,3,0,3.650,0,'2015-10-01 12:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:09','C',3.650,0.000,0.000,0),(932,957,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.360,NULL,NULL,NULL,3.360,NULL,NULL,NULL,NULL,3.360,3.360,0.000,0.000,NULL,NULL,3,0,3.360,0,'2015-10-01 12:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:09','C',3.360,0.000,0.000,0),(933,958,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.480,NULL,NULL,NULL,7.480,NULL,NULL,NULL,NULL,7.480,7.480,0.000,0.000,NULL,NULL,3,0,7.480,0,'2015-10-01 12:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:09','C',7.480,0.000,0.000,0),(934,959,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,21.890,NULL,NULL,NULL,21.890,NULL,NULL,NULL,NULL,21.890,21.890,0.000,0.000,NULL,NULL,3,0,21.890,0,'2015-10-01 12:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:09','C',21.890,0.000,0.000,0),(935,960,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,21.040,NULL,NULL,NULL,21.040,NULL,NULL,NULL,NULL,21.040,21.040,0.000,0.000,NULL,NULL,3,0,21.040,0,'2015-10-01 12:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:10','C',21.040,0.000,0.000,0),(936,961,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,3,0,4.770,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:10','C',4.770,0.000,0.000,0),(937,962,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.700,NULL,NULL,NULL,4.700,NULL,NULL,NULL,NULL,4.700,4.700,0.000,0.000,NULL,NULL,3,0,4.700,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:10','C',4.700,0.000,0.000,0),(938,963,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.420,NULL,NULL,NULL,3.420,NULL,NULL,NULL,NULL,3.420,3.420,0.000,0.000,NULL,NULL,3,0,3.420,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:11','C',3.420,0.000,0.000,0),(939,964,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.520,NULL,NULL,NULL,4.520,NULL,NULL,NULL,NULL,4.520,4.520,0.000,0.000,NULL,NULL,3,0,4.520,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:11','C',4.520,0.000,0.000,0),(940,965,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.600,NULL,NULL,NULL,3.600,NULL,NULL,NULL,NULL,3.600,3.600,0.000,0.000,NULL,NULL,3,0,3.600,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:11','C',3.600,0.000,0.000,0),(941,966,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,3,0,3.280,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:11','C',3.280,0.000,0.000,0),(942,967,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.490,NULL,NULL,NULL,4.490,NULL,NULL,NULL,NULL,4.490,4.490,0.000,0.000,NULL,NULL,3,0,4.490,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:12','C',4.490,0.000,0.000,0),(943,968,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.920,NULL,NULL,NULL,3.920,NULL,NULL,NULL,NULL,3.920,3.920,0.000,0.000,NULL,NULL,3,0,3.920,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:12','C',3.920,0.000,0.000,0),(944,969,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.910,NULL,NULL,NULL,4.910,NULL,NULL,NULL,NULL,4.910,4.910,0.000,0.000,NULL,NULL,3,0,4.910,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:12','C',4.910,0.000,0.000,0),(945,970,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.170,NULL,NULL,NULL,4.170,NULL,NULL,NULL,NULL,4.170,4.170,0.000,0.000,NULL,NULL,3,0,4.170,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:12','C',4.170,0.000,0.000,0),(946,971,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.700,NULL,NULL,NULL,3.700,NULL,NULL,NULL,NULL,3.700,3.700,0.000,0.000,NULL,NULL,3,0,3.700,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:16','C',3.700,0.000,0.000,0),(947,972,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,3,0,4.130,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:17','C',4.130,0.000,0.000,0),(948,973,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.060,NULL,NULL,NULL,4.060,NULL,NULL,NULL,NULL,4.060,4.060,0.000,0.000,NULL,NULL,3,0,4.060,0,'2015-10-01 12:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:17','C',4.060,0.000,0.000,0),(949,974,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.200,NULL,NULL,NULL,4.200,NULL,NULL,NULL,NULL,4.200,4.200,0.000,0.000,NULL,NULL,3,0,4.200,0,'2015-10-01 12:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:17','C',4.200,0.000,0.000,0),(950,975,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.060,NULL,NULL,NULL,4.060,NULL,NULL,NULL,NULL,4.060,4.060,0.000,0.000,NULL,NULL,3,0,4.060,0,'2015-10-01 12:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:17','C',4.060,0.000,0.000,0),(951,976,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,3,0,3.670,0,'2015-10-01 12:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:18','C',3.670,0.000,0.000,0),(952,977,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.840,NULL,NULL,NULL,3.840,NULL,NULL,NULL,NULL,3.840,3.840,0.000,0.000,NULL,NULL,3,0,3.840,0,'2015-10-01 12:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:18','C',3.840,0.000,0.000,0),(953,978,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.420,NULL,NULL,NULL,3.420,NULL,NULL,NULL,NULL,3.420,3.420,0.000,0.000,NULL,NULL,3,0,3.420,0,'2015-10-01 12:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:18','C',3.420,0.000,0.000,0),(954,979,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.920,NULL,NULL,NULL,3.920,NULL,NULL,NULL,NULL,3.920,3.920,0.000,0.000,NULL,NULL,3,0,3.920,0,'2015-10-01 12:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:18','C',3.920,0.000,0.000,0),(955,980,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.760,NULL,NULL,NULL,3.760,NULL,NULL,NULL,NULL,3.760,3.760,0.000,0.000,NULL,NULL,3,0,3.760,0,'2015-10-01 13:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:19','C',3.760,0.000,0.000,0),(956,981,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.760,NULL,NULL,NULL,3.760,NULL,NULL,NULL,NULL,3.760,3.760,0.000,0.000,NULL,NULL,3,0,3.760,0,'2015-10-01 13:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:19','C',3.760,0.000,0.000,0),(957,982,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,3,0,3.780,0,'2015-10-01 13:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:19','C',3.780,0.000,0.000,0),(958,983,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.760,NULL,NULL,NULL,3.760,NULL,NULL,NULL,NULL,3.760,3.760,0.000,0.000,NULL,NULL,3,0,3.760,0,'2015-10-01 13:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:19','C',3.760,0.000,0.000,0),(959,984,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.900,NULL,NULL,NULL,7.900,NULL,NULL,NULL,NULL,7.900,7.900,0.000,0.000,NULL,NULL,3,0,7.900,0,'2015-10-01 13:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:20','C',7.900,0.000,0.000,0),(960,985,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.760,NULL,NULL,NULL,3.760,NULL,NULL,NULL,NULL,3.760,3.760,0.000,0.000,NULL,NULL,3,0,3.760,0,'2015-10-01 13:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:20','C',3.760,0.000,0.000,0),(961,986,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.570,NULL,NULL,NULL,3.570,NULL,NULL,NULL,NULL,3.570,3.570,0.000,0.000,NULL,NULL,3,0,3.570,0,'2015-10-01 13:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:20','C',3.570,0.000,0.000,0),(962,987,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.990,NULL,NULL,NULL,3.990,NULL,NULL,NULL,NULL,3.990,3.990,0.000,0.000,NULL,NULL,3,0,3.990,0,'2015-10-01 13:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:21','C',3.990,0.000,0.000,0),(963,988,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.990,NULL,NULL,NULL,3.990,NULL,NULL,NULL,NULL,3.990,3.990,0.000,0.000,NULL,NULL,3,0,3.990,0,'2015-10-01 13:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:21','C',3.990,0.000,0.000,0),(964,989,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.070,NULL,NULL,NULL,3.070,NULL,NULL,NULL,NULL,3.070,3.070,0.000,0.000,NULL,NULL,3,0,3.070,0,'2015-10-01 13:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:21','C',3.070,0.000,0.000,0),(965,990,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.440,NULL,NULL,NULL,3.440,NULL,NULL,NULL,NULL,3.440,3.440,0.000,0.000,NULL,NULL,3,0,3.440,0,'2015-10-01 13:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:21','C',3.440,0.000,0.000,0),(966,991,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.490,NULL,NULL,NULL,3.490,NULL,NULL,NULL,NULL,3.490,3.490,0.000,0.000,NULL,NULL,3,0,3.490,0,'2015-10-01 13:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:22','C',3.490,0.000,0.000,0),(967,992,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.320,NULL,NULL,NULL,3.320,NULL,NULL,NULL,NULL,3.320,3.320,0.000,0.000,NULL,NULL,3,0,3.320,0,'2015-10-01 13:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:22','C',3.320,0.000,0.000,0),(968,993,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.490,NULL,NULL,NULL,3.490,NULL,NULL,NULL,NULL,3.490,3.490,0.000,0.000,NULL,NULL,3,0,3.490,0,'2015-10-01 13:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:22','C',3.490,0.000,0.000,0),(969,994,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.320,NULL,NULL,NULL,3.320,NULL,NULL,NULL,NULL,3.320,3.320,0.000,0.000,NULL,NULL,3,0,3.320,0,'2015-10-01 13:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:23','C',3.320,0.000,0.000,0),(970,995,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,21.200,NULL,NULL,NULL,21.200,NULL,NULL,NULL,NULL,21.200,21.200,0.000,0.000,NULL,NULL,3,0,21.200,0,'2015-10-01 13:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:23','C',21.200,0.000,0.000,0),(971,996,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.580,NULL,NULL,NULL,15.580,NULL,NULL,NULL,NULL,15.580,15.580,0.000,0.000,NULL,NULL,3,0,15.580,0,'2015-10-01 13:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:23','C',15.580,0.000,0.000,0),(972,1000,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.140,NULL,NULL,NULL,4.140,NULL,NULL,NULL,NULL,4.140,4.140,0.000,0.000,NULL,NULL,3,0,4.140,0,'2015-10-01 13:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:24','C',4.140,0.000,0.000,0),(973,1001,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.010,NULL,NULL,NULL,8.010,NULL,NULL,NULL,NULL,8.010,8.010,0.000,0.000,NULL,NULL,3,0,8.010,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:24','C',8.010,0.000,0.000,0),(974,1002,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.460,NULL,NULL,NULL,3.460,NULL,NULL,NULL,NULL,3.460,3.460,0.000,0.000,NULL,NULL,3,0,3.460,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:24','C',3.460,0.000,0.000,0),(975,1003,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.170,NULL,NULL,NULL,4.170,NULL,NULL,NULL,NULL,4.170,4.170,0.000,0.000,NULL,NULL,3,0,4.170,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:25','C',4.170,0.000,0.000,0),(976,1004,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,3,0,4.290,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:25','C',4.290,0.000,0.000,0),(977,1005,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.680,NULL,NULL,NULL,5.680,NULL,NULL,NULL,NULL,5.680,5.680,0.000,0.000,NULL,NULL,3,0,5.680,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:25','C',5.680,0.000,0.000,0),(978,1006,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.810,NULL,NULL,NULL,4.810,NULL,NULL,NULL,NULL,4.810,4.810,0.000,0.000,NULL,NULL,3,0,4.810,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:25','C',4.810,0.000,0.000,0),(979,1007,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.380,NULL,NULL,NULL,3.380,NULL,NULL,NULL,NULL,3.380,3.380,0.000,0.000,NULL,NULL,3,0,3.380,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:26','C',3.380,0.000,0.000,0),(980,1008,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.430,NULL,NULL,NULL,6.430,NULL,NULL,NULL,NULL,6.430,6.430,0.000,0.000,NULL,NULL,3,0,6.430,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:26','C',6.430,0.000,0.000,0),(981,997,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,3,0,3.820,0,'2015-10-01 13:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:26','C',3.820,0.000,0.000,0),(982,998,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.550,NULL,NULL,NULL,6.550,NULL,NULL,NULL,NULL,6.550,6.550,0.000,0.000,NULL,NULL,3,0,6.550,0,'2015-10-01 13:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:26','C',6.550,0.000,0.000,0),(983,999,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.080,NULL,NULL,NULL,5.080,NULL,NULL,NULL,NULL,5.080,5.080,0.000,0.000,NULL,NULL,3,0,5.080,0,'2015-10-01 13:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:27','C',5.080,0.000,0.000,0),(984,1009,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.990,NULL,NULL,NULL,3.990,NULL,NULL,NULL,NULL,3.990,3.990,0.000,0.000,NULL,NULL,3,0,3.990,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:27','C',3.990,0.000,0.000,0),(985,1010,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,3,0,4.290,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:27','C',4.290,0.000,0.000,0),(986,1011,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.060,NULL,NULL,NULL,3.060,NULL,NULL,NULL,NULL,3.060,3.060,0.000,0.000,NULL,NULL,3,0,3.060,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:27','C',3.060,0.000,0.000,0),(987,1012,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.830,NULL,NULL,NULL,3.830,NULL,NULL,NULL,NULL,3.830,3.830,0.000,0.000,NULL,NULL,3,0,3.830,0,'2015-10-01 13:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:28','C',3.830,0.000,0.000,0),(988,1013,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.660,NULL,NULL,NULL,8.660,NULL,NULL,NULL,NULL,8.660,8.660,0.000,0.000,NULL,NULL,1,0,8.660,0,'2015-10-01 13:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:28','C',8.660,0.000,0.000,0),(989,1014,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.880,NULL,NULL,NULL,10.880,NULL,NULL,NULL,NULL,10.880,10.880,0.000,0.000,NULL,NULL,1,0,10.880,0,'2015-10-01 13:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:28','C',10.880,0.000,0.000,0),(990,1015,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.160,NULL,NULL,NULL,9.160,NULL,NULL,NULL,NULL,9.160,9.160,0.000,0.000,NULL,NULL,1,0,9.160,0,'2015-10-01 13:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:28','C',9.160,0.000,0.000,0),(991,1016,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.560,NULL,NULL,NULL,7.560,NULL,NULL,NULL,NULL,7.560,7.560,0.000,0.000,NULL,NULL,1,0,7.560,0,'2015-10-01 13:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:29','C',7.560,0.000,0.000,0),(992,1017,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,5,0,1.670,0,'2015-10-03 15:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:29','C',1.670,0.000,0.000,0),(993,1018,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,5,0,1.670,0,'2015-10-03 15:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:29','C',1.670,0.000,0.000,0),(994,1019,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-03 15:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:30','C',0.000,0.000,0.000,0),(995,1020,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-03 15:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:30','C',0.000,0.000,0.000,0),(996,1021,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-03 15:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:30','C',0.000,0.000,0.000,0),(997,1022,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-03 15:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:31','C',0.000,0.000,0.000,0),(998,1023,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.130,NULL,NULL,NULL,5.130,NULL,NULL,NULL,NULL,5.130,5.130,0.000,0.000,NULL,NULL,5,0,5.130,0,'2015-10-03 15:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:31','C',5.130,0.000,0.000,0),(999,1024,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.130,NULL,NULL,NULL,5.130,NULL,NULL,NULL,NULL,5.130,5.130,0.000,0.000,NULL,NULL,5,0,5.130,0,'2015-10-03 15:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:31','C',5.130,0.000,0.000,0),(1000,1025,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:32','C',0.890,0.000,0.000,0),(1001,1026,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.490,NULL,NULL,NULL,0.490,NULL,NULL,NULL,NULL,0.490,0.490,0.000,0.000,NULL,NULL,3,0,0.490,0,'2015-10-03 15:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:32','C',0.490,0.000,0.000,0),(1002,1027,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:32','C',0.890,0.000,0.000,0),(1003,1028,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-10-03 15:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:32','C',0.000,0.000,0.000,0),(1004,1029,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:33','C',0.890,0.000,0.000,0),(1005,1030,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:33','C',0.890,0.000,0.000,0),(1006,1031,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-10-03 15:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:33','C',0.910,0.000,0.000,0),(1007,1032,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-10-03 15:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:33','C',0.910,0.000,0.000,0),(1008,1033,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-10-03 15:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:34','C',0.910,0.000,0.000,0),(1009,1034,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.910,NULL,NULL,NULL,0.910,NULL,NULL,NULL,NULL,0.910,0.910,0.000,0.000,NULL,NULL,1,0,0.910,0,'2015-10-03 15:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:34','C',0.910,0.000,0.000,0),(1010,1036,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.400,NULL,NULL,NULL,5.400,NULL,NULL,NULL,NULL,5.400,5.400,0.000,0.000,NULL,NULL,1,0,5.400,0,'2015-10-03 15:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:34','C',5.400,0.000,0.000,0),(1011,1037,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:34','C',0.890,0.000,0.000,0),(1012,1038,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:35','C',0.890,0.000,0.000,0),(1013,1039,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:35','C',0.890,0.000,0.000,0),(1014,1040,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:35','C',0.890,0.000,0.000,0),(1015,1041,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.890,NULL,NULL,NULL,0.890,NULL,NULL,NULL,NULL,0.890,0.890,0.000,0.000,NULL,NULL,1,0,0.890,0,'2015-10-03 15:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:36','C',0.890,0.000,0.000,0),(1016,1042,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,5,0,1.670,0,'2015-10-03 15:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:36','C',1.670,0.000,0.000,0),(1017,1043,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.610,NULL,NULL,NULL,0.610,NULL,NULL,NULL,NULL,0.610,0.610,0.000,0.000,NULL,NULL,5,0,0.610,0,'2015-10-03 15:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:36','C',0.610,0.000,0.000,0),(1018,1044,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.800,NULL,NULL,NULL,0.800,NULL,NULL,NULL,NULL,0.800,0.800,0.000,0.000,NULL,NULL,5,0,0.800,0,'2015-10-03 15:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:36','C',0.800,0.000,0.000,0),(1019,1045,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.220,NULL,NULL,NULL,8.220,NULL,NULL,NULL,NULL,8.220,8.220,0.000,0.000,NULL,NULL,5,0,8.220,0,'2015-10-03 15:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:37','C',8.220,0.000,0.000,0),(1020,1046,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.490,NULL,NULL,NULL,0.490,NULL,NULL,NULL,NULL,0.490,0.490,0.000,0.000,NULL,NULL,5,0,0.490,0,'2015-10-03 15:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:37','C',0.490,0.000,0.000,0),(1021,1047,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.800,NULL,NULL,NULL,0.800,NULL,NULL,NULL,NULL,0.800,0.800,0.000,0.000,NULL,NULL,5,0,0.800,0,'2015-10-03 15:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:37','C',0.800,0.000,0.000,0),(1022,1048,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.910,NULL,NULL,NULL,4.910,NULL,NULL,NULL,NULL,4.910,4.910,0.000,0.000,NULL,NULL,1,0,4.910,0,'2015-10-03 15:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:37','C',4.910,0.000,0.000,0),(1023,1049,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.910,NULL,NULL,NULL,4.910,NULL,NULL,NULL,NULL,4.910,4.910,0.000,0.000,NULL,NULL,1,0,4.910,0,'2015-10-03 15:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:38','C',4.910,0.000,0.000,0),(1024,1050,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.240,NULL,NULL,NULL,0.240,NULL,NULL,NULL,NULL,0.240,0.240,0.000,0.000,NULL,NULL,5,0,0.240,0,'2015-10-03 15:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:38','C',0.240,0.000,0.000,0),(1025,1051,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.570,NULL,NULL,NULL,0.570,NULL,NULL,NULL,NULL,0.570,0.570,0.000,0.000,NULL,NULL,5,0,0.570,0,'2015-10-03 15:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:38','C',0.570,0.000,0.000,0),(1026,1052,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.240,NULL,NULL,NULL,0.240,NULL,NULL,NULL,NULL,0.240,0.240,0.000,0.000,NULL,NULL,5,0,0.240,0,'2015-10-03 15:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:38','C',0.240,0.000,0.000,0),(1027,1053,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.930,NULL,NULL,NULL,0.930,NULL,NULL,NULL,NULL,0.930,0.930,0.000,0.000,NULL,NULL,1,0,0.930,0,'2015-10-03 15:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:39','C',0.930,0.000,0.000,0),(1028,1054,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,5,0,1.670,0,'2015-10-03 15:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:39','C',1.670,0.000,0.000,0),(1029,1055,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,5,0,1.670,0,'2015-10-03 15:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:39','C',1.670,0.000,0.000,0),(1030,1056,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,5,0,1.670,0,'2015-10-03 15:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:40','C',1.670,0.000,0.000,0),(1031,1057,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,5,0,1.670,0,'2015-10-03 15:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:40','C',1.670,0.000,0.000,0),(1032,1058,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.110,NULL,NULL,NULL,1.110,NULL,NULL,NULL,NULL,1.110,1.110,0.000,0.000,NULL,NULL,5,0,1.110,0,'2015-10-03 15:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:40','C',1.110,0.000,0.000,0),(1033,1059,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.630,NULL,NULL,NULL,1.630,NULL,NULL,NULL,NULL,1.630,1.630,0.000,0.000,NULL,NULL,5,0,1.630,0,'2015-10-03 15:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:40','C',1.630,0.000,0.000,0),(1034,1060,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.990,NULL,NULL,NULL,0.990,NULL,NULL,NULL,NULL,0.990,0.990,0.000,0.000,NULL,NULL,5,0,0.990,0,'2015-10-03 15:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:41','C',0.990,0.000,0.000,0),(1035,1061,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.110,NULL,NULL,NULL,1.110,NULL,NULL,NULL,NULL,1.110,1.110,0.000,0.000,NULL,NULL,1,0,1.110,0,'2015-10-03 15:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:41','C',1.110,0.000,0.000,0),(1036,1062,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.430,NULL,NULL,NULL,0.430,NULL,NULL,NULL,NULL,0.430,0.430,0.000,0.000,NULL,NULL,1,0,0.430,0,'2015-10-03 15:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:41','C',0.430,0.000,0.000,0),(1037,1063,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.160,NULL,NULL,NULL,1.160,NULL,NULL,NULL,NULL,1.160,1.160,0.000,0.000,NULL,NULL,5,0,1.160,0,'2015-10-03 16:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:41','C',1.160,0.000,0.000,0),(1038,1064,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.450,NULL,NULL,NULL,1.450,NULL,NULL,NULL,NULL,1.450,1.450,0.000,0.000,NULL,NULL,1,0,1.450,0,'2015-10-03 16:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:42','C',1.450,0.000,0.000,0),(1039,1065,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.620,NULL,NULL,NULL,1.620,NULL,NULL,NULL,NULL,1.620,1.620,0.000,0.000,NULL,NULL,5,0,1.620,0,'2015-10-03 16:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:42','C',1.620,0.000,0.000,0),(1040,1066,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.990,NULL,NULL,NULL,0.990,NULL,NULL,NULL,NULL,0.990,0.990,0.000,0.000,NULL,NULL,1,0,0.990,0,'2015-10-03 16:02:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:42','C',0.990,0.000,0.000,0),(1041,1067,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,NULL,0,0.000,0,'2015-10-03 16:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:42','C',0.000,0.000,0.000,0),(1042,1068,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.080,NULL,NULL,NULL,1.080,NULL,NULL,NULL,NULL,1.080,1.080,0.000,0.000,NULL,NULL,1,0,1.080,0,'2015-10-03 16:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:43','C',1.080,0.000,0.000,0),(1043,1069,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.080,NULL,NULL,NULL,1.080,NULL,NULL,NULL,NULL,1.080,1.080,0.000,0.000,NULL,NULL,1,0,1.080,0,'2015-10-03 16:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:43','C',1.080,0.000,0.000,0),(1044,1070,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.080,NULL,NULL,NULL,1.080,NULL,NULL,NULL,NULL,1.080,1.080,0.000,0.000,NULL,NULL,1,0,1.080,0,'2015-10-03 16:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:43','C',1.080,0.000,0.000,0),(1045,1071,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.070,NULL,NULL,NULL,0.070,NULL,NULL,NULL,NULL,0.070,0.070,0.000,0.000,NULL,NULL,5,0,0.070,0,'2015-10-03 16:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:44','C',0.070,0.000,0.000,0),(1046,1072,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.580,NULL,NULL,NULL,2.580,NULL,NULL,NULL,NULL,2.580,2.580,0.000,0.000,NULL,NULL,1,0,2.580,0,'2015-10-03 16:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:53','C',2.580,0.000,0.000,0),(1047,1073,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.620,NULL,NULL,NULL,1.620,NULL,NULL,NULL,NULL,1.620,1.620,0.000,0.000,NULL,NULL,1,0,1.620,0,'2015-10-03 16:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:53','C',1.620,0.000,0.000,0),(1048,1074,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,1,0,3.740,0,'2015-10-03 16:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:53','C',3.740,0.000,0.000,0),(1049,1075,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.870,NULL,NULL,NULL,18.870,NULL,NULL,NULL,NULL,18.870,18.870,0.000,0.000,NULL,NULL,1,0,18.870,0,'2015-10-03 16:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:53','C',18.870,0.000,0.000,0),(1050,1076,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,19.360,NULL,NULL,NULL,19.360,NULL,NULL,NULL,NULL,19.360,19.360,0.000,0.000,NULL,NULL,3,0,19.360,0,'2015-10-03 16:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:54','C',19.360,0.000,0.000,0),(1051,1077,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.920,NULL,NULL,NULL,18.920,NULL,NULL,NULL,NULL,18.920,18.920,0.000,0.000,NULL,NULL,3,0,18.920,0,'2015-10-03 16:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:54','C',18.920,0.000,0.000,0),(1052,1078,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.700,NULL,NULL,NULL,18.700,NULL,NULL,NULL,NULL,18.700,18.700,0.000,0.000,NULL,NULL,3,0,18.700,0,'2015-10-03 16:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:54','C',18.700,0.000,0.000,0),(1053,1079,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.700,NULL,NULL,NULL,18.700,NULL,NULL,NULL,NULL,18.700,18.700,0.000,0.000,NULL,NULL,3,0,18.700,0,'2015-10-03 16:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:55','C',18.700,0.000,0.000,0),(1054,1080,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,22.000,NULL,NULL,NULL,22.000,NULL,NULL,NULL,NULL,22.000,22.000,0.000,0.000,NULL,NULL,3,0,22.000,0,'2015-10-03 16:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:55','C',22.000,0.000,0.000,0),(1055,1081,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,22.000,NULL,NULL,NULL,22.000,NULL,NULL,NULL,NULL,22.000,22.000,0.000,0.000,NULL,NULL,3,0,22.000,0,'2015-10-03 16:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:55','C',22.000,0.000,0.000,0),(1056,1082,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,35.980,NULL,NULL,NULL,35.980,NULL,NULL,NULL,NULL,35.980,35.980,0.000,0.000,NULL,NULL,3,0,35.980,0,'2015-10-03 16:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:55','C',35.980,0.000,0.000,0),(1057,1083,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,30.580,NULL,NULL,NULL,30.580,NULL,NULL,NULL,NULL,30.580,30.580,0.000,0.000,NULL,NULL,3,0,30.580,0,'2015-10-03 16:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:56','C',30.580,0.000,0.000,0),(1058,1084,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,1,0,1.670,0,'2015-10-07 21:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:56','C',1.670,0.000,0.000,0),(1059,1085,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.020,NULL,NULL,NULL,2.020,NULL,NULL,NULL,NULL,2.020,2.020,0.000,0.000,NULL,NULL,5,0,2.020,0,'2015-10-07 21:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:56','C',2.020,0.000,0.000,0),(1060,1086,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.670,NULL,NULL,NULL,1.670,NULL,NULL,NULL,NULL,1.670,1.670,0.000,0.000,NULL,NULL,5,0,1.670,0,'2015-10-07 21:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:57','C',1.670,0.000,0.000,0),(1061,1087,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.060,NULL,NULL,NULL,2.060,NULL,NULL,NULL,NULL,2.060,2.060,0.000,0.000,NULL,NULL,5,0,2.060,0,'2015-10-07 21:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:57','C',2.060,0.000,0.000,0),(1062,1088,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.060,NULL,NULL,NULL,2.060,NULL,NULL,NULL,NULL,2.060,2.060,0.000,0.000,NULL,NULL,5,0,2.060,0,'2015-10-07 21:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:57','C',2.060,0.000,0.000,0),(1063,1089,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.370,NULL,NULL,NULL,14.370,NULL,NULL,NULL,NULL,14.370,14.370,0.000,0.000,NULL,NULL,5,0,14.370,0,'2015-10-07 21:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:57','C',14.370,0.000,0.000,0),(1064,1090,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.370,NULL,NULL,NULL,14.370,NULL,NULL,NULL,NULL,14.370,14.370,0.000,0.000,NULL,NULL,5,0,14.370,0,'2015-10-07 21:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:58','C',14.370,0.000,0.000,0),(1065,1091,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.370,NULL,NULL,NULL,14.370,NULL,NULL,NULL,NULL,14.370,14.370,0.000,0.000,NULL,NULL,1,0,14.370,0,'2015-10-07 21:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:58','C',14.370,0.000,0.000,0),(1066,1092,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,67.280,NULL,NULL,NULL,67.280,NULL,NULL,NULL,NULL,67.280,67.280,0.000,0.000,NULL,NULL,5,0,67.280,0,'2015-10-07 21:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:58','C',67.280,0.000,0.000,0),(1067,1093,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,70.130,NULL,NULL,NULL,70.130,NULL,NULL,NULL,NULL,70.130,70.130,0.000,0.000,NULL,NULL,5,0,70.130,0,'2015-10-07 21:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:58','C',70.130,0.000,0.000,0),(1068,1094,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,67.280,NULL,NULL,NULL,67.280,NULL,NULL,NULL,NULL,67.280,67.280,0.000,0.000,NULL,NULL,5,0,67.280,0,'2015-10-07 21:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:59','C',67.280,0.000,0.000,0),(1069,1095,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,70.130,NULL,NULL,NULL,70.130,NULL,NULL,NULL,NULL,70.130,70.130,0.000,0.000,NULL,NULL,5,0,70.130,0,'2015-10-07 21:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:59','C',70.130,0.000,0.000,0),(1070,1096,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.690,NULL,NULL,NULL,0.690,NULL,NULL,NULL,NULL,0.690,0.690,0.000,0.000,NULL,NULL,1,0,0.690,0,'2015-10-07 21:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:06:59','C',0.690,0.000,0.000,0),(1071,1097,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,20.130,NULL,NULL,NULL,20.130,NULL,NULL,NULL,NULL,20.130,20.130,0.000,0.000,NULL,NULL,1,0,20.130,0,'2015-10-07 21:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:00','C',20.130,0.000,0.000,0),(1072,1098,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,19.280,NULL,NULL,NULL,19.280,NULL,NULL,NULL,NULL,19.280,19.280,0.000,0.000,NULL,NULL,1,0,19.280,0,'2015-10-07 21:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:00','C',19.280,0.000,0.000,0),(1073,1099,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,27.020,NULL,NULL,NULL,27.020,NULL,NULL,NULL,NULL,27.020,27.020,0.000,0.000,NULL,NULL,1,0,27.020,0,'2015-10-07 21:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:00','C',27.020,0.000,0.000,0),(1074,1100,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,28.160,NULL,NULL,NULL,28.160,NULL,NULL,NULL,NULL,28.160,28.160,0.000,0.000,NULL,NULL,1,0,28.160,0,'2015-10-07 21:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:00','C',28.160,0.000,0.000,0),(1075,1101,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.920,NULL,NULL,NULL,0.920,NULL,NULL,NULL,NULL,0.920,0.920,0.000,0.000,NULL,NULL,1,0,0.920,0,'2015-10-07 21:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:01','C',0.920,0.000,0.000,0),(1076,1102,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.170,NULL,NULL,NULL,18.170,NULL,NULL,NULL,NULL,18.170,18.170,0.000,0.000,NULL,NULL,5,0,18.170,0,'2015-10-07 21:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:01','C',18.170,0.000,0.000,0),(1077,1103,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,21.860,NULL,NULL,NULL,21.860,NULL,NULL,NULL,NULL,21.860,21.860,0.000,0.000,NULL,NULL,5,0,21.860,0,'2015-10-07 21:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:01','C',21.860,0.000,0.000,0),(1078,1104,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,22.780,NULL,NULL,NULL,22.780,NULL,NULL,NULL,NULL,22.780,22.780,0.000,0.000,NULL,NULL,5,0,22.780,0,'2015-10-07 21:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:01','C',22.780,0.000,0.000,0),(1079,1105,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.500,NULL,NULL,NULL,2.500,NULL,NULL,NULL,NULL,2.500,2.500,0.000,0.000,NULL,NULL,1,0,2.500,0,'2015-10-08 06:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:02','C',2.500,0.000,0.000,0),(1080,1106,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.710,NULL,NULL,NULL,4.710,NULL,NULL,NULL,NULL,4.710,4.710,0.000,0.000,NULL,NULL,1,0,4.710,0,'2015-10-08 06:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:02','C',4.710,0.000,0.000,0),(1081,1107,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.710,NULL,NULL,NULL,4.710,NULL,NULL,NULL,NULL,4.710,4.710,0.000,0.000,NULL,NULL,1,0,4.710,0,'2015-10-08 06:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:02','C',4.710,0.000,0.000,0),(1082,1108,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.710,NULL,NULL,NULL,4.710,NULL,NULL,NULL,NULL,4.710,4.710,0.000,0.000,NULL,NULL,1,0,4.710,0,'2015-10-08 06:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:03','C',4.710,0.000,0.000,0),(1083,1109,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',0,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,-22.000,NULL,NULL,NULL,-22.000,NULL,NULL,NULL,NULL,-22.000,-22.000,0.000,0.000,NULL,NULL,1,1,22.000,0,'2015-10-08 06:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:03','C',-22.000,0.000,0.000,0),(1084,1110,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,-22.000,NULL,NULL,NULL,-22.000,NULL,NULL,NULL,NULL,-22.000,-22.000,0.000,0.000,NULL,NULL,1,1,22.000,0,'2015-10-08 06:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:03','C',-22.000,0.000,0.000,0),(1085,1111,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.500,NULL,NULL,NULL,2.500,NULL,NULL,NULL,NULL,2.500,2.500,0.000,0.000,NULL,NULL,1,0,2.500,0,'2015-10-08 06:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:03','C',2.500,0.000,0.000,0),(1086,1112,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.710,NULL,NULL,NULL,4.710,NULL,NULL,NULL,NULL,4.710,4.710,0.000,0.000,NULL,NULL,1,0,4.710,0,'2015-10-08 06:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:04','C',4.710,0.000,0.000,0),(1087,1113,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.830,NULL,NULL,NULL,4.830,NULL,NULL,NULL,NULL,4.830,4.830,0.000,0.000,NULL,NULL,1,0,4.830,0,'2015-10-08 06:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:04','C',4.830,0.000,0.000,0),(1088,1114,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.500,NULL,NULL,NULL,2.500,NULL,NULL,NULL,NULL,2.500,2.500,0.000,0.000,NULL,NULL,5,0,2.500,0,'2015-10-08 06:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:04','C',2.500,0.000,0.000,0),(1089,1115,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.440,NULL,NULL,NULL,2.440,NULL,NULL,NULL,NULL,2.440,2.440,0.000,0.000,NULL,NULL,5,0,2.440,0,'2015-10-08 06:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:04','C',2.440,0.000,0.000,0),(1090,1116,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.350,NULL,NULL,NULL,5.350,NULL,NULL,NULL,NULL,5.350,5.350,0.000,0.000,NULL,NULL,5,0,5.350,0,'2015-10-08 06:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:05','C',5.350,0.000,0.000,0),(1091,1117,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.540,NULL,NULL,NULL,0.540,NULL,NULL,NULL,NULL,0.540,0.540,0.000,0.000,NULL,NULL,5,0,0.540,0,'2015-10-08 06:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:05','C',0.540,0.000,0.000,0),(1092,1118,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.460,NULL,NULL,NULL,5.460,NULL,NULL,NULL,NULL,5.460,5.460,0.000,0.000,NULL,NULL,1,0,5.460,0,'2015-10-08 06:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:05','C',5.460,0.000,0.000,0),(1093,1119,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.370,NULL,NULL,NULL,3.370,NULL,NULL,NULL,NULL,3.370,3.370,0.000,0.000,NULL,NULL,1,0,3.370,0,'2015-10-08 06:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:06','C',3.370,0.000,0.000,0),(1094,1120,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,1,0,3.400,0,'2015-10-08 06:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:06','C',3.400,0.000,0.000,0),(1095,1121,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,1,0,3.400,0,'2015-10-08 06:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:06','C',3.400,0.000,0.000,0),(1096,1122,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.370,NULL,NULL,NULL,3.370,NULL,NULL,NULL,NULL,3.370,3.370,0.000,0.000,NULL,NULL,1,0,3.370,0,'2015-10-08 06:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:07','C',3.370,0.000,0.000,0),(1097,1123,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.370,NULL,NULL,NULL,3.370,NULL,NULL,NULL,NULL,3.370,3.370,0.000,0.000,NULL,NULL,1,0,3.370,0,'2015-10-08 06:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:07','C',3.370,0.000,0.000,0),(1098,1124,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-08 06:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:07','C',3.470,0.000,0.000,0),(1099,1125,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,1,0,3.300,0,'2015-10-08 06:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:07','C',3.300,0.000,0.000,0),(1100,1126,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.520,NULL,NULL,NULL,3.520,NULL,NULL,NULL,NULL,3.520,3.520,0.000,0.000,NULL,NULL,1,0,3.520,0,'2015-10-08 06:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:08','C',3.520,0.000,0.000,0),(1101,1127,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-08 06:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:08','C',3.610,0.000,0.000,0),(1102,1128,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-08 06:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:08','C',3.610,0.000,0.000,0),(1103,1129,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.260,NULL,NULL,NULL,3.260,NULL,NULL,NULL,NULL,3.260,3.260,0.000,0.000,NULL,NULL,1,0,3.260,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:09','C',3.260,0.000,0.000,0),(1104,1130,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,1,0,3.280,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:09','C',3.280,0.000,0.000,0),(1105,1131,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:09','C',3.660,0.000,0.000,0),(1106,1132,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:09','C',3.590,0.000,0.000,0),(1107,1133,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.730,NULL,NULL,NULL,3.730,NULL,NULL,NULL,NULL,3.730,3.730,0.000,0.000,NULL,NULL,1,0,3.730,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:10','C',3.730,0.000,0.000,0),(1108,1134,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,1,0,3.750,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:10','C',3.750,0.000,0.000,0),(1109,1135,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.800,NULL,NULL,NULL,3.800,NULL,NULL,NULL,NULL,3.800,3.800,0.000,0.000,NULL,NULL,1,0,3.800,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:10','C',3.800,0.000,0.000,0),(1110,1136,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:10','C',3.470,0.000,0.000,0),(1111,1137,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,1,0,3.750,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:11','C',3.750,0.000,0.000,0),(1112,1138,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,1,0,3.330,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:11','C',3.330,0.000,0.000,0),(1113,1139,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:11','C',3.630,0.000,0.000,0),(1114,1140,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:12','C',3.630,0.000,0.000,0),(1115,1141,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:12','C',3.560,0.000,0.000,0),(1116,1142,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.230,NULL,NULL,NULL,3.230,NULL,NULL,NULL,NULL,3.230,3.230,0.000,0.000,NULL,NULL,1,0,3.230,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:12','C',3.230,0.000,0.000,0),(1117,1143,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,1,0,3.280,0,'2015-10-08 06:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:13','C',3.280,0.000,0.000,0),(1118,1144,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,1,0,3.280,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:13','C',3.280,0.000,0.000,0),(1119,1145,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:13','C',3.630,0.000,0.000,0),(1120,1146,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:13','C',3.590,0.000,0.000,0),(1121,1147,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.730,NULL,NULL,NULL,3.730,NULL,NULL,NULL,NULL,3.730,3.730,0.000,0.000,NULL,NULL,1,0,3.730,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:14','C',3.730,0.000,0.000,0),(1122,1148,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:14','C',3.560,0.000,0.000,0),(1123,1149,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,1,0,3.300,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:14','C',3.300,0.000,0.000,0),(1124,1150,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:14','C',3.630,0.000,0.000,0),(1125,1151,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:15','C',3.630,0.000,0.000,0),(1126,1152,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.490,NULL,NULL,NULL,3.490,NULL,NULL,NULL,NULL,3.490,3.490,0.000,0.000,NULL,NULL,1,0,3.490,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:15','C',3.490,0.000,0.000,0),(1127,1153,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,1,0,3.400,0,'2015-10-08 06:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:15','C',3.400,0.000,0.000,0),(1128,1154,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-10-08 06:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:15','C',0.000,0.000,0.000,0),(1129,1155,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-10-08 06:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:16','C',0.000,0.000,0.000,0),(1130,1156,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-10-08 06:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:16','C',0.000,0.000,0.000,0),(1131,1157,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-10-08 07:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:16','C',0.000,0.000,0.000,0),(1132,1158,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-08 07:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:17','C',3.560,0.000,0.000,0),(1133,1159,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-08 07:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:17','C',3.780,0.000,0.000,0),(1134,1160,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,1,0,3.630,0,'2015-10-08 07:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:17','C',3.630,0.000,0.000,0),(1135,1161,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,1,0,3.300,0,'2015-10-08 07:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:17','C',3.300,0.000,0.000,0),(1136,1162,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.070,NULL,NULL,NULL,3.070,NULL,NULL,NULL,NULL,3.070,3.070,0.000,0.000,NULL,NULL,1,0,3.070,0,'2015-10-08 07:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:18','C',3.070,0.000,0.000,0),(1137,1163,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.470,NULL,NULL,NULL,3.470,NULL,NULL,NULL,NULL,3.470,3.470,0.000,0.000,NULL,NULL,1,0,3.470,0,'2015-10-08 07:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:18','C',3.470,0.000,0.000,0),(1138,1164,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,1,0,3.450,0,'2015-10-08 07:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:18','C',3.450,0.000,0.000,0),(1139,1165,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.370,NULL,NULL,NULL,3.370,NULL,NULL,NULL,NULL,3.370,3.370,0.000,0.000,NULL,NULL,1,0,3.370,0,'2015-10-08 07:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:18','C',3.370,0.000,0.000,0),(1140,1166,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.410,NULL,NULL,NULL,2.410,NULL,NULL,NULL,NULL,2.410,2.410,0.000,0.000,NULL,NULL,1,0,2.410,0,'2015-10-08 07:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:19','C',2.410,0.000,0.000,0),(1141,1167,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.710,NULL,NULL,NULL,3.710,NULL,NULL,NULL,NULL,3.710,3.710,0.000,0.000,NULL,NULL,1,0,3.710,0,'2015-10-08 07:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:19','C',3.710,0.000,0.000,0),(1142,1168,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-08 07:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:19','C',3.660,0.000,0.000,0),(1143,1169,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.730,NULL,NULL,NULL,3.730,NULL,NULL,NULL,NULL,3.730,3.730,0.000,0.000,NULL,NULL,1,0,3.730,0,'2015-10-08 07:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:20','C',3.730,0.000,0.000,0),(1144,1170,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:20','C',3.560,0.000,0.000,0),(1145,1171,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,1,0,3.750,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:20','C',3.750,0.000,0.000,0),(1146,1172,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.490,NULL,NULL,NULL,3.490,NULL,NULL,NULL,NULL,3.490,3.490,0.000,0.000,NULL,NULL,1,0,3.490,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:31','C',3.490,0.000,0.000,0),(1147,1173,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:32','C',3.590,0.000,0.000,0),(1148,1174,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,1,0,3.400,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:32','C',3.400,0.000,0.000,0),(1149,1175,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.680,NULL,NULL,NULL,3.680,NULL,NULL,NULL,NULL,3.680,3.680,0.000,0.000,NULL,NULL,1,0,3.680,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:32','C',3.680,0.000,0.000,0),(1150,1176,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:33','C',3.590,0.000,0.000,0),(1151,1177,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,1,0,3.560,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:33','C',3.560,0.000,0.000,0),(1152,1178,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.160,NULL,NULL,NULL,3.160,NULL,NULL,NULL,NULL,3.160,3.160,0.000,0.000,NULL,NULL,1,0,3.160,0,'2015-10-08 07:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:33','C',3.160,0.000,0.000,0),(1153,1179,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.730,NULL,NULL,NULL,3.730,NULL,NULL,NULL,NULL,3.730,3.730,0.000,0.000,NULL,NULL,1,0,3.730,0,'2015-10-08 07:07:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:33','C',3.730,0.000,0.000,0),(1154,1180,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.710,NULL,NULL,NULL,3.710,NULL,NULL,NULL,NULL,3.710,3.710,0.000,0.000,NULL,NULL,1,0,3.710,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:34','C',3.710,0.000,0.000,0),(1155,1181,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:34','C',3.610,0.000,0.000,0),(1156,1182,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:34','C',3.590,0.000,0.000,0),(1157,1183,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.710,NULL,NULL,NULL,3.710,NULL,NULL,NULL,NULL,3.710,3.710,0.000,0.000,NULL,NULL,1,0,3.710,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:34','C',3.710,0.000,0.000,0),(1158,1184,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.420,NULL,NULL,NULL,3.420,NULL,NULL,NULL,NULL,3.420,3.420,0.000,0.000,NULL,NULL,1,0,3.420,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:35','C',3.420,0.000,0.000,0),(1159,1185,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,1,0,3.400,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:35','C',3.400,0.000,0.000,0),(1160,1186,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:35','C',3.590,0.000,0.000,0),(1161,1187,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,1,0,3.450,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:36','C',3.450,0.000,0.000,0),(1162,1188,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.730,NULL,NULL,NULL,3.730,NULL,NULL,NULL,NULL,3.730,3.730,0.000,0.000,NULL,NULL,1,0,3.730,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:36','C',3.730,0.000,0.000,0),(1163,1189,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.490,NULL,NULL,NULL,3.490,NULL,NULL,NULL,NULL,3.490,3.490,0.000,0.000,NULL,NULL,1,0,3.490,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:36','C',3.490,0.000,0.000,0),(1164,1190,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:36','C',3.660,0.000,0.000,0),(1165,1191,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,1,0,3.450,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:37','C',3.450,0.000,0.000,0),(1166,1192,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:37','C',3.780,0.000,0.000,0),(1167,1193,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:37','C',3.610,0.000,0.000,0),(1168,1194,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.710,NULL,NULL,NULL,3.710,NULL,NULL,NULL,NULL,3.710,3.710,0.000,0.000,NULL,NULL,1,0,3.710,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:38','C',3.710,0.000,0.000,0),(1169,1195,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.610,NULL,NULL,NULL,3.610,NULL,NULL,NULL,NULL,3.610,3.610,0.000,0.000,NULL,NULL,1,0,3.610,0,'2015-10-08 07:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:38','C',3.610,0.000,0.000,0),(1170,1196,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.730,NULL,NULL,NULL,3.730,NULL,NULL,NULL,NULL,3.730,3.730,0.000,0.000,NULL,NULL,1,0,3.730,0,'2015-10-08 07:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:38','C',3.730,0.000,0.000,0),(1171,1197,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 07:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:38','C',4.270,0.000,0.000,0),(1172,1198,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:39','C',4.190,0.000,0.000,0),(1173,1199,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,1,0,3.750,0,'2015-10-08 07:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:39','C',3.750,0.000,0.000,0),(1174,1200,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:39','C',4.190,0.000,0.000,0),(1175,1201,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.830,NULL,NULL,NULL,3.830,NULL,NULL,NULL,NULL,3.830,3.830,0.000,0.000,NULL,NULL,1,0,3.830,0,'2015-10-08 07:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:39','C',3.830,0.000,0.000,0),(1176,1202,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,1,0,3.890,0,'2015-10-08 07:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:40','C',3.890,0.000,0.000,0),(1177,1203,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,1,0,3.890,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:40','C',3.890,0.000,0.000,0),(1178,1204,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:40','C',4.290,0.000,0.000,0),(1179,1205,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.370,NULL,NULL,NULL,4.370,NULL,NULL,NULL,NULL,4.370,4.370,0.000,0.000,NULL,NULL,1,0,4.370,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:40','C',4.370,0.000,0.000,0),(1180,1206,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:41','C',4.080,0.000,0.000,0),(1181,1207,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:41','C',4.100,0.000,0.000,0),(1182,1208,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:41','C',4.270,0.000,0.000,0),(1183,1209,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:41','C',4.190,0.000,0.000,0),(1184,1210,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:42','C',4.190,0.000,0.000,0),(1185,1211,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:42','C',4.270,0.000,0.000,0),(1186,1212,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:42','C',4.190,0.000,0.000,0),(1187,1213,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:43','C',4.210,0.000,0.000,0),(1188,1214,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.350,NULL,NULL,NULL,4.350,NULL,NULL,NULL,NULL,4.350,4.350,0.000,0.000,NULL,NULL,1,0,4.350,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:43','C',4.350,0.000,0.000,0),(1189,1215,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:43','C',4.290,0.000,0.000,0),(1190,1216,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:43','C',4.190,0.000,0.000,0),(1191,1217,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:44','C',4.000,0.000,0.000,0),(1192,1218,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-08 07:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:44','C',4.210,0.000,0.000,0),(1193,1219,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:44','C',4.100,0.000,0.000,0),(1194,1220,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:44','C',4.160,0.000,0.000,0),(1195,1221,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:45','C',4.100,0.000,0.000,0),(1196,1222,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.860,NULL,NULL,NULL,3.860,NULL,NULL,NULL,NULL,3.860,3.860,0.000,0.000,NULL,NULL,1,0,3.860,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:45','C',3.860,0.000,0.000,0),(1197,1223,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:45','C',4.190,0.000,0.000,0),(1198,1224,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:46','C',4.190,0.000,0.000,0),(1199,1225,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:46','C',4.290,0.000,0.000,0),(1200,1226,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:46','C',4.080,0.000,0.000,0),(1201,1227,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.320,NULL,NULL,NULL,4.320,NULL,NULL,NULL,NULL,4.320,4.320,0.000,0.000,NULL,NULL,1,0,4.320,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:46','C',4.320,0.000,0.000,0),(1202,1228,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:47','C',4.020,0.000,0.000,0),(1203,1229,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:47','C',3.970,0.000,0.000,0),(1204,1230,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:47','C',4.080,0.000,0.000,0),(1205,1231,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,1,0,3.890,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:47','C',3.890,0.000,0.000,0),(1206,1232,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-08 07:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:48','C',4.210,0.000,0.000,0),(1207,1233,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:48','C',4.240,0.000,0.000,0),(1208,1234,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.050,NULL,NULL,NULL,4.050,NULL,NULL,NULL,NULL,4.050,4.050,0.000,0.000,NULL,NULL,1,0,4.050,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:48','C',4.050,0.000,0.000,0),(1209,1235,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.320,NULL,NULL,NULL,4.320,NULL,NULL,NULL,NULL,4.320,4.320,0.000,0.000,NULL,NULL,1,0,4.320,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:49','C',4.320,0.000,0.000,0),(1210,1236,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:49','C',4.240,0.000,0.000,0),(1211,1237,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:49','C',4.290,0.000,0.000,0),(1212,1238,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:50','C',4.080,0.000,0.000,0),(1213,1239,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:50','C',4.290,0.000,0.000,0),(1214,1240,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:50','C',4.290,0.000,0.000,0),(1215,1241,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:50','C',4.290,0.000,0.000,0),(1216,1242,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:51','C',4.160,0.000,0.000,0),(1217,1243,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:51','C',4.020,0.000,0.000,0),(1218,1244,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.510,NULL,NULL,NULL,4.510,NULL,NULL,NULL,NULL,4.510,4.510,0.000,0.000,NULL,NULL,1,0,4.510,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:51','C',4.510,0.000,0.000,0),(1219,1245,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.810,NULL,NULL,NULL,3.810,NULL,NULL,NULL,NULL,3.810,3.810,0.000,0.000,NULL,NULL,1,0,3.810,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:51','C',3.810,0.000,0.000,0),(1220,1246,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:52','C',4.290,0.000,0.000,0),(1221,1247,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.810,NULL,NULL,NULL,3.810,NULL,NULL,NULL,NULL,3.810,3.810,0.000,0.000,NULL,NULL,1,0,3.810,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:52','C',3.810,0.000,0.000,0),(1222,1248,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:52','C',4.020,0.000,0.000,0),(1223,1249,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:53','C',4.080,0.000,0.000,0),(1224,1250,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-08 07:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:53','C',4.160,0.000,0.000,0),(1225,1251,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:53','C',4.100,0.000,0.000,0),(1226,1252,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:53','C',4.240,0.000,0.000,0),(1227,1253,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:54','C',4.210,0.000,0.000,0),(1228,1254,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:54','C',3.970,0.000,0.000,0),(1229,1255,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:54','C',3.970,0.000,0.000,0),(1230,1256,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:54','C',4.100,0.000,0.000,0),(1231,1257,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:55','C',4.130,0.000,0.000,0),(1232,1258,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:55','C',4.190,0.000,0.000,0),(1233,1259,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:55','C',4.160,0.000,0.000,0),(1234,1260,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.920,NULL,NULL,NULL,3.920,NULL,NULL,NULL,NULL,3.920,3.920,0.000,0.000,NULL,NULL,1,0,3.920,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:56','C',3.920,0.000,0.000,0),(1235,1261,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:56','C',4.160,0.000,0.000,0),(1236,1262,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-08 07:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:56','C',4.000,0.000,0.000,0),(1237,1263,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:57','C',3.970,0.000,0.000,0),(1238,1264,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:57','C',4.290,0.000,0.000,0),(1239,1265,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:57','C',4.100,0.000,0.000,0),(1240,1266,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:58','C',4.080,0.000,0.000,0),(1241,1267,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.940,NULL,NULL,NULL,3.940,NULL,NULL,NULL,NULL,3.940,3.940,0.000,0.000,NULL,NULL,1,0,3.940,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:58','C',3.940,0.000,0.000,0),(1242,1268,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:58','C',4.270,0.000,0.000,0),(1243,1269,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:58','C',4.270,0.000,0.000,0),(1244,1270,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:59','C',4.160,0.000,0.000,0),(1245,1271,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:07:59','C',3.970,0.000,0.000,0),(1246,1272,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:08','C',4.190,0.000,0.000,0),(1247,1273,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:08','C',4.160,0.000,0.000,0),(1248,1274,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.350,NULL,NULL,NULL,4.350,NULL,NULL,NULL,NULL,4.350,4.350,0.000,0.000,NULL,NULL,1,0,4.350,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:08','C',4.350,0.000,0.000,0),(1249,1275,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:09','C',4.020,0.000,0.000,0),(1250,1276,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.290,NULL,NULL,NULL,4.290,NULL,NULL,NULL,NULL,4.290,4.290,0.000,0.000,NULL,NULL,1,0,4.290,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:09','C',4.290,0.000,0.000,0),(1251,1277,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:09','C',4.130,0.000,0.000,0),(1252,1278,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:10','C',4.270,0.000,0.000,0),(1253,1279,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.160,NULL,NULL,NULL,4.160,NULL,NULL,NULL,NULL,4.160,4.160,0.000,0.000,NULL,NULL,1,0,4.160,0,'2015-10-08 07:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:10','C',4.160,0.000,0.000,0),(1254,1280,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-08 07:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:10','C',4.240,0.000,0.000,0),(1255,1281,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-08 07:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:10','C',4.240,0.000,0.000,0),(1256,1282,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,1,0,4.130,0,'2015-10-08 07:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:11','C',4.130,0.000,0.000,0),(1257,1283,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:11','C',4.190,0.000,0.000,0),(1258,1284,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,1,0,4.240,0,'2015-10-08 07:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:11','C',4.240,0.000,0.000,0),(1259,1285,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.100,NULL,NULL,NULL,4.100,NULL,NULL,NULL,NULL,4.100,4.100,0.000,0.000,NULL,NULL,1,0,4.100,0,'2015-10-08 07:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:11','C',4.100,0.000,0.000,0),(1260,1286,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,1,0,4.190,0,'2015-10-08 07:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:12','C',4.190,0.000,0.000,0),(1261,1287,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-10-08 07:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:12','C',0.000,0.000,0.000,0),(1262,1288,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-10-08 07:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:12','C',0.000,0.000,0.000,0),(1263,1289,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,1,0,0.000,0,'2015-10-08 07:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:13','C',0.000,0.000,0.000,0),(1264,1290,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.850,NULL,NULL,NULL,4.850,NULL,NULL,NULL,NULL,4.850,4.850,0.000,0.000,NULL,NULL,5,0,4.850,0,'2015-10-08 07:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:13','C',4.850,0.000,0.000,0),(1265,1291,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.200,NULL,NULL,NULL,4.200,NULL,NULL,NULL,NULL,4.200,4.200,0.000,0.000,NULL,NULL,5,0,4.200,0,'2015-10-08 07:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:13','C',4.200,0.000,0.000,0),(1266,1292,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.000,NULL,NULL,NULL,8.000,NULL,NULL,NULL,NULL,8.000,8.000,0.000,0.000,NULL,NULL,5,0,8.000,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:13','C',8.000,0.000,0.000,0),(1267,1293,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,5,0,4.000,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:14','C',4.000,0.000,0.000,0),(1268,1294,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.300,NULL,NULL,NULL,5.300,NULL,NULL,NULL,NULL,5.300,5.300,0.000,0.000,NULL,NULL,5,0,5.300,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:14','C',5.300,0.000,0.000,0),(1269,1295,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.300,NULL,NULL,NULL,5.300,NULL,NULL,NULL,NULL,5.300,5.300,0.000,0.000,NULL,NULL,5,0,5.300,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:14','C',5.300,0.000,0.000,0),(1270,1296,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.150,NULL,NULL,NULL,6.150,NULL,NULL,NULL,NULL,6.150,6.150,0.000,0.000,NULL,NULL,5,0,6.150,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:14','C',6.150,0.000,0.000,0),(1271,1297,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.600,NULL,NULL,NULL,5.600,NULL,NULL,NULL,NULL,5.600,5.600,0.000,0.000,NULL,NULL,5,0,5.600,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:15','C',5.600,0.000,0.000,0),(1272,1298,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.550,NULL,NULL,NULL,7.550,NULL,NULL,NULL,NULL,7.550,7.550,0.000,0.000,NULL,NULL,5,0,7.550,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:15','C',7.550,0.000,0.000,0),(1273,1299,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.350,NULL,NULL,NULL,7.350,NULL,NULL,NULL,NULL,7.350,7.350,0.000,0.000,NULL,NULL,5,0,7.350,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:15','C',7.350,0.000,0.000,0),(1274,1300,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.350,NULL,NULL,NULL,6.350,NULL,NULL,NULL,NULL,6.350,6.350,0.000,0.000,NULL,NULL,5,0,6.350,0,'2015-10-08 07:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:16','C',6.350,0.000,0.000,0),(1275,1301,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.400,NULL,NULL,NULL,6.400,NULL,NULL,NULL,NULL,6.400,6.400,0.000,0.000,NULL,NULL,5,0,6.400,0,'2015-10-08 07:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:16','C',6.400,0.000,0.000,0),(1276,1302,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.800,NULL,NULL,NULL,7.800,NULL,NULL,NULL,NULL,7.800,7.800,0.000,0.000,NULL,NULL,5,0,7.800,0,'2015-10-08 07:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:16','C',7.800,0.000,0.000,0),(1277,1303,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.450,NULL,NULL,NULL,6.450,NULL,NULL,NULL,NULL,6.450,6.450,0.000,0.000,NULL,NULL,5,0,6.450,0,'2015-10-08 07:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:16','C',6.450,0.000,0.000,0),(1278,1304,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.470,NULL,NULL,NULL,5.470,NULL,NULL,NULL,NULL,5.470,5.470,0.000,0.000,NULL,NULL,5,0,5.470,0,'2015-10-08 07:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:17','C',5.470,0.000,0.000,0),(1279,1305,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.130,NULL,NULL,NULL,8.130,NULL,NULL,NULL,NULL,8.130,8.130,0.000,0.000,NULL,NULL,5,0,8.130,0,'2015-10-08 07:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:17','C',8.130,0.000,0.000,0),(1280,1306,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.650,NULL,NULL,NULL,9.650,NULL,NULL,NULL,NULL,9.650,9.650,0.000,0.000,NULL,NULL,5,0,9.650,0,'2015-10-08 07:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:17','C',9.650,0.000,0.000,0),(1281,1307,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.290,NULL,NULL,NULL,10.290,NULL,NULL,NULL,NULL,10.290,10.290,0.000,0.000,NULL,NULL,5,0,10.290,0,'2015-10-08 07:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:17','C',10.290,0.000,0.000,0),(1282,1308,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.170,NULL,NULL,NULL,18.170,NULL,NULL,NULL,NULL,18.170,18.170,0.000,0.000,NULL,NULL,5,0,18.170,0,'2015-10-08 07:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:18','C',18.170,0.000,0.000,0),(1283,1309,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.320,NULL,NULL,NULL,14.320,NULL,NULL,NULL,NULL,14.320,14.320,0.000,0.000,NULL,NULL,5,0,14.320,0,'2015-10-08 07:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:18','C',14.320,0.000,0.000,0),(1284,1310,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.770,NULL,NULL,NULL,11.770,NULL,NULL,NULL,NULL,11.770,11.770,0.000,0.000,NULL,NULL,5,0,11.770,0,'2015-10-08 07:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:18','C',11.770,0.000,0.000,0),(1285,1311,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.470,NULL,NULL,NULL,13.470,NULL,NULL,NULL,NULL,13.470,13.470,0.000,0.000,NULL,NULL,5,0,13.470,0,'2015-10-08 07:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:19','C',13.470,0.000,0.000,0),(1286,1312,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.580,NULL,NULL,NULL,10.580,NULL,NULL,NULL,NULL,10.580,10.580,0.000,0.000,NULL,NULL,5,0,10.580,0,'2015-10-08 07:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:19','C',10.580,0.000,0.000,0),(1287,1313,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.920,NULL,NULL,NULL,9.920,NULL,NULL,NULL,NULL,9.920,9.920,0.000,0.000,NULL,NULL,5,0,9.920,0,'2015-10-08 07:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:19','C',9.920,0.000,0.000,0),(1288,1314,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.910,NULL,NULL,NULL,13.910,NULL,NULL,NULL,NULL,13.910,13.910,0.000,0.000,NULL,NULL,5,0,13.910,0,'2015-10-08 07:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:19','C',13.910,0.000,0.000,0),(1289,1315,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.430,NULL,NULL,NULL,11.430,NULL,NULL,NULL,NULL,11.430,11.430,0.000,0.000,NULL,NULL,5,0,11.430,0,'2015-10-08 07:31:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:20','C',11.430,0.000,0.000,0),(1290,1316,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.990,NULL,NULL,NULL,12.990,NULL,NULL,NULL,NULL,12.990,12.990,0.000,0.000,NULL,NULL,5,0,12.990,0,'2015-10-08 07:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:20','C',12.990,0.000,0.000,0),(1291,1317,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,21.790,NULL,NULL,NULL,21.790,NULL,NULL,NULL,NULL,21.790,21.790,0.000,0.000,NULL,NULL,5,0,21.790,0,'2015-10-08 07:32:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:20','C',21.790,0.000,0.000,0),(1292,1318,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.940,NULL,NULL,NULL,12.940,NULL,NULL,NULL,NULL,12.940,12.940,0.000,0.000,NULL,NULL,5,0,12.940,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:20','C',12.940,0.000,0.000,0),(1293,1319,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.490,NULL,NULL,NULL,13.490,NULL,NULL,NULL,NULL,13.490,13.490,0.000,0.000,NULL,NULL,5,0,13.490,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:21','C',13.490,0.000,0.000,0),(1294,1320,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.170,NULL,NULL,NULL,13.170,NULL,NULL,NULL,NULL,13.170,13.170,0.000,0.000,NULL,NULL,5,0,13.170,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:21','C',13.170,0.000,0.000,0),(1295,1321,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.410,NULL,NULL,NULL,3.410,NULL,NULL,NULL,NULL,3.410,3.410,0.000,0.000,NULL,NULL,5,0,3.410,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:21','C',3.410,0.000,0.000,0),(1296,1322,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,5,0,4.770,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:22','C',4.770,0.000,0.000,0),(1297,1323,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.530,NULL,NULL,NULL,3.530,NULL,NULL,NULL,NULL,3.530,3.530,0.000,0.000,NULL,NULL,5,0,3.530,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:22','C',3.530,0.000,0.000,0),(1298,1324,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.890,NULL,NULL,NULL,4.890,NULL,NULL,NULL,NULL,4.890,4.890,0.000,0.000,NULL,NULL,5,0,4.890,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:22','C',4.890,0.000,0.000,0),(1299,1325,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.420,NULL,NULL,NULL,4.420,NULL,NULL,NULL,NULL,4.420,4.420,0.000,0.000,NULL,NULL,5,0,4.420,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:23','C',4.420,0.000,0.000,0),(1300,1326,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,5,0,4.190,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:23','C',4.190,0.000,0.000,0),(1301,1327,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.470,NULL,NULL,NULL,5.470,NULL,NULL,NULL,NULL,5.470,5.470,0.000,0.000,NULL,NULL,5,0,5.470,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:23','C',5.470,0.000,0.000,0),(1302,1328,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.500,NULL,NULL,NULL,4.500,NULL,NULL,NULL,NULL,4.500,4.500,0.000,0.000,NULL,NULL,5,0,4.500,0,'2015-10-08 07:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:23','C',4.500,0.000,0.000,0),(1303,1329,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.930,NULL,NULL,NULL,4.930,NULL,NULL,NULL,NULL,4.930,4.930,0.000,0.000,NULL,NULL,5,0,4.930,0,'2015-10-08 07:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:24','C',4.930,0.000,0.000,0),(1304,1330,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,5,0,4.770,0,'2015-10-08 07:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:24','C',4.770,0.000,0.000,0),(1305,1331,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.860,NULL,NULL,NULL,4.860,NULL,NULL,NULL,NULL,4.860,4.860,0.000,0.000,NULL,NULL,5,0,4.860,0,'2015-10-08 07:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:24','C',4.860,0.000,0.000,0),(1306,1332,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.840,NULL,NULL,NULL,5.840,NULL,NULL,NULL,NULL,5.840,5.840,0.000,0.000,NULL,NULL,5,0,5.840,0,'2015-10-08 07:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:24','C',5.840,0.000,0.000,0),(1307,1333,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.170,NULL,NULL,NULL,4.170,NULL,NULL,NULL,NULL,4.170,4.170,0.000,0.000,NULL,NULL,5,0,4.170,0,'2015-10-08 07:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:25','C',4.170,0.000,0.000,0),(1308,1334,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.610,NULL,NULL,NULL,4.610,NULL,NULL,NULL,NULL,4.610,4.610,0.000,0.000,NULL,NULL,5,0,4.610,0,'2015-10-08 07:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:25','C',4.610,0.000,0.000,0),(1309,1335,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.020,NULL,NULL,NULL,7.020,NULL,NULL,NULL,NULL,7.020,7.020,0.000,0.000,NULL,NULL,5,0,7.020,0,'2015-10-08 07:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:25','C',7.020,0.000,0.000,0),(1310,1336,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.170,NULL,NULL,NULL,4.170,NULL,NULL,NULL,NULL,4.170,4.170,0.000,0.000,NULL,NULL,5,0,4.170,0,'2015-10-08 07:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:25','C',4.170,0.000,0.000,0),(1311,1337,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.400,NULL,NULL,NULL,6.400,NULL,NULL,NULL,NULL,6.400,6.400,0.000,0.000,NULL,NULL,5,0,6.400,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:26','C',6.400,0.000,0.000,0),(1312,1338,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.300,NULL,NULL,NULL,4.300,NULL,NULL,NULL,NULL,4.300,4.300,0.000,0.000,NULL,NULL,5,0,4.300,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:26','C',4.300,0.000,0.000,0),(1313,1339,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.600,NULL,NULL,NULL,5.600,NULL,NULL,NULL,NULL,5.600,5.600,0.000,0.000,NULL,NULL,5,0,5.600,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:26','C',5.600,0.000,0.000,0),(1314,1340,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.550,NULL,NULL,NULL,5.550,NULL,NULL,NULL,NULL,5.550,5.550,0.000,0.000,NULL,NULL,5,0,5.550,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:27','C',5.550,0.000,0.000,0),(1315,1341,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.100,NULL,NULL,NULL,6.100,NULL,NULL,NULL,NULL,6.100,6.100,0.000,0.000,NULL,NULL,5,0,6.100,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:27','C',6.100,0.000,0.000,0),(1316,1342,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.400,NULL,NULL,NULL,8.400,NULL,NULL,NULL,NULL,8.400,8.400,0.000,0.000,NULL,NULL,5,0,8.400,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:27','C',8.400,0.000,0.000,0),(1317,1343,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.000,NULL,NULL,NULL,7.000,NULL,NULL,NULL,NULL,7.000,7.000,0.000,0.000,NULL,NULL,5,0,7.000,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:27','C',7.000,0.000,0.000,0),(1318,1344,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.300,NULL,NULL,NULL,6.300,NULL,NULL,NULL,NULL,6.300,6.300,0.000,0.000,NULL,NULL,5,0,6.300,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:28','C',6.300,0.000,0.000,0),(1319,1345,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.200,NULL,NULL,NULL,5.200,NULL,NULL,NULL,NULL,5.200,5.200,0.000,0.000,NULL,NULL,5,0,5.200,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:28','C',5.200,0.000,0.000,0),(1320,1346,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.400,NULL,NULL,NULL,7.400,NULL,NULL,NULL,NULL,7.400,7.400,0.000,0.000,NULL,NULL,5,0,7.400,0,'2015-10-08 07:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:28','C',7.400,0.000,0.000,0),(1321,1347,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.770,NULL,NULL,NULL,10.770,NULL,NULL,NULL,NULL,10.770,10.770,0.000,0.000,NULL,NULL,1,0,10.770,0,'2015-10-08 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:28','C',10.770,0.000,0.000,0),(1322,1348,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.520,NULL,NULL,NULL,12.520,NULL,NULL,NULL,NULL,12.520,12.520,0.000,0.000,NULL,NULL,1,0,12.520,0,'2015-10-08 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:29','C',12.520,0.000,0.000,0),(1323,1349,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.490,NULL,NULL,NULL,6.490,NULL,NULL,NULL,NULL,6.490,6.490,0.000,0.000,NULL,NULL,1,0,6.490,0,'2015-10-08 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:29','C',6.490,0.000,0.000,0),(1324,1350,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.010,NULL,NULL,NULL,9.010,NULL,NULL,NULL,NULL,9.010,9.010,0.000,0.000,NULL,NULL,1,0,9.010,0,'2015-10-08 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:29','C',9.010,0.000,0.000,0),(1325,1351,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.790,NULL,NULL,NULL,10.790,NULL,NULL,NULL,NULL,10.790,10.790,0.000,0.000,NULL,NULL,1,0,10.790,0,'2015-10-08 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:30','C',10.790,0.000,0.000,0),(1326,1352,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.560,NULL,NULL,NULL,9.560,NULL,NULL,NULL,NULL,9.560,9.560,0.000,0.000,NULL,NULL,1,0,9.560,0,'2015-10-08 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:30','C',9.560,0.000,0.000,0),(1327,1353,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.640,NULL,NULL,NULL,7.640,NULL,NULL,NULL,NULL,7.640,7.640,0.000,0.000,NULL,NULL,1,0,7.640,0,'2015-10-08 07:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:30','C',7.640,0.000,0.000,0),(1328,1354,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.820,NULL,NULL,NULL,8.820,NULL,NULL,NULL,NULL,8.820,8.820,0.000,0.000,NULL,NULL,1,0,8.820,0,'2015-10-08 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:30','C',8.820,0.000,0.000,0),(1329,1355,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.770,NULL,NULL,NULL,8.770,NULL,NULL,NULL,NULL,8.770,8.770,0.000,0.000,NULL,NULL,1,0,8.770,0,'2015-10-08 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:31','C',8.770,0.000,0.000,0),(1330,1356,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.650,NULL,NULL,NULL,8.650,NULL,NULL,NULL,NULL,8.650,8.650,0.000,0.000,NULL,NULL,1,0,8.650,0,'2015-10-08 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:31','C',8.650,0.000,0.000,0),(1331,1357,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.280,NULL,NULL,NULL,8.280,NULL,NULL,NULL,NULL,8.280,8.280,0.000,0.000,NULL,NULL,1,0,8.280,0,'2015-10-08 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:31','C',8.280,0.000,0.000,0),(1332,1358,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.940,NULL,NULL,NULL,10.940,NULL,NULL,NULL,NULL,10.940,10.940,0.000,0.000,NULL,NULL,1,0,10.940,0,'2015-10-08 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:31','C',10.940,0.000,0.000,0),(1333,1359,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.550,NULL,NULL,NULL,9.550,NULL,NULL,NULL,NULL,9.550,9.550,0.000,0.000,NULL,NULL,1,0,9.550,0,'2015-10-08 07:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:32','C',9.550,0.000,0.000,0),(1334,1360,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.940,NULL,NULL,NULL,10.940,NULL,NULL,NULL,NULL,10.940,10.940,0.000,0.000,NULL,NULL,1,0,10.940,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:32','C',10.940,0.000,0.000,0),(1335,1361,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,1,0,4.750,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:32','C',4.750,0.000,0.000,0),(1336,1362,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.560,NULL,NULL,NULL,4.560,NULL,NULL,NULL,NULL,4.560,4.560,0.000,0.000,NULL,NULL,1,0,4.560,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:33','C',4.560,0.000,0.000,0),(1337,1363,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,1,0,4.080,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:33','C',4.080,0.000,0.000,0),(1338,1364,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.770,NULL,NULL,NULL,6.770,NULL,NULL,NULL,NULL,6.770,6.770,0.000,0.000,NULL,NULL,1,0,6.770,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:33','C',6.770,0.000,0.000,0),(1339,1365,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.620,NULL,NULL,NULL,5.620,NULL,NULL,NULL,NULL,5.620,5.620,0.000,0.000,NULL,NULL,1,0,5.620,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:34','C',5.620,0.000,0.000,0),(1340,1366,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.830,NULL,NULL,NULL,8.830,NULL,NULL,NULL,NULL,8.830,8.830,0.000,0.000,NULL,NULL,1,0,8.830,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:34','C',8.830,0.000,0.000,0),(1341,1367,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.660,NULL,NULL,NULL,5.660,NULL,NULL,NULL,NULL,5.660,5.660,0.000,0.000,NULL,NULL,1,0,5.660,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:34','C',5.660,0.000,0.000,0),(1342,1368,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:34','C',4.270,0.000,0.000,0),(1343,1369,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.570,NULL,NULL,NULL,5.570,NULL,NULL,NULL,NULL,5.570,5.570,0.000,0.000,NULL,NULL,1,0,5.570,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:35','C',5.570,0.000,0.000,0),(1344,1370,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.460,NULL,NULL,NULL,4.460,NULL,NULL,NULL,NULL,4.460,4.460,0.000,0.000,NULL,NULL,1,0,4.460,0,'2015-10-08 07:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:35','C',4.460,0.000,0.000,0),(1345,1371,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,1,0,3.820,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:35','C',3.820,0.000,0.000,0),(1346,1372,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.840,NULL,NULL,NULL,3.840,NULL,NULL,NULL,NULL,3.840,3.840,0.000,0.000,NULL,NULL,1,0,3.840,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:53','C',3.840,0.000,0.000,0),(1347,1373,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.810,NULL,NULL,NULL,2.810,NULL,NULL,NULL,NULL,2.810,2.810,0.000,0.000,NULL,NULL,1,0,2.810,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:54','C',2.810,0.000,0.000,0),(1348,1374,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.840,NULL,NULL,NULL,3.840,NULL,NULL,NULL,NULL,3.840,3.840,0.000,0.000,NULL,NULL,1,0,3.840,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:54','C',3.840,0.000,0.000,0),(1349,1375,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.950,NULL,NULL,NULL,3.950,NULL,NULL,NULL,NULL,3.950,3.950,0.000,0.000,NULL,NULL,1,0,3.950,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:54','C',3.950,0.000,0.000,0),(1350,1376,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,1,0,3.020,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:54','C',3.020,0.000,0.000,0),(1351,1377,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.840,NULL,NULL,NULL,3.840,NULL,NULL,NULL,NULL,3.840,3.840,0.000,0.000,NULL,NULL,1,0,3.840,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:55','C',3.840,0.000,0.000,0),(1352,1378,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.890,NULL,NULL,NULL,2.890,NULL,NULL,NULL,NULL,2.890,2.890,0.000,0.000,NULL,NULL,1,0,2.890,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:55','C',2.890,0.000,0.000,0),(1353,1379,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.970,NULL,NULL,NULL,2.970,NULL,NULL,NULL,NULL,2.970,2.970,0.000,0.000,NULL,NULL,1,0,2.970,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:55','C',2.970,0.000,0.000,0),(1354,1380,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.180,NULL,NULL,NULL,4.180,NULL,NULL,NULL,NULL,4.180,4.180,0.000,0.000,NULL,NULL,1,0,4.180,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:56','C',4.180,0.000,0.000,0),(1355,1381,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:56','C',3.660,0.000,0.000,0),(1356,1382,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.950,NULL,NULL,NULL,3.950,NULL,NULL,NULL,NULL,3.950,3.950,0.000,0.000,NULL,NULL,1,0,3.950,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:56','C',3.950,0.000,0.000,0),(1357,1383,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.390,NULL,NULL,NULL,4.390,NULL,NULL,NULL,NULL,4.390,4.390,0.000,0.000,NULL,NULL,1,0,4.390,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:56','C',4.390,0.000,0.000,0),(1358,1384,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:57','C',3.970,0.000,0.000,0),(1359,1385,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:57','C',3.970,0.000,0.000,0),(1360,1386,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.970,NULL,NULL,NULL,3.970,NULL,NULL,NULL,NULL,3.970,3.970,0.000,0.000,NULL,NULL,1,0,3.970,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:57','C',3.970,0.000,0.000,0),(1361,1387,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:57','C',3.660,0.000,0.000,0),(1362,1388,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,1,0,3.820,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:58','C',3.820,0.000,0.000,0),(1363,1389,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.200,NULL,NULL,NULL,3.200,NULL,NULL,NULL,NULL,3.200,3.200,0.000,0.000,NULL,NULL,1,0,3.200,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:58','C',3.200,0.000,0.000,0),(1364,1390,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.410,NULL,NULL,NULL,3.410,NULL,NULL,NULL,NULL,3.410,3.410,0.000,0.000,NULL,NULL,1,0,3.410,0,'2015-10-08 07:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:58','C',3.410,0.000,0.000,0),(1365,1391,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.720,NULL,NULL,NULL,3.720,NULL,NULL,NULL,NULL,3.720,3.720,0.000,0.000,NULL,NULL,1,0,3.720,0,'2015-10-08 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:59','C',3.720,0.000,0.000,0),(1366,1392,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.860,NULL,NULL,NULL,2.860,NULL,NULL,NULL,NULL,2.860,2.860,0.000,0.000,NULL,NULL,1,0,2.860,0,'2015-10-08 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:59','C',2.860,0.000,0.000,0),(1367,1393,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.010,NULL,NULL,NULL,17.010,NULL,NULL,NULL,NULL,17.010,17.010,0.000,0.000,NULL,NULL,1,0,17.010,0,'2015-10-08 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:08:59','C',17.010,0.000,0.000,0),(1368,1394,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,19.330,NULL,NULL,NULL,19.330,NULL,NULL,NULL,NULL,19.330,19.330,0.000,0.000,NULL,NULL,1,0,19.330,0,'2015-10-08 07:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:00','C',19.330,0.000,0.000,0),(1369,1395,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.400,NULL,NULL,NULL,5.400,NULL,NULL,NULL,NULL,5.400,5.400,0.000,0.000,NULL,NULL,1,0,5.400,0,'2015-10-08 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:00','C',5.400,0.000,0.000,0),(1370,1396,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.480,NULL,NULL,NULL,4.480,NULL,NULL,NULL,NULL,4.480,4.480,0.000,0.000,NULL,NULL,1,0,4.480,0,'2015-10-08 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:00','C',4.480,0.000,0.000,0),(1371,1397,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.690,NULL,NULL,NULL,6.690,NULL,NULL,NULL,NULL,6.690,6.690,0.000,0.000,NULL,NULL,1,0,6.690,0,'2015-10-08 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:00','C',6.690,0.000,0.000,0),(1372,1398,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.980,NULL,NULL,NULL,4.980,NULL,NULL,NULL,NULL,4.980,4.980,0.000,0.000,NULL,NULL,1,0,4.980,0,'2015-10-08 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:01','C',4.980,0.000,0.000,0),(1373,1399,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.860,NULL,NULL,NULL,5.860,NULL,NULL,NULL,NULL,5.860,5.860,0.000,0.000,NULL,NULL,1,0,5.860,0,'2015-10-08 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:01','C',5.860,0.000,0.000,0),(1374,1400,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,1,0,3.590,0,'2015-10-08 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:01','C',3.590,0.000,0.000,0),(1375,1401,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.050,NULL,NULL,NULL,4.050,NULL,NULL,NULL,NULL,4.050,4.050,0.000,0.000,NULL,NULL,1,0,4.050,0,'2015-10-08 07:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:01','C',4.050,0.000,0.000,0),(1376,1402,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.280,NULL,NULL,NULL,5.280,NULL,NULL,NULL,NULL,5.280,5.280,0.000,0.000,NULL,NULL,1,0,5.280,0,'2015-10-08 07:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:02','C',5.280,0.000,0.000,0),(1377,1403,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.460,NULL,NULL,NULL,8.460,NULL,NULL,NULL,NULL,8.460,8.460,0.000,0.000,NULL,NULL,1,0,8.460,0,'2015-10-08 08:14:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:02','C',8.460,0.000,0.000,0),(1378,1404,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.710,NULL,NULL,NULL,8.710,NULL,NULL,NULL,NULL,8.710,8.710,0.000,0.000,NULL,NULL,1,0,8.710,0,'2015-10-08 08:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:02','C',8.710,0.000,0.000,0),(1379,1405,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.480,NULL,NULL,NULL,10.480,NULL,NULL,NULL,NULL,10.480,10.480,0.000,0.000,NULL,NULL,1,0,10.480,0,'2015-10-08 08:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:02','C',10.480,0.000,0.000,0),(1380,1406,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.120,NULL,NULL,NULL,11.120,NULL,NULL,NULL,NULL,11.120,11.120,0.000,0.000,NULL,NULL,1,0,11.120,0,'2015-10-08 08:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:03','C',11.120,0.000,0.000,0),(1381,1407,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.070,NULL,NULL,NULL,8.070,NULL,NULL,NULL,NULL,8.070,8.070,0.000,0.000,NULL,NULL,1,0,8.070,0,'2015-10-08 08:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:03','C',8.070,0.000,0.000,0),(1382,1408,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.910,NULL,NULL,NULL,8.910,NULL,NULL,NULL,NULL,8.910,8.910,0.000,0.000,NULL,NULL,1,0,8.910,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:03','C',8.910,0.000,0.000,0),(1383,1409,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.070,NULL,NULL,NULL,8.070,NULL,NULL,NULL,NULL,8.070,8.070,0.000,0.000,NULL,NULL,1,0,8.070,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:04','C',8.070,0.000,0.000,0),(1384,1410,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.070,NULL,NULL,NULL,8.070,NULL,NULL,NULL,NULL,8.070,8.070,0.000,0.000,NULL,NULL,1,0,8.070,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:04','C',8.070,0.000,0.000,0),(1385,1411,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.250,NULL,NULL,NULL,9.250,NULL,NULL,NULL,NULL,9.250,9.250,0.000,0.000,NULL,NULL,1,0,9.250,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:04','C',9.250,0.000,0.000,0),(1386,1412,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.820,NULL,NULL,NULL,7.820,NULL,NULL,NULL,NULL,7.820,7.820,0.000,0.000,NULL,NULL,1,0,7.820,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:04','C',7.820,0.000,0.000,0),(1387,1413,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.610,NULL,NULL,NULL,8.610,NULL,NULL,NULL,NULL,8.610,8.610,0.000,0.000,NULL,NULL,1,0,8.610,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:05','C',8.610,0.000,0.000,0),(1388,1414,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.990,NULL,NULL,NULL,9.990,NULL,NULL,NULL,NULL,9.990,9.990,0.000,0.000,NULL,NULL,1,0,9.990,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:05','C',9.990,0.000,0.000,0),(1389,1415,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.100,NULL,NULL,NULL,9.100,NULL,NULL,NULL,NULL,9.100,9.100,0.000,0.000,NULL,NULL,1,0,9.100,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:05','C',9.100,0.000,0.000,0),(1390,1416,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.310,NULL,NULL,NULL,8.310,NULL,NULL,NULL,NULL,8.310,8.310,0.000,0.000,NULL,NULL,1,0,8.310,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:05','C',8.310,0.000,0.000,0),(1391,1417,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.920,NULL,NULL,NULL,7.920,NULL,NULL,NULL,NULL,7.920,7.920,0.000,0.000,NULL,NULL,1,0,7.920,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:06','C',7.920,0.000,0.000,0),(1392,1418,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.130,NULL,NULL,NULL,7.130,NULL,NULL,NULL,NULL,7.130,7.130,0.000,0.000,NULL,NULL,1,0,7.130,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:06','C',7.130,0.000,0.000,0),(1393,1419,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.500,NULL,NULL,NULL,9.500,NULL,NULL,NULL,NULL,9.500,9.500,0.000,0.000,NULL,NULL,1,0,9.500,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:06','C',9.500,0.000,0.000,0),(1394,1420,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.020,NULL,NULL,NULL,11.020,NULL,NULL,NULL,NULL,11.020,11.020,0.000,0.000,NULL,NULL,1,0,11.020,0,'2015-10-08 08:17:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:07','C',11.020,0.000,0.000,0),(1395,1421,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.400,NULL,NULL,NULL,9.400,NULL,NULL,NULL,NULL,9.400,9.400,0.000,0.000,NULL,NULL,1,0,9.400,0,'2015-10-08 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:07','C',9.400,0.000,0.000,0),(1396,1422,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.080,NULL,NULL,NULL,7.080,NULL,NULL,NULL,NULL,7.080,7.080,0.000,0.000,NULL,NULL,1,0,7.080,0,'2015-10-08 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:07','C',7.080,0.000,0.000,0),(1397,1423,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.330,NULL,NULL,NULL,10.330,NULL,NULL,NULL,NULL,10.330,10.330,0.000,0.000,NULL,NULL,1,0,10.330,0,'2015-10-08 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:07','C',10.330,0.000,0.000,0),(1398,1424,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.410,NULL,NULL,NULL,8.410,NULL,NULL,NULL,NULL,8.410,8.410,0.000,0.000,NULL,NULL,1,0,8.410,0,'2015-10-08 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:08','C',8.410,0.000,0.000,0),(1399,1425,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.920,NULL,NULL,NULL,10.920,NULL,NULL,NULL,NULL,10.920,10.920,0.000,0.000,NULL,NULL,1,0,10.920,0,'2015-10-08 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:08','C',10.920,0.000,0.000,0),(1400,1426,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.320,NULL,NULL,NULL,11.320,NULL,NULL,NULL,NULL,11.320,11.320,0.000,0.000,NULL,NULL,1,0,11.320,0,'2015-10-08 08:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:08','C',11.320,0.000,0.000,0),(1401,1427,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.850,NULL,NULL,NULL,4.850,NULL,NULL,NULL,NULL,4.850,4.850,0.000,0.000,NULL,NULL,1,0,4.850,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:08','C',4.850,0.000,0.000,0),(1402,1428,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.610,NULL,NULL,NULL,4.610,NULL,NULL,NULL,NULL,4.610,4.610,0.000,0.000,NULL,NULL,1,0,4.610,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:09','C',4.610,0.000,0.000,0),(1403,1429,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.420,NULL,NULL,NULL,4.420,NULL,NULL,NULL,NULL,4.420,4.420,0.000,0.000,NULL,NULL,1,0,4.420,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:09','C',4.420,0.000,0.000,0),(1404,1430,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.850,NULL,NULL,NULL,4.850,NULL,NULL,NULL,NULL,4.850,4.850,0.000,0.000,NULL,NULL,1,0,4.850,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:09','C',4.850,0.000,0.000,0),(1405,1431,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.700,NULL,NULL,NULL,4.700,NULL,NULL,NULL,NULL,4.700,4.700,0.000,0.000,NULL,NULL,1,0,4.700,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:09','C',4.700,0.000,0.000,0),(1406,1432,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.220,NULL,NULL,NULL,4.220,NULL,NULL,NULL,NULL,4.220,4.220,0.000,0.000,NULL,NULL,1,0,4.220,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:10','C',4.220,0.000,0.000,0),(1407,1433,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.790,NULL,NULL,NULL,3.790,NULL,NULL,NULL,NULL,3.790,3.790,0.000,0.000,NULL,NULL,1,0,3.790,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:10','C',3.790,0.000,0.000,0),(1408,1434,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.230,NULL,NULL,NULL,5.230,NULL,NULL,NULL,NULL,5.230,5.230,0.000,0.000,NULL,NULL,1,0,5.230,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:10','C',5.230,0.000,0.000,0),(1409,1435,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.690,NULL,NULL,NULL,2.690,NULL,NULL,NULL,NULL,2.690,2.690,0.000,0.000,NULL,NULL,1,0,2.690,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:11','C',2.690,0.000,0.000,0),(1410,1436,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:11','C',4.270,0.000,0.000,0),(1411,1437,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.850,NULL,NULL,NULL,4.850,NULL,NULL,NULL,NULL,4.850,4.850,0.000,0.000,NULL,NULL,1,0,4.850,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:11','C',4.850,0.000,0.000,0),(1412,1438,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.790,NULL,NULL,NULL,3.790,NULL,NULL,NULL,NULL,3.790,3.790,0.000,0.000,NULL,NULL,1,0,3.790,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:11','C',3.790,0.000,0.000,0),(1413,1439,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.320,NULL,NULL,NULL,4.320,NULL,NULL,NULL,NULL,4.320,4.320,0.000,0.000,NULL,NULL,1,0,4.320,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:12','C',4.320,0.000,0.000,0),(1414,1440,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.850,NULL,NULL,NULL,4.850,NULL,NULL,NULL,NULL,4.850,4.850,0.000,0.000,NULL,NULL,1,0,4.850,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:12','C',4.850,0.000,0.000,0),(1415,1441,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.420,NULL,NULL,NULL,4.420,NULL,NULL,NULL,NULL,4.420,4.420,0.000,0.000,NULL,NULL,1,0,4.420,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:12','C',4.420,0.000,0.000,0),(1416,1442,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,1,0,4.270,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:12','C',4.270,0.000,0.000,0),(1417,1443,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.990,NULL,NULL,NULL,4.990,NULL,NULL,NULL,NULL,4.990,4.990,0.000,0.000,NULL,NULL,1,0,4.990,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:13','C',4.990,0.000,0.000,0),(1418,1444,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.140,NULL,NULL,NULL,5.140,NULL,NULL,NULL,NULL,5.140,5.140,0.000,0.000,NULL,NULL,1,0,5.140,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:13','C',5.140,0.000,0.000,0),(1419,1445,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.090,NULL,NULL,NULL,5.090,NULL,NULL,NULL,NULL,5.090,5.090,0.000,0.000,NULL,NULL,1,0,5.090,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:13','C',5.090,0.000,0.000,0),(1420,1446,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.800,NULL,NULL,NULL,4.800,NULL,NULL,NULL,NULL,4.800,4.800,0.000,0.000,NULL,NULL,1,0,4.800,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:13','C',4.800,0.000,0.000,0),(1421,1447,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.470,NULL,NULL,NULL,5.470,NULL,NULL,NULL,NULL,5.470,5.470,0.000,0.000,NULL,NULL,1,0,5.470,0,'2015-10-08 08:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:14','C',5.470,0.000,0.000,0),(1422,1448,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.410,NULL,NULL,NULL,3.410,NULL,NULL,NULL,NULL,3.410,3.410,0.000,0.000,NULL,NULL,1,0,3.410,0,'2015-10-08 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:14','C',3.410,0.000,0.000,0),(1423,1449,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.660,NULL,NULL,NULL,4.660,NULL,NULL,NULL,NULL,4.660,4.660,0.000,0.000,NULL,NULL,1,0,4.660,0,'2015-10-08 08:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:14','C',4.660,0.000,0.000,0),(1424,1450,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.740,NULL,NULL,NULL,12.740,NULL,NULL,NULL,NULL,12.740,12.740,0.000,0.000,NULL,NULL,1,0,12.740,0,'2015-10-08 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:15','C',12.740,0.000,0.000,0),(1425,1451,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.010,NULL,NULL,NULL,15.010,NULL,NULL,NULL,NULL,15.010,15.010,0.000,0.000,NULL,NULL,1,0,15.010,0,'2015-10-08 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:15','C',15.010,0.000,0.000,0),(1426,1452,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.510,NULL,NULL,NULL,14.510,NULL,NULL,NULL,NULL,14.510,14.510,0.000,0.000,NULL,NULL,1,0,14.510,0,'2015-10-08 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:15','C',14.510,0.000,0.000,0),(1427,1453,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.810,NULL,NULL,NULL,14.810,NULL,NULL,NULL,NULL,14.810,14.810,0.000,0.000,NULL,NULL,1,0,14.810,0,'2015-10-08 08:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:15','C',14.810,0.000,0.000,0),(1428,1454,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.300,NULL,NULL,NULL,15.300,NULL,NULL,NULL,NULL,15.300,15.300,0.000,0.000,NULL,NULL,1,0,15.300,0,'2015-10-08 08:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:16','C',15.300,0.000,0.000,0),(1429,1455,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,16.970,NULL,NULL,NULL,16.970,NULL,NULL,NULL,NULL,16.970,16.970,0.000,0.000,NULL,NULL,1,0,16.970,0,'2015-10-08 08:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:16','C',16.970,0.000,0.000,0),(1430,1456,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.120,NULL,NULL,NULL,14.120,NULL,NULL,NULL,NULL,14.120,14.120,0.000,0.000,NULL,NULL,1,0,14.120,0,'2015-10-08 08:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:16','C',14.120,0.000,0.000,0),(1431,1457,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,16.040,NULL,NULL,NULL,16.040,NULL,NULL,NULL,NULL,16.040,16.040,0.000,0.000,NULL,NULL,1,0,16.040,0,'2015-10-08 08:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:16','C',16.040,0.000,0.000,0),(1432,1458,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.830,NULL,NULL,NULL,13.830,NULL,NULL,NULL,NULL,13.830,13.830,0.000,0.000,NULL,NULL,1,0,13.830,0,'2015-10-08 08:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:17','C',13.830,0.000,0.000,0),(1433,1459,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.480,NULL,NULL,NULL,13.480,NULL,NULL,NULL,NULL,13.480,13.480,0.000,0.000,NULL,NULL,1,0,13.480,0,'2015-10-08 08:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:17','C',13.480,0.000,0.000,0),(1434,1460,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.020,NULL,NULL,NULL,14.020,NULL,NULL,NULL,NULL,14.020,14.020,0.000,0.000,NULL,NULL,1,0,14.020,0,'2015-10-08 08:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:17','C',14.020,0.000,0.000,0),(1435,1461,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.020,NULL,NULL,NULL,17.020,NULL,NULL,NULL,NULL,17.020,17.020,0.000,0.000,NULL,NULL,1,0,17.020,0,'2015-10-08 08:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:17','C',17.020,0.000,0.000,0),(1436,1462,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,17.660,NULL,NULL,NULL,17.660,NULL,NULL,NULL,NULL,17.660,17.660,0.000,0.000,NULL,NULL,1,0,17.660,0,'2015-10-08 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:18','C',17.660,0.000,0.000,0),(1437,1463,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.890,NULL,NULL,NULL,4.890,NULL,NULL,NULL,NULL,4.890,4.890,0.000,0.000,NULL,NULL,1,0,4.890,0,'2015-10-08 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:18','C',4.890,0.000,0.000,0),(1438,1464,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.680,NULL,NULL,NULL,7.680,NULL,NULL,NULL,NULL,7.680,7.680,0.000,0.000,NULL,NULL,1,0,7.680,0,'2015-10-08 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:18','C',7.680,0.000,0.000,0),(1439,1465,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.260,NULL,NULL,NULL,8.260,NULL,NULL,NULL,NULL,8.260,8.260,0.000,0.000,NULL,NULL,1,0,8.260,0,'2015-10-08 08:23:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:19','C',8.260,0.000,0.000,0),(1440,1466,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.040,NULL,NULL,NULL,6.040,NULL,NULL,NULL,NULL,6.040,6.040,0.000,0.000,NULL,NULL,1,0,6.040,0,'2015-10-08 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:19','C',6.040,0.000,0.000,0),(1441,1467,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.160,NULL,NULL,NULL,6.160,NULL,NULL,NULL,NULL,6.160,6.160,0.000,0.000,NULL,NULL,1,0,6.160,0,'2015-10-08 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:19','C',6.160,0.000,0.000,0),(1442,1468,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.040,NULL,NULL,NULL,6.040,NULL,NULL,NULL,NULL,6.040,6.040,0.000,0.000,NULL,NULL,1,0,6.040,0,'2015-10-08 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:19','C',6.040,0.000,0.000,0),(1443,1469,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.220,NULL,NULL,NULL,6.220,NULL,NULL,NULL,NULL,6.220,6.220,0.000,0.000,NULL,NULL,1,0,6.220,0,'2015-10-08 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:20','C',6.220,0.000,0.000,0),(1444,1470,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.020,NULL,NULL,NULL,8.020,NULL,NULL,NULL,NULL,8.020,8.020,0.000,0.000,NULL,NULL,1,0,8.020,0,'2015-10-08 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:20','C',8.020,0.000,0.000,0),(1445,1471,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.500,NULL,NULL,NULL,7.500,NULL,NULL,NULL,NULL,7.500,7.500,0.000,0.000,NULL,NULL,1,0,7.500,0,'2015-10-08 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:20','C',7.500,0.000,0.000,0),(1446,1472,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.010,NULL,NULL,NULL,10.010,NULL,NULL,NULL,NULL,10.010,10.010,0.000,0.000,NULL,NULL,1,0,10.010,0,'2015-10-08 08:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:38','C',10.010,0.000,0.000,0),(1447,1473,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.340,NULL,NULL,NULL,6.340,NULL,NULL,NULL,NULL,6.340,6.340,0.000,0.000,NULL,NULL,1,0,6.340,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:38','C',6.340,0.000,0.000,0),(1448,1474,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.430,NULL,NULL,NULL,9.430,NULL,NULL,NULL,NULL,9.430,9.430,0.000,0.000,NULL,NULL,1,0,9.430,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:39','C',9.430,0.000,0.000,0),(1449,1475,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.580,NULL,NULL,NULL,9.580,NULL,NULL,NULL,NULL,9.580,9.580,0.000,0.000,NULL,NULL,1,0,9.580,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:39','C',9.580,0.000,0.000,0),(1450,1476,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.490,NULL,NULL,NULL,7.490,NULL,NULL,NULL,NULL,7.490,7.490,0.000,0.000,NULL,NULL,1,0,7.490,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:39','C',7.490,0.000,0.000,0),(1451,1477,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.040,NULL,NULL,NULL,5.040,NULL,NULL,NULL,NULL,5.040,5.040,0.000,0.000,NULL,NULL,1,0,5.040,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:39','C',5.040,0.000,0.000,0),(1452,1478,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.490,NULL,NULL,NULL,7.490,NULL,NULL,NULL,NULL,7.490,7.490,0.000,0.000,NULL,NULL,1,0,7.490,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:40','C',7.490,0.000,0.000,0),(1453,1479,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.180,NULL,NULL,NULL,5.180,NULL,NULL,NULL,NULL,5.180,5.180,0.000,0.000,NULL,NULL,1,0,5.180,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:40','C',5.180,0.000,0.000,0),(1454,1480,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.070,NULL,NULL,NULL,9.070,NULL,NULL,NULL,NULL,9.070,9.070,0.000,0.000,NULL,NULL,1,0,9.070,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:40','C',9.070,0.000,0.000,0),(1455,1481,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.060,NULL,NULL,NULL,8.060,NULL,NULL,NULL,NULL,8.060,8.060,0.000,0.000,NULL,NULL,1,0,8.060,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:40','C',8.060,0.000,0.000,0),(1456,1482,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.840,NULL,NULL,NULL,6.840,NULL,NULL,NULL,NULL,6.840,6.840,0.000,0.000,NULL,NULL,1,0,6.840,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:41','C',6.840,0.000,0.000,0),(1457,1483,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.240,NULL,NULL,NULL,12.240,NULL,NULL,NULL,NULL,12.240,12.240,0.000,0.000,NULL,NULL,1,0,12.240,0,'2015-10-08 08:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:41','C',12.240,0.000,0.000,0),(1458,1484,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.270,NULL,NULL,NULL,8.270,NULL,NULL,NULL,NULL,8.270,8.270,0.000,0.000,NULL,NULL,1,0,8.270,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:41','C',8.270,0.000,0.000,0),(1459,1485,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.200,NULL,NULL,NULL,6.200,NULL,NULL,NULL,NULL,6.200,6.200,0.000,0.000,NULL,NULL,1,0,6.200,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:42','C',6.200,0.000,0.000,0),(1460,1486,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.100,NULL,NULL,NULL,6.100,NULL,NULL,NULL,NULL,6.100,6.100,0.000,0.000,NULL,NULL,1,0,6.100,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:42','C',6.100,0.000,0.000,0),(1461,1487,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.170,NULL,NULL,NULL,8.170,NULL,NULL,NULL,NULL,8.170,8.170,0.000,0.000,NULL,NULL,1,0,8.170,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:42','C',8.170,0.000,0.000,0),(1462,1488,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.480,NULL,NULL,NULL,7.480,NULL,NULL,NULL,NULL,7.480,7.480,0.000,0.000,NULL,NULL,1,0,7.480,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:42','C',7.480,0.000,0.000,0),(1463,1489,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.050,NULL,NULL,NULL,6.050,NULL,NULL,NULL,NULL,6.050,6.050,0.000,0.000,NULL,NULL,1,0,6.050,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:43','C',6.050,0.000,0.000,0),(1464,1490,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.810,NULL,NULL,NULL,5.810,NULL,NULL,NULL,NULL,5.810,5.810,0.000,0.000,NULL,NULL,1,0,5.810,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:43','C',5.810,0.000,0.000,0),(1465,1491,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.490,NULL,NULL,NULL,6.490,NULL,NULL,NULL,NULL,6.490,6.490,0.000,0.000,NULL,NULL,1,0,6.490,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:43','C',6.490,0.000,0.000,0),(1466,1492,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.510,NULL,NULL,NULL,8.510,NULL,NULL,NULL,NULL,8.510,8.510,0.000,0.000,NULL,NULL,1,0,8.510,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:44','C',8.510,0.000,0.000,0),(1467,1493,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.100,NULL,NULL,NULL,6.100,NULL,NULL,NULL,NULL,6.100,6.100,0.000,0.000,NULL,NULL,1,0,6.100,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:44','C',6.100,0.000,0.000,0),(1468,1494,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.200,NULL,NULL,NULL,6.200,NULL,NULL,NULL,NULL,6.200,6.200,0.000,0.000,NULL,NULL,1,0,6.200,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:44','C',6.200,0.000,0.000,0),(1469,1495,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.540,NULL,NULL,NULL,6.540,NULL,NULL,NULL,NULL,6.540,6.540,0.000,0.000,NULL,NULL,1,0,6.540,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:44','C',6.540,0.000,0.000,0),(1470,1496,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.360,NULL,NULL,NULL,8.360,NULL,NULL,NULL,NULL,8.360,8.360,0.000,0.000,NULL,NULL,1,0,8.360,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:45','C',8.360,0.000,0.000,0),(1471,1497,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.480,NULL,NULL,NULL,7.480,NULL,NULL,NULL,NULL,7.480,7.480,0.000,0.000,NULL,NULL,1,0,7.480,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:45','C',7.480,0.000,0.000,0),(1472,1498,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.220,NULL,NULL,NULL,8.220,NULL,NULL,NULL,NULL,8.220,8.220,0.000,0.000,NULL,NULL,1,0,8.220,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:45','C',8.220,0.000,0.000,0),(1473,1499,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.200,NULL,NULL,NULL,6.200,NULL,NULL,NULL,NULL,6.200,6.200,0.000,0.000,NULL,NULL,1,0,6.200,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:45','C',6.200,0.000,0.000,0),(1474,1500,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.250,NULL,NULL,NULL,6.250,NULL,NULL,NULL,NULL,6.250,6.250,0.000,0.000,NULL,NULL,1,0,6.250,0,'2015-10-08 08:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:46','C',6.250,0.000,0.000,0),(1475,1501,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.630,NULL,NULL,NULL,7.630,NULL,NULL,NULL,NULL,7.630,7.630,0.000,0.000,NULL,NULL,1,0,7.630,0,'2015-10-08 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:46','C',7.630,0.000,0.000,0),(1476,1502,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.740,NULL,NULL,NULL,6.740,NULL,NULL,NULL,NULL,6.740,6.740,0.000,0.000,NULL,NULL,1,0,6.740,0,'2015-10-08 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:46','C',6.740,0.000,0.000,0),(1477,1503,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.510,NULL,NULL,NULL,8.510,NULL,NULL,NULL,NULL,8.510,8.510,0.000,0.000,NULL,NULL,1,0,8.510,0,'2015-10-08 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:46','C',8.510,0.000,0.000,0),(1478,1504,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.920,NULL,NULL,NULL,7.920,NULL,NULL,NULL,NULL,7.920,7.920,0.000,0.000,NULL,NULL,1,0,7.920,0,'2015-10-08 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:47','C',7.920,0.000,0.000,0),(1479,1505,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,20.860,NULL,NULL,NULL,20.860,NULL,NULL,NULL,NULL,20.860,20.860,0.000,0.000,NULL,NULL,1,0,20.860,0,'2015-10-08 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:47','C',20.860,0.000,0.000,0),(1480,1506,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,21.650,NULL,NULL,NULL,21.650,NULL,NULL,NULL,NULL,21.650,21.650,0.000,0.000,NULL,NULL,1,0,21.650,0,'2015-10-08 08:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:47','C',21.650,0.000,0.000,0),(1481,1507,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.080,NULL,NULL,NULL,7.080,NULL,NULL,NULL,NULL,7.080,7.080,0.000,0.000,NULL,NULL,3,0,7.080,0,'2015-10-08 08:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:48','C',7.080,0.000,0.000,0),(1482,1508,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.940,NULL,NULL,NULL,6.940,NULL,NULL,NULL,NULL,6.940,6.940,0.000,0.000,NULL,NULL,3,0,6.940,0,'2015-10-08 08:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:48','C',6.940,0.000,0.000,0),(1483,1509,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.420,NULL,NULL,NULL,3.420,NULL,NULL,NULL,NULL,3.420,3.420,0.000,0.000,NULL,NULL,3,0,3.420,0,'2015-10-08 08:29:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:48','C',3.420,0.000,0.000,0),(1484,1510,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.640,NULL,NULL,NULL,1.640,NULL,NULL,NULL,NULL,1.640,1.640,0.000,0.000,NULL,NULL,3,0,1.640,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:48','C',1.640,0.000,0.000,0),(1485,1511,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.910,NULL,NULL,NULL,6.910,NULL,NULL,NULL,NULL,6.910,6.910,0.000,0.000,NULL,NULL,3,0,6.910,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:49','C',6.910,0.000,0.000,0),(1486,1512,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.450,NULL,NULL,NULL,4.450,NULL,NULL,NULL,NULL,4.450,4.450,0.000,0.000,NULL,NULL,3,0,4.450,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:49','C',4.450,0.000,0.000,0),(1487,1513,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,3,0,4.240,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:49','C',4.240,0.000,0.000,0),(1488,1514,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.480,NULL,NULL,NULL,5.480,NULL,NULL,NULL,NULL,5.480,5.480,0.000,0.000,NULL,NULL,3,0,5.480,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:49','C',5.480,0.000,0.000,0),(1489,1515,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,3,0,3.560,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:50','C',3.560,0.000,0.000,0),(1490,1516,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.240,NULL,NULL,NULL,3.240,NULL,NULL,NULL,NULL,3.240,3.240,0.000,0.000,NULL,NULL,3,0,3.240,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:50','C',3.240,0.000,0.000,0),(1491,1517,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.880,NULL,NULL,NULL,3.880,NULL,NULL,NULL,NULL,3.880,3.880,0.000,0.000,NULL,NULL,3,0,3.880,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:50','C',3.880,0.000,0.000,0),(1492,1518,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,3,0,3.280,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:50','C',3.280,0.000,0.000,0),(1493,1519,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.590,NULL,NULL,NULL,5.590,NULL,NULL,NULL,NULL,5.590,5.590,0.000,0.000,NULL,NULL,3,0,5.590,0,'2015-10-08 08:30:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:51','C',5.590,0.000,0.000,0),(1494,1520,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.830,NULL,NULL,NULL,11.830,NULL,NULL,NULL,NULL,11.830,11.830,0.000,0.000,NULL,NULL,3,0,11.830,0,'2015-10-08 08:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:51','C',11.830,0.000,0.000,0),(1495,1521,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.830,NULL,NULL,NULL,11.830,NULL,NULL,NULL,NULL,11.830,11.830,0.000,0.000,NULL,NULL,3,0,11.830,0,'2015-10-08 08:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:51','C',11.830,0.000,0.000,0),(1496,1522,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.520,NULL,NULL,NULL,11.520,NULL,NULL,NULL,NULL,11.520,11.520,0.000,0.000,NULL,NULL,3,0,11.520,0,'2015-10-08 08:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:52','C',11.520,0.000,0.000,0),(1497,1523,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.490,NULL,NULL,NULL,9.490,NULL,NULL,NULL,NULL,9.490,9.490,0.000,0.000,NULL,NULL,3,0,9.490,0,'2015-10-08 08:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:52','C',9.490,0.000,0.000,0),(1498,1524,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.660,NULL,NULL,NULL,6.660,NULL,NULL,NULL,NULL,6.660,6.660,0.000,0.000,NULL,NULL,3,0,6.660,0,'2015-10-08 08:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:52','C',6.660,0.000,0.000,0),(1499,1525,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.010,NULL,NULL,NULL,8.010,NULL,NULL,NULL,NULL,8.010,8.010,0.000,0.000,NULL,NULL,3,0,8.010,0,'2015-10-08 08:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:52','C',8.010,0.000,0.000,0),(1500,1526,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.560,NULL,NULL,NULL,3.560,NULL,NULL,NULL,NULL,3.560,3.560,0.000,0.000,NULL,NULL,3,0,3.560,0,'2015-10-08 08:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:53','C',3.560,0.000,0.000,0),(1501,1527,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.380,NULL,NULL,NULL,3.380,NULL,NULL,NULL,NULL,3.380,3.380,0.000,0.000,NULL,NULL,3,0,3.380,0,'2015-10-08 08:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:53','C',3.380,0.000,0.000,0),(1502,1528,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.700,NULL,NULL,NULL,4.700,NULL,NULL,NULL,NULL,4.700,4.700,0.000,0.000,NULL,NULL,3,0,4.700,0,'2015-10-08 08:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:53','C',4.700,0.000,0.000,0),(1503,1529,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.560,NULL,NULL,NULL,4.560,NULL,NULL,NULL,NULL,4.560,4.560,0.000,0.000,NULL,NULL,3,0,4.560,0,'2015-10-08 08:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:53','C',4.560,0.000,0.000,0),(1504,1530,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.200,NULL,NULL,NULL,5.200,NULL,NULL,NULL,NULL,5.200,5.200,0.000,0.000,NULL,NULL,3,0,5.200,0,'2015-10-08 08:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:54','C',5.200,0.000,0.000,0),(1505,1531,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.060,NULL,NULL,NULL,4.060,NULL,NULL,NULL,NULL,4.060,4.060,0.000,0.000,NULL,NULL,3,0,4.060,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:54','C',4.060,0.000,0.000,0),(1506,1532,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.490,NULL,NULL,NULL,4.490,NULL,NULL,NULL,NULL,4.490,4.490,0.000,0.000,NULL,NULL,3,0,4.490,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:54','C',4.490,0.000,0.000,0),(1507,1533,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,3,0,4.770,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:54','C',4.770,0.000,0.000,0),(1508,1534,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.380,NULL,NULL,NULL,4.380,NULL,NULL,NULL,NULL,4.380,4.380,0.000,0.000,NULL,NULL,3,0,4.380,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:55','C',4.380,0.000,0.000,0),(1509,1535,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.240,NULL,NULL,NULL,4.240,NULL,NULL,NULL,NULL,4.240,4.240,0.000,0.000,NULL,NULL,3,0,4.240,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:55','C',4.240,0.000,0.000,0),(1510,1536,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,3,0,4.130,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:55','C',4.130,0.000,0.000,0),(1511,1537,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,3,0,3.450,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:56','C',3.450,0.000,0.000,0),(1512,1538,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.990,NULL,NULL,NULL,3.990,NULL,NULL,NULL,NULL,3.990,3.990,0.000,0.000,NULL,NULL,3,0,3.990,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:56','C',3.990,0.000,0.000,0),(1513,1539,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.590,NULL,NULL,NULL,4.590,NULL,NULL,NULL,NULL,4.590,4.590,0.000,0.000,NULL,NULL,3,0,4.590,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:56','C',4.590,0.000,0.000,0),(1514,1540,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,3,0,4.770,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:57','C',4.770,0.000,0.000,0),(1515,1541,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,3,0,4.020,0,'2015-10-08 08:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:57','C',4.020,0.000,0.000,0),(1516,1542,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.130,NULL,NULL,NULL,4.130,NULL,NULL,NULL,NULL,4.130,4.130,0.000,0.000,NULL,NULL,3,0,4.130,0,'2015-10-08 08:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:57','C',4.130,0.000,0.000,0),(1517,1543,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.090,NULL,NULL,NULL,4.090,NULL,NULL,NULL,NULL,4.090,4.090,0.000,0.000,NULL,NULL,3,0,4.090,0,'2015-10-08 08:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:57','C',4.090,0.000,0.000,0),(1518,1544,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.840,NULL,NULL,NULL,4.840,NULL,NULL,NULL,NULL,4.840,4.840,0.000,0.000,NULL,NULL,3,0,4.840,0,'2015-10-08 08:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:58','C',4.840,0.000,0.000,0),(1519,1545,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.810,NULL,NULL,NULL,4.810,NULL,NULL,NULL,NULL,4.810,4.810,0.000,0.000,NULL,NULL,3,0,4.810,0,'2015-10-08 08:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:58','C',4.810,0.000,0.000,0),(1520,1546,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.990,NULL,NULL,NULL,3.990,NULL,NULL,NULL,NULL,3.990,3.990,0.000,0.000,NULL,NULL,3,0,3.990,0,'2015-10-08 08:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:58','C',3.990,0.000,0.000,0),(1521,1547,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.280,NULL,NULL,NULL,4.280,NULL,NULL,NULL,NULL,4.280,4.280,0.000,0.000,NULL,NULL,3,0,4.280,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:58','C',4.280,0.000,0.000,0),(1522,1548,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.700,NULL,NULL,NULL,3.700,NULL,NULL,NULL,NULL,3.700,3.700,0.000,0.000,NULL,NULL,3,0,3.700,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:59','C',3.700,0.000,0.000,0),(1523,1549,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.940,NULL,NULL,NULL,2.940,NULL,NULL,NULL,NULL,2.940,2.940,0.000,0.000,NULL,NULL,3,0,2.940,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:59','C',2.940,0.000,0.000,0),(1524,1550,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,3,0,3.020,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:59','C',3.020,0.000,0.000,0),(1525,1551,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,3,0,3.740,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:09:59','C',3.740,0.000,0.000,0),(1526,1552,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.570,NULL,NULL,NULL,3.570,NULL,NULL,NULL,NULL,3.570,3.570,0.000,0.000,NULL,NULL,3,0,3.570,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:00','C',3.570,0.000,0.000,0),(1527,1553,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,3,0,3.740,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:00','C',3.740,0.000,0.000,0),(1528,1554,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,3,0,3.820,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:00','C',3.820,0.000,0.000,0),(1529,1555,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,3,0,3.740,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:01','C',3.740,0.000,0.000,0),(1530,1556,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.980,NULL,NULL,NULL,2.980,NULL,NULL,NULL,NULL,2.980,2.980,0.000,0.000,NULL,NULL,3,0,2.980,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:01','C',2.980,0.000,0.000,0),(1531,1557,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.190,NULL,NULL,NULL,3.190,NULL,NULL,NULL,NULL,3.190,3.190,0.000,0.000,NULL,NULL,3,0,3.190,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:01','C',3.190,0.000,0.000,0),(1532,1558,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.530,NULL,NULL,NULL,3.530,NULL,NULL,NULL,NULL,3.530,3.530,0.000,0.000,NULL,NULL,3,0,3.530,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:01','C',3.530,0.000,0.000,0),(1533,1559,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,3,0,3.740,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:02','C',3.740,0.000,0.000,0),(1534,1560,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.190,NULL,NULL,NULL,3.190,NULL,NULL,NULL,NULL,3.190,3.190,0.000,0.000,NULL,NULL,3,0,3.190,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:02','C',3.190,0.000,0.000,0),(1535,1561,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.910,NULL,NULL,NULL,3.910,NULL,NULL,NULL,NULL,3.910,3.910,0.000,0.000,NULL,NULL,3,0,3.910,0,'2015-10-08 08:37:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:02','C',3.910,0.000,0.000,0),(1536,1562,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.730,NULL,NULL,NULL,13.730,NULL,NULL,NULL,NULL,13.730,13.730,0.000,0.000,NULL,NULL,3,0,13.730,0,'2015-10-08 08:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:02','C',13.730,0.000,0.000,0),(1537,1563,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.020,NULL,NULL,NULL,13.020,NULL,NULL,NULL,NULL,13.020,13.020,0.000,0.000,NULL,NULL,3,0,13.020,0,'2015-10-08 08:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:03','C',13.020,0.000,0.000,0),(1538,1564,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,20.190,NULL,NULL,NULL,20.190,NULL,NULL,NULL,NULL,20.190,20.190,0.000,0.000,NULL,NULL,3,0,20.190,0,'2015-10-08 08:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:03','C',20.190,0.000,0.000,0),(1539,1565,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,19.540,NULL,NULL,NULL,19.540,NULL,NULL,NULL,NULL,19.540,19.540,0.000,0.000,NULL,NULL,3,0,19.540,0,'2015-10-08 08:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:03','C',19.540,0.000,0.000,0),(1540,1566,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.470,NULL,NULL,NULL,4.470,NULL,NULL,NULL,NULL,4.470,4.470,0.000,0.000,NULL,NULL,3,0,4.470,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:04','C',4.470,0.000,0.000,0),(1541,1567,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.410,NULL,NULL,NULL,5.410,NULL,NULL,NULL,NULL,5.410,5.410,0.000,0.000,NULL,NULL,3,0,5.410,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:04','C',5.410,0.000,0.000,0),(1542,1568,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.470,NULL,NULL,NULL,4.470,NULL,NULL,NULL,NULL,4.470,4.470,0.000,0.000,NULL,NULL,3,0,4.470,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:04','C',4.470,0.000,0.000,0),(1543,1569,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.930,NULL,NULL,NULL,4.930,NULL,NULL,NULL,NULL,4.930,4.930,0.000,0.000,NULL,NULL,3,0,4.930,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:05','C',4.930,0.000,0.000,0),(1544,1570,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.620,NULL,NULL,NULL,4.620,NULL,NULL,NULL,NULL,4.620,4.620,0.000,0.000,NULL,NULL,3,0,4.620,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:05','C',4.620,0.000,0.000,0),(1545,1571,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.680,NULL,NULL,NULL,5.680,NULL,NULL,NULL,NULL,5.680,5.680,0.000,0.000,NULL,NULL,3,0,5.680,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:05','C',5.680,0.000,0.000,0),(1546,1572,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.030,NULL,NULL,NULL,7.030,NULL,NULL,NULL,NULL,7.030,7.030,0.000,0.000,NULL,NULL,3,0,7.030,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:26','C',7.030,0.000,0.000,0),(1547,1573,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.090,NULL,NULL,NULL,6.090,NULL,NULL,NULL,NULL,6.090,6.090,0.000,0.000,NULL,NULL,3,0,6.090,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:26','C',6.090,0.000,0.000,0),(1548,1574,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.320,NULL,NULL,NULL,6.320,NULL,NULL,NULL,NULL,6.320,6.320,0.000,0.000,NULL,NULL,3,0,6.320,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:27','C',6.320,0.000,0.000,0),(1549,1575,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.260,NULL,NULL,NULL,5.260,NULL,NULL,NULL,NULL,5.260,5.260,0.000,0.000,NULL,NULL,3,0,5.260,0,'2015-10-08 08:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:27','C',5.260,0.000,0.000,0),(1550,1576,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.810,NULL,NULL,NULL,4.810,NULL,NULL,NULL,NULL,4.810,4.810,0.000,0.000,NULL,NULL,3,0,4.810,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:27','C',4.810,0.000,0.000,0),(1551,1577,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.620,NULL,NULL,NULL,1.620,NULL,NULL,NULL,NULL,1.620,1.620,0.000,0.000,NULL,NULL,3,0,1.620,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:27','C',1.620,0.000,0.000,0),(1552,1578,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.780,NULL,NULL,NULL,4.780,NULL,NULL,NULL,NULL,4.780,4.780,0.000,0.000,NULL,NULL,3,0,4.780,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:28','C',4.780,0.000,0.000,0),(1553,1579,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.320,NULL,NULL,NULL,4.320,NULL,NULL,NULL,NULL,4.320,4.320,0.000,0.000,NULL,NULL,3,0,4.320,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:28','C',4.320,0.000,0.000,0),(1554,1580,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.910,NULL,NULL,NULL,3.910,NULL,NULL,NULL,NULL,3.910,3.910,0.000,0.000,NULL,NULL,3,0,3.910,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:28','C',3.910,0.000,0.000,0),(1555,1581,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.680,NULL,NULL,NULL,5.680,NULL,NULL,NULL,NULL,5.680,5.680,0.000,0.000,NULL,NULL,3,0,5.680,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:28','C',5.680,0.000,0.000,0),(1556,1582,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.910,NULL,NULL,NULL,3.910,NULL,NULL,NULL,NULL,3.910,3.910,0.000,0.000,NULL,NULL,3,0,3.910,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:29','C',3.910,0.000,0.000,0),(1557,1583,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.440,NULL,NULL,NULL,3.440,NULL,NULL,NULL,NULL,3.440,3.440,0.000,0.000,NULL,NULL,3,0,3.440,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:29','C',3.440,0.000,0.000,0),(1558,1584,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.770,NULL,NULL,NULL,2.770,NULL,NULL,NULL,NULL,2.770,2.770,0.000,0.000,NULL,NULL,3,0,2.770,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:29','C',2.770,0.000,0.000,0),(1559,1585,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.860,NULL,NULL,NULL,3.860,NULL,NULL,NULL,NULL,3.860,3.860,0.000,0.000,NULL,NULL,3,0,3.860,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:30','C',3.860,0.000,0.000,0),(1560,1586,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.570,NULL,NULL,NULL,3.570,NULL,NULL,NULL,NULL,3.570,3.570,0.000,0.000,NULL,NULL,3,0,3.570,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:30','C',3.570,0.000,0.000,0),(1561,1587,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.190,NULL,NULL,NULL,3.190,NULL,NULL,NULL,NULL,3.190,3.190,0.000,0.000,NULL,NULL,3,0,3.190,0,'2015-10-08 08:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:30','C',3.190,0.000,0.000,0),(1562,1588,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.230,NULL,NULL,NULL,3.230,NULL,NULL,NULL,NULL,3.230,3.230,0.000,0.000,NULL,NULL,3,0,3.230,0,'2015-10-08 08:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:30','C',3.230,0.000,0.000,0),(1563,1589,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.150,NULL,NULL,NULL,3.150,NULL,NULL,NULL,NULL,3.150,3.150,0.000,0.000,NULL,NULL,3,0,3.150,0,'2015-10-08 08:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:31','C',3.150,0.000,0.000,0),(1564,1590,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.070,NULL,NULL,NULL,3.070,NULL,NULL,NULL,NULL,3.070,3.070,0.000,0.000,NULL,NULL,3,0,3.070,0,'2015-10-08 08:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:31','C',3.070,0.000,0.000,0),(1565,1591,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.190,NULL,NULL,NULL,4.190,NULL,NULL,NULL,NULL,4.190,4.190,0.000,0.000,NULL,NULL,3,0,4.190,0,'2015-10-08 08:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:31','C',4.190,0.000,0.000,0),(1566,1592,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.660,NULL,NULL,NULL,4.660,NULL,NULL,NULL,NULL,4.660,4.660,0.000,0.000,NULL,NULL,3,0,4.660,0,'2015-10-08 08:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:31','C',4.660,0.000,0.000,0),(1567,1593,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.450,NULL,NULL,NULL,4.450,NULL,NULL,NULL,NULL,4.450,4.450,0.000,0.000,NULL,NULL,3,0,4.450,0,'2015-10-08 08:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:32','C',4.450,0.000,0.000,0),(1568,1594,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.200,NULL,NULL,NULL,5.200,NULL,NULL,NULL,NULL,5.200,5.200,0.000,0.000,NULL,NULL,3,0,5.200,0,'2015-10-08 08:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:32','C',5.200,0.000,0.000,0),(1569,1595,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.080,NULL,NULL,NULL,6.080,NULL,NULL,NULL,NULL,6.080,6.080,0.000,0.000,NULL,NULL,3,0,6.080,0,'2015-10-08 08:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:32','C',6.080,0.000,0.000,0),(1570,1596,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.100,NULL,NULL,NULL,13.100,NULL,NULL,NULL,NULL,13.100,13.100,0.000,0.000,NULL,NULL,3,0,13.100,0,'2015-10-08 08:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:32','C',13.100,0.000,0.000,0),(1571,1597,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.860,NULL,NULL,NULL,18.860,NULL,NULL,NULL,NULL,18.860,18.860,0.000,0.000,NULL,NULL,3,0,18.860,0,'2015-10-08 08:43:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:33','C',18.860,0.000,0.000,0),(1572,1598,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,18.230,NULL,NULL,NULL,18.230,NULL,NULL,NULL,NULL,18.230,18.230,0.000,0.000,NULL,NULL,3,0,18.230,0,'2015-10-08 08:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:33','C',18.230,0.000,0.000,0),(1573,1599,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.200,NULL,NULL,NULL,1.200,NULL,NULL,NULL,NULL,1.200,1.200,0.000,0.000,NULL,NULL,3,0,1.200,0,'2015-10-08 08:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:33','C',1.200,0.000,0.000,0),(1574,1600,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.490,NULL,NULL,NULL,1.490,NULL,NULL,NULL,NULL,1.490,1.490,0.000,0.000,NULL,NULL,3,0,1.490,0,'2015-10-08 08:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:34','C',1.490,0.000,0.000,0),(1575,1601,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.330,NULL,NULL,NULL,1.330,NULL,NULL,NULL,NULL,1.330,1.330,0.000,0.000,NULL,NULL,3,0,1.330,0,'2015-10-08 08:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:34','C',1.330,0.000,0.000,0),(1576,1602,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.410,NULL,NULL,NULL,1.410,NULL,NULL,NULL,NULL,1.410,1.410,0.000,0.000,NULL,NULL,3,0,1.410,0,'2015-10-08 08:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:34','C',1.410,0.000,0.000,0),(1577,1603,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.490,NULL,NULL,NULL,1.490,NULL,NULL,NULL,NULL,1.490,1.490,0.000,0.000,NULL,NULL,3,0,1.490,0,'2015-10-08 08:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:34','C',1.490,0.000,0.000,0),(1578,1604,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.330,NULL,NULL,NULL,1.330,NULL,NULL,NULL,NULL,1.330,1.330,0.000,0.000,NULL,NULL,3,0,1.330,0,'2015-10-08 08:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:35','C',1.330,0.000,0.000,0),(1579,1605,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-08 08:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:35','C',3.480,0.000,0.000,0),(1580,1606,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,5,0,4.270,0,'2015-10-08 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:35','C',4.270,0.000,0.000,0),(1581,1607,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.610,NULL,NULL,NULL,4.610,NULL,NULL,NULL,NULL,4.610,4.610,0.000,0.000,NULL,NULL,5,0,4.610,0,'2015-10-08 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:35','C',4.610,0.000,0.000,0),(1582,1608,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.570,NULL,NULL,NULL,4.570,NULL,NULL,NULL,NULL,4.570,4.570,0.000,0.000,NULL,NULL,5,0,4.570,0,'2015-10-08 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:36','C',4.570,0.000,0.000,0),(1583,1609,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.020,NULL,NULL,NULL,3.020,NULL,NULL,NULL,NULL,3.020,3.020,0.000,0.000,NULL,NULL,5,0,3.020,0,'2015-10-08 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:36','C',3.020,0.000,0.000,0),(1584,1610,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,5,0,3.890,0,'2015-10-08 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:36','C',3.890,0.000,0.000,0),(1585,1611,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.460,NULL,NULL,NULL,4.460,NULL,NULL,NULL,NULL,4.460,4.460,0.000,0.000,NULL,NULL,5,0,4.460,0,'2015-10-08 08:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:37','C',4.460,0.000,0.000,0),(1586,1612,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,5,0,3.590,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:37','C',3.590,0.000,0.000,0),(1587,1613,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,5,0,4.080,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:37','C',4.080,0.000,0.000,0),(1588,1614,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.500,NULL,NULL,NULL,4.500,NULL,NULL,NULL,NULL,4.500,4.500,0.000,0.000,NULL,NULL,5,0,4.500,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:37','C',4.500,0.000,0.000,0),(1589,1615,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.760,NULL,NULL,NULL,4.760,NULL,NULL,NULL,NULL,4.760,4.760,0.000,0.000,NULL,NULL,5,0,4.760,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:38','C',4.760,0.000,0.000,0),(1590,1616,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.990,NULL,NULL,NULL,4.990,NULL,NULL,NULL,NULL,4.990,4.990,0.000,0.000,NULL,NULL,5,0,4.990,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:38','C',4.990,0.000,0.000,0),(1591,1617,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.120,NULL,NULL,NULL,4.120,NULL,NULL,NULL,NULL,4.120,4.120,0.000,0.000,NULL,NULL,5,0,4.120,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:38','C',4.120,0.000,0.000,0),(1592,1618,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.840,NULL,NULL,NULL,4.840,NULL,NULL,NULL,NULL,4.840,4.840,0.000,0.000,NULL,NULL,5,0,4.840,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:38','C',4.840,0.000,0.000,0),(1593,1619,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.880,NULL,NULL,NULL,4.880,NULL,NULL,NULL,NULL,4.880,4.880,0.000,0.000,NULL,NULL,5,0,4.880,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:39','C',4.880,0.000,0.000,0),(1594,1620,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.520,NULL,NULL,NULL,5.520,NULL,NULL,NULL,NULL,5.520,5.520,0.000,0.000,NULL,NULL,5,0,5.520,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:39','C',5.520,0.000,0.000,0),(1595,1621,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,5,0,4.080,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:39','C',4.080,0.000,0.000,0),(1596,1622,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,5,0,3.400,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:40','C',3.400,0.000,0.000,0),(1597,1623,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,5,0,3.670,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:40','C',3.670,0.000,0.000,0),(1598,1624,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.780,NULL,NULL,NULL,5.780,NULL,NULL,NULL,NULL,5.780,5.780,0.000,0.000,NULL,NULL,5,0,5.780,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:40','C',5.780,0.000,0.000,0),(1599,1625,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.120,NULL,NULL,NULL,4.120,NULL,NULL,NULL,NULL,4.120,4.120,0.000,0.000,NULL,NULL,5,0,4.120,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:40','C',4.120,0.000,0.000,0),(1600,1626,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.480,NULL,NULL,NULL,5.480,NULL,NULL,NULL,NULL,5.480,5.480,0.000,0.000,NULL,NULL,5,0,5.480,0,'2015-10-08 08:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:41','C',5.480,0.000,0.000,0),(1601,1627,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.860,NULL,NULL,NULL,3.860,NULL,NULL,NULL,NULL,3.860,3.860,0.000,0.000,NULL,NULL,5,0,3.860,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:41','C',3.860,0.000,0.000,0),(1602,1628,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.760,NULL,NULL,NULL,4.760,NULL,NULL,NULL,NULL,4.760,4.760,0.000,0.000,NULL,NULL,5,0,4.760,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:41','C',4.760,0.000,0.000,0),(1603,1629,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.350,NULL,NULL,NULL,4.350,NULL,NULL,NULL,NULL,4.350,4.350,0.000,0.000,NULL,NULL,5,0,4.350,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:42','C',4.350,0.000,0.000,0),(1604,1630,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:42','C',3.480,0.000,0.000,0),(1605,1631,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,5,0,3.630,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:42','C',3.630,0.000,0.000,0),(1606,1632,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.930,NULL,NULL,NULL,3.930,NULL,NULL,NULL,NULL,3.930,3.930,0.000,0.000,NULL,NULL,5,0,3.930,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:42','C',3.930,0.000,0.000,0),(1607,1633,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,5,0,3.820,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:43','C',3.820,0.000,0.000,0),(1608,1634,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.180,NULL,NULL,NULL,5.180,NULL,NULL,NULL,NULL,5.180,5.180,0.000,0.000,NULL,NULL,5,0,5.180,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:43','C',5.180,0.000,0.000,0),(1609,1635,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.200,NULL,NULL,NULL,4.200,NULL,NULL,NULL,NULL,4.200,4.200,0.000,0.000,NULL,NULL,5,0,4.200,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:43','C',4.200,0.000,0.000,0),(1610,1636,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,5,0,3.590,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:43','C',3.590,0.000,0.000,0),(1611,1637,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.730,NULL,NULL,NULL,4.730,NULL,NULL,NULL,NULL,4.730,4.730,0.000,0.000,NULL,NULL,5,0,4.730,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:44','C',4.730,0.000,0.000,0),(1612,1638,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,5,0,3.780,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:44','C',3.780,0.000,0.000,0),(1613,1639,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.290,NULL,NULL,NULL,3.290,NULL,NULL,NULL,NULL,3.290,3.290,0.000,0.000,NULL,NULL,5,0,3.290,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:44','C',3.290,0.000,0.000,0),(1614,1640,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.700,NULL,NULL,NULL,3.700,NULL,NULL,NULL,NULL,3.700,3.700,0.000,0.000,NULL,NULL,5,0,3.700,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:44','C',3.700,0.000,0.000,0),(1615,1641,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,5,0,3.330,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:45','C',3.330,0.000,0.000,0),(1616,1642,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.570,NULL,NULL,NULL,2.570,NULL,NULL,NULL,NULL,2.570,2.570,0.000,0.000,NULL,NULL,5,0,2.570,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:45','C',2.570,0.000,0.000,0),(1617,1643,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.060,NULL,NULL,NULL,3.060,NULL,NULL,NULL,NULL,3.060,3.060,0.000,0.000,NULL,NULL,5,0,3.060,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:45','C',3.060,0.000,0.000,0),(1618,1644,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.540,NULL,NULL,NULL,4.540,NULL,NULL,NULL,NULL,4.540,4.540,0.000,0.000,NULL,NULL,5,0,4.540,0,'2015-10-08 08:54:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:46','C',4.540,0.000,0.000,0),(1619,1645,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.610,NULL,NULL,NULL,4.610,NULL,NULL,NULL,NULL,4.610,4.610,0.000,0.000,NULL,NULL,5,0,4.610,0,'2015-10-08 08:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:46','C',4.610,0.000,0.000,0),(1620,1646,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.270,NULL,NULL,NULL,4.270,NULL,NULL,NULL,NULL,4.270,4.270,0.000,0.000,NULL,NULL,5,0,4.270,0,'2015-10-08 08:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:46','C',4.270,0.000,0.000,0),(1621,1647,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.180,NULL,NULL,NULL,3.180,NULL,NULL,NULL,NULL,3.180,3.180,0.000,0.000,NULL,NULL,5,0,3.180,0,'2015-10-08 08:55:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:46','C',3.180,0.000,0.000,0),(1622,1648,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,24.650,NULL,NULL,NULL,24.650,NULL,NULL,NULL,NULL,24.650,24.650,0.000,0.000,NULL,NULL,5,0,24.650,0,'2015-10-08 08:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:47','C',24.650,0.000,0.000,0),(1623,1649,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.210,NULL,NULL,NULL,11.210,NULL,NULL,NULL,NULL,11.210,11.210,0.000,0.000,NULL,NULL,5,0,11.210,0,'2015-10-08 08:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:47','C',11.210,0.000,0.000,0),(1624,1650,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.750,NULL,NULL,NULL,9.750,NULL,NULL,NULL,NULL,9.750,9.750,0.000,0.000,NULL,NULL,5,0,9.750,0,'2015-10-08 08:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:47','C',9.750,0.000,0.000,0),(1625,1651,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.450,NULL,NULL,NULL,12.450,NULL,NULL,NULL,NULL,12.450,12.450,0.000,0.000,NULL,NULL,5,0,12.450,0,'2015-10-08 08:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:48','C',12.450,0.000,0.000,0),(1626,1652,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.890,NULL,NULL,NULL,10.890,NULL,NULL,NULL,NULL,10.890,10.890,0.000,0.000,NULL,NULL,5,0,10.890,0,'2015-10-08 08:56:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:48','C',10.890,0.000,0.000,0),(1627,1653,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.330,NULL,NULL,NULL,7.330,NULL,NULL,NULL,NULL,7.330,7.330,0.000,0.000,NULL,NULL,5,0,7.330,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:48','C',7.330,0.000,0.000,0),(1628,1654,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.660,NULL,NULL,NULL,6.660,NULL,NULL,NULL,NULL,6.660,6.660,0.000,0.000,NULL,NULL,5,0,6.660,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:48','C',6.660,0.000,0.000,0),(1629,1655,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.580,NULL,NULL,NULL,6.580,NULL,NULL,NULL,NULL,6.580,6.580,0.000,0.000,NULL,NULL,5,0,6.580,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:49','C',6.580,0.000,0.000,0),(1630,1656,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.350,NULL,NULL,NULL,6.350,NULL,NULL,NULL,NULL,6.350,6.350,0.000,0.000,NULL,NULL,5,0,6.350,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:49','C',6.350,0.000,0.000,0),(1631,1657,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.910,NULL,NULL,NULL,8.910,NULL,NULL,NULL,NULL,8.910,8.910,0.000,0.000,NULL,NULL,5,0,8.910,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:49','C',8.910,0.000,0.000,0),(1632,1658,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.740,NULL,NULL,NULL,9.740,NULL,NULL,NULL,NULL,9.740,9.740,0.000,0.000,NULL,NULL,5,0,9.740,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:49','C',9.740,0.000,0.000,0),(1633,1659,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.750,NULL,NULL,NULL,7.750,NULL,NULL,NULL,NULL,7.750,7.750,0.000,0.000,NULL,NULL,5,0,7.750,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:50','C',7.750,0.000,0.000,0),(1634,1660,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.850,NULL,NULL,NULL,9.850,NULL,NULL,NULL,NULL,9.850,9.850,0.000,0.000,NULL,NULL,5,0,9.850,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:50','C',9.850,0.000,0.000,0),(1635,1661,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.930,NULL,NULL,NULL,9.930,NULL,NULL,NULL,NULL,9.930,9.930,0.000,0.000,NULL,NULL,5,0,9.930,0,'2015-10-08 08:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:50','C',9.930,0.000,0.000,0),(1636,1662,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.110,NULL,NULL,NULL,10.110,NULL,NULL,NULL,NULL,10.110,10.110,0.000,0.000,NULL,NULL,5,0,10.110,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:51','C',10.110,0.000,0.000,0),(1637,1663,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.790,NULL,NULL,NULL,10.790,NULL,NULL,NULL,NULL,10.790,10.790,0.000,0.000,NULL,NULL,5,0,10.790,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:51','C',10.790,0.000,0.000,0),(1638,1664,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.900,NULL,NULL,NULL,5.900,NULL,NULL,NULL,NULL,5.900,5.900,0.000,0.000,NULL,NULL,5,0,5.900,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:51','C',5.900,0.000,0.000,0),(1639,1665,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.810,NULL,NULL,NULL,6.810,NULL,NULL,NULL,NULL,6.810,6.810,0.000,0.000,NULL,NULL,5,0,6.810,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:51','C',6.810,0.000,0.000,0),(1640,1666,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.220,NULL,NULL,NULL,12.220,NULL,NULL,NULL,NULL,12.220,12.220,0.000,0.000,NULL,NULL,5,0,12.220,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:52','C',12.220,0.000,0.000,0),(1641,1667,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.810,NULL,NULL,NULL,9.810,NULL,NULL,NULL,NULL,9.810,9.810,0.000,0.000,NULL,NULL,5,0,9.810,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:52','C',9.810,0.000,0.000,0),(1642,1668,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.320,NULL,NULL,NULL,9.320,NULL,NULL,NULL,NULL,9.320,9.320,0.000,0.000,NULL,NULL,5,0,9.320,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:53','C',9.320,0.000,0.000,0),(1643,1669,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.210,NULL,NULL,NULL,9.210,NULL,NULL,NULL,NULL,9.210,9.210,0.000,0.000,NULL,NULL,5,0,9.210,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:53','C',9.210,0.000,0.000,0),(1644,1670,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.790,NULL,NULL,NULL,10.790,NULL,NULL,NULL,NULL,10.790,10.790,0.000,0.000,NULL,NULL,5,0,10.790,0,'2015-10-08 08:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:53','C',10.790,0.000,0.000,0),(1645,1671,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.890,NULL,NULL,NULL,10.890,NULL,NULL,NULL,NULL,10.890,10.890,0.000,0.000,NULL,NULL,5,0,10.890,0,'2015-10-08 09:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:10:53','C',10.890,0.000,0.000,0),(1646,1672,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.290,NULL,NULL,NULL,10.290,NULL,NULL,NULL,NULL,10.290,10.290,0.000,0.000,NULL,NULL,5,0,10.290,0,'2015-10-08 09:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:24','C',10.290,0.000,0.000,0),(1647,1673,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.610,NULL,NULL,NULL,9.610,NULL,NULL,NULL,NULL,9.610,9.610,0.000,0.000,NULL,NULL,5,0,9.610,0,'2015-10-08 09:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:24','C',9.610,0.000,0.000,0),(1648,1674,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.240,NULL,NULL,NULL,15.240,NULL,NULL,NULL,NULL,15.240,15.240,0.000,0.000,NULL,NULL,5,0,15.240,0,'2015-10-08 09:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:24','C',15.240,0.000,0.000,0),(1649,1675,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.570,NULL,NULL,NULL,12.570,NULL,NULL,NULL,NULL,12.570,12.570,0.000,0.000,NULL,NULL,5,0,12.570,0,'2015-10-08 09:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:24','C',12.570,0.000,0.000,0),(1650,1676,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.000,NULL,NULL,NULL,10.000,NULL,NULL,NULL,NULL,10.000,10.000,0.000,0.000,NULL,NULL,5,0,10.000,0,'2015-10-08 09:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:25','C',10.000,0.000,0.000,0),(1651,1677,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.820,NULL,NULL,NULL,11.820,NULL,NULL,NULL,NULL,11.820,11.820,0.000,0.000,NULL,NULL,5,0,11.820,0,'2015-10-08 09:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:25','C',11.820,0.000,0.000,0),(1652,1678,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.960,NULL,NULL,NULL,10.960,NULL,NULL,NULL,NULL,10.960,10.960,0.000,0.000,NULL,NULL,5,0,10.960,0,'2015-10-08 09:00:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:25','C',10.960,0.000,0.000,0),(1653,1679,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.690,NULL,NULL,NULL,4.690,NULL,NULL,NULL,NULL,4.690,4.690,0.000,0.000,NULL,NULL,5,0,4.690,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:25','C',4.690,0.000,0.000,0),(1654,1680,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.540,NULL,NULL,NULL,4.540,NULL,NULL,NULL,NULL,4.540,4.540,0.000,0.000,NULL,NULL,5,0,4.540,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:26','C',4.540,0.000,0.000,0),(1655,1681,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.120,NULL,NULL,NULL,4.120,NULL,NULL,NULL,NULL,4.120,4.120,0.000,0.000,NULL,NULL,5,0,4.120,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:26','C',4.120,0.000,0.000,0),(1656,1682,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.230,NULL,NULL,NULL,4.230,NULL,NULL,NULL,NULL,4.230,4.230,0.000,0.000,NULL,NULL,5,0,4.230,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:26','C',4.230,0.000,0.000,0),(1657,1683,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.310,NULL,NULL,NULL,4.310,NULL,NULL,NULL,NULL,4.310,4.310,0.000,0.000,NULL,NULL,5,0,4.310,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:27','C',4.310,0.000,0.000,0),(1658,1684,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.210,NULL,NULL,NULL,3.210,NULL,NULL,NULL,NULL,3.210,3.210,0.000,0.000,NULL,NULL,5,0,3.210,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:27','C',3.210,0.000,0.000,0),(1659,1685,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.710,NULL,NULL,NULL,5.710,NULL,NULL,NULL,NULL,5.710,5.710,0.000,0.000,NULL,NULL,5,0,5.710,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:27','C',5.710,0.000,0.000,0),(1660,1686,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.460,NULL,NULL,NULL,4.460,NULL,NULL,NULL,NULL,4.460,4.460,0.000,0.000,NULL,NULL,5,0,4.460,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:27','C',4.460,0.000,0.000,0),(1661,1687,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.400,NULL,NULL,NULL,3.400,NULL,NULL,NULL,NULL,3.400,3.400,0.000,0.000,NULL,NULL,5,0,3.400,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:28','C',3.400,0.000,0.000,0),(1662,1688,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.250,NULL,NULL,NULL,3.250,NULL,NULL,NULL,NULL,3.250,3.250,0.000,0.000,NULL,NULL,5,0,3.250,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:28','C',3.250,0.000,0.000,0),(1663,1689,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.060,NULL,NULL,NULL,3.060,NULL,NULL,NULL,NULL,3.060,3.060,0.000,0.000,NULL,NULL,5,0,3.060,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:28','C',3.060,0.000,0.000,0),(1664,1690,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.500,NULL,NULL,NULL,4.500,NULL,NULL,NULL,NULL,4.500,4.500,0.000,0.000,NULL,NULL,5,0,4.500,0,'2015-10-08 09:34:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:28','C',4.500,0.000,0.000,0),(1665,1691,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.860,NULL,NULL,NULL,3.860,NULL,NULL,NULL,NULL,3.860,3.860,0.000,0.000,NULL,NULL,5,0,3.860,0,'2015-10-08 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:29','C',3.860,0.000,0.000,0),(1666,1692,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,5,0,3.670,0,'2015-10-08 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:29','C',3.670,0.000,0.000,0),(1667,1693,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,5,0,3.670,0,'2015-10-08 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:29','C',3.670,0.000,0.000,0),(1668,1694,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-08 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:30','C',3.480,0.000,0.000,0),(1669,1695,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,5,0,3.740,0,'2015-10-08 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:30','C',3.740,0.000,0.000,0),(1670,1696,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.750,NULL,NULL,NULL,5.750,NULL,NULL,NULL,NULL,5.750,5.750,0.000,0.000,NULL,NULL,5,0,5.750,0,'2015-10-08 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:30','C',5.750,0.000,0.000,0),(1671,1697,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.060,NULL,NULL,NULL,3.060,NULL,NULL,NULL,NULL,3.060,3.060,0.000,0.000,NULL,NULL,5,0,3.060,0,'2015-10-08 09:35:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:30','C',3.060,0.000,0.000,0),(1672,1698,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.590,NULL,NULL,NULL,3.590,NULL,NULL,NULL,NULL,3.590,3.590,0.000,0.000,NULL,NULL,5,0,3.590,0,'2015-10-08 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:31','C',3.590,0.000,0.000,0),(1673,1699,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.290,NULL,NULL,NULL,5.290,NULL,NULL,NULL,NULL,5.290,5.290,0.000,0.000,NULL,NULL,5,0,5.290,0,'2015-10-08 09:36:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:31','C',5.290,0.000,0.000,0),(1674,1700,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.880,NULL,NULL,NULL,3.880,NULL,NULL,NULL,NULL,3.880,3.880,0.000,0.000,NULL,NULL,5,0,3.880,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:31','C',3.880,0.000,0.000,0),(1675,1701,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:31','C',3.480,0.000,0.000,0),(1676,1702,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.490,NULL,NULL,NULL,2.490,NULL,NULL,NULL,NULL,2.490,2.490,0.000,0.000,NULL,NULL,5,0,2.490,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:32','C',2.490,0.000,0.000,0),(1677,1703,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.260,NULL,NULL,NULL,3.260,NULL,NULL,NULL,NULL,3.260,3.260,0.000,0.000,NULL,NULL,5,0,3.260,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:32','C',3.260,0.000,0.000,0),(1678,1704,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.900,NULL,NULL,NULL,2.900,NULL,NULL,NULL,NULL,2.900,2.900,0.000,0.000,NULL,NULL,5,0,2.900,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:32','C',2.900,0.000,0.000,0),(1679,1705,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.850,NULL,NULL,NULL,3.850,NULL,NULL,NULL,NULL,3.850,3.850,0.000,0.000,NULL,NULL,5,0,3.850,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:33','C',3.850,0.000,0.000,0),(1680,1706,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,5,0,3.300,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:33','C',3.300,0.000,0.000,0),(1681,1707,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.230,NULL,NULL,NULL,3.230,NULL,NULL,NULL,NULL,3.230,3.230,0.000,0.000,NULL,NULL,5,0,3.230,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:33','C',3.230,0.000,0.000,0),(1682,1708,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,5,0,3.630,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:34','C',3.630,0.000,0.000,0),(1683,1709,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,5,0,3.670,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:34','C',3.670,0.000,0.000,0),(1684,1710,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.650,NULL,NULL,NULL,2.650,NULL,NULL,NULL,NULL,2.650,2.650,0.000,0.000,NULL,NULL,5,0,2.650,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:34','C',2.650,0.000,0.000,0),(1685,1711,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.900,NULL,NULL,NULL,2.900,NULL,NULL,NULL,NULL,2.900,2.900,0.000,0.000,NULL,NULL,5,0,2.900,0,'2015-10-08 09:38:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:34','C',2.900,0.000,0.000,0),(1686,1712,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.170,NULL,NULL,NULL,3.170,NULL,NULL,NULL,NULL,3.170,3.170,0.000,0.000,NULL,NULL,5,0,3.170,0,'2015-10-08 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:35','C',3.170,0.000,0.000,0),(1687,1713,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.820,NULL,NULL,NULL,3.820,NULL,NULL,NULL,NULL,3.820,3.820,0.000,0.000,NULL,NULL,5,0,3.820,0,'2015-10-08 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:35','C',3.820,0.000,0.000,0),(1688,1714,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-08 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:35','C',3.480,0.000,0.000,0),(1689,1715,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.430,NULL,NULL,NULL,2.430,NULL,NULL,NULL,NULL,2.430,2.430,0.000,0.000,NULL,NULL,5,0,2.430,0,'2015-10-08 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:36','C',2.430,0.000,0.000,0),(1690,1716,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.070,NULL,NULL,NULL,4.070,NULL,NULL,NULL,NULL,4.070,4.070,0.000,0.000,NULL,NULL,5,0,4.070,0,'2015-10-08 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:36','C',4.070,0.000,0.000,0),(1691,1717,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.530,NULL,NULL,NULL,2.530,NULL,NULL,NULL,NULL,2.530,2.530,0.000,0.000,NULL,NULL,5,0,2.530,0,'2015-10-08 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:36','C',2.530,0.000,0.000,0),(1692,1718,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,5,0,3.330,0,'2015-10-08 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:36','C',3.330,0.000,0.000,0),(1693,1719,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.220,NULL,NULL,NULL,2.220,NULL,NULL,NULL,NULL,2.220,2.220,0.000,0.000,NULL,NULL,5,0,2.220,0,'2015-10-08 09:39:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:37','C',2.220,0.000,0.000,0),(1694,1720,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.360,NULL,NULL,NULL,3.360,NULL,NULL,NULL,NULL,3.360,3.360,0.000,0.000,NULL,NULL,5,0,3.360,0,'2015-10-08 09:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:37','C',3.360,0.000,0.000,0),(1695,1721,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.540,NULL,NULL,NULL,3.540,NULL,NULL,NULL,NULL,3.540,3.540,0.000,0.000,NULL,NULL,5,0,3.540,0,'2015-10-08 09:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:37','C',3.540,0.000,0.000,0),(1696,1722,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.360,NULL,NULL,NULL,3.360,NULL,NULL,NULL,NULL,3.360,3.360,0.000,0.000,NULL,NULL,5,0,3.360,0,'2015-10-08 09:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:38','C',3.360,0.000,0.000,0),(1697,1723,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.930,NULL,NULL,NULL,2.930,NULL,NULL,NULL,NULL,2.930,2.930,0.000,0.000,NULL,NULL,5,0,2.930,0,'2015-10-08 09:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:38','C',2.930,0.000,0.000,0),(1698,1724,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.390,NULL,NULL,NULL,3.390,NULL,NULL,NULL,NULL,3.390,3.390,0.000,0.000,NULL,NULL,5,0,3.390,0,'2015-10-08 09:40:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:38','C',3.390,0.000,0.000,0),(1699,1725,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.370,NULL,NULL,NULL,4.370,NULL,NULL,NULL,NULL,4.370,4.370,0.000,0.000,NULL,NULL,5,0,4.370,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:39','C',4.370,0.000,0.000,0),(1700,1726,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.190,NULL,NULL,NULL,2.190,NULL,NULL,NULL,NULL,2.190,2.190,0.000,0.000,NULL,NULL,5,0,2.190,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:39','C',2.190,0.000,0.000,0),(1701,1727,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.230,NULL,NULL,NULL,3.230,NULL,NULL,NULL,NULL,3.230,3.230,0.000,0.000,NULL,NULL,5,0,3.230,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:39','C',3.230,0.000,0.000,0),(1702,1728,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.860,NULL,NULL,NULL,2.860,NULL,NULL,NULL,NULL,2.860,2.860,0.000,0.000,NULL,NULL,5,0,2.860,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:39','C',2.860,0.000,0.000,0),(1703,1729,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.900,NULL,NULL,NULL,2.900,NULL,NULL,NULL,NULL,2.900,2.900,0.000,0.000,NULL,NULL,5,0,2.900,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:40','C',2.900,0.000,0.000,0),(1704,1730,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,5,0,3.330,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:40','C',3.330,0.000,0.000,0),(1705,1731,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.330,NULL,NULL,NULL,3.330,NULL,NULL,NULL,NULL,3.330,3.330,0.000,0.000,NULL,NULL,5,0,3.330,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:40','C',3.330,0.000,0.000,0),(1706,1732,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.670,NULL,NULL,NULL,3.670,NULL,NULL,NULL,NULL,3.670,3.670,0.000,0.000,NULL,NULL,5,0,3.670,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:41','C',3.670,0.000,0.000,0),(1707,1733,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.800,NULL,NULL,NULL,2.800,NULL,NULL,NULL,NULL,2.800,2.800,0.000,0.000,NULL,NULL,5,0,2.800,0,'2015-10-08 09:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:41','C',2.800,0.000,0.000,0),(1708,1734,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.710,NULL,NULL,NULL,2.710,NULL,NULL,NULL,NULL,2.710,2.710,0.000,0.000,NULL,NULL,5,0,2.710,0,'2015-10-08 09:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:41','C',2.710,0.000,0.000,0),(1709,1735,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,5,0,4.000,0,'2015-10-08 09:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:41','C',4.000,0.000,0.000,0),(1710,1736,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.220,NULL,NULL,NULL,2.220,NULL,NULL,NULL,NULL,2.220,2.220,0.000,0.000,NULL,NULL,5,0,2.220,0,'2015-10-08 09:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:42','C',2.220,0.000,0.000,0),(1711,1737,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.850,NULL,NULL,NULL,3.850,NULL,NULL,NULL,NULL,3.850,3.850,0.000,0.000,NULL,NULL,5,0,3.850,0,'2015-10-08 09:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:42','C',3.850,0.000,0.000,0),(1712,1738,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.260,NULL,NULL,NULL,3.260,NULL,NULL,NULL,NULL,3.260,3.260,0.000,0.000,NULL,NULL,5,0,3.260,0,'2015-10-08 09:42:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:42','C',3.260,0.000,0.000,0),(1713,1739,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.420,NULL,NULL,NULL,8.420,NULL,NULL,NULL,NULL,8.420,8.420,0.000,0.000,NULL,NULL,5,0,8.420,0,'2015-10-08 09:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:42','C',8.420,0.000,0.000,0),(1714,1740,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.350,NULL,NULL,NULL,10.350,NULL,NULL,NULL,NULL,10.350,10.350,0.000,0.000,NULL,NULL,5,0,10.350,0,'2015-10-08 09:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:43','C',10.350,0.000,0.000,0),(1715,1741,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.000,NULL,NULL,NULL,11.000,NULL,NULL,NULL,NULL,11.000,11.000,0.000,0.000,NULL,NULL,5,0,11.000,0,'2015-10-08 09:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:43','C',11.000,0.000,0.000,0),(1716,1742,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.790,NULL,NULL,NULL,9.790,NULL,NULL,NULL,NULL,9.790,9.790,0.000,0.000,NULL,NULL,5,0,9.790,0,'2015-10-08 09:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:43','C',9.790,0.000,0.000,0),(1717,1743,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.240,NULL,NULL,NULL,13.240,NULL,NULL,NULL,NULL,13.240,13.240,0.000,0.000,NULL,NULL,5,0,13.240,0,'2015-10-08 09:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:44','C',13.240,0.000,0.000,0),(1718,1744,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.420,NULL,NULL,NULL,13.420,NULL,NULL,NULL,NULL,13.420,13.420,0.000,0.000,NULL,NULL,5,0,13.420,0,'2015-10-08 09:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:44','C',13.420,0.000,0.000,0),(1719,1745,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.960,NULL,NULL,NULL,13.960,NULL,NULL,NULL,NULL,13.960,13.960,0.000,0.000,NULL,NULL,5,0,13.960,0,'2015-10-08 09:44:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:44','C',13.960,0.000,0.000,0),(1720,1746,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.960,NULL,NULL,NULL,10.960,NULL,NULL,NULL,NULL,10.960,10.960,0.000,0.000,NULL,NULL,5,0,10.960,0,'2015-10-08 09:45:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:44','C',10.960,0.000,0.000,0),(1721,1747,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.430,NULL,NULL,NULL,11.430,NULL,NULL,NULL,NULL,11.430,11.430,0.000,0.000,NULL,NULL,5,0,11.430,0,'2015-10-08 09:46:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:45','C',11.430,0.000,0.000,0),(1722,1748,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.070,NULL,NULL,NULL,12.070,NULL,NULL,NULL,NULL,12.070,12.070,0.000,0.000,NULL,NULL,5,0,12.070,0,'2015-10-08 09:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:45','C',12.070,0.000,0.000,0),(1723,1749,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.910,NULL,NULL,NULL,5.910,NULL,NULL,NULL,NULL,5.910,5.910,0.000,0.000,NULL,NULL,5,0,5.910,0,'2015-10-08 09:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:45','C',5.910,0.000,0.000,0),(1724,1750,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.020,NULL,NULL,NULL,5.020,NULL,NULL,NULL,NULL,5.020,5.020,0.000,0.000,NULL,NULL,5,0,5.020,0,'2015-10-08 09:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:45','C',5.020,0.000,0.000,0),(1725,1751,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.280,NULL,NULL,NULL,5.280,NULL,NULL,NULL,NULL,5.280,5.280,0.000,0.000,NULL,NULL,5,0,5.280,0,'2015-10-08 09:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:46','C',5.280,0.000,0.000,0),(1726,1752,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.960,NULL,NULL,NULL,4.960,NULL,NULL,NULL,NULL,4.960,4.960,0.000,0.000,NULL,NULL,5,0,4.960,0,'2015-10-08 09:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:46','C',4.960,0.000,0.000,0),(1727,1753,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.820,NULL,NULL,NULL,5.820,NULL,NULL,NULL,NULL,5.820,5.820,0.000,0.000,NULL,NULL,5,0,5.820,0,'2015-10-08 09:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:46','C',5.820,0.000,0.000,0),(1728,1754,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.720,NULL,NULL,NULL,5.720,NULL,NULL,NULL,NULL,5.720,5.720,0.000,0.000,NULL,NULL,5,0,5.720,0,'2015-10-08 09:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:46','C',5.720,0.000,0.000,0),(1729,1755,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.530,NULL,NULL,NULL,5.530,NULL,NULL,NULL,NULL,5.530,5.530,0.000,0.000,NULL,NULL,5,0,5.530,0,'2015-10-08 09:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:47','C',5.530,0.000,0.000,0),(1730,1756,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.250,NULL,NULL,NULL,7.250,NULL,NULL,NULL,NULL,7.250,7.250,0.000,0.000,NULL,NULL,5,0,7.250,0,'2015-10-08 09:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:47','C',7.250,0.000,0.000,0),(1731,1757,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.000,NULL,NULL,NULL,7.000,NULL,NULL,NULL,NULL,7.000,7.000,0.000,0.000,NULL,NULL,5,0,7.000,0,'2015-10-08 09:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:47','C',7.000,0.000,0.000,0),(1732,1758,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.300,NULL,NULL,NULL,6.300,NULL,NULL,NULL,NULL,6.300,6.300,0.000,0.000,NULL,NULL,5,0,6.300,0,'2015-10-08 09:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:48','C',6.300,0.000,0.000,0),(1733,1759,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.480,NULL,NULL,NULL,7.480,NULL,NULL,NULL,NULL,7.480,7.480,0.000,0.000,NULL,NULL,5,0,7.480,0,'2015-10-08 09:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:48','C',7.480,0.000,0.000,0),(1734,1760,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.130,NULL,NULL,NULL,3.130,NULL,NULL,NULL,NULL,3.130,3.130,0.000,0.000,NULL,NULL,5,0,3.130,0,'2015-10-08 09:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:48','C',3.130,0.000,0.000,0),(1735,1761,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.530,NULL,NULL,NULL,3.530,NULL,NULL,NULL,NULL,3.530,3.530,0.000,0.000,NULL,NULL,5,0,3.530,0,'2015-10-08 09:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:48','C',3.530,0.000,0.000,0),(1736,1762,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.030,NULL,NULL,NULL,3.030,NULL,NULL,NULL,NULL,3.030,3.030,0.000,0.000,NULL,NULL,5,0,3.030,0,'2015-10-08 09:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:49','C',3.030,0.000,0.000,0),(1737,1763,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,5,0,3.280,0,'2015-10-08 09:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:49','C',3.280,0.000,0.000,0),(1738,1764,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,5,0,3.450,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:49','C',3.450,0.000,0.000,0),(1739,1765,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.500,NULL,NULL,NULL,3.500,NULL,NULL,NULL,NULL,3.500,3.500,0.000,0.000,NULL,NULL,5,0,3.500,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:49','C',3.500,0.000,0.000,0),(1740,1766,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.180,NULL,NULL,NULL,3.180,NULL,NULL,NULL,NULL,3.180,3.180,0.000,0.000,NULL,NULL,5,0,3.180,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:50','C',3.180,0.000,0.000,0),(1741,1767,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.600,NULL,NULL,NULL,3.600,NULL,NULL,NULL,NULL,3.600,3.600,0.000,0.000,NULL,NULL,5,0,3.600,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:50','C',3.600,0.000,0.000,0),(1742,1768,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.630,NULL,NULL,NULL,3.630,NULL,NULL,NULL,NULL,3.630,3.630,0.000,0.000,NULL,NULL,5,0,3.630,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:50','C',3.630,0.000,0.000,0),(1743,1769,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.030,NULL,NULL,NULL,3.030,NULL,NULL,NULL,NULL,3.030,3.030,0.000,0.000,NULL,NULL,5,0,3.030,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:51','C',3.030,0.000,0.000,0),(1744,1770,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.980,NULL,NULL,NULL,6.980,NULL,NULL,NULL,NULL,6.980,6.980,0.000,0.000,NULL,NULL,5,0,6.980,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:51','C',6.980,0.000,0.000,0),(1745,1771,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.250,NULL,NULL,NULL,7.250,NULL,NULL,NULL,NULL,7.250,7.250,0.000,0.000,NULL,NULL,5,0,7.250,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:11:51','C',7.250,0.000,0.000,0),(1746,1772,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.500,NULL,NULL,NULL,7.500,NULL,NULL,NULL,NULL,7.500,7.500,0.000,0.000,NULL,NULL,5,0,7.500,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:24','C',7.500,0.000,0.000,0),(1747,1773,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.430,NULL,NULL,NULL,6.430,NULL,NULL,NULL,NULL,6.430,6.430,0.000,0.000,NULL,NULL,5,0,6.430,0,'2015-10-08 09:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:25','C',6.430,0.000,0.000,0),(1748,1774,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.130,NULL,NULL,NULL,7.130,NULL,NULL,NULL,NULL,7.130,7.130,0.000,0.000,NULL,NULL,5,0,7.130,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:25','C',7.130,0.000,0.000,0),(1749,1775,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.830,NULL,NULL,NULL,6.830,NULL,NULL,NULL,NULL,6.830,6.830,0.000,0.000,NULL,NULL,5,0,6.830,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:25','C',6.830,0.000,0.000,0),(1750,1776,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.600,NULL,NULL,NULL,6.600,NULL,NULL,NULL,NULL,6.600,6.600,0.000,0.000,NULL,NULL,5,0,6.600,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:26','C',6.600,0.000,0.000,0),(1751,1777,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.530,NULL,NULL,NULL,6.530,NULL,NULL,NULL,NULL,6.530,6.530,0.000,0.000,NULL,NULL,5,0,6.530,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:26','C',6.530,0.000,0.000,0),(1752,1778,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.900,NULL,NULL,NULL,6.900,NULL,NULL,NULL,NULL,6.900,6.900,0.000,0.000,NULL,NULL,5,0,6.900,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:27','C',6.900,0.000,0.000,0),(1753,1779,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.030,NULL,NULL,NULL,3.030,NULL,NULL,NULL,NULL,3.030,3.030,0.000,0.000,NULL,NULL,5,0,3.030,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:27','C',3.030,0.000,0.000,0),(1754,1780,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,5,0,3.300,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:27','C',3.300,0.000,0.000,0),(1755,1781,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.280,NULL,NULL,NULL,3.280,NULL,NULL,NULL,NULL,3.280,3.280,0.000,0.000,NULL,NULL,5,0,3.280,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:27','C',3.280,0.000,0.000,0),(1756,1782,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.800,NULL,NULL,NULL,3.800,NULL,NULL,NULL,NULL,3.800,3.800,0.000,0.000,NULL,NULL,5,0,3.800,0,'2015-10-08 09:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:28','C',3.800,0.000,0.000,0),(1757,1783,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.150,NULL,NULL,NULL,3.150,NULL,NULL,NULL,NULL,3.150,3.150,0.000,0.000,NULL,NULL,5,0,3.150,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:28','C',3.150,0.000,0.000,0),(1758,1784,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,5,0,3.300,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:28','C',3.300,0.000,0.000,0),(1759,1785,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.450,NULL,NULL,NULL,3.450,NULL,NULL,NULL,NULL,3.450,3.450,0.000,0.000,NULL,NULL,5,0,3.450,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:29','C',3.450,0.000,0.000,0),(1760,1786,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.850,NULL,NULL,NULL,2.850,NULL,NULL,NULL,NULL,2.850,2.850,0.000,0.000,NULL,NULL,5,0,2.850,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:29','C',2.850,0.000,0.000,0),(1761,1787,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.080,NULL,NULL,NULL,3.080,NULL,NULL,NULL,NULL,3.080,3.080,0.000,0.000,NULL,NULL,5,0,3.080,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:29','C',3.080,0.000,0.000,0),(1762,1788,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.800,NULL,NULL,NULL,3.800,NULL,NULL,NULL,NULL,3.800,3.800,0.000,0.000,NULL,NULL,5,0,3.800,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:30','C',3.800,0.000,0.000,0),(1763,1789,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,5,0,3.780,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:30','C',3.780,0.000,0.000,0),(1764,1790,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.700,NULL,NULL,NULL,3.700,NULL,NULL,NULL,NULL,3.700,3.700,0.000,0.000,NULL,NULL,5,0,3.700,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:30','C',3.700,0.000,0.000,0),(1765,1791,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,5,0,3.300,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:30','C',3.300,0.000,0.000,0),(1766,1792,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.880,NULL,NULL,NULL,2.880,NULL,NULL,NULL,NULL,2.880,2.880,0.000,0.000,NULL,NULL,5,0,2.880,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:31','C',2.880,0.000,0.000,0),(1767,1793,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.830,NULL,NULL,NULL,3.830,NULL,NULL,NULL,NULL,3.830,3.830,0.000,0.000,NULL,NULL,5,0,3.830,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:31','C',3.830,0.000,0.000,0),(1768,1794,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.850,NULL,NULL,NULL,2.850,NULL,NULL,NULL,NULL,2.850,2.850,0.000,0.000,NULL,NULL,5,0,2.850,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:31','C',2.850,0.000,0.000,0),(1769,1795,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:31','C',3.480,0.000,0.000,0),(1770,1796,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.680,NULL,NULL,NULL,3.680,NULL,NULL,NULL,NULL,3.680,3.680,0.000,0.000,NULL,NULL,5,0,3.680,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:32','C',3.680,0.000,0.000,0),(1771,1797,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.730,NULL,NULL,NULL,6.730,NULL,NULL,NULL,NULL,6.730,6.730,0.000,0.000,NULL,NULL,5,0,6.730,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:32','C',6.730,0.000,0.000,0),(1772,1798,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.400,NULL,NULL,NULL,6.400,NULL,NULL,NULL,NULL,6.400,6.400,0.000,0.000,NULL,NULL,5,0,6.400,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:32','C',6.400,0.000,0.000,0),(1773,1799,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.800,NULL,NULL,NULL,6.800,NULL,NULL,NULL,NULL,6.800,6.800,0.000,0.000,NULL,NULL,5,0,6.800,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:32','C',6.800,0.000,0.000,0),(1774,1800,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-08 09:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:33','C',3.480,0.000,0.000,0),(1775,1801,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.750,NULL,NULL,NULL,3.750,NULL,NULL,NULL,NULL,3.750,3.750,0.000,0.000,NULL,NULL,5,0,3.750,0,'2015-10-08 09:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:33','C',3.750,0.000,0.000,0),(1776,1802,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.080,NULL,NULL,NULL,3.080,NULL,NULL,NULL,NULL,3.080,3.080,0.000,0.000,NULL,NULL,5,0,3.080,0,'2015-10-08 09:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:33','C',3.080,0.000,0.000,0),(1777,1803,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.300,NULL,NULL,NULL,6.300,NULL,NULL,NULL,NULL,6.300,6.300,0.000,0.000,NULL,NULL,5,0,6.300,0,'2015-10-08 09:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:34','C',6.300,0.000,0.000,0),(1778,1804,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.350,NULL,NULL,NULL,3.350,NULL,NULL,NULL,NULL,3.350,3.350,0.000,0.000,NULL,NULL,5,0,3.350,0,'2015-10-08 09:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:34','C',3.350,0.000,0.000,0),(1779,1805,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.950,NULL,NULL,NULL,2.950,NULL,NULL,NULL,NULL,2.950,2.950,0.000,0.000,NULL,NULL,5,0,2.950,0,'2015-10-08 09:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:35','C',2.950,0.000,0.000,0),(1780,1806,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,5,0,3.480,0,'2015-10-08 09:53:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:35','C',3.480,0.000,0.000,0),(1781,1807,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.140,NULL,NULL,NULL,14.140,NULL,NULL,NULL,NULL,14.140,14.140,0.000,0.000,NULL,NULL,5,0,14.140,0,'2015-10-08 09:57:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:35','C',14.140,0.000,0.000,0),(1782,1808,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.430,NULL,NULL,NULL,12.430,NULL,NULL,NULL,NULL,12.430,12.430,0.000,0.000,NULL,NULL,5,0,12.430,0,'2015-10-08 09:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:35','C',12.430,0.000,0.000,0),(1783,1809,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.150,NULL,NULL,NULL,11.150,NULL,NULL,NULL,NULL,11.150,11.150,0.000,0.000,NULL,NULL,5,0,11.150,0,'2015-10-08 09:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:36','C',11.150,0.000,0.000,0),(1784,1810,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.800,NULL,NULL,NULL,11.800,NULL,NULL,NULL,NULL,11.800,11.800,0.000,0.000,NULL,NULL,5,0,11.800,0,'2015-10-08 09:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:36','C',11.800,0.000,0.000,0),(1785,1811,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.570,NULL,NULL,NULL,13.570,NULL,NULL,NULL,NULL,13.570,13.570,0.000,0.000,NULL,NULL,5,0,13.570,0,'2015-10-08 09:58:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:36','C',13.570,0.000,0.000,0),(1786,1812,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-08 09:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:37','C',0.000,0.000,0.000,0),(1787,1813,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-08 09:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:37','C',0.000,0.000,0.000,0),(1788,1814,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-08 09:59:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:37','C',0.000,0.000,0.000,0),(1789,1815,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.210,NULL,NULL,NULL,2.210,NULL,NULL,NULL,NULL,2.210,2.210,0.000,0.000,NULL,NULL,1,0,2.210,0,'2015-10-08 10:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:37','C',2.210,0.000,0.000,0),(1790,1816,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.900,NULL,NULL,NULL,3.900,NULL,NULL,NULL,NULL,3.900,3.900,0.000,0.000,NULL,NULL,1,0,3.900,0,'2015-10-08 10:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:38','C',3.900,0.000,0.000,0),(1791,1817,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,1,0,3.740,0,'2015-10-08 10:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:38','C',3.740,0.000,0.000,0),(1792,1818,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.960,NULL,NULL,NULL,1.960,NULL,NULL,NULL,NULL,1.960,1.960,0.000,0.000,NULL,NULL,1,0,1.960,0,'2015-10-08 10:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:38','C',1.960,0.000,0.000,0),(1793,1819,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.450,NULL,NULL,NULL,2.450,NULL,NULL,NULL,NULL,2.450,2.450,0.000,0.000,NULL,NULL,1,0,2.450,0,'2015-10-08 10:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:38','C',2.450,0.000,0.000,0),(1794,1820,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.420,NULL,NULL,NULL,3.420,NULL,NULL,NULL,NULL,3.420,3.420,0.000,0.000,NULL,NULL,1,0,3.420,0,'2015-10-08 10:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:39','C',3.420,0.000,0.000,0),(1795,1821,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.250,NULL,NULL,NULL,3.250,NULL,NULL,NULL,NULL,3.250,3.250,0.000,0.000,NULL,NULL,1,0,3.250,0,'2015-10-08 10:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:39','C',3.250,0.000,0.000,0),(1796,1822,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.090,NULL,NULL,NULL,2.090,NULL,NULL,NULL,NULL,2.090,2.090,0.000,0.000,NULL,NULL,1,0,2.090,0,'2015-10-08 10:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:39','C',2.090,0.000,0.000,0),(1797,1823,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.750,NULL,NULL,NULL,2.750,NULL,NULL,NULL,NULL,2.750,2.750,0.000,0.000,NULL,NULL,1,0,2.750,0,'2015-10-08 10:06:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:39','C',2.750,0.000,0.000,0),(1798,1824,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.020,NULL,NULL,NULL,4.020,NULL,NULL,NULL,NULL,4.020,4.020,0.000,0.000,NULL,NULL,1,0,4.020,0,'2015-10-08 10:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:40','C',4.020,0.000,0.000,0),(1799,1825,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.460,NULL,NULL,NULL,3.460,NULL,NULL,NULL,NULL,3.460,3.460,0.000,0.000,NULL,NULL,1,0,3.460,0,'2015-10-08 10:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:40','C',3.460,0.000,0.000,0),(1800,1826,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.060,NULL,NULL,NULL,5.060,NULL,NULL,NULL,NULL,5.060,5.060,0.000,0.000,NULL,NULL,1,0,5.060,0,'2015-10-08 10:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:40','C',5.060,0.000,0.000,0),(1801,1827,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.210,NULL,NULL,NULL,4.210,NULL,NULL,NULL,NULL,4.210,4.210,0.000,0.000,NULL,NULL,1,0,4.210,0,'2015-10-08 10:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:41','C',4.210,0.000,0.000,0),(1802,1828,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.460,NULL,NULL,NULL,3.460,NULL,NULL,NULL,NULL,3.460,3.460,0.000,0.000,NULL,NULL,1,0,3.460,0,'2015-10-08 10:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:41','C',3.460,0.000,0.000,0),(1803,1829,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.280,NULL,NULL,NULL,5.280,NULL,NULL,NULL,NULL,5.280,5.280,0.000,0.000,NULL,NULL,1,0,5.280,0,'2015-10-08 10:08:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:41','C',5.280,0.000,0.000,0),(1804,1830,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.340,NULL,NULL,NULL,5.340,NULL,NULL,NULL,NULL,5.340,5.340,0.000,0.000,NULL,NULL,1,0,5.340,0,'2015-10-08 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:41','C',5.340,0.000,0.000,0),(1805,1831,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.890,NULL,NULL,NULL,3.890,NULL,NULL,NULL,NULL,3.890,3.890,0.000,0.000,NULL,NULL,1,0,3.890,0,'2015-10-08 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:42','C',3.890,0.000,0.000,0),(1806,1832,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.670,NULL,NULL,NULL,6.670,NULL,NULL,NULL,NULL,6.670,6.670,0.000,0.000,NULL,NULL,1,0,6.670,0,'2015-10-08 10:09:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:42','C',6.670,0.000,0.000,0),(1807,1833,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.480,NULL,NULL,NULL,7.480,NULL,NULL,NULL,NULL,7.480,7.480,0.000,0.000,NULL,NULL,1,0,7.480,0,'2015-10-08 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:42','C',7.480,0.000,0.000,0),(1808,1834,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.760,NULL,NULL,NULL,4.760,NULL,NULL,NULL,NULL,4.760,4.760,0.000,0.000,NULL,NULL,1,0,4.760,0,'2015-10-08 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:42','C',4.760,0.000,0.000,0),(1809,1835,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.720,NULL,NULL,NULL,5.720,NULL,NULL,NULL,NULL,5.720,5.720,0.000,0.000,NULL,NULL,1,0,5.720,0,'2015-10-08 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:43','C',5.720,0.000,0.000,0),(1810,1836,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.160,NULL,NULL,NULL,3.160,NULL,NULL,NULL,NULL,3.160,3.160,0.000,0.000,NULL,NULL,1,0,3.160,0,'2015-10-08 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:43','C',3.160,0.000,0.000,0),(1811,1837,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.100,NULL,NULL,NULL,5.100,NULL,NULL,NULL,NULL,5.100,5.100,0.000,0.000,NULL,NULL,1,0,5.100,0,'2015-10-08 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:43','C',5.100,0.000,0.000,0),(1812,1838,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.880,NULL,NULL,NULL,4.880,NULL,NULL,NULL,NULL,4.880,4.880,0.000,0.000,NULL,NULL,1,0,4.880,0,'2015-10-08 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:44','C',4.880,0.000,0.000,0),(1813,1839,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.810,NULL,NULL,NULL,5.810,NULL,NULL,NULL,NULL,5.810,5.810,0.000,0.000,NULL,NULL,1,0,5.810,0,'2015-10-08 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:44','C',5.810,0.000,0.000,0),(1814,1840,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.060,NULL,NULL,NULL,5.060,NULL,NULL,NULL,NULL,5.060,5.060,0.000,0.000,NULL,NULL,1,0,5.060,0,'2015-10-08 10:10:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:44','C',5.060,0.000,0.000,0),(1815,1841,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.600,NULL,NULL,NULL,4.600,NULL,NULL,NULL,NULL,4.600,4.600,0.000,0.000,NULL,NULL,1,0,4.600,0,'2015-10-08 10:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:44','C',4.600,0.000,0.000,0),(1816,1842,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.750,NULL,NULL,NULL,5.750,NULL,NULL,NULL,NULL,5.750,5.750,0.000,0.000,NULL,NULL,1,0,5.750,0,'2015-10-08 10:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:45','C',5.750,0.000,0.000,0),(1817,1843,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.470,NULL,NULL,NULL,5.470,NULL,NULL,NULL,NULL,5.470,5.470,0.000,0.000,NULL,NULL,1,0,5.470,0,'2015-10-08 10:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:45','C',5.470,0.000,0.000,0),(1818,1844,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.030,NULL,NULL,NULL,5.030,NULL,NULL,NULL,NULL,5.030,5.030,0.000,0.000,NULL,NULL,1,0,5.030,0,'2015-10-08 10:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:45','C',5.030,0.000,0.000,0),(1819,1845,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.640,NULL,NULL,NULL,7.640,NULL,NULL,NULL,NULL,7.640,7.640,0.000,0.000,NULL,NULL,1,0,7.640,0,'2015-10-08 10:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:45','C',7.640,0.000,0.000,0),(1820,1846,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.660,NULL,NULL,NULL,6.660,NULL,NULL,NULL,NULL,6.660,6.660,0.000,0.000,NULL,NULL,1,0,6.660,0,'2015-10-08 10:11:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:46','C',6.660,0.000,0.000,0),(1821,1847,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.420,NULL,NULL,NULL,11.420,NULL,NULL,NULL,NULL,11.420,11.420,0.000,0.000,NULL,NULL,1,0,11.420,0,'2015-10-08 10:12:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:46','C',11.420,0.000,0.000,0),(1822,1848,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.190,NULL,NULL,NULL,6.190,NULL,NULL,NULL,NULL,6.190,6.190,0.000,0.000,NULL,NULL,1,0,6.190,0,'2015-10-08 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:46','C',6.190,0.000,0.000,0),(1823,1849,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.750,NULL,NULL,NULL,6.750,NULL,NULL,NULL,NULL,6.750,6.750,0.000,0.000,NULL,NULL,1,0,6.750,0,'2015-10-08 10:13:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:46','C',6.750,0.000,0.000,0),(1824,1850,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.480,NULL,NULL,NULL,3.480,NULL,NULL,NULL,NULL,3.480,3.480,0.000,0.000,NULL,NULL,1,0,3.480,0,'2015-10-08 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:47','C',3.480,0.000,0.000,0),(1825,1851,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.750,NULL,NULL,NULL,4.750,NULL,NULL,NULL,NULL,4.750,4.750,0.000,0.000,NULL,NULL,1,0,4.750,0,'2015-10-08 10:15:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:47','C',4.750,0.000,0.000,0),(1826,1852,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.010,NULL,NULL,NULL,4.010,NULL,NULL,NULL,NULL,4.010,4.010,0.000,0.000,NULL,NULL,1,0,4.010,0,'2015-10-08 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:47','C',4.010,0.000,0.000,0),(1827,1853,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.050,NULL,NULL,NULL,4.050,NULL,NULL,NULL,NULL,4.050,4.050,0.000,0.000,NULL,NULL,1,0,4.050,0,'2015-10-08 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:48','C',4.050,0.000,0.000,0),(1828,1854,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.660,NULL,NULL,NULL,3.660,NULL,NULL,NULL,NULL,3.660,3.660,0.000,0.000,NULL,NULL,1,0,3.660,0,'2015-10-08 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:48','C',3.660,0.000,0.000,0),(1829,1855,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.360,NULL,NULL,NULL,4.360,NULL,NULL,NULL,NULL,4.360,4.360,0.000,0.000,NULL,NULL,1,0,4.360,0,'2015-10-08 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:48','C',4.360,0.000,0.000,0),(1830,1856,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.360,NULL,NULL,NULL,4.360,NULL,NULL,NULL,NULL,4.360,4.360,0.000,0.000,NULL,NULL,1,0,4.360,0,'2015-10-08 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:48','C',4.360,0.000,0.000,0),(1831,1857,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.220,NULL,NULL,NULL,2.220,NULL,NULL,NULL,NULL,2.220,2.220,0.000,0.000,NULL,NULL,1,0,2.220,0,'2015-10-08 10:16:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:49','C',2.220,0.000,0.000,0),(1832,1858,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.840,NULL,NULL,NULL,8.840,NULL,NULL,NULL,NULL,8.840,8.840,0.000,0.000,NULL,NULL,1,0,8.840,0,'2015-10-08 10:18:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:49','C',8.840,0.000,0.000,0),(1833,1859,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.500,NULL,NULL,NULL,3.500,NULL,NULL,NULL,NULL,3.500,3.500,0.000,0.000,NULL,NULL,1,0,3.500,0,'2015-10-08 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:49','C',3.500,0.000,0.000,0),(1834,1860,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.940,NULL,NULL,NULL,3.940,NULL,NULL,NULL,NULL,3.940,3.940,0.000,0.000,NULL,NULL,1,0,3.940,0,'2015-10-08 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:49','C',3.940,0.000,0.000,0),(1835,1861,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.980,NULL,NULL,NULL,3.980,NULL,NULL,NULL,NULL,3.980,3.980,0.000,0.000,NULL,NULL,1,0,3.980,0,'2015-10-08 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:50','C',3.980,0.000,0.000,0),(1836,1862,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.900,NULL,NULL,NULL,4.900,NULL,NULL,NULL,NULL,4.900,4.900,0.000,0.000,NULL,NULL,1,0,4.900,0,'2015-10-08 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:50','C',4.900,0.000,0.000,0),(1837,1863,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.780,NULL,NULL,NULL,3.780,NULL,NULL,NULL,NULL,3.780,3.780,0.000,0.000,NULL,NULL,1,0,3.780,0,'2015-10-08 10:19:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:50','C',3.780,0.000,0.000,0),(1838,1864,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.740,NULL,NULL,NULL,3.740,NULL,NULL,NULL,NULL,3.740,3.740,0.000,0.000,NULL,NULL,1,0,3.740,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:50','C',3.740,0.000,0.000,0),(1839,1865,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2.870,NULL,NULL,NULL,2.870,NULL,NULL,NULL,NULL,2.870,2.870,0.000,0.000,NULL,NULL,1,0,2.870,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:51','C',2.870,0.000,0.000,0),(1840,1866,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.220,NULL,NULL,NULL,4.220,NULL,NULL,NULL,NULL,4.220,4.220,0.000,0.000,NULL,NULL,1,0,4.220,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:51','C',4.220,0.000,0.000,0),(1841,1867,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,1.630,NULL,NULL,NULL,1.630,NULL,NULL,NULL,NULL,1.630,1.630,0.000,0.000,NULL,NULL,1,0,1.630,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:51','C',1.630,0.000,0.000,0),(1842,1868,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.140,NULL,NULL,NULL,3.140,NULL,NULL,NULL,NULL,3.140,3.140,0.000,0.000,NULL,NULL,1,0,3.140,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:52','C',3.140,0.000,0.000,0),(1843,1869,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.420,NULL,NULL,NULL,4.420,NULL,NULL,NULL,NULL,4.420,4.420,0.000,0.000,NULL,NULL,1,0,4.420,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:52','C',4.420,0.000,0.000,0),(1844,1870,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.980,NULL,NULL,NULL,4.980,NULL,NULL,NULL,NULL,4.980,4.980,0.000,0.000,NULL,NULL,1,0,4.980,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:52','C',4.980,0.000,0.000,0),(1845,1871,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.220,NULL,NULL,NULL,4.220,NULL,NULL,NULL,NULL,4.220,4.220,0.000,0.000,NULL,NULL,1,0,4.220,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:12:52','C',4.220,0.000,0.000,0),(1846,1872,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.410,NULL,NULL,NULL,10.410,NULL,NULL,NULL,NULL,10.410,10.410,0.000,0.000,NULL,NULL,1,0,10.410,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:25','C',10.410,0.000,0.000,0),(1847,1873,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.050,NULL,NULL,NULL,11.050,NULL,NULL,NULL,NULL,11.050,11.050,0.000,0.000,NULL,NULL,1,0,11.050,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:25','C',11.050,0.000,0.000,0),(1848,1874,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.500,NULL,NULL,NULL,9.500,NULL,NULL,NULL,NULL,9.500,9.500,0.000,0.000,NULL,NULL,1,0,9.500,0,'2015-10-08 10:20:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:25','C',9.500,0.000,0.000,0),(1849,1875,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.940,NULL,NULL,NULL,9.940,NULL,NULL,NULL,NULL,9.940,9.940,0.000,0.000,NULL,NULL,1,0,9.940,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:25','C',9.940,0.000,0.000,0),(1850,1876,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.910,NULL,NULL,NULL,6.910,NULL,NULL,NULL,NULL,6.910,6.910,0.000,0.000,NULL,NULL,1,0,6.910,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:26','C',6.910,0.000,0.000,0),(1851,1877,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.200,NULL,NULL,NULL,8.200,NULL,NULL,NULL,NULL,8.200,8.200,0.000,0.000,NULL,NULL,1,0,8.200,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:26','C',8.200,0.000,0.000,0),(1852,1878,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.390,NULL,NULL,NULL,7.390,NULL,NULL,NULL,NULL,7.390,7.390,0.000,0.000,NULL,NULL,1,0,7.390,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:26','C',7.390,0.000,0.000,0),(1853,1879,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.950,NULL,NULL,NULL,6.950,NULL,NULL,NULL,NULL,6.950,6.950,0.000,0.000,NULL,NULL,1,0,6.950,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:26','C',6.950,0.000,0.000,0),(1854,1880,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.630,NULL,NULL,NULL,6.630,NULL,NULL,NULL,NULL,6.630,6.630,0.000,0.000,NULL,NULL,1,0,6.630,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:27','C',6.630,0.000,0.000,0),(1855,1881,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.030,NULL,NULL,NULL,7.030,NULL,NULL,NULL,NULL,7.030,7.030,0.000,0.000,NULL,NULL,1,0,7.030,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:27','C',7.030,0.000,0.000,0),(1856,1882,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.360,NULL,NULL,NULL,8.360,NULL,NULL,NULL,NULL,8.360,8.360,0.000,0.000,NULL,NULL,1,0,8.360,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:27','C',8.360,0.000,0.000,0),(1857,1883,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.230,NULL,NULL,NULL,7.230,NULL,NULL,NULL,NULL,7.230,7.230,0.000,0.000,NULL,NULL,1,0,7.230,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:27','C',7.230,0.000,0.000,0),(1858,1884,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.560,NULL,NULL,NULL,8.560,NULL,NULL,NULL,NULL,8.560,8.560,0.000,0.000,NULL,NULL,1,0,8.560,0,'2015-10-08 10:21:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:28','C',8.560,0.000,0.000,0),(1859,1885,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.600,NULL,NULL,NULL,7.600,NULL,NULL,NULL,NULL,7.600,7.600,0.000,0.000,NULL,NULL,1,0,7.600,0,'2015-10-08 10:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:28','C',7.600,0.000,0.000,0),(1860,1886,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.400,NULL,NULL,NULL,8.400,NULL,NULL,NULL,NULL,8.400,8.400,0.000,0.000,NULL,NULL,1,0,8.400,0,'2015-10-08 10:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:28','C',8.400,0.000,0.000,0),(1861,1887,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.110,NULL,NULL,NULL,9.110,NULL,NULL,NULL,NULL,9.110,9.110,0.000,0.000,NULL,NULL,1,0,9.110,0,'2015-10-08 10:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:28','C',9.110,0.000,0.000,0),(1862,1888,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.410,NULL,NULL,NULL,7.410,NULL,NULL,NULL,NULL,7.410,7.410,0.000,0.000,NULL,NULL,1,0,7.410,0,'2015-10-08 10:22:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:29','C',7.410,0.000,0.000,0),(1863,1889,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.140,NULL,NULL,NULL,12.140,NULL,NULL,NULL,NULL,12.140,12.140,0.000,0.000,NULL,NULL,1,0,12.140,0,'2015-10-08 10:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:29','C',12.140,0.000,0.000,0),(1864,1890,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.620,NULL,NULL,NULL,11.620,NULL,NULL,NULL,NULL,11.620,11.620,0.000,0.000,NULL,NULL,1,0,11.620,0,'2015-10-08 10:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:29','C',11.620,0.000,0.000,0),(1865,1891,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.010,NULL,NULL,NULL,12.010,NULL,NULL,NULL,NULL,12.010,12.010,0.000,0.000,NULL,NULL,1,0,12.010,0,'2015-10-08 10:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:30','C',12.010,0.000,0.000,0),(1866,1892,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',2,'BELIVENT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.400,NULL,NULL,NULL,12.400,NULL,NULL,NULL,NULL,12.400,12.400,0.000,0.000,NULL,NULL,1,0,12.400,0,'2015-10-08 10:24:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:30','C',12.400,0.000,0.000,0),(1867,1893,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.840,NULL,NULL,NULL,7.840,NULL,NULL,NULL,NULL,7.840,7.840,0.000,0.000,NULL,NULL,1,0,7.840,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:30','C',7.840,0.000,0.000,0),(1868,1894,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.720,NULL,NULL,NULL,12.720,NULL,NULL,NULL,NULL,12.720,12.720,0.000,0.000,NULL,NULL,1,0,12.720,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:30','C',12.720,0.000,0.000,0),(1869,1895,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.510,NULL,NULL,NULL,12.510,NULL,NULL,NULL,NULL,12.510,12.510,0.000,0.000,NULL,NULL,1,0,12.510,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:31','C',12.510,0.000,0.000,0),(1870,1896,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.540,NULL,NULL,NULL,9.540,NULL,NULL,NULL,NULL,9.540,9.540,0.000,0.000,NULL,NULL,1,0,9.540,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:31','C',9.540,0.000,0.000,0),(1871,1897,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.330,NULL,NULL,NULL,9.330,NULL,NULL,NULL,NULL,9.330,9.330,0.000,0.000,NULL,NULL,1,0,9.330,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:31','C',9.330,0.000,0.000,0),(1872,1898,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.080,NULL,NULL,NULL,11.080,NULL,NULL,NULL,NULL,11.080,11.080,0.000,0.000,NULL,NULL,1,0,11.080,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:32','C',11.080,0.000,0.000,0),(1873,1899,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.720,NULL,NULL,NULL,12.720,NULL,NULL,NULL,NULL,12.720,12.720,0.000,0.000,NULL,NULL,1,0,12.720,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:32','C',12.720,0.000,0.000,0),(1874,1900,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.500,NULL,NULL,NULL,11.500,NULL,NULL,NULL,NULL,11.500,11.500,0.000,0.000,NULL,NULL,1,0,11.500,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:32','C',11.500,0.000,0.000,0),(1875,1901,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.960,NULL,NULL,NULL,9.960,NULL,NULL,NULL,NULL,9.960,9.960,0.000,0.000,NULL,NULL,1,0,9.960,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:32','C',9.960,0.000,0.000,0),(1876,1902,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.610,NULL,NULL,NULL,11.610,NULL,NULL,NULL,NULL,11.610,11.610,0.000,0.000,NULL,NULL,1,0,11.610,0,'2015-10-08 10:25:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:33','C',11.610,0.000,0.000,0),(1877,1903,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.080,NULL,NULL,NULL,12.080,NULL,NULL,NULL,NULL,12.080,12.080,0.000,0.000,NULL,NULL,1,0,12.080,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:33','C',12.080,0.000,0.000,0),(1878,1904,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.860,NULL,NULL,NULL,9.860,NULL,NULL,NULL,NULL,9.860,9.860,0.000,0.000,NULL,NULL,1,0,9.860,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:33','C',9.860,0.000,0.000,0),(1879,1905,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.710,NULL,NULL,NULL,11.710,NULL,NULL,NULL,NULL,11.710,11.710,0.000,0.000,NULL,NULL,1,0,11.710,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:33','C',11.710,0.000,0.000,0),(1880,1906,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.600,NULL,NULL,NULL,10.600,NULL,NULL,NULL,NULL,10.600,10.600,0.000,0.000,NULL,NULL,1,0,10.600,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:34','C',10.600,0.000,0.000,0),(1881,1907,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.830,NULL,NULL,NULL,13.830,NULL,NULL,NULL,NULL,13.830,13.830,0.000,0.000,NULL,NULL,1,0,13.830,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:34','C',13.830,0.000,0.000,0),(1882,1908,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.250,NULL,NULL,NULL,13.250,NULL,NULL,NULL,NULL,13.250,13.250,0.000,0.000,NULL,NULL,1,0,13.250,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:34','C',13.250,0.000,0.000,0),(1883,1909,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.330,NULL,NULL,NULL,9.330,NULL,NULL,NULL,NULL,9.330,9.330,0.000,0.000,NULL,NULL,1,0,9.330,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:35','C',9.330,0.000,0.000,0),(1884,1910,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,9.750,NULL,NULL,NULL,9.750,NULL,NULL,NULL,NULL,9.750,9.750,0.000,0.000,NULL,NULL,1,0,9.750,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:35','C',9.750,0.000,0.000,0),(1885,1911,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.410,NULL,NULL,NULL,13.410,NULL,NULL,NULL,NULL,13.410,13.410,0.000,0.000,NULL,NULL,1,0,13.410,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:35','C',13.410,0.000,0.000,0),(1886,1912,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.560,NULL,NULL,NULL,12.560,NULL,NULL,NULL,NULL,12.560,12.560,0.000,0.000,NULL,NULL,1,0,12.560,0,'2015-10-08 10:26:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:35','C',12.560,0.000,0.000,0),(1887,1913,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.850,NULL,NULL,NULL,13.850,NULL,NULL,NULL,NULL,13.850,13.850,0.000,0.000,NULL,NULL,1,0,13.850,0,'2015-10-08 10:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:36','C',13.850,0.000,0.000,0),(1888,1914,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,14.570,NULL,NULL,NULL,14.570,NULL,NULL,NULL,NULL,14.570,14.570,0.000,0.000,NULL,NULL,1,0,14.570,0,'2015-10-08 10:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:36','C',14.570,0.000,0.000,0),(1889,1915,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.720,NULL,NULL,NULL,12.720,NULL,NULL,NULL,NULL,12.720,12.720,0.000,0.000,NULL,NULL,1,0,12.720,0,'2015-10-08 10:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:36','C',12.720,0.000,0.000,0),(1890,1916,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,15.490,NULL,NULL,NULL,15.490,NULL,NULL,NULL,NULL,15.490,15.490,0.000,0.000,NULL,NULL,1,0,15.490,0,'2015-10-08 10:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:36','C',15.490,0.000,0.000,0),(1891,1917,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,16.110,NULL,NULL,NULL,16.110,NULL,NULL,NULL,NULL,16.110,16.110,0.000,0.000,NULL,NULL,1,0,16.110,0,'2015-10-08 10:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:37','C',16.110,0.000,0.000,0),(1892,1918,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,16.110,NULL,NULL,NULL,16.110,NULL,NULL,NULL,NULL,16.110,16.110,0.000,0.000,NULL,NULL,1,0,16.110,0,'2015-10-08 10:27:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:37','C',16.110,0.000,0.000,0),(1893,1919,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.390,NULL,NULL,NULL,5.390,NULL,NULL,NULL,NULL,5.390,5.390,0.000,0.000,NULL,NULL,1,0,5.390,0,'2015-10-08 10:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:37','C',5.390,0.000,0.000,0),(1894,1920,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.980,NULL,NULL,NULL,6.980,NULL,NULL,NULL,NULL,6.980,6.980,0.000,0.000,NULL,NULL,1,0,6.980,0,'2015-10-08 10:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:37','C',6.980,0.000,0.000,0),(1895,1921,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.180,NULL,NULL,NULL,5.180,NULL,NULL,NULL,NULL,5.180,5.180,0.000,0.000,NULL,NULL,1,0,5.180,0,'2015-10-08 10:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:38','C',5.180,0.000,0.000,0),(1896,1922,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.360,NULL,NULL,NULL,4.360,NULL,NULL,NULL,NULL,4.360,4.360,0.000,0.000,NULL,NULL,1,0,4.360,0,'2015-10-08 10:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:38','C',4.360,0.000,0.000,0),(1897,1923,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.280,NULL,NULL,NULL,5.280,NULL,NULL,NULL,NULL,5.280,5.280,0.000,0.000,NULL,NULL,1,0,5.280,0,'2015-10-08 10:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:38','C',5.280,0.000,0.000,0),(1898,1924,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.820,NULL,NULL,NULL,6.820,NULL,NULL,NULL,NULL,6.820,6.820,0.000,0.000,NULL,NULL,1,0,6.820,0,'2015-10-08 10:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:39','C',6.820,0.000,0.000,0),(1899,1925,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.000,NULL,NULL,NULL,4.000,NULL,NULL,NULL,NULL,4.000,4.000,0.000,0.000,NULL,NULL,1,0,4.000,0,'2015-10-08 10:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:39','C',4.000,0.000,0.000,0),(1900,1926,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.490,NULL,NULL,NULL,5.490,NULL,NULL,NULL,NULL,5.490,5.490,0.000,0.000,NULL,NULL,1,0,5.490,0,'2015-10-08 10:28:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:40','C',5.490,0.000,0.000,0),(1901,1927,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.580,NULL,NULL,NULL,6.580,NULL,NULL,NULL,NULL,6.580,6.580,0.000,0.000,NULL,NULL,5,0,6.580,0,'2015-10-08 10:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:40','C',6.580,0.000,0.000,0),(1902,1928,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.510,NULL,NULL,NULL,12.510,NULL,NULL,NULL,NULL,12.510,12.510,0.000,0.000,NULL,NULL,5,0,12.510,0,'2015-10-08 10:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:40','C',12.510,0.000,0.000,0),(1903,1929,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,12.560,NULL,NULL,NULL,12.560,NULL,NULL,NULL,NULL,12.560,12.560,0.000,0.000,NULL,NULL,5,0,12.560,0,'2015-10-08 10:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:40','C',12.560,0.000,0.000,0),(1904,1930,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,13.470,NULL,NULL,NULL,13.470,NULL,NULL,NULL,NULL,13.470,13.470,0.000,0.000,NULL,NULL,5,0,13.470,0,'2015-10-08 10:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:41','C',13.470,0.000,0.000,0),(1905,1931,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,11.340,NULL,NULL,NULL,11.340,NULL,NULL,NULL,NULL,11.340,11.340,0.000,0.000,NULL,NULL,5,0,11.340,0,'2015-10-08 10:33:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:41','C',11.340,0.000,0.000,0),(1906,1932,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-08 10:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:41','C',0.000,0.000,0.000,0),(1907,1933,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',1,'Fermes du Pays Bourian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.000,NULL,NULL,NULL,0.000,NULL,NULL,NULL,NULL,0.000,0.000,0.000,0.000,NULL,NULL,5,0,0.000,0,'2015-10-08 10:41:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:41','C',0.000,0.000,0.000,0),(1908,1934,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.540,NULL,NULL,NULL,0.540,NULL,NULL,NULL,NULL,0.540,0.540,0.000,0.000,NULL,NULL,5,0,0.540,0,'2015-10-08 10:47:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:42','C',0.540,0.000,0.000,0),(1909,1935,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.390,NULL,NULL,NULL,5.390,NULL,NULL,NULL,NULL,5.390,5.390,0.000,0.000,NULL,NULL,5,0,5.390,0,'2015-10-08 10:48:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:42','C',5.390,0.000,0.000,0),(1910,1936,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.210,NULL,NULL,NULL,7.210,NULL,NULL,NULL,NULL,7.210,7.210,0.000,0.000,NULL,NULL,5,0,7.210,0,'2015-10-08 10:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:42','C',7.210,0.000,0.000,0),(1911,1937,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.510,NULL,NULL,NULL,6.510,NULL,NULL,NULL,NULL,6.510,6.510,0.000,0.000,NULL,NULL,5,0,6.510,0,'2015-10-08 10:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:43','C',6.510,0.000,0.000,0),(1912,1938,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.690,NULL,NULL,NULL,6.690,NULL,NULL,NULL,NULL,6.690,6.690,0.000,0.000,NULL,NULL,5,0,6.690,0,'2015-10-08 10:49:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:43','C',6.690,0.000,0.000,0),(1913,1939,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.650,NULL,NULL,NULL,6.650,NULL,NULL,NULL,NULL,6.650,6.650,0.000,0.000,NULL,NULL,5,0,6.650,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:43','C',6.650,0.000,0.000,0),(1914,1940,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.980,NULL,NULL,NULL,7.980,NULL,NULL,NULL,NULL,7.980,7.980,0.000,0.000,NULL,NULL,5,0,7.980,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:43','C',7.980,0.000,0.000,0),(1915,1941,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.250,NULL,NULL,NULL,7.250,NULL,NULL,NULL,NULL,7.250,7.250,0.000,0.000,NULL,NULL,5,0,7.250,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:44','C',7.250,0.000,0.000,0),(1916,1942,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.260,NULL,NULL,NULL,8.260,NULL,NULL,NULL,NULL,8.260,8.260,0.000,0.000,NULL,NULL,5,0,8.260,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:44','C',8.260,0.000,0.000,0),(1917,1943,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.210,NULL,NULL,NULL,7.210,NULL,NULL,NULL,NULL,7.210,7.210,0.000,0.000,NULL,NULL,5,0,7.210,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:44','C',7.210,0.000,0.000,0),(1918,1944,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.000,NULL,NULL,NULL,7.000,NULL,NULL,NULL,NULL,7.000,7.000,0.000,0.000,NULL,NULL,5,0,7.000,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:44','C',7.000,0.000,0.000,0),(1919,1945,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.950,NULL,NULL,NULL,5.950,NULL,NULL,NULL,NULL,5.950,5.950,0.000,0.000,NULL,NULL,5,0,5.950,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:45','C',5.950,0.000,0.000,0),(1920,1946,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.620,NULL,NULL,NULL,6.620,NULL,NULL,NULL,NULL,6.620,6.620,0.000,0.000,NULL,NULL,5,0,6.620,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:45','C',6.620,0.000,0.000,0),(1921,1947,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.460,NULL,NULL,NULL,7.460,NULL,NULL,NULL,NULL,7.460,7.460,0.000,0.000,NULL,NULL,5,0,7.460,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:45','C',7.460,0.000,0.000,0),(1922,1948,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.070,NULL,NULL,NULL,7.070,NULL,NULL,NULL,NULL,7.070,7.070,0.000,0.000,NULL,NULL,5,0,7.070,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:45','C',7.070,0.000,0.000,0),(1923,1949,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.790,NULL,NULL,NULL,8.790,NULL,NULL,NULL,NULL,8.790,8.790,0.000,0.000,NULL,NULL,5,0,8.790,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:46','C',8.790,0.000,0.000,0),(1924,1950,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.950,NULL,NULL,NULL,5.950,NULL,NULL,NULL,NULL,5.950,5.950,0.000,0.000,NULL,NULL,5,0,5.950,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:46','C',5.950,0.000,0.000,0),(1925,1951,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,10.960,NULL,NULL,NULL,10.960,NULL,NULL,NULL,NULL,10.960,10.960,0.000,0.000,NULL,NULL,5,0,10.960,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:46','C',10.960,0.000,0.000,0),(1926,1952,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.600,NULL,NULL,NULL,5.600,NULL,NULL,NULL,NULL,5.600,5.600,0.000,0.000,NULL,NULL,5,0,5.600,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:47','C',5.600,0.000,0.000,0),(1927,1953,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.970,NULL,NULL,NULL,4.970,NULL,NULL,NULL,NULL,4.970,4.970,0.000,0.000,NULL,NULL,5,0,4.970,0,'2015-10-08 10:50:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:47','C',4.970,0.000,0.000,0),(1928,1954,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.660,NULL,NULL,NULL,4.660,NULL,NULL,NULL,NULL,4.660,4.660,0.000,0.000,NULL,NULL,5,0,4.660,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:47','C',4.660,0.000,0.000,0),(1929,1955,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.620,NULL,NULL,NULL,4.620,NULL,NULL,NULL,NULL,4.620,4.620,0.000,0.000,NULL,NULL,5,0,4.620,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:47','C',4.620,0.000,0.000,0),(1930,1956,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.760,NULL,NULL,NULL,4.760,NULL,NULL,NULL,NULL,4.760,4.760,0.000,0.000,NULL,NULL,5,0,4.760,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:48','C',4.760,0.000,0.000,0),(1931,1957,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.070,NULL,NULL,NULL,7.070,NULL,NULL,NULL,NULL,7.070,7.070,0.000,0.000,NULL,NULL,5,0,7.070,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:48','C',7.070,0.000,0.000,0),(1932,1958,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.940,NULL,NULL,NULL,4.940,NULL,NULL,NULL,NULL,4.940,4.940,0.000,0.000,NULL,NULL,5,0,4.940,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:48','C',4.940,0.000,0.000,0),(1933,1959,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.710,NULL,NULL,NULL,5.710,NULL,NULL,NULL,NULL,5.710,5.710,0.000,0.000,NULL,NULL,5,0,5.710,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:48','C',5.710,0.000,0.000,0),(1934,1960,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.670,NULL,NULL,NULL,5.670,NULL,NULL,NULL,NULL,5.670,5.670,0.000,0.000,NULL,NULL,5,0,5.670,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:49','C',5.670,0.000,0.000,0),(1935,1961,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.460,NULL,NULL,NULL,5.460,NULL,NULL,NULL,NULL,5.460,5.460,0.000,0.000,NULL,NULL,5,0,5.460,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:49','C',5.460,0.000,0.000,0),(1936,1962,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.040,NULL,NULL,NULL,5.040,NULL,NULL,NULL,NULL,5.040,5.040,0.000,0.000,NULL,NULL,5,0,5.040,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:49','C',5.040,0.000,0.000,0),(1937,1963,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.780,NULL,NULL,NULL,5.780,NULL,NULL,NULL,NULL,5.780,5.780,0.000,0.000,NULL,NULL,5,0,5.780,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:50','C',5.780,0.000,0.000,0),(1938,1964,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.810,NULL,NULL,NULL,5.810,NULL,NULL,NULL,NULL,5.810,5.810,0.000,0.000,NULL,NULL,5,0,5.810,0,'2015-10-08 10:51:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:50','C',5.810,0.000,0.000,0),(1939,1965,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.720,NULL,NULL,NULL,6.720,NULL,NULL,NULL,NULL,6.720,6.720,0.000,0.000,NULL,NULL,5,0,6.720,0,'2015-10-08 10:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:50','C',6.720,0.000,0.000,0),(1940,1966,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.000,NULL,NULL,NULL,8.000,NULL,NULL,NULL,NULL,8.000,8.000,0.000,0.000,NULL,NULL,5,0,8.000,0,'2015-10-08 10:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:50','C',8.000,0.000,0.000,0),(1941,1967,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.530,NULL,NULL,NULL,6.530,NULL,NULL,NULL,NULL,6.530,6.530,0.000,0.000,NULL,NULL,5,0,6.530,0,'2015-10-08 10:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:51','C',6.530,0.000,0.000,0),(1942,1968,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.510,NULL,NULL,NULL,8.510,NULL,NULL,NULL,NULL,8.510,8.510,0.000,0.000,NULL,NULL,5,0,8.510,0,'2015-10-08 10:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:51','C',8.510,0.000,0.000,0),(1943,1969,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.210,NULL,NULL,NULL,6.210,NULL,NULL,NULL,NULL,6.210,6.210,0.000,0.000,NULL,NULL,5,0,6.210,0,'2015-10-08 10:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:51','C',6.210,0.000,0.000,0),(1944,1970,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.800,NULL,NULL,NULL,8.800,NULL,NULL,NULL,NULL,8.800,8.800,0.000,0.000,NULL,NULL,5,0,8.800,0,'2015-10-08 10:52:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:51','C',8.800,0.000,0.000,0),(1945,1971,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.700,NULL,NULL,NULL,7.700,NULL,NULL,NULL,NULL,7.700,7.700,0.000,0.000,NULL,NULL,5,0,7.700,0,'2015-10-08 11:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:13:52','C',7.700,0.000,0.000,0),(1946,1972,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.090,NULL,NULL,NULL,6.090,NULL,NULL,NULL,NULL,6.090,6.090,0.000,0.000,NULL,NULL,5,0,6.090,0,'2015-10-08 11:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:26','C',6.090,0.000,0.000,0),(1947,1973,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.580,NULL,NULL,NULL,6.580,NULL,NULL,NULL,NULL,6.580,6.580,0.000,0.000,NULL,NULL,5,0,6.580,0,'2015-10-08 11:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:27','C',6.580,0.000,0.000,0),(1948,1974,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.930,NULL,NULL,NULL,6.930,NULL,NULL,NULL,NULL,6.930,6.930,0.000,0.000,NULL,NULL,5,0,6.930,0,'2015-10-08 11:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:27','C',6.930,0.000,0.000,0),(1949,1975,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.300,NULL,NULL,NULL,6.300,NULL,NULL,NULL,NULL,6.300,6.300,0.000,0.000,NULL,NULL,5,0,6.300,0,'2015-10-08 11:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:27','C',6.300,0.000,0.000,0),(1950,1976,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.320,NULL,NULL,NULL,5.320,NULL,NULL,NULL,NULL,5.320,5.320,0.000,0.000,NULL,NULL,5,0,5.320,0,'2015-10-08 11:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:28','C',5.320,0.000,0.000,0),(1951,1977,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.670,NULL,NULL,NULL,5.670,NULL,NULL,NULL,NULL,5.670,5.670,0.000,0.000,NULL,NULL,5,0,5.670,0,'2015-10-08 11:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:28','C',5.670,0.000,0.000,0),(1952,1978,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.670,NULL,NULL,NULL,5.670,NULL,NULL,NULL,NULL,5.670,5.670,0.000,0.000,NULL,NULL,5,0,5.670,0,'2015-10-08 11:01:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:28','C',5.670,0.000,0.000,0),(1953,1979,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.860,NULL,NULL,NULL,4.860,NULL,NULL,NULL,NULL,4.860,4.860,0.000,0.000,NULL,NULL,5,0,4.860,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:28','C',4.860,0.000,0.000,0),(1954,1980,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.280,NULL,NULL,NULL,4.280,NULL,NULL,NULL,NULL,4.280,4.280,0.000,0.000,NULL,NULL,5,0,4.280,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:29','C',4.280,0.000,0.000,0),(1955,1981,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.390,NULL,NULL,NULL,8.390,NULL,NULL,NULL,NULL,8.390,8.390,0.000,0.000,NULL,NULL,5,0,8.390,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:29','C',8.390,0.000,0.000,0),(1956,1982,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,8.460,NULL,NULL,NULL,8.460,NULL,NULL,NULL,NULL,8.460,8.460,0.000,0.000,NULL,NULL,5,0,8.460,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:29','C',8.460,0.000,0.000,0),(1957,1983,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.440,NULL,NULL,NULL,6.440,NULL,NULL,NULL,NULL,6.440,6.440,0.000,0.000,NULL,NULL,5,0,6.440,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:30','C',6.440,0.000,0.000,0),(1958,1984,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,7.850,NULL,NULL,NULL,7.850,NULL,NULL,NULL,NULL,7.850,7.850,0.000,0.000,NULL,NULL,5,0,7.850,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:30','C',7.850,0.000,0.000,0),(1959,1985,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.400,NULL,NULL,NULL,5.400,NULL,NULL,NULL,NULL,5.400,5.400,0.000,0.000,NULL,NULL,5,0,5.400,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:30','C',5.400,0.000,0.000,0),(1960,1986,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.980,NULL,NULL,NULL,5.980,NULL,NULL,NULL,NULL,5.980,5.980,0.000,0.000,NULL,NULL,5,0,5.980,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:30','C',5.980,0.000,0.000,0),(1961,1987,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.260,NULL,NULL,NULL,5.260,NULL,NULL,NULL,NULL,5.260,5.260,0.000,0.000,NULL,NULL,5,0,5.260,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:31','C',5.260,0.000,0.000,0),(1962,1988,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.230,NULL,NULL,NULL,6.230,NULL,NULL,NULL,NULL,6.230,6.230,0.000,0.000,NULL,NULL,5,0,6.230,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:31','C',6.230,0.000,0.000,0),(1963,1989,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,6.880,NULL,NULL,NULL,6.880,NULL,NULL,NULL,NULL,6.880,6.880,0.000,0.000,NULL,NULL,5,0,6.880,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:31','C',6.880,0.000,0.000,0),(1964,1990,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.360,NULL,NULL,NULL,5.360,NULL,NULL,NULL,NULL,5.360,5.360,0.000,0.000,NULL,NULL,5,0,5.360,0,'2015-10-08 11:03:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:31','C',5.360,0.000,0.000,0),(1965,1991,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.140,NULL,NULL,NULL,4.140,NULL,NULL,NULL,NULL,4.140,4.140,0.000,0.000,NULL,NULL,5,0,4.140,0,'2015-10-08 11:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:32','C',4.140,0.000,0.000,0),(1966,1992,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.040,NULL,NULL,NULL,5.040,NULL,NULL,NULL,NULL,5.040,5.040,0.000,0.000,NULL,NULL,5,0,5.040,0,'2015-10-08 11:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:32','C',5.040,0.000,0.000,0),(1967,1993,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.770,NULL,NULL,NULL,4.770,NULL,NULL,NULL,NULL,4.770,4.770,0.000,0.000,NULL,NULL,5,0,4.770,0,'2015-10-08 11:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:32','C',4.770,0.000,0.000,0),(1968,1994,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.470,NULL,NULL,NULL,4.470,NULL,NULL,NULL,NULL,4.470,4.470,0.000,0.000,NULL,NULL,5,0,4.470,0,'2015-10-08 11:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:32','C',4.470,0.000,0.000,0),(1969,1995,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.680,NULL,NULL,NULL,4.680,NULL,NULL,NULL,NULL,4.680,4.680,0.000,0.000,NULL,NULL,5,0,4.680,0,'2015-10-08 11:04:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:33','C',4.680,0.000,0.000,0),(1970,1996,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.830,NULL,NULL,NULL,4.830,NULL,NULL,NULL,NULL,4.830,4.830,0.000,0.000,NULL,NULL,5,0,4.830,0,'2015-10-08 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:33','C',4.830,0.000,0.000,0),(1971,1997,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.080,NULL,NULL,NULL,4.080,NULL,NULL,NULL,NULL,4.080,4.080,0.000,0.000,NULL,NULL,5,0,4.080,0,'2015-10-08 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:33','C',4.080,0.000,0.000,0),(1972,1998,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.300,NULL,NULL,NULL,3.300,NULL,NULL,NULL,NULL,3.300,3.300,0.000,0.000,NULL,NULL,5,0,3.300,0,'2015-10-08 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:34','C',3.300,0.000,0.000,0),(1973,1999,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.830,NULL,NULL,NULL,4.830,NULL,NULL,NULL,NULL,4.830,4.830,0.000,0.000,NULL,NULL,5,0,4.830,0,'2015-10-08 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:34','C',4.830,0.000,0.000,0),(1974,2000,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.950,NULL,NULL,NULL,4.950,NULL,NULL,NULL,NULL,4.950,4.950,0.000,0.000,NULL,NULL,5,0,4.950,0,'2015-10-08 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:34','C',4.950,0.000,0.000,0),(1975,2001,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,5.160,NULL,NULL,NULL,5.160,NULL,NULL,NULL,NULL,5.160,5.160,0.000,0.000,NULL,NULL,5,0,5.160,0,'2015-10-08 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:34','C',5.160,0.000,0.000,0),(1976,2002,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.860,NULL,NULL,NULL,4.860,NULL,NULL,NULL,NULL,4.860,4.860,0.000,0.000,NULL,NULL,5,0,4.860,0,'2015-10-08 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:35','C',4.860,0.000,0.000,0),(1977,2003,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,4.500,NULL,NULL,NULL,4.500,NULL,NULL,NULL,NULL,4.500,4.500,0.000,0.000,NULL,NULL,5,0,4.500,0,'2015-10-08 11:05:00',0,1,NULL,NULL,1,0,1,'A','Comunicaciones','2015-10-10 15:14:35','C',4.500,0.000,0.000,0),(1978,2004,1,'',1,'Shop 1',10,'Scale 00',-1,NULL,'E',5,'BALDY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,3.990,NULL,NULL,NULL,3.990,NULL,NULL,NULL,NULL,3.990,3.990,0.000,0.000,NULL,N